/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LucenePlanner;
import com.apple.foundationdb.record.lucene.LuceneQueryComponent;
import com.apple.foundationdb.record.lucene.directory.FDBDirectorySharedCacheManager;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.common.text.TextSamples;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextIndexTestUtils;
import com.apple.foundationdb.record.provider.foundationdb.query.FDBRecordStoreQueryTestBase;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RequiresFDB")
public class LuceneSharedCacheTest
extends FDBRecordStoreQueryTestBase {
    FDBDirectorySharedCacheManager sharedCacheManager = FDBDirectorySharedCacheManager.newBuilder().build();
    private static final List<TestRecordsTextProto.SimpleDocument> DOCUMENTS = TextIndexTestUtils.toSimpleDocuments(List.of("The Angstrom unit (\u212b) was named after Anders \u00c5ngstr\u00f6m.", "The Angstrom unit (\u212b) was named after Anders \u00c5ngstr\u00f6m.", "According to the encyclop\u00e6dia, \u00c6thelred the Unr\u00e6d was king from 966 to 1016.", TextSamples.FRENCH, "Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\nAnd the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend.", "Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\n", "And the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend."));

    public void setupPlanner(@Nullable PlannableIndexTypes indexTypes) {
        if (indexTypes == null) {
            indexTypes = new PlannableIndexTypes(Set.of("value", "version"), Set.of("rank", "time_window_leaderboard"), Set.of("text"), Set.of("lucene"));
            this.planner = new LucenePlanner(this.recordStore.getRecordMetaData(), this.recordStore.getRecordStoreState(), indexTypes, this.recordStore.getTimer());
        }
    }

    protected void openRecordStore(@Nonnull FDBRecordContext context) {
        RecordMetaDataBuilder metaDataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsTextProto.getDescriptor());
        metaDataBuilder.getRecordType("ComplexDocument").setPrimaryKey((KeyExpression)Key.Expressions.concatenateFields((String)"group", (String)"doc_id", (String[])new String[0]));
        metaDataBuilder.removeIndex("SimpleDocument$text");
        metaDataBuilder.addIndex("SimpleDocument", new Index("grouped_text", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene", Map.of()));
        this.recordStore = (FDBRecordStore)this.getStoreBuilder(context, metaDataBuilder.getRecordMetaData()).setSerializer((RecordSerializer)TextIndexTestUtils.COMPRESSING_SERIALIZER).uncheckedOpen();
        this.setupPlanner(null);
    }

    protected void initializeRecords() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            DOCUMENTS.forEach(arg_0 -> ((FDBRecordStore)this.recordStore).saveRecord(arg_0));
            this.commit(context);
        }
    }

    protected Set<Long> groupQueryForPrimaryKeys(@Nonnull RecordQuery query, long group) throws Exception {
        RecordQueryPlan plan = this.planner.plan(query);
        EvaluationContext context = EvaluationContext.forBinding((String)"g", (Object)group);
        List primaryKeys = (List)plan.execute(this.recordStore, context).map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
        return Set.copyOf(primaryKeys);
    }

    @Test
    void simple() throws Exception {
        RecordQuery query;
        QueryComponent filter;
        this.initializeRecords();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            this.sharedCacheManager.setForContext(context);
            filter = Query.and((QueryComponent)Query.field((String)"group").equalsParameter("g"), (QueryComponent)new LuceneQueryComponent("text:traffic", List.of("text")), (QueryComponent[])new QueryComponent[0]);
            query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(filter).build();
            this.timer.reset();
            Assertions.assertEquals(Set.of(Long.valueOf(4L), Long.valueOf(6L)), this.groupQueryForPrimaryKeys(query, 0L));
            MatcherAssert.assertThat((String)"no hits", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_HITS), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((String)"some misses", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_MISSES), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
        context = this.openContext();
        try {
            this.openRecordStore(context);
            this.sharedCacheManager.setForContext(context);
            filter = Query.and((QueryComponent)Query.field((String)"group").equalsParameter("g"), (QueryComponent)new LuceneQueryComponent("text:mutiny", List.of("text")), (QueryComponent[])new QueryComponent[0]);
            query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(filter).build();
            this.timer.reset();
            Assertions.assertEquals(Set.of(Long.valueOf(4L)), this.groupQueryForPrimaryKeys(query, 0L));
            MatcherAssert.assertThat((String)"some hits", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_HITS), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            MatcherAssert.assertThat((String)"no misses", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_MISSES), (Matcher)Matchers.equalTo((Object)0));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    void separateGroups() throws Exception {
        this.initializeRecords();
        QueryComponent filter = Query.and((QueryComponent)Query.field((String)"group").equalsParameter("g"), (QueryComponent)new LuceneQueryComponent("text:mutiny", List.of("text")), (QueryComponent[])new QueryComponent[0]);
        RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(filter).build();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            this.sharedCacheManager.setForContext(context);
            this.timer.reset();
            Assertions.assertEquals(Set.of(Long.valueOf(4L)), this.groupQueryForPrimaryKeys(query, 0L));
            MatcherAssert.assertThat((String)"no hits", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_HITS), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((String)"some misses", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_MISSES), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
        context = this.openContext();
        try {
            this.openRecordStore(context);
            this.sharedCacheManager.setForContext(context);
            this.timer.reset();
            Assertions.assertEquals(Set.of(Long.valueOf(5L)), this.groupQueryForPrimaryKeys(query, 1L));
            MatcherAssert.assertThat((String)"no hits", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_HITS), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((String)"some misses", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_MISSES), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    void intermediateWrite() throws Exception {
        RecordQuery query;
        QueryComponent filter;
        this.initializeRecords();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            this.sharedCacheManager.setForContext(context);
            filter = Query.and((QueryComponent)Query.field((String)"group").equalsParameter("g"), (QueryComponent)new LuceneQueryComponent("text:traffic", List.of("text")), (QueryComponent[])new QueryComponent[0]);
            query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(filter).build();
            this.timer.reset();
            Assertions.assertEquals(Set.of(Long.valueOf(4L), Long.valueOf(6L)), this.groupQueryForPrimaryKeys(query, 0L));
            MatcherAssert.assertThat((String)"no hits", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_HITS), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((String)"some misses", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_MISSES), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
        context = this.openContext();
        try {
            this.openRecordStore(context);
            TextIndexTestUtils.toSimpleDocuments(List.of(TextSamples.GERMAN)).forEach(arg_0 -> ((FDBRecordStore)this.recordStore).saveRecord(arg_0));
            this.commit(context);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openRecordStore(context);
            this.sharedCacheManager.setForContext(context);
            filter = Query.and((QueryComponent)Query.field((String)"group").equalsParameter("g"), (QueryComponent)new LuceneQueryComponent("text:mutiny", List.of("text")), (QueryComponent[])new QueryComponent[0]);
            query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(filter).build();
            this.timer.reset();
            Assertions.assertEquals(Set.of(Long.valueOf(4L)), this.groupQueryForPrimaryKeys(query, 0L));
            MatcherAssert.assertThat((String)"no hits", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_HITS), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((String)"some misses", (Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SHARED_CACHE_MISSES), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }
}

