/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.LucenePartitioner;
import com.apple.foundationdb.record.lucene.LuceneRepartitionPlanner;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Tag(value="RequiresFDB")
public class LuceneRepartitionPlannerTest {
    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTest#simplePartitionConsolidationTest"})
    public void luceneRepartitionPlannerTest(int lowWatermark, int highWatermark, int repartitionDocumentCount, int[] allPartitionCounts, int[] countExpectations) {
        int totalMoved;
        Tuple groupingKey = Tuple.from((Object[])new Object[]{1L});
        LuceneRepartitionPlanner repartitionPlanner = new LuceneRepartitionPlanner(lowWatermark, highWatermark);
        int maxPartitionId = allPartitionCounts.length;
        List partitionIds = IntStream.range(0, allPartitionCounts.length).boxed().collect(Collectors.toList());
        Collections.shuffle(partitionIds);
        List<Object> allPartitions = new ArrayList<LucenePartitionInfoProto.LucenePartitionInfo>();
        for (int i = allPartitionCounts.length - 1; i >= 0; --i) {
            allPartitions.add(LucenePartitionInfoProto.LucenePartitionInfo.newBuilder().setCount(allPartitionCounts[i]).setId(((Integer)partitionIds.get(i)).intValue()).setFrom(ByteString.copyFrom((byte[])Tuple.from((Object[])new Object[]{i * 1000}).pack())).setTo(ByteString.copyFrom((byte[])Tuple.from((Object[])new Object[]{i * 1000 + 999}).pack())).build());
        }
        block6: do {
            totalMoved = 0;
            for (int i = 0; i < allPartitions.size(); ++i) {
                LucenePartitionInfoProto.LucenePartitionInfo currentPartitionInfo = (LucenePartitionInfoProto.LucenePartitionInfo)allPartitions.get(i);
                if (currentPartitionInfo.getCount() == 0) continue;
                Pair neighborPartitions = LucenePartitioner.getPartitionNeighbors(allPartitions, (int)i);
                LucenePartitionInfoProto.LucenePartitionInfo newerPartition = (LucenePartitionInfoProto.LucenePartitionInfo)neighborPartitions.getLeft();
                LucenePartitionInfoProto.LucenePartitionInfo olderPartition = (LucenePartitionInfoProto.LucenePartitionInfo)neighborPartitions.getRight();
                LuceneRepartitionPlanner.RepartitioningContext repartitioningContext = repartitionPlanner.determineRepartitioningAction(groupingKey, allPartitions, i, repartitionDocumentCount);
                if (repartitioningContext.action == LuceneRepartitionPlanner.RepartitioningAction.NOT_REQUIRED || repartitioningContext.action == LuceneRepartitionPlanner.RepartitioningAction.NO_CAPACITY_FOR_MERGE) continue;
                int actualCountToMove = repartitioningContext.countToMove;
                if (!repartitioningContext.emptyingPartition && repartitioningContext.newBoundaryRecordPresent) {
                    --actualCountToMove;
                }
                long currentFrom = Tuple.fromBytes((byte[])currentPartitionInfo.getFrom().toByteArray()).getLong(0);
                switch (repartitioningContext.action) {
                    case MERGE_INTO_BOTH: 
                    case MERGE_INTO_OLDER: {
                        Assertions.assertNotNull((Object)olderPartition);
                        Assertions.assertFalse((olderPartition.getCount() + actualCountToMove > highWatermark ? 1 : 0) != 0);
                        allPartitions.set(i + 1, olderPartition.toBuilder().setCount(olderPartition.getCount() + actualCountToMove).build());
                        totalMoved += actualCountToMove;
                        break;
                    }
                    case MERGE_INTO_NEWER: {
                        Assertions.assertNotNull((Object)newerPartition);
                        Assertions.assertFalse((newerPartition.getCount() + actualCountToMove > highWatermark ? 1 : 0) != 0);
                        allPartitions.set(i - 1, newerPartition.toBuilder().setCount(newerPartition.getCount() + actualCountToMove).build());
                        totalMoved += actualCountToMove;
                        break;
                    }
                    case OVERFLOW: {
                        if (olderPartition != null && olderPartition.getCount() + actualCountToMove <= highWatermark) {
                            Assertions.assertFalse((olderPartition.getCount() + actualCountToMove > highWatermark ? 1 : 0) != 0);
                            allPartitions.set(i + 1, olderPartition.toBuilder().setCount(olderPartition.getCount() + actualCountToMove).build());
                        } else {
                            Assertions.assertFalse((actualCountToMove > highWatermark ? 1 : 0) != 0);
                            LucenePartitionInfoProto.LucenePartitionInfo newOverflowPartition = LucenePartitionInfoProto.LucenePartitionInfo.newBuilder().setCount(actualCountToMove).setId(maxPartitionId++).setFrom(ByteString.copyFrom((byte[])Tuple.from((Object[])new Object[]{currentFrom}).pack())).setTo(ByteString.copyFrom((byte[])Tuple.from((Object[])new Object[]{currentFrom + (long)actualCountToMove}).pack())).build();
                            allPartitions.add(newOverflowPartition);
                            allPartitions.sort(Collections.reverseOrder(Comparator.comparing(p -> Tuple.fromBytes((byte[])p.getFrom().toByteArray()))));
                        }
                        totalMoved += actualCountToMove;
                        break;
                    }
                }
                Assertions.assertTrue((actualCountToMove <= currentPartitionInfo.getCount() ? 1 : 0) != 0);
                if (actualCountToMove <= 0) continue;
                allPartitions.set(i, currentPartitionInfo.toBuilder().setCount(currentPartitionInfo.getCount() - actualCountToMove).setFrom(ByteString.copyFrom((byte[])Tuple.from((Object[])new Object[]{currentFrom + (long)actualCountToMove}).pack())).build());
                allPartitions = allPartitions.stream().filter(pInfo -> pInfo.getCount() > 0).collect(Collectors.toList());
                continue block6;
            }
        } while (totalMoved > 0);
        Collections.reverse(allPartitions);
        int[] actualCounts = allPartitions.stream().mapToInt(LucenePartitionInfoProto.LucenePartitionInfo::getCount).toArray();
        Assertions.assertArrayEquals((int[])countExpectations, (int[])actualCounts);
    }
}

