/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.lucene.LucenePlanner;
import com.apple.foundationdb.record.lucene.LuceneQueryComponent;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextIndexTestUtils;
import com.apple.foundationdb.record.provider.foundationdb.query.FDBRecordStoreQueryTestBase;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.NotComponent;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RequiresFDB")
public class LuceneQueryIntegrationTest
extends FDBRecordStoreQueryTestBase {
    private final Index textIndex = new Index("Complex$text_index", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "lucene");
    private final Index text2Index = new Index("Complex$text2_index", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")), "lucene");
    private final Index nestedDualIndex = new Index("Complex$nested_index", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"header").nest("header_id"), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression[])new KeyExpression[0]), "lucene");
    private final Index nestedDualIndex2 = new Index("Complex$nested_index2", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"header").nest("header_id"), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")), (KeyExpression[])new KeyExpression[0]), "lucene");

    public void setupPlanner(@Nullable PlannableIndexTypes indexTypes) {
        if (this.isUseCascadesPlanner()) {
            this.planner = this.recordStore.getCascadesPlanner();
        } else {
            if (indexTypes == null) {
                indexTypes = new PlannableIndexTypes((Set)Sets.newHashSet((Object[])new String[]{"value", "version"}), (Set)Sets.newHashSet((Object[])new String[]{"rank", "time_window_leaderboard"}), (Set)Sets.newHashSet((Object[])new String[]{"text"}), (Set)Sets.newHashSet((Object[])new String[]{"lucene"}));
            }
            this.planner = new LucenePlanner(this.recordStore.getRecordMetaData(), this.recordStore.getRecordStoreState(), indexTypes, this.recordStore.getTimer());
        }
    }

    protected void openRecordStore(FDBRecordContext context) {
        this.openRecordStore(context, store -> {});
    }

    protected void openRecordStore(FDBRecordContext context, FDBRecordStoreTestBase.RecordMetaDataHook hook) {
        RecordMetaDataBuilder metaDataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsTextProto.getDescriptor());
        metaDataBuilder.getRecordType("ComplexDocument").setPrimaryKey((KeyExpression)Key.Expressions.concatenateFields((String)"group", (String)"doc_id", (String[])new String[0]));
        metaDataBuilder.removeIndex("SimpleDocument$text");
        hook.apply(metaDataBuilder);
        this.recordStore = (FDBRecordStore)this.getStoreBuilder(context, metaDataBuilder.getRecordMetaData()).setSerializer((RecordSerializer)TextIndexTestUtils.COMPRESSING_SERIALIZER).uncheckedOpen();
        this.setupPlanner(null);
    }

    @Test
    void selectsFromMultipleIndexes() throws Exception {
        this.setUseCascadesPlanner(false);
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, metaData -> {
                metaData.addIndex("ComplexDocument", this.textIndex);
                metaData.addIndex("ComplexDocument", this.text2Index);
            });
            this.setupPlanner(null);
            LuceneQueryComponent filter = new LuceneQueryComponent("text2:test", Arrays.asList("text2"));
            RecordQuery rq = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter((QueryComponent)filter).build();
            RecordQueryPlan plan = LuceneQueryIntegrationTest.planQuery((QueryPlanner)this.planner, (RecordQuery)rq);
            Set appliedIndexNames = plan.getUsedIndexes();
            Assertions.assertEquals((int)1, (int)appliedIndexNames.size(), (String)"index selection is incorrect");
            Assertions.assertTrue((boolean)appliedIndexNames.contains(this.text2Index.getName()), (String)"Did not select the correct index");
        }
    }

    @Test
    void selectsFromMultipleNestedIndexes() throws Exception {
        this.setUseCascadesPlanner(false);
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, metaData -> {
                metaData.addIndex("ComplexDocument", new Index(this.nestedDualIndex.toProto()));
                metaData.addIndex("ComplexDocument", new Index(this.nestedDualIndex2.toProto()));
            });
            this.setupPlanner(null);
            LuceneQueryComponent filter = new LuceneQueryComponent("text2:test", Arrays.asList("text2"));
            RecordQuery rq = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter((QueryComponent)filter).build();
            RecordQueryPlan plan = LuceneQueryIntegrationTest.planQuery((QueryPlanner)this.planner, (RecordQuery)rq);
            Set appliedIndexNames = plan.getUsedIndexes();
            Assertions.assertEquals((int)1, (int)appliedIndexNames.size(), (String)"index selection is incorrect");
            Assertions.assertTrue((boolean)appliedIndexNames.contains(this.nestedDualIndex2.getName()), (String)"Did not select the correct index");
        }
    }

    @Test
    void notLucene() throws Exception {
        this.setUseCascadesPlanner(false);
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, metaData -> {
                metaData.addIndex("ComplexDocument", new Index(this.nestedDualIndex.toProto()));
                metaData.addIndex("ComplexDocument", new Index(this.nestedDualIndex2.toProto()));
            });
            this.setupPlanner(null);
            LuceneQueryComponent filter = new LuceneQueryComponent("text2:test", List.of("text2"));
            RecordQuery rq = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter((QueryComponent)filter).build();
            RecordQuery notQuery = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter((QueryComponent)new NotComponent((QueryComponent)filter)).build();
            RecordQueryPlan plan = LuceneQueryIntegrationTest.planQuery((QueryPlanner)this.planner, (RecordQuery)rq);
            RecordQueryPlan notPlan = LuceneQueryIntegrationTest.planQuery((QueryPlanner)this.planner, (RecordQuery)notQuery);
            Assertions.assertEquals((int)71592145, (int)plan.planHash(PlanHashable.CURRENT_LEGACY));
            Assertions.assertEquals((int)-1378983311, (int)notPlan.planHash(PlanHashable.CURRENT_LEGACY));
        }
    }
}

