/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.lucene.LuceneAutoCompleteQueryClause;
import com.apple.foundationdb.record.lucene.LuceneIndexQueryPlan;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneScanParameters;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PPlanReference;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class LucenePlanSerializationTest {
    private static final List<KeyExpression> COMPLEX_MULTIPLE_TEXT_INDEXES_WITH_AUTO_COMPLETE_STORED_FIELDS = List.of(Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")));
    private static final Index COMPLEX_MULTIPLE_TEXT_INDEXES_WITH_AUTO_COMPLETE = new Index("Complex$text_multipleIndexes", (KeyExpression)Key.Expressions.concat(COMPLEX_MULTIPLE_TEXT_INDEXES_WITH_AUTO_COMPLETE_STORED_FIELDS), "lucene", (Map)ImmutableMap.of());

    @Test
    public void simpleLuceneIndexPlan() throws Exception {
        LuceneIndexQueryPlan plan = LuceneIndexQueryPlan.of((String)COMPLEX_MULTIPLE_TEXT_INDEXES_WITH_AUTO_COMPLETE.getName(), (LuceneScanParameters)new LuceneScanQueryParameters(ScanComparisons.EMPTY, (LuceneQueryClause)new LuceneAutoCompleteQueryClause("good", false, (Iterable)ImmutableSet.of((Object)"text", (Object)"text2"))), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY, (boolean)false, null, COMPLEX_MULTIPLE_TEXT_INDEXES_WITH_AUTO_COMPLETE_STORED_FIELDS);
        int plannedPlanHashCode = plan.hashCode();
        PlanSerializationContext planSerializationContext = PlanSerializationContext.newForCurrentMode();
        PPlanReference proto = planSerializationContext.toPlanReferenceProto((RecordQueryPlan)plan);
        byte[] bytes = proto.toByteArray();
        PPlanReference parsedProto = PPlanReference.parseFrom((byte[])bytes);
        planSerializationContext = PlanSerializationContext.newForCurrentMode();
        RecordQueryPlan parsedPlan = planSerializationContext.fromPlanReferenceProto(parsedProto);
        Verify.verify((boolean)(parsedPlan instanceof LuceneIndexQueryPlan));
        Assertions.assertEquals((int)plannedPlanHashCode, (int)plan.hashCode());
    }
}

