/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.lucene.LuceneFunctionNames;
import com.apple.foundationdb.record.lucene.LuceneIndexMaintainer;
import com.apple.foundationdb.record.lucene.LucenePlanner;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryMultiFieldSearchClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.LuceneScanBounds;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.FormatVersion;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactoryRegistry;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextIndexTestUtils;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.CascadesPlanner;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.debug.DebuggerWithSymbolTables;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.search.Sort;

public class LuceneIndexTestUtils {
    protected static final List<KeyExpression> lucene_keys = List.of(Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"value")), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"second_value")), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"third_value")));
    protected static final List<KeyExpression> keys = ImmutableList.copyOf((Iterable)Iterables.concat(List.of(Key.Expressions.field((String)"key")), lucene_keys));
    protected static final String COMBINED_SYNONYM_SETS = "COMBINED_SYNONYM_SETS";
    protected static final String COMPLEX_MULTIPLE_TEXT_INDEXES_KEY = "complex_multiple_text_indexes_key";
    protected static final String SIMPLE_TEXT_SUFFIXES_KEY = "simple_text_suffixes_key";
    protected static final String MANY_FIELDS_INDEX_KEY = "many_fields_index_key";
    protected static final String TEXT_AND_BOOLEAN_INDEX_KEY = "text_and_boolean_index_key";
    protected static final String TEXT_AND_NUMBER_INDEX_KEY = "text_and_number_index_key";
    protected static final String SIMPLE_TEXT_WITH_AUTO_COMPLETE_KEY = "simple_text_with_auto_complete_key";
    protected static final String EMAIL_CJK_SYM_TEXT_WITH_AUTO_COMPLETE_KEY = "email_cjk_sym_text_with_auto_complete_key";
    protected static final String MAP_ON_VALUE_INDEX_KEY = "map_on_value_index_key";
    protected static final String SIMPLE_TEXT_SUFFIXES_WITH_PRIMARY_KEY_SEGMENT_INDEX_KEY = "simple_text_suffixes_with_primary_key_segment_index_key";
    protected static final String COMPLEX_GROUPED_WITH_PRIMARY_KEY_SEGMENT_INDEX_KEY = "complex_grouped_with_primary_key_segment_index_key";
    protected static final String QUERY_ONLY_SYNONYM_LUCENE_INDEX_KEY = "query_only_synonym_lucene_index_key";
    protected static final String AUTHORITATIVE_SYNONYM_ONLY_LUCENE_INDEX_KEY = "authoritative_synonym_only_lucene_index_key";
    protected static final String QUERY_ONLY_SYNONYM_LUCENE_COMBINED_SETS_INDEX_KEY = "query_only_synonym_lucene_combined_sets_index_key";
    protected static final String COMPLEX_MULTIPLE_TEXT_INDEXES_WITH_AUTO_COMPLETE_KEY = "complex_multiple_text_indexes_with_auto_complete_key";
    protected static final String MAP_ON_VALUE_INDEX_WITH_AUTO_COMPLETE_KEY = "map_on_value_index_with_auto_complete_key";
    protected static final String MAP_ON_VALUE_INDEX_WITH_AUTO_COMPLETE_EXCLUDED_FIELDS_KEY = "map_on_value_index_with_auto_complete_excluded_fields_key";
    protected static final String SIMPLE_TEXT_WITH_AUTO_COMPLETE_NO_FREQS_POSITIONS_KEY = "simple_text_with_auto_complete_no_freqs_positions";
    protected static final String SPELLCHECK_INDEX_KEY = "spellcheck_index_key";
    protected static final String SPELLCHECK_INDEX_COMPLEX_KEY = "spellcheck_index_complex_key";
    protected static final String COMPLEX_MULTIPLE_GROUPED_KEY = "complex_multiple_grouped_key";
    protected static final String COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE_KEY = "complex_multi_grouped_with_auto_complete_key";
    protected static final String AUTO_COMPLETE_SIMPLE_LUCENE_INDEX_KEY = "auto_complete_simple_lucene_index_key";
    public static final KeyExpression SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD = Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"));
    protected static final List<KeyExpression> COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE_STORED_FIELDS = ImmutableList.of((Object)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (Object)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")));
    public static final KeyExpression JOINED_SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD = Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")));
    protected static final List<KeyExpression> JOINED_COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE_STORED_FIELDS = ImmutableList.of((Object)Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"))), (Object)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))));
    protected static final List<KeyExpression> MAP_ON_VALUE_INDEX_STORED_FIELDS = (List)lucene_keys.stream().map(key -> Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest(key)).collect(ImmutableList.toImmutableList());
    protected static final List<KeyExpression> JOINED_MAP_ON_VALUE_INDEX_STORED_FIELDS = ImmutableList.of((Object)Key.Expressions.field((String)"map").nest((KeyExpression)Key.Expressions.concat((List)((List)lucene_keys.stream().map(key -> Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest(key)).collect(ImmutableList.toImmutableList())))));
    protected static final Index MAP_ON_VALUE_INDEX_WITH_AUTO_COMPLETE_EXCLUDED_FIELDS = LuceneIndexTestUtils.getMapOnValueIndexWithOption("Map_with_auto_complete_excluded_fields$entry-value", (ImmutableMap<String, String>)ImmutableMap.of());
    public static final Index SIMPLE_TEXT_SUFFIXES = LuceneIndexTestUtils.simpleTextSuffixesIndex(options -> {});
    protected static final Index MANY_FIELDS_INDEX = new Index("many_fields_idx", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text0")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text1")), (KeyExpression[])new KeyExpression[]{Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text3")), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text4")), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text5")), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text6")), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text7")), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text8")), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text9")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long0")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long0")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long1")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long1")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long2")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long2")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long3")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long3")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long4")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long4")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long5")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long5")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long6")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long6")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long7")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long7")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long8")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long8")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long9")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long9")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool0")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool0")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool1")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool1")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool2")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool2")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool3")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool3")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool4")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool4")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool5")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool5")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool6")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool6")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool7")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool7")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool8")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool8")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool9")), Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool9"))}), "lucene", (Map)ImmutableMap.of((Object)"luceneAnalyzerName", (Object)"SYNONYM", (Object)"textSynonymSetName", (Object)"COMBINED_SYNONYM_SETS"));
    protected static final Index TEXT_AND_BOOLEAN_INDEX = new Index("text_and_number_idx", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen")), (KeyExpression[])new KeyExpression[0]), "lucene", Collections.emptyMap());
    protected static final Index TEXT_AND_NUMBER_INDEX = new Index("text_and_number_idx", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group")), (KeyExpression[])new KeyExpression[0]), "lucene", Collections.emptyMap());
    protected static final Index SIMPLE_TEXT_WITH_AUTO_COMPLETE = new Index("Simple_with_auto_complete", SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD, "lucene", (Map)ImmutableMap.of());
    protected static final Index EMAIL_CJK_SYM_TEXT_WITH_AUTO_COMPLETE = new Index("Email_cjk_sym_with_auto_complete", SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD, "lucene", (Map)ImmutableMap.of((Object)"luceneAnalyzerName", (Object)"SYNONYM_EMAIL"));
    protected static final Index MAP_ON_VALUE_INDEX = LuceneIndexTestUtils.getMapOnValueIndexWithOption("Map$entry-value", (ImmutableMap<String, String>)ImmutableMap.of());
    protected static final Index MAP_ON_VALUE_INDEX_WITH_AUTO_COMPLETE = LuceneIndexTestUtils.getMapOnValueIndexWithOption("Map_with_auto_complete$entry-value", (ImmutableMap<String, String>)ImmutableMap.of());
    protected static final Index SIMPLE_TEXT_SUFFIXES_WITH_PRIMARY_KEY_SEGMENT_INDEX = new Index("Simple$text_suffixes_pky", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes", (Object)"primaryKeySegmentIndexV2Enabled", (Object)"true"));
    protected static final Index COMPLEX_GROUPED_WITH_PRIMARY_KEY_SEGMENT_INDEX = new Index("Complex$text_pky", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes", (Object)"primaryKeySegmentIndexV2Enabled", (Object)"true"));
    public static final Index COMPLEX_MULTIPLE_TEXT_INDEXES = new Index("Complex$text_multipleIndexes", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")), (KeyExpression[])new KeyExpression[0]), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes"));
    public static final Index TEXT_AND_STORED = new Index("Simple$test_stored", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group")), (KeyExpression[])new KeyExpression[0]), "lucene", Collections.emptyMap());
    public static final Index TEXT_AND_STORED_COMPLEX = LuceneIndexTestUtils.textAndStoredComplexIndex(options -> {});
    public static final Index QUERY_ONLY_SYNONYM_LUCENE_INDEX = new Index("synonym_index", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "lucene", (Map)ImmutableMap.of((Object)"luceneAnalyzerName", (Object)"SYNONYM", (Object)"textSynonymSetName", (Object)"EXPANDED_US_EN"));
    protected static final Index AUTHORITATIVE_SYNONYM_ONLY_LUCENE_INDEX = new Index("synonym_index", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "lucene", (Map)ImmutableMap.of((Object)"luceneAnalyzerName", (Object)"INDEX_ONLY_SYNONYM", (Object)"textSynonymSetName", (Object)"AUTHORITATIVE_ONLY_US_EN"));
    private static final Index QUERY_ONLY_SYNONYM_LUCENE_COMBINED_SETS_INDEX = new Index("synonym_combined_sets_index", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "lucene", (Map)ImmutableMap.of((Object)"luceneAnalyzerName", (Object)"SYNONYM", (Object)"textSynonymSetName", (Object)"COMBINED_SYNONYM_SETS"));
    public static final Index NGRAM_LUCENE_INDEX = new Index("ngram_index", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "lucene", (Map)ImmutableMap.of((Object)"luceneAnalyzerName", (Object)"NGRAM", (Object)"textTokenMinSize", (Object)"3", (Object)"textTokenMaxSize", (Object)"5"));
    protected static final List<KeyExpression> COMPLEX_MULTIPLE_TEXT_INDEXES_WITH_AUTO_COMPLETE_STORED_FIELDS = List.of(Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")));
    protected static final Index COMPLEX_MULTIPLE_TEXT_INDEXES_WITH_AUTO_COMPLETE = new Index("Complex$text_multipleIndexes", (KeyExpression)Key.Expressions.concat(COMPLEX_MULTIPLE_TEXT_INDEXES_WITH_AUTO_COMPLETE_STORED_FIELDS), "lucene", (Map)ImmutableMap.of());
    private static final Index SIMPLE_TEXT_WITH_AUTO_COMPLETE_NO_FREQS_POSITIONS = new Index("Simple_with_auto_complete", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"text"), (KeyExpression)Key.Expressions.function((String)"lucene_auto_complete_field_index_options", (KeyExpression)Key.Expressions.value((Object)LuceneFunctionNames.LuceneFieldIndexOptions.DOCS.name())), (KeyExpression[])new KeyExpression[]{Key.Expressions.function((String)"lucene_full_text_field_index_options", (KeyExpression)Key.Expressions.value((Object)LuceneFunctionNames.LuceneFieldIndexOptions.DOCS.name()))})), "lucene", (Map)ImmutableMap.of());
    protected static final Index SPELLCHECK_INDEX = new Index("spellcheck_index", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "lucene", Collections.emptyMap());
    protected static final Index SPELLCHECK_INDEX_COMPLEX = new Index("spellcheck_index_complex", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")), (KeyExpression[])new KeyExpression[0]), "lucene", Collections.emptyMap());
    protected static final Index COMPLEX_MULTIPLE_GROUPED = new Index("Complex$text_multiple_grouped", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")), (KeyExpression[])new KeyExpression[0]).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene");
    protected static final Index COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE = new Index("Complex$text_multiple_grouped_autocomplete", (KeyExpression)Key.Expressions.concat(COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE_STORED_FIELDS).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene", (Map)ImmutableMap.of());
    private static final Index AUTO_COMPLETE_SIMPLE_LUCENE_INDEX = new Index("Complex$multiple_analyzer_autocomplete", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")), (KeyExpression[])new KeyExpression[0]), "lucene", (Map)ImmutableMap.of());
    protected static final Index JOINED_COMPLEX_GROUPED_WITH_PRIMARY_KEY_SEGMENT_INDEX = new Index("JoinedComplex$text_pky", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"))), (KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"score"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))}).groupBy((KeyExpression)Key.Expressions.field((String)"complex").nest("score"), new KeyExpression[0]), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes", (Object)"primaryKeySegmentIndexV2Enabled", (Object)"true"));
    protected static final Index JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES = new Index("JoinedComplex$text_multipleIndexes", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), (KeyExpression)Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"score"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))}), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes", (Object)"textSynonymSetName", (Object)"EXPANDED_US_EN", (Object)"optimizedStoredFieldsFormatEnabled", (Object)"true"));
    protected static final Index JOINED_COMPLEX_MULTIPLE_EMAIL_CJK_SYM_INDEXES = new Index("JoinedComplex$text_multipleEmailCJKSymIndexes", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), (KeyExpression)Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"score"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))}), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes", (Object)"luceneAnalyzerName", (Object)"SYNONYM_EMAIL", (Object)"textSynonymSetName", (Object)"EXPANDED_US_EN", (Object)"optimizedStoredFieldsFormatEnabled", (Object)"true"));
    protected static final Index JOINED_SYNONYM_ONLY_COMPLEX_MULTIPLE_TEXT_INDEXES = new Index("JoinedComplex$synonym_only_text_multipleIndexes", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), (KeyExpression)Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"score"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))}), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes", (Object)"luceneAnalyzerName", (Object)"SYNONYM", (Object)"textSynonymSetName", (Object)"EXPANDED_US_EN", (Object)"optimizedStoredFieldsFormatEnabled", (Object)"true"));
    protected static final Index JOINED_AUTHORITATIVE_SYNONYM_COMPLEX_MULTIPLE_TEXT_INDEXES = new Index("JoinedSynonymAuthoritativeComplex$text_multipleIndexes", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), (KeyExpression)Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"score"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))}), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes", (Object)"luceneAnalyzerName", (Object)"INDEX_ONLY_SYNONYM", (Object)"textSynonymSetName", (Object)"AUTHORITATIVE_ONLY_US_EN", (Object)"optimizedStoredFieldsFormatEnabled", (Object)"true"));
    protected static final Index JOINED_QUERY_ONLY_SYNONYM_LUCENE_COMBINED_SETS_INDEX = new Index("JoinedSynonymCombinedComplex$text_multipleIndexes", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), (KeyExpression)Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"score"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))}), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes", (Object)"luceneAnalyzerName", (Object)"INDEX_ONLY_SYNONYM", (Object)"textSynonymSetName", (Object)"COMBINED_SYNONYM_SETS", (Object)"optimizedStoredFieldsFormatEnabled", (Object)"true"));
    protected static final Index JOINED_COMPLEX_MULTIPLE_TEXT_PRIMARY_KEY_SEGMENT_INDEXES = new Index("JoinedComplex$text_multipleIndexes", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), (KeyExpression)Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"score"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))}), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes", (Object)"primaryKeySegmentIndexV2Enabled", (Object)"true"));
    protected static final Index JOINED_MANY_FIELDS_INDEX = new Index("Joined$many_fields_idx", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), (KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text0"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text1"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text3"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text4"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text5"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text6"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text7"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text8"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text9"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long0"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long0"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long1"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long1"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long2"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long2"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long3"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long3"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long4"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long4"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long5"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long5"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long6"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long6"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long7"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long7"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long8"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long8"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"long9"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"long9"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool0"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool0"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool1"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool1"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool2"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool2"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool3"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool3"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool4"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool4"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool5"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool5"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool6"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool6"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool7"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool7"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool8"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool8"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"bool9"))), Key.Expressions.field((String)"many").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"bool9")))}), "lucene", (Map)ImmutableMap.of((Object)"luceneAnalyzerName", (Object)"SYNONYM", (Object)"textSynonymSetName", (Object)"COMBINED_SYNONYM_SETS"));
    protected static final Index JOINED_COMPLEX_MAP_TEXT_INDEXES = new Index("JoinedComplex$map_textIndexes", (KeyExpression)new GroupingKeyExpression((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"map").nest((KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.concat(keys))), (KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"score"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))}), 8), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes", (Object)"primaryKeySegmentIndexV2Enabled", (Object)"true"));
    protected static final Index JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES_NO_FREQS_POSITIONS = new Index("JoinedComplex$text_multipleIndexes", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), (KeyExpression)Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"text"), (KeyExpression)Key.Expressions.function((String)"lucene_auto_complete_field_index_options", (KeyExpression)Key.Expressions.value((Object)LuceneFunctionNames.LuceneFieldIndexOptions.DOCS.name())), (KeyExpression[])new KeyExpression[]{Key.Expressions.function((String)"lucene_full_text_field_index_options", (KeyExpression)Key.Expressions.value((Object)LuceneFunctionNames.LuceneFieldIndexOptions.DOCS.name()))}))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"score"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group"))), Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))}), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes", (Object)"luceneAnalyzerName", (Object)"SYNONYM", (Object)"textSynonymSetName", (Object)"EXPANDED_US_EN", (Object)"optimizedStoredFieldsFormatEnabled", (Object)"true"));

    @Nonnull
    public static Index simpleTextSuffixesIndex(Consumer<Map<String, String>> optionsBuilder) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("textTokenizerName", "all_suffixes");
        options.put("optimizedStoredFieldsFormatEnabled", "true");
        optionsBuilder.accept(options);
        return new Index("Simple$text_suffixes", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "lucene", options);
    }

    @Nonnull
    public static Index textAndStoredComplexIndex(Consumer<Map<String, String>> optionsBuilder) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("textTokenizerName", "all_suffixes");
        options.put("optimizedStoredFieldsFormatEnabled", "true");
        optionsBuilder.accept(options);
        return new Index("Simple$test_stored_complex", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"text2")), (KeyExpression[])new KeyExpression[]{Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"group")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"score")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"time")), Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))}), "lucene", options);
    }

    public static Stream<IndexedType> luceneIndexMapParams() {
        return Stream.of(IndexedType.values());
    }

    protected static Index getMapOnValueIndexWithOption(@Nonnull String name, @Nonnull ImmutableMap<String, String> options) {
        return new Index(name, (KeyExpression)new GroupingKeyExpression((KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.concat(keys)), 3), "lucene", options);
    }

    public static TestRecordsTextProto.SimpleDocument createSimpleDocument(long docId, String text, Integer group) {
        TestRecordsTextProto.SimpleDocument.Builder doc = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(docId).setText(text);
        if (group != null) {
            doc.setGroup((long)group.intValue());
        }
        return doc.build();
    }

    static TestRecordsTextProto.SimpleDocument createSimpleDocument(long docId, int group) {
        return TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(docId).setGroup((long)group).build();
    }

    public static Pair<FDBRecordStore, QueryPlanner> rebuildIndexMetaData(FDBRecordContext context, KeySpacePath path, String document, Index index, boolean useCascadesPlanner) {
        return LuceneIndexTestUtils.rebuildIndexMetaData(context, path, document, index, useCascadesPlanner, null);
    }

    public static Pair<FDBRecordStore, QueryPlanner> rebuildIndexMetaData(FDBRecordContext context, KeySpacePath path, String document, Index index, boolean useCascadesPlanner, @Nullable IndexMaintainerFactoryRegistry indexMaintainerRegistry) {
        FDBRecordStore store = LuceneIndexTestUtils.openRecordStore(context, path, metaDataBuilder -> {
            metaDataBuilder.removeIndex("SimpleDocument$text");
            metaDataBuilder.addIndex(document, index);
        }, indexMaintainerRegistry);
        QueryPlanner planner = LuceneIndexTestUtils.setupPlanner(store, null, useCascadesPlanner);
        return Pair.of((Object)store, (Object)planner);
    }

    static FDBRecordStore openRecordStore(FDBRecordContext context, @Nonnull KeySpacePath path, FDBRecordStoreTestBase.RecordMetaDataHook hook) {
        return LuceneIndexTestUtils.openRecordStore(context, path, hook, null);
    }

    static FDBRecordStore openRecordStore(FDBRecordContext context, @Nonnull KeySpacePath path, FDBRecordStoreTestBase.RecordMetaDataHook hook, @Nullable IndexMaintainerFactoryRegistry indexMaintainerRegistry) {
        RecordMetaDataBuilder metaDataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsTextProto.getDescriptor());
        metaDataBuilder.getRecordType("ComplexDocument").setPrimaryKey((KeyExpression)Key.Expressions.concatenateFields((String)"group", (String)"doc_id", (String[])new String[0]));
        hook.apply(metaDataBuilder);
        return (FDBRecordStore)LuceneIndexTestUtils.getStoreBuilder(context, path, metaDataBuilder.getRecordMetaData(), indexMaintainerRegistry).setSerializer((RecordSerializer)TextIndexTestUtils.COMPRESSING_SERIALIZER).createOrOpen();
    }

    @Nonnull
    private static FDBRecordStore.Builder getStoreBuilder(@Nonnull FDBRecordContext context, @Nonnull KeySpacePath path, @Nonnull RecordMetaData metaData, @Nullable IndexMaintainerFactoryRegistry indexMaintainerRegistry) {
        FDBRecordStore.Builder builder = FDBRecordStore.newBuilder().setFormatVersion(FormatVersion.getMaximumSupportedVersion()).setKeySpacePath(path).setContext(context).setMetaDataProvider((RecordMetaDataProvider)metaData);
        if (indexMaintainerRegistry != null) {
            builder.setIndexMaintainerRegistry(indexMaintainerRegistry);
        }
        return builder;
    }

    static QueryPlanner setupPlanner(@Nonnull FDBRecordStore recordStore, @Nullable PlannableIndexTypes indexTypes, boolean useRewritePlanner) {
        CascadesPlanner planner;
        if (useRewritePlanner) {
            planner = recordStore.getCascadesPlanner();
            if (Debugger.getDebugger() == null) {
                Debugger.setDebugger((Debugger)DebuggerWithSymbolTables.withSanityChecks());
            }
            Debugger.setup();
        } else {
            if (indexTypes == null) {
                indexTypes = new PlannableIndexTypes((Set)Sets.newHashSet((Object[])new String[]{"value", "version"}), (Set)Sets.newHashSet((Object[])new String[]{"rank", "time_window_leaderboard"}), (Set)Sets.newHashSet((Object[])new String[]{"text"}), (Set)Sets.newHashSet((Object[])new String[]{"lucene"}));
            }
            planner = new LucenePlanner(recordStore.getRecordMetaData(), recordStore.getRecordStoreState(), indexTypes, recordStore.getTimer());
        }
        return planner;
    }

    public static LuceneScanBounds fullSortTextSearch(FDBRecordStore recordStore, Index index, String search, Sort sort) {
        LuceneScanQueryParameters scan = new LuceneScanQueryParameters(ScanComparisons.EMPTY, (LuceneQueryClause)new LuceneQueryMultiFieldSearchClause(LuceneQueryType.QUERY, search, false), sort, null, null, null);
        return scan.bind((FDBRecordStoreBase)recordStore, index, EvaluationContext.EMPTY);
    }

    public static LuceneScanBounds fullTextSearch(FDBRecordStore recordStore, Index index, String search, boolean highlight) {
        return LuceneIndexTestUtils.fullTextSearch(recordStore, index, (LuceneQueryClause)new LuceneQueryMultiFieldSearchClause(highlight ? LuceneQueryType.QUERY_HIGHLIGHT : LuceneQueryType.QUERY, search, false), highlight);
    }

    public static LuceneScanBounds fullTextSearch(FDBRecordStore recordStore, Index index, LuceneQueryClause search, boolean highlight) {
        LuceneScanQueryParameters scan = new LuceneScanQueryParameters(ScanComparisons.EMPTY, search, null, null, null, highlight ? new LuceneScanQueryParameters.LuceneQueryHighlightParameters(-1, 10) : null);
        return scan.bind((FDBRecordStoreBase)recordStore, index, EvaluationContext.EMPTY);
    }

    public static LuceneScanBounds fullTextSearch(FDBRecordStore recordStore, Index index, String search, boolean highlight, int snippetSize) {
        LuceneScanQueryParameters scan = new LuceneScanQueryParameters(ScanComparisons.EMPTY, (LuceneQueryClause)new LuceneQueryMultiFieldSearchClause(highlight ? LuceneQueryType.QUERY_HIGHLIGHT : LuceneQueryType.QUERY, search, false), null, null, null, highlight ? new LuceneScanQueryParameters.LuceneQueryHighlightParameters(snippetSize, 10) : null);
        return scan.bind((FDBRecordStoreBase)recordStore, index, EvaluationContext.EMPTY);
    }

    public static String[] generateRandomWords(int numberOfWords) {
        assert (numberOfWords > 0) : "Number of words have to be greater than 0";
        StringBuilder builder = new StringBuilder();
        Random random = new Random();
        char[] word = null;
        for (int i = 0; i < numberOfWords; ++i) {
            word = new char[random.nextInt(8) + 3];
            for (int j = 0; j < word.length; ++j) {
                word[j] = (char)(97 + random.nextInt(26));
            }
            if (i == numberOfWords - 1) continue;
            builder.append(word).append(" ");
        }
        String[] returnValue = new String[]{new String(word), builder.toString()};
        return returnValue;
    }

    public static TestRecordsTextProto.ComplexDocument createComplexDocument(long docId, String text, String text2, int group) {
        return LuceneIndexTestUtils.createComplexDocument(docId, text, text2, group, true);
    }

    public static TestRecordsTextProto.ComplexDocument createComplexDocument(long docId, String text, String text2, int group, boolean isSeen) {
        return TestRecordsTextProto.ComplexDocument.newBuilder().setDocId(docId).setText(text).setText2(text2).setGroup((long)group).setIsSeen(isSeen).build();
    }

    public static TestRecordsTextProto.ComplexDocument createComplexDocument(long docId, String text, long group, long timestamp) {
        return TestRecordsTextProto.ComplexDocument.newBuilder().setDocId(docId).setText(text).setGroup(group).setTimestamp(timestamp).build();
    }

    public static TestRecordsTextProto.ComplexDocument createComplexDocument(long docId, String text, String text2, long group, Integer score, boolean isSeen, double time) {
        TestRecordsTextProto.ComplexDocument.Builder builder = TestRecordsTextProto.ComplexDocument.newBuilder().setDocId(docId).setText(text).setText2(text2).setGroup(group).setIsSeen(isSeen).setTime(time);
        if (score != null) {
            builder.setScore(score.intValue());
        }
        return builder.build();
    }

    public static TestRecordsTextProto.MapDocument createComplexMapDocument(long docId, String text, String text2, int group) {
        return TestRecordsTextProto.MapDocument.newBuilder().setDocId(docId).setGroup((long)group).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey(text2).setValue(text).setSecondValue("secondValue" + docId).setThirdValue("thirdValue" + docId).build()).build();
    }

    static TestRecordsTextProto.ManyFieldsDocument createManyFieldsDocument(long docId, String text, long number, boolean bool) {
        return TestRecordsTextProto.ManyFieldsDocument.newBuilder().setDocId(docId).setText0(text).setText1(text).setText2(text).setText3(text).setText4(text).setText5(text).setText6(text).setText7(text).setText8(text).setText9(text).setLong0(number).setLong1(number).setLong2(number).setLong3(number).setLong4(number).setLong5(number).setLong6(number).setLong7(number).setLong8(number).setLong9(number).setBool0(bool).setBool1(bool).setBool2(bool).setBool3(bool).setBool4(bool).setBool5(bool).setBool6(bool).setBool7(bool).setBool8(bool).setBool9(bool).build();
    }

    protected static TestRecordsTextProto.MapDocument createMultiEntryMapDoc(long docId, String text, String text2, String text3, String text4, int group) {
        return TestRecordsTextProto.MapDocument.newBuilder().setDocId(docId).setGroup((long)group).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey(text2).setValue(text).setSecondValue("firstEntrySecondValue").setThirdValue("firstEntryThirdValue")).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey(text4).setValue(text3).setSecondValue("secondEntrySecondValue").setThirdValue("secondEntryThirdValue")).build();
    }

    public static void mergeSegments(FDBRecordStore recordStore, Index index) {
        try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(recordStore)).setIndex(index).build();){
            indexBuilder.mergeIndex();
        }
    }

    public static void rebalancePartitions(FDBRecordStore recordStore, Index index) throws Exception {
        LuceneIndexMaintainer indexMaintainer = (LuceneIndexMaintainer)recordStore.getIndexMaintainer(index);
        try {
            indexMaintainer.rebalancePartitions().get();
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    public static enum IndexedType {
        Synthetic(Map.ofEntries(Map.entry("simple_text_suffixes_key", JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES), Map.entry("many_fields_index_key", JOINED_MANY_FIELDS_INDEX), Map.entry("text_and_boolean_index_key", JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES), Map.entry("text_and_number_index_key", JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES), Map.entry("simple_text_with_auto_complete_key", JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES), Map.entry("email_cjk_sym_text_with_auto_complete_key", JOINED_COMPLEX_MULTIPLE_EMAIL_CJK_SYM_INDEXES), Map.entry("map_on_value_index_key", JOINED_COMPLEX_MAP_TEXT_INDEXES), Map.entry("simple_text_suffixes_with_primary_key_segment_index_key", JOINED_COMPLEX_MULTIPLE_TEXT_PRIMARY_KEY_SEGMENT_INDEXES), Map.entry("complex_multiple_text_indexes_key", JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES), Map.entry("complex_grouped_with_primary_key_segment_index_key", JOINED_COMPLEX_GROUPED_WITH_PRIMARY_KEY_SEGMENT_INDEX), Map.entry("query_only_synonym_lucene_index_key", JOINED_SYNONYM_ONLY_COMPLEX_MULTIPLE_TEXT_INDEXES), Map.entry("authoritative_synonym_only_lucene_index_key", JOINED_AUTHORITATIVE_SYNONYM_COMPLEX_MULTIPLE_TEXT_INDEXES), Map.entry("query_only_synonym_lucene_combined_sets_index_key", JOINED_QUERY_ONLY_SYNONYM_LUCENE_COMBINED_SETS_INDEX), Map.entry("complex_multiple_text_indexes_with_auto_complete_key", JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES), Map.entry("map_on_value_index_with_auto_complete_key", JOINED_COMPLEX_MAP_TEXT_INDEXES), Map.entry("map_on_value_index_with_auto_complete_excluded_fields_key", JOINED_COMPLEX_MAP_TEXT_INDEXES), Map.entry("simple_text_with_auto_complete_no_freqs_positions", JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES_NO_FREQS_POSITIONS), Map.entry("spellcheck_index_key", JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES), Map.entry("spellcheck_index_complex_key", JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES), Map.entry("complex_multiple_grouped_key", JOINED_COMPLEX_GROUPED_WITH_PRIMARY_KEY_SEGMENT_INDEX), Map.entry("complex_multi_grouped_with_auto_complete_key", JOINED_COMPLEX_GROUPED_WITH_PRIMARY_KEY_SEGMENT_INDEX), Map.entry("auto_complete_simple_lucene_index_key", JOINED_COMPLEX_MULTIPLE_TEXT_INDEXES)), true, List.of(Integer.valueOf(1373414429), Integer.valueOf(-542327065), Integer.valueOf(1373414429), Integer.valueOf(-1751615347), Integer.valueOf(-1644529491), Integer.valueOf(-1644529491), Integer.valueOf(2019229269))),
        NonSynthetic(Map.ofEntries(Map.entry("simple_text_suffixes_key", SIMPLE_TEXT_SUFFIXES), Map.entry("many_fields_index_key", MANY_FIELDS_INDEX), Map.entry("text_and_boolean_index_key", TEXT_AND_BOOLEAN_INDEX), Map.entry("text_and_number_index_key", TEXT_AND_NUMBER_INDEX), Map.entry("simple_text_with_auto_complete_key", SIMPLE_TEXT_WITH_AUTO_COMPLETE), Map.entry("email_cjk_sym_text_with_auto_complete_key", EMAIL_CJK_SYM_TEXT_WITH_AUTO_COMPLETE), Map.entry("map_on_value_index_key", MAP_ON_VALUE_INDEX), Map.entry("simple_text_suffixes_with_primary_key_segment_index_key", SIMPLE_TEXT_SUFFIXES_WITH_PRIMARY_KEY_SEGMENT_INDEX), Map.entry("complex_multiple_text_indexes_key", COMPLEX_MULTIPLE_TEXT_INDEXES), Map.entry("complex_grouped_with_primary_key_segment_index_key", COMPLEX_GROUPED_WITH_PRIMARY_KEY_SEGMENT_INDEX), Map.entry("query_only_synonym_lucene_index_key", QUERY_ONLY_SYNONYM_LUCENE_INDEX), Map.entry("authoritative_synonym_only_lucene_index_key", AUTHORITATIVE_SYNONYM_ONLY_LUCENE_INDEX), Map.entry("query_only_synonym_lucene_combined_sets_index_key", QUERY_ONLY_SYNONYM_LUCENE_COMBINED_SETS_INDEX), Map.entry("complex_multiple_text_indexes_with_auto_complete_key", COMPLEX_MULTIPLE_TEXT_INDEXES_WITH_AUTO_COMPLETE), Map.entry("map_on_value_index_with_auto_complete_key", MAP_ON_VALUE_INDEX_WITH_AUTO_COMPLETE), Map.entry("map_on_value_index_with_auto_complete_excluded_fields_key", MAP_ON_VALUE_INDEX_WITH_AUTO_COMPLETE_EXCLUDED_FIELDS), Map.entry("simple_text_with_auto_complete_no_freqs_positions", SIMPLE_TEXT_WITH_AUTO_COMPLETE_NO_FREQS_POSITIONS), Map.entry("spellcheck_index_key", SPELLCHECK_INDEX), Map.entry("spellcheck_index_complex_key", SPELLCHECK_INDEX_COMPLEX), Map.entry("complex_multiple_grouped_key", COMPLEX_MULTIPLE_GROUPED), Map.entry("complex_multi_grouped_with_auto_complete_key", COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE), Map.entry("auto_complete_simple_lucene_index_key", AUTO_COMPLETE_SIMPLE_LUCENE_INDEX)), false, List.of(Integer.valueOf(1498044543), Integer.valueOf(-417696951), Integer.valueOf(-687982540), Integer.valueOf(-1626985233), Integer.valueOf(-1008465729), Integer.valueOf(1532371150), Integer.valueOf(-42167700)));

        private final Map<String, Index> indexes;
        private final boolean isSynthetic;
        private final List<Integer> planHashes;

        private IndexedType(Map<String, Index> indexes, boolean isSynthetic, List<Integer> planHashes) {
            this.indexes = indexes;
            this.isSynthetic = isSynthetic;
            this.planHashes = planHashes;
        }

        public Index getIndex(String key) {
            return this.indexes.get(key);
        }

        public boolean isSynthetic() {
            return this.isSynthetic;
        }

        public List<Integer> getPlanHashes() {
            return this.planHashes;
        }
    }
}

