/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.IndexState;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.lucene.FDBLuceneTestBase;
import com.apple.foundationdb.record.lucene.LuceneIndexTestDataModel;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.directory.InjectedFailureRepository;
import com.apple.foundationdb.record.lucene.directory.MockedLuceneIndexMaintainerFactory;
import com.apple.foundationdb.record.lucene.directory.TestingIndexMaintainerRegistry;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactoryRegistry;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexScrubber;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.protobuf.Message;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class LuceneIndexScrubbingTest
extends FDBLuceneTestBase {
    private TestingIndexMaintainerRegistry registry;
    private boolean flipBoolean = false;

    LuceneIndexScrubbingTest() {
    }

    @BeforeEach
    public void beforeEach() {
        this.registry = new TestingIndexMaintainerRegistry();
    }

    private void rebuildIndexMetaData(FDBRecordContext context, String document, Index index) {
        Pair<FDBRecordStore, QueryPlanner> pair = LuceneIndexTestUtils.rebuildIndexMetaData(context, this.path, document, index, this.isUseCascadesPlanner());
        this.recordStore = (FDBRecordStore)pair.getLeft();
        this.planner = (QueryPlanner)pair.getRight();
    }

    private static Stream<Arguments> threeBooleanArgs() {
        return Stream.of(false, true).flatMap(isSynthetic -> Stream.of(false, true).flatMap(isPartitioned -> Stream.of(false, true).map(isGrouped -> Arguments.of((Object[])new Object[]{isSynthetic, isGrouped, isPartitioned}))));
    }

    @Nonnull
    protected FDBRecordStore.Builder getStoreBuilderWithRegistry(@Nonnull FDBRecordContext context, @Nonnull RecordMetaDataProvider metaData, @Nonnull KeySpacePath path) {
        return super.getStoreBuilder(context, metaData, path).setIndexMaintainerRegistry((IndexMaintainerFactoryRegistry)this.registry);
    }

    @ParameterizedTest
    @MethodSource(value={"threeBooleanArgs"})
    void luceneIndexScrubMissingDataModelNoIssues(boolean isSynthetic, boolean isGrouped, boolean isPartitioned) {
        long seed = 7L;
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(7L, this::getStoreBuilderWithRegistry, this.pathManager).setIsGrouped(isGrouped).setIsSynthetic(isSynthetic).setPartitionHighWatermark(isPartitioned ? 5 : 0).build();
        for (int i = 0; i < 14; ++i) {
            try (FDBRecordContext context = this.openContext();){
                dataModel.saveRecords(7, context, i / 6);
                context.commit();
                continue;
            }
        }
        try (FDBRecordContext context = this.openContext();){
            dataModel.explicitMergeIndex(context, this.timer);
            context.commit();
        }
        context = this.openContext();
        try {
            FDBRecordStore store = dataModel.createOrOpenRecordStore(context);
            boolean atLeastOnce = false;
            for (Map.Entry entry : store.getAllIndexStates().entrySet()) {
                Index index = (Index)entry.getKey();
                IndexState indexState = (IndexState)entry.getValue();
                if (!index.getType().equalsIgnoreCase("lucene") || !indexState.equals((Object)IndexState.READABLE)) continue;
                atLeastOnce = true;
                OnlineIndexScrubber indexScrubber = ((OnlineIndexScrubber.Builder)OnlineIndexScrubber.newBuilder().setRecordStore(store)).setIndex(index).build();
                try {
                    long missingEntriesCount = indexScrubber.scrubMissingIndexEntries();
                    Assertions.assertEquals((long)0L, (long)missingEntriesCount);
                }
                finally {
                    if (indexScrubber == null) continue;
                    indexScrubber.close();
                }
            }
            Assertions.assertTrue((boolean)atLeastOnce);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    void luceneIndexScrubMissingSimpleNoIssues() {
        Index index = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES_WITH_PRIMARY_KEY_SEGMENT_INDEX;
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(2222L, "There's always one more way to do things and that's your way, and you have a right to try it at least once. who?", 1));
            context.commit();
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(7771547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(7772222L, "There's always one more way to do things and that's your way, and you have a right to try it at least once. who?", 1));
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            try (OnlineIndexScrubber indexScrubber = ((OnlineIndexScrubber.Builder)OnlineIndexScrubber.newBuilder().setRecordStore(this.recordStore)).setIndex(index).build();){
                long missingEntriesCount = indexScrubber.scrubMissingIndexEntries();
                Assertions.assertEquals((long)0L, (long)missingEntriesCount);
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"threeBooleanArgs"})
    void luceneIndexScrubMissingDataModel(boolean isSynthetic, boolean isGrouped, boolean isPartitioned) {
        long seed = 207L;
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(207L, this::getStoreBuilderWithRegistry, this.pathManager).setIsGrouped(isGrouped).setIsSynthetic(isSynthetic).setPartitionHighWatermark(isPartitioned ? 5 : 0).build();
        InjectedFailureRepository injectedFailures = new InjectedFailureRepository();
        this.registry.overrideFactory((IndexMaintainerFactory)new MockedLuceneIndexMaintainerFactory(injectedFailures));
        try (FDBRecordContext context = this.openContext();){
            dataModel.saveRecordsToAllGroups(17, context);
            context.commit();
        }
        context = this.openContext();
        try {
            dataModel.explicitMergeIndex(context, this.timer);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            dataModel.setReverseSaveOrder(true);
            dataModel.saveRecords(7, context, 1);
            dataModel.setReverseSaveOrder(false);
            dataModel.saveRecords(7, context, 2);
            injectedFailures.setFlag(InjectedFailureRepository.Flags.LUCENE_MAINTAINER_SKIP_INDEX_UPDATE);
            dataModel.saveRecords(5, context, 4);
            dataModel.setReverseSaveOrder(true);
            dataModel.saveRecords(3, context, 1);
            dataModel.setReverseSaveOrder(false);
            dataModel.saveRecords(2, context, 3);
            injectedFailures.setFlag(InjectedFailureRepository.Flags.LUCENE_MAINTAINER_SKIP_INDEX_UPDATE, false);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            dataModel.explicitMergeIndex(context, this.timer);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            FDBRecordStore store = dataModel.createOrOpenRecordStore(context);
            boolean atLeastOnce = false;
            for (Map.Entry entry : store.getAllIndexStates().entrySet()) {
                Index index = (Index)entry.getKey();
                IndexState indexState = (IndexState)entry.getValue();
                if (!index.getType().equalsIgnoreCase("lucene") || !indexState.equals((Object)IndexState.READABLE)) continue;
                atLeastOnce = true;
                OnlineIndexScrubber indexScrubber = ((OnlineIndexScrubber.Builder)OnlineIndexScrubber.newBuilder().setRecordStore(store)).setIndex(index).build();
                try {
                    long missingEntriesCount = indexScrubber.scrubMissingIndexEntries();
                    Assertions.assertEquals((long)10L, (long)missingEntriesCount);
                }
                finally {
                    if (indexScrubber == null) continue;
                    indexScrubber.close();
                }
            }
            Assertions.assertTrue((boolean)atLeastOnce);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    void luceneIndexScrubMissingSimple() {
        Index index = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES_WITH_PRIMARY_KEY_SEGMENT_INDEX;
        long startTime = System.currentTimeMillis();
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1L, startTime));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1L, startTime + 1000L));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(2222L, "There's always one more way to do things and that's your way, and you have a right to try it at least once. who?", 1L, startTime + 2000L));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(899L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, startTime + 3000L));
            context.commit();
        }
        InjectedFailureRepository injectedFailures = new InjectedFailureRepository();
        this.registry.overrideFactory((IndexMaintainerFactory)new MockedLuceneIndexMaintainerFactory(injectedFailures));
        try (FDBRecordContext context = this.openContext();){
            Pair<FDBRecordStore, QueryPlanner> pair = LuceneIndexTestUtils.rebuildIndexMetaData(context, this.path, "SimpleDocument", index, this.isUseCascadesPlanner(), this.registry);
            this.recordStore = (FDBRecordStore)pair.getLeft();
            this.planner = (QueryPlanner)pair.getRight();
            injectedFailures.setFlag(InjectedFailureRepository.Flags.LUCENE_MAINTAINER_SKIP_INDEX_UPDATE);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(7771547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(7772222L, "There's always one more way to do things and that's your way, and you have a right to try it at least once. who?", 1));
            injectedFailures.setFlag(InjectedFailureRepository.Flags.LUCENE_MAINTAINER_SKIP_INDEX_UPDATE, false);
            context.commit();
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            try (OnlineIndexScrubber indexScrubber = ((OnlineIndexScrubber.Builder)OnlineIndexScrubber.newBuilder().setRecordStore(this.recordStore)).setIndex(index).build();){
                long missingEntriesCount = indexScrubber.scrubMissingIndexEntries();
                Assertions.assertEquals((long)3L, (long)missingEntriesCount);
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }
}

