/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.EmailCjkSynonymAnalyzer;
import com.apple.foundationdb.record.lucene.EmailCjkSynonymAnalyzerFactory;
import com.apple.foundationdb.record.lucene.LuceneAutoCompleteHelpers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class LuceneAutoCompletedMatchesTest {
    LuceneAutoCompletedMatchesTest() {
    }

    private static Analyzer getTestAnalyzer() {
        return new EmailCjkSynonymAnalyzer(EmailCjkSynonymAnalyzerFactory.MINIMAL_STOP_WORDS, 3, 3, 255, true, false, null);
    }

    static Stream<Arguments> searchForQua() {
        return ImmutableList.of((Object)Arguments.of((Object[])new Object[]{"quality", 0, ImmutableList.of((Object)"quality")}), (Object)Arguments.of((Object[])new Object[]{"The basic qualia of objects", 0, ImmutableList.of((Object)"qualia")}), (Object)Arguments.of((Object[])new Object[]{"Quality over quantity!", 0, ImmutableList.of((Object)"Quality", (Object)"quantity")}), (Object)Arguments.of((Object[])new Object[]{"Quality over quantity!", 1, ImmutableList.of((Object)"Quality over", (Object)"quantity")}), (Object)Arguments.of((Object[])new Object[]{"Quality over quantity!", 5, ImmutableList.of((Object)"Quality over quantity", (Object)"quantity")}), (Object)Arguments.of((Object[])new Object[]{"quorum logic", 0, ImmutableList.of()}), (Object)Arguments.of((Object[])new Object[]{"example qua example", 0, ImmutableList.of((Object)"qua")}), (Object)Arguments.of((Object[])new Object[]{"example qua example", 1, ImmutableList.of((Object)"qua example")})).stream();
    }

    @ParameterizedTest(name="searchForQua[text={1}]")
    @MethodSource
    void searchForQua(String text, int numAdditionalTokens, List<String> expected) throws IOException {
        LuceneAutoCompletedMatchesTest.assertComputeAllMatches("qua", Collections.emptyList(), (Set<String>)ImmutableSet.of((Object)"qua"), text, numAdditionalTokens, expected);
    }

    static Stream<Arguments> searchForCjk() {
        return ImmutableList.of((Object)Arguments.of((Object[])new Object[]{"\u4e16\u4e0a\u65e0\u96be\u4e8b", "\u4e0a\u65e0", ImmutableList.of((Object)"\u4e0a"), "\u65e0", 0, ImmutableList.of((Object)"\u4e0a\u65e0")}), (Object)Arguments.of((Object[])new Object[]{"\u4e16\u4e0a\u65e0\u96be\u4e8b \u4e0a\u65e0", "\u4e0a\u65e0 ", ImmutableList.of((Object)"\u4e0a", (Object)"\u65e0"), null, 2, ImmutableList.of((Object)"\u4e0a\u65e0\u96be\u4e8b", (Object)"\u4e0a\u65e0")}), (Object)Arguments.of((Object[])new Object[]{"\u4e16\u4e0a\u65e0\u96be\u4e8b \u4e0a\u65e0 english word", "\u4e0a\u65e0 eng", ImmutableList.of((Object)"\u4e0a", (Object)"\u65e0"), "eng", 1, ImmutableList.of((Object)"\u4e0a\u65e0 english word")}), (Object)Arguments.of((Object[])new Object[]{"\u4e16\u306e\u4e2d\u306b\u96e3\u3057\u3044\u3053\u3068\u306a\u3093\u3066\u306a\u3044\u3088 \u306e\u4e2d\u306b\u96e3\u3057", "\u306e\u4e2d\u306b", ImmutableList.of((Object)"\u306e", (Object)"\u4e2d"), "\u306b", 3, ImmutableList.of((Object)"\u306e\u4e2d\u306b\u96e3\u3057\u3044", (Object)"\u306e\u4e2d\u306b\u96e3\u3057")}), (Object)Arguments.of((Object[])new Object[]{"\u4e16\u30ce\u4e2d\u30cb\u30b7\u30a4\u30b3\u30c8\u30ca\u30f3\u30c6\u30ca", "\u30b7\u30a4\u30b3", ImmutableList.of((Object)"\u30b7", (Object)"\u30a4"), "\u30b3", 3, ImmutableList.of((Object)"\u30b7\u30a4\u30b3\u30c8\u30ca\u30f3")}), (Object)Arguments.of((Object[])new Object[]{"\u4e16\u30ce\u4e2d\u30cb\u30b7\u30a4english\u30b3\u30c8\u30ca\u30f3\u30c6\u30ca", "\u30b7\u30a4", ImmutableList.of((Object)"\u30b7"), "\u30a4", 5, ImmutableList.of((Object)"\u30b7\u30a4english\u30b3\u30c8\u30ca\u30f3")}), (Object)Arguments.of((Object[])new Object[]{"\u4e16\u30ce\u4e2d \u4e16\u306e\u4e2d\u306b\u96e3\u3057\u3044", "\u4e16", ImmutableList.of(), "\u4e16", 3, ImmutableList.of((Object)"\u4e16\u30ce\u4e2d \u4e16", (Object)"\u4e16\u306e\u4e2d\u306b")}), (Object)Arguments.of((Object[])new Object[]{"\uc138\uc0c1\uc5d0 english words \uc5b4\ub824\uc6b4 \uc77c\uc740 \uc5c6\ub2e4", "english wor", ImmutableList.of((Object)"english"), "wor", 4, ImmutableList.of((Object)"english words \uc5b4\ub824\uc6b4 \uc77c")}), (Object)Arguments.of((Object[])new Object[]{"\uc138\uc0c1\uc5d0english words \uc5b4\ub824\uc6b4 \uc77c\uc740 \uc5c6\ub2e4", "\uc138\uc0c1\uc5d0english wor", ImmutableList.of((Object)"\uc138\uc0c1\uc5d0english"), "wor", 4, ImmutableList.of((Object)"\uc138\uc0c1\uc5d0english words \uc5b4\ub824\uc6b4 \uc77c")}), (Object)Arguments.of((Object[])new Object[]{"\uc138\uc0c1\uc5d0english words \uc5b4\ub824\uc6b4 \uc77c\uc740 \uc5c6\ub2e4", "\uc5d0english wor", ImmutableList.of((Object)"\uc5d0english"), "wor", 4, ImmutableList.of()}), (Object)Arguments.of((Object[])new Object[]{"\uc138\uc0c1\uc5d0 \uc5b4\ub824\uc6b4 \uc77c\uc740 \uc5c6\ub2e4", "\uc5b4\ub824", ImmutableList.of((Object)"\uc5b4"), "\ub824", 2, ImmutableList.of((Object)"\uc5b4\ub824\uc6b4 \uc77c")})).stream();
    }

    @ParameterizedTest(name="searchForCjk[text={1}]")
    @MethodSource
    void searchForCjk(String text, String query, List<String> expectedTokens, String expectedPrefix, int numAdditionalTokens, List<String> expected) throws IOException {
        LuceneAutoCompletedMatchesTest.assertComputeAllMatchesForPhrase(query, expectedTokens, expectedPrefix, text, numAdditionalTokens, expected);
    }

    static Stream<Arguments> searchForGoodMor() {
        return ImmutableList.of((Object)Arguments.of((Object[])new Object[]{"Good morning!", 0, ImmutableList.of((Object)"Good", (Object)"morning")}), (Object)Arguments.of((Object[])new Object[]{"It is all for the good, and I'll see you on the morrow", 0, ImmutableList.of((Object)"good", (Object)"morrow")}), (Object)Arguments.of((Object[])new Object[]{"The more good we do, the more good we see", 0, ImmutableList.of((Object)"more", (Object)"good", (Object)"more", (Object)"good")}), (Object)Arguments.of((Object[])new Object[]{"Good day!", 0, ImmutableList.of((Object)"Good")}), (Object)Arguments.of((Object[])new Object[]{"Morning!", 0, ImmutableList.of((Object)"Morning")})).stream();
    }

    @ParameterizedTest(name="searchForGoodMor[text={0}]")
    @MethodSource
    void searchForGoodMor(String text, int numAdditionalTokens, List<String> expected) {
        LuceneAutoCompletedMatchesTest.assertComputeAllMatches("Good mor", List.of("good"), (Set<String>)ImmutableSet.of((Object)"mor"), text, numAdditionalTokens, expected);
    }

    static Stream<Arguments> searchForHelloWorld() {
        return ImmutableList.of((Object)Arguments.of((Object[])new Object[]{"Hello, world!", 0, ImmutableList.of((Object)"Hello", (Object)"world")}), (Object)Arguments.of((Object[])new Object[]{"Hello, worldlings!", 0, ImmutableList.of((Object)"Hello")}), (Object)Arguments.of((Object[])new Object[]{"World--hello!", 0, ImmutableList.of((Object)"World", (Object)"hello")}), (Object)Arguments.of((Object[])new Object[]{"Worldly--hello!", 0, ImmutableList.of((Object)"hello")})).stream();
    }

    @ParameterizedTest(name="searchForHelloWorld[text={1}]")
    @MethodSource
    void searchForHelloWorld(String text, int numAdditionalTokens, List<String> expected) {
        LuceneAutoCompletedMatchesTest.assertComputeAllMatches("Hello World ", List.of("hello", "world"), (Set<String>)ImmutableSet.of(), text, numAdditionalTokens, expected);
    }

    private static void assertComputeAllMatches(@Nonnull String queryString, @Nonnull List<String> expectedTokens, @Nullable Set<String> expectedPrefixTokens, @Nonnull String text, int numAdditionalTokens, @Nonnull List<String> expectedMatches) {
        Analyzer analyzer = LuceneAutoCompletedMatchesTest.getTestAnalyzer();
        LuceneAutoCompleteHelpers.AutoCompleteTokens tokens = LuceneAutoCompleteHelpers.getQueryTokens((Analyzer)analyzer, (String)queryString);
        Assertions.assertEquals(expectedTokens, (Object)tokens.getQueryTokens());
        Assertions.assertEquals(expectedPrefixTokens, (Object)tokens.getPrefixTokens());
        List match = LuceneAutoCompleteHelpers.computeAllMatches((String)"text", (Analyzer)analyzer, (String)text, (LuceneAutoCompleteHelpers.AutoCompleteTokens)tokens, (int)numAdditionalTokens);
        Assertions.assertEquals(expectedMatches, (Object)match);
    }

    static Stream<Arguments> searchForHelloWorldInPhrase() {
        return ImmutableList.of((Object)Arguments.of((Object[])new Object[]{"Hello, world!", 0, ImmutableList.of((Object)"Hello, world")}), (Object)Arguments.of((Object[])new Object[]{"world, Hello!", 0, ImmutableList.of()}), (Object)Arguments.of((Object[])new Object[]{"Hello to the entire world!", 0, ImmutableList.of()}), (Object)Arguments.of((Object[])new Object[]{"Hello to the entire hello, world!", 0, ImmutableList.of((Object)"hello, world")}), (Object)Arguments.of((Object[])new Object[]{"Hello, hello, world, world!", 0, ImmutableList.of((Object)"hello, world")}), (Object)Arguments.of((Object[])new Object[]{"Hello, hello, world, hello World!", 0, ImmutableList.of((Object)"hello, world", (Object)"hello World")}), (Object)Arguments.of((Object[])new Object[]{"Hello, hello, world, hello World!", 1, ImmutableList.of((Object)"hello, world, hello", (Object)"hello World")})).stream();
    }

    @ParameterizedTest(name="searchForHelloWorldInPhrase[text={1}]")
    @MethodSource
    void searchForHelloWorldInPhrase(String text, int numAdditionalTokens, List<String> expected) {
        LuceneAutoCompletedMatchesTest.assertComputeAllMatchesForPhrase("Hello World ", List.of("hello", "world"), null, text, numAdditionalTokens, expected);
    }

    static Stream<Arguments> searchForGoodMorInPhrase() {
        return ImmutableList.of((Object)Arguments.of((Object[])new Object[]{"Good Morning!", 0, ImmutableList.of((Object)"Good Morning")}), (Object)Arguments.of((Object[])new Object[]{"Good Morrow Morning!", 0, ImmutableList.of((Object)"Good Morrow")}), (Object)Arguments.of((Object[])new Object[]{"Morning!", 0, ImmutableList.of()}), (Object)Arguments.of((Object[])new Object[]{"Morning, Good it is! (Yoda)", 0, ImmutableList.of()}), (Object)Arguments.of((Object[])new Object[]{"Good, Good, good, more mornings!", 0, ImmutableList.of((Object)"good, more")})).stream();
    }

    @ParameterizedTest(name="searchForGoodMorInPhrase[text={1}]")
    @MethodSource
    void searchForGoodMorInPhrase(String text, int numAdditionalTokens, List<String> expected) {
        LuceneAutoCompletedMatchesTest.assertComputeAllMatchesForPhrase("Good Mor", List.of("good"), "mor", text, numAdditionalTokens, expected);
    }

    private static void assertComputeAllMatchesForPhrase(@Nonnull String queryString, @Nonnull List<String> expectedTokens, @Nullable String expectedPrefixToken, @Nonnull String text, int numAdditionalTokens, @Nonnull List<String> expectedMatches) {
        Analyzer analyzer = LuceneAutoCompletedMatchesTest.getTestAnalyzer();
        LuceneAutoCompleteHelpers.AutoCompleteTokens tokens = LuceneAutoCompleteHelpers.getQueryTokens((Analyzer)analyzer, (String)queryString);
        Assertions.assertEquals(expectedTokens, (Object)tokens.getQueryTokens());
        Assertions.assertEquals((Object)expectedPrefixToken, (Object)tokens.getPrefixTokenOrNull());
        List match = LuceneAutoCompleteHelpers.computeAllMatchesForPhrase((String)"text", (Analyzer)analyzer, (String)text, (LuceneAutoCompleteHelpers.AutoCompleteTokens)tokens, (int)numAdditionalTokens);
        Assertions.assertEquals(expectedMatches, (Object)match);
    }

    @Test
    void autoCompleteMatchesWithStopWord() {
        LuceneAutoCompletedMatchesTest.assertComputeAllMatchesForPhrase("United States of Ameri", List.of("united", "states"), "ameri", "United States of America", 0, (List<String>)ImmutableList.of((Object)"United States of America"));
        LuceneAutoCompletedMatchesTest.assertComputeAllMatchesForPhrase("United States of", List.of("united", "states"), null, "United States of America", 1, (List<String>)ImmutableList.of((Object)"United States of America"));
        LuceneAutoCompletedMatchesTest.assertComputeAllMatchesForPhrase("United States", List.of("united"), "states", "United States of America", 1, (List<String>)ImmutableList.of((Object)"United States of America"));
    }
}

