/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.LuceneIndexMaintainer;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LuceneIndexTestValidator;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.LuceneScanBounds;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryManager;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Sort;
import org.junit.jupiter.api.Assertions;

public abstract class FDBLuceneTestBase
extends FDBRecordStoreTestBase {
    protected static final String ENGINEER_JOKE = "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'";
    protected static final String WAYLON = "There's always one more way to do things and that's your way, and you have a right to try it at least once.";
    protected static final Index COMPLEX_PARTITIONED = FDBLuceneTestBase.complexPartitionedIndex(Map.of("textTokenizerName", "all_suffixes", "partitionFieldName", "timestamp", "partitionHighWatermark", "10"));
    protected static final Index COMPLEX_PARTITIONED_NOGROUP = FDBLuceneTestBase.complexPartitionedIndexNoGroup(Map.of("textTokenizerName", "all_suffixes", "partitionFieldName", "timestamp", "partitionHighWatermark", "10"));
    protected static final Index MULTIPLE_ANALYZER_LUCENE_INDEX = new Index("Complex$multiple_analyzer_autocomplete", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")), (KeyExpression[])new KeyExpression[0]), "lucene", (Map)ImmutableMap.of((Object)"luceneAnalyzerName", (Object)"SYNONYM", (Object)"luceneAnalyzerNamePerField", (Object)"text2:NGRAM"));
    protected static final Index JOINED_INDEX = FDBLuceneTestBase.getJoinedIndex(Map.of("partitionFieldName", "complex.timestamp", "partitionHighWatermark", "10"));

    protected StoreTimer.Counter getCounter(@Nonnull FDBRecordContext recordContext, @Nonnull StoreTimer.Event event) {
        return ((FDBStoreTimer)Verify.verifyNotNull((Object)recordContext.getTimer())).getCounter(event);
    }

    protected List<LucenePartitionInfoProto.LucenePartitionInfo> getPartitionMeta(Index index, Tuple groupingKey, RecordLayerPropertyStorage contextProps, Consumer<FDBRecordContext> schemaSetup) {
        try (FDBRecordContext context = this.openContext(contextProps);){
            schemaSetup.accept(context);
            LuceneIndexMaintainer indexMaintainer = (LuceneIndexMaintainer)this.recordStore.getIndexMaintainer(index);
            List list = (List)indexMaintainer.getPartitioner().getAllPartitionMetaInfo(groupingKey).join();
            return list;
        }
    }

    protected FDBDirectoryManager getDirectoryManager(Index index) {
        return this.getIndexMaintainer(index).getDirectoryManager();
    }

    protected IndexReader getIndexReader(Index index, Tuple groupingKey, int partitionId) throws IOException {
        FDBDirectoryManager manager = this.getDirectoryManager(index);
        return manager.getIndexReader(groupingKey, Integer.valueOf(partitionId));
    }

    @Nonnull
    protected LuceneIndexMaintainer getIndexMaintainer(Index index) {
        return (LuceneIndexMaintainer)this.recordStore.getIndexMaintainer(index);
    }

    protected FDBDirectory getDirectory(Index index, Tuple groupingKey) {
        return this.getIndexMaintainer(index).getDirectory(groupingKey, null);
    }

    protected long getSegmentCount(Index index, Tuple groupingKey) throws IOException {
        String[] files = this.getDirectory(index, groupingKey).listAll();
        return Arrays.stream(files).filter(FDBDirectory::isCompoundFile).count();
    }

    protected Map<Integer, Integer> getSegmentCounts(Index index, Tuple groupingKey, RecordLayerPropertyStorage contextProps, Consumer<FDBRecordContext> schemaSetup) {
        List<LucenePartitionInfoProto.LucenePartitionInfo> partitionMeta = this.getPartitionMeta(index, groupingKey, contextProps, schemaSetup);
        try (FDBRecordContext context = this.openContext(contextProps);){
            schemaSetup.accept(context);
            Map<Integer, Integer> map = partitionMeta.stream().collect(Collectors.toMap(LucenePartitionInfoProto.LucenePartitionInfo::getId, partitionInfo -> (Integer)Assertions.assertDoesNotThrow(() -> this.getIndexReader(index, groupingKey, partitionInfo.getId()).getContext().leaves().size())));
            return map;
        }
    }

    @Nonnull
    protected static Index complexPartitionedIndex(Map<String, String> options) {
        return new Index("Complex$partitioned", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")), (KeyExpression[])new KeyExpression[0]).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene", options);
    }

    @Nonnull
    protected static Index getJoinedIndex(Map<String, String> options) {
        return new Index("joinNestedConcat", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), (KeyExpression)Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))}).groupBy((KeyExpression)Key.Expressions.field((String)"complex").nest("group"), new KeyExpression[0]), "lucene", options);
    }

    @Nonnull
    protected static Index complexPartitionedIndexNoGroup(Map<String, String> options) {
        return new Index("Complex$partitioned_noGroup", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")), (KeyExpression[])new KeyExpression[0]), "lucene", options);
    }

    protected LuceneScanBounds groupedTextSearch(Index index, String search, Object group) {
        return this.groupedSortedTextSearch(index, search, null, group);
    }

    protected LuceneScanBounds groupedSortedTextSearch(Index index, String search, Sort sort, Object group) {
        return LuceneIndexTestValidator.groupedSortedTextSearch(this.recordStore, index, search, sort, group);
    }

    protected LuceneScanBounds fullTextSearch(Index index, String search) {
        return LuceneIndexTestUtils.fullTextSearch(this.recordStore, index, search, false);
    }

    protected void validateDocsInPartition(Index index, int partitionId, Tuple groupingKey, Set<Tuple> expectedPrimaryKeys, String universalSearch) throws IOException {
        LuceneIndexTestValidator.validateDocsInPartition(this.recordStore, index, partitionId, groupingKey, expectedPrimaryKeys, universalSearch);
    }

    protected Set<Tuple> makeKeyTuples(long group, int ... ranges) {
        int[] rangeList = Arrays.stream(ranges).toArray();
        if (rangeList.length == 0 || rangeList.length % 2 == 1) {
            throw new IllegalArgumentException("specify ranges as pairs of (from, to)");
        }
        HashSet<Tuple> tuples = new HashSet<Tuple>();
        for (int i = 0; i < rangeList.length - 1; i += 2) {
            for (int j = rangeList[i]; j <= rangeList[i + 1]; ++j) {
                tuples.add(Tuple.from((Object[])new Object[]{group, j}));
            }
        }
        return tuples;
    }
}

