/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.TestHelpers;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.lucene.LuceneIndexQueryPlan;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LucenePlanMatchers;
import com.apple.foundationdb.record.lucene.LucenePlanner;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryComponent;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.LuceneScanQuery;
import com.apple.foundationdb.record.lucene.LuceneScanTypes;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapRegistryImpl;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.RollingTestKeyManager;
import com.apple.foundationdb.record.provider.common.SerializationKeyManager;
import com.apple.foundationdb.record.provider.common.text.TextSamples;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseFactory;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextIndexTestUtils;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.provider.foundationdb.query.FDBRecordStoreQueryTestBase;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.match.PlanMatchers;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.test.BooleanSource;
import com.apple.test.RandomSeedSource;
import com.apple.test.RandomizedTestUtils;
import com.apple.test.SuperSlow;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.search.Query;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="RequiresFDB")
public class FDBLuceneQueryTest
extends FDBRecordStoreQueryTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBLuceneQueryTest.class);
    private static final int PARALLELISM = 8;
    private static final List<TestRecordsTextProto.SimpleDocument> DOCUMENTS = TextIndexTestUtils.toSimpleDocuments(Arrays.asList("The Angstrom unit (\u212b) was named after Anders \u00c5ngstr\u00f6m.", "According to the encyclop\u00e6dia, \u00c6thelred the Unr\u00e6d was king from 966 to 1016.", "Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\n", TextSamples.FRENCH, "Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\nAnd the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend.", "And the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend."));
    final List<String> textSamples = Arrays.asList("Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\nAnd the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend.", "According to the encyclop\u00e6dia, \u00c6thelred the Unr\u00e6d was king from 966 to 1016.", "Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\nAnd the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend.", "The Angstrom unit (\u212b) was named after Anders \u00c5ngstr\u00f6m.", "According to the encyclop\u00e6dia, \u00c6thelred the Unr\u00e6d was king from 966 to 1016.", TextSamples.FRENCH);
    private final List<TestRecordsTextProto.MapDocument> mapDocuments = IntStream.range(0, this.textSamples.size() / 2).mapToObj(i -> TestRecordsTextProto.MapDocument.newBuilder().setDocId((long)i).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("a").setValue(this.textSamples.get(i * 2)).build()).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("b").setValue(this.textSamples.get(i * 2 + 1)).build()).setGroup((long)(i % 2)).build()).collect(Collectors.toList());
    private final List<TestRecordsTextProto.MapDocument> mapWithFieldDocuments = IntStream.range(0, this.textSamples.size() / 2).mapToObj(i -> TestRecordsTextProto.MapDocument.newBuilder().setDocId((long)i).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("a").setValue(this.textSamples.get(i * 2)).build()).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("b").setValue(this.textSamples.get(i * 2 + 1)).build()).setGroup((long)(i % 2)).build()).collect(Collectors.toList());
    private final List<TestRecordsTextProto.ComplexDocument> complexDocuments = IntStream.range(0, this.textSamples.size()).mapToObj(i -> TestRecordsTextProto.ComplexDocument.newBuilder().setDocId((long)i).setGroup((long)(i % 2)).setText(this.textSamples.get(i)).build()).collect(Collectors.toList());
    private static final String MAP_DOC = "MapDocument";
    private static final Index TEXT_AND_GROUP = new Index("text_and_group", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"group"))), (KeyExpression[])new KeyExpression[0]), "lucene", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes"));
    private static final List<KeyExpression> keys = List.of(Key.Expressions.field((String)"key"), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"value")));
    private static final KeyExpression mainExpression = Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.concat(keys));
    private static final Index MAP_AND_FIELD_ON_LUCENE_INDEX = new Index("MapField$values", (KeyExpression)Key.Expressions.concat((KeyExpression)mainExpression, (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]), "lucene");
    private static final Index MAP_ON_LUCENE_INDEX = new Index("Map$entry-value", (KeyExpression)new GroupingKeyExpression(mainExpression, 1), "lucene");
    private static final Index COMPLEX_TEXT_BY_GROUP = new Index("Complex$text_by_group", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene");
    private ExecutorService executorService = null;
    private SerializationKeyManager keyManager;

    @BeforeAll
    public static void setup() {
        SynonymMapRegistryImpl.instance().getSynonymMap("EXPANDED_US_EN");
    }

    public void setupPlanner(@Nullable PlannableIndexTypes indexTypes) {
        if (this.isUseCascadesPlanner()) {
            this.planner = this.recordStore.getCascadesPlanner();
        } else {
            if (indexTypes == null) {
                indexTypes = new PlannableIndexTypes((Set)Sets.newHashSet((Object[])new String[]{"value", "version"}), (Set)Sets.newHashSet((Object[])new String[]{"rank", "time_window_leaderboard"}), (Set)Sets.newHashSet((Object[])new String[]{"text"}), (Set)Sets.newHashSet((Object[])new String[]{"lucene"}));
            }
            this.planner = new LucenePlanner(this.recordStore.getRecordMetaData(), this.recordStore.getRecordStoreState(), indexTypes, this.recordStore.getTimer());
        }
    }

    protected RecordLayerPropertyStorage.Builder addDefaultProps(RecordLayerPropertyStorage.Builder props) {
        return super.addDefaultProps(props).addProp(LuceneRecordContextProperties.LUCENE_EXECUTOR_SERVICE, () -> this.executorService).addProp(LuceneRecordContextProperties.LUCENE_INDEX_ENCRYPTION_ENABLED, () -> this.keyManager != null).addProp(LuceneRecordContextProperties.LUCENE_INDEX_KEY_MANAGER, () -> this.keyManager);
    }

    protected void openRecordStoreWithNgramIndex(FDBRecordContext context, boolean edgesOnly, int minSize, int maxSize) {
        Index ngramIndex = new Index("Complex$text_index", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "lucene", (Map)ImmutableMap.of((Object)"luceneAnalyzerName", (Object)"NGRAM", (Object)"textTokenMinSize", (Object)String.valueOf(minSize), (Object)"textTokenMaxSize", (Object)String.valueOf(maxSize), (Object)"ngramTokenEdgesOnly", (Object)String.valueOf(edgesOnly)));
        this.openRecordStore(context, md -> {}, ngramIndex);
    }

    protected void openRecordStoreWithSynonymIndex(FDBRecordContext context) {
        Index ngramIndex = new Index("Complex$text_index", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "lucene", (Map)ImmutableMap.of((Object)"luceneAnalyzerName", (Object)"SYNONYM", (Object)"textSynonymSetName", (Object)"EXPANDED_US_EN"));
        this.openRecordStore(context, md -> {}, ngramIndex);
    }

    protected void openRecordStoreWithGroup(FDBRecordContext context) {
        this.openRecordStore(context, md -> {}, TEXT_AND_GROUP);
    }

    protected void openRecordStoreWithComplex(FDBRecordContext context) {
        this.openRecordStore(context, md -> md.addIndex("ComplexDocument", COMPLEX_TEXT_BY_GROUP), null);
    }

    protected void openRecordStore(FDBRecordContext context) {
        this.openRecordStore(context, md -> {}, LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES);
    }

    protected void openRecordStore(FDBRecordContext context, FDBRecordStoreTestBase.RecordMetaDataHook hook, Index simpleDocIndex) {
        RecordMetaDataBuilder metaDataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsTextProto.getDescriptor());
        metaDataBuilder.getRecordType("ComplexDocument").setPrimaryKey((KeyExpression)Key.Expressions.concatenateFields((String)"group", (String)"doc_id", (String[])new String[0]));
        if (simpleDocIndex != null) {
            metaDataBuilder.removeIndex("SimpleDocument$text");
            metaDataBuilder.addIndex("SimpleDocument", simpleDocIndex);
        }
        metaDataBuilder.addIndex(MAP_DOC, MAP_ON_LUCENE_INDEX);
        metaDataBuilder.addIndex(MAP_DOC, MAP_AND_FIELD_ON_LUCENE_INDEX);
        hook.apply(metaDataBuilder);
        this.recordStore = (FDBRecordStore)this.getStoreBuilder(context, metaDataBuilder.getRecordMetaData()).setSerializer((RecordSerializer)TextIndexTestUtils.COMPRESSING_SERIALIZER).createOrOpen();
        this.setupPlanner(null);
    }

    private void initializeFlat() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            DOCUMENTS.forEach(arg_0 -> ((FDBRecordStore)this.recordStore).saveRecord(arg_0));
            this.commit(context);
        }
    }

    private void initializeWithGroup() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStoreWithGroup(context);
            DOCUMENTS.forEach(arg_0 -> ((FDBRecordStore)this.recordStore).saveRecord(arg_0));
            this.commit(context);
        }
    }

    private void initializeNested() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            this.mapDocuments.forEach(arg_0 -> ((FDBRecordStore)this.recordStore).saveRecord(arg_0));
            this.commit(context);
        }
    }

    private void initializeNestedWithField() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            this.mapWithFieldDocuments.forEach(arg_0 -> ((FDBRecordStore)this.recordStore).saveRecord(arg_0));
            this.commit(context);
        }
    }

    private void assertPrimaryKeys(String term, boolean shouldDeferFetch, Set<Long> expectedPrimaryKeys) {
        LuceneQueryComponent filter = new LuceneQueryComponent(term, (List)Lists.newArrayList());
        RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter).build();
        this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
        RecordQueryPlan plan = this.planQuery(query);
        try (RecordCursor fdbQueriedRecordRecordCursor = this.recordStore.executeQuery(plan);){
            Set primaryKeys = fdbQueriedRecordRecordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asStream().collect(Collectors.toSet());
            Assertions.assertEquals(expectedPrimaryKeys, primaryKeys, (String)"Expected term not indexed");
        }
    }

    @ParameterizedTest(name="testSynonym[shouldDeferFetch={0}]")
    @ValueSource(booleans={true, false})
    void testSynonym(boolean shouldDeferFetch) {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStoreWithSynonymIndex(context);
            TestRecordsTextProto.SimpleDocument document = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(1L).setGroup(1L).setText("Good morning Mr Tian").build();
            this.recordStore.saveRecord((Message)document);
            this.assertPrimaryKeys("good", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("morning", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("full", shouldDeferFetch, Set.of(Long.valueOf(1L)));
        }
    }

    @ParameterizedTest(name="testNgram[shouldDeferFetch={0}]")
    @ValueSource(booleans={true, false})
    void testNgram(boolean shouldDeferFetch) {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStoreWithNgramIndex(context, false, 3, 5);
            TestRecordsTextProto.SimpleDocument document = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(1L).setGroup(1L).setText("Good morning Mr Tian").build();
            this.recordStore.saveRecord((Message)document);
            this.assertPrimaryKeys("mo", shouldDeferFetch, Set.of());
            this.assertPrimaryKeys("mor", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("morn", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("morni", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("ornin", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("orning", shouldDeferFetch, Set.of());
            this.assertPrimaryKeys("mornin", shouldDeferFetch, Set.of());
            this.assertPrimaryKeys("Good", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("good", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("Mr", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("morning", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("Mr T", shouldDeferFetch, Set.of(Long.valueOf(1L)));
        }
    }

    @ParameterizedTest(name="testNgramEdgesOnly[shouldDeferFetch={0}]")
    @ValueSource(booleans={true, false})
    void testNgramEdgesOnly(boolean shouldDeferFetch) {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStoreWithNgramIndex(context, true, 3, 5);
            TestRecordsTextProto.SimpleDocument document = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(1L).setGroup(1L).setText("Good morning Mr Tian").build();
            this.recordStore.saveRecord((Message)document);
            this.assertPrimaryKeys("mo", shouldDeferFetch, Set.of());
            this.assertPrimaryKeys("mor", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("morn", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("morni", shouldDeferFetch, Set.of(Long.valueOf(1L)));
            this.assertPrimaryKeys("ornin", shouldDeferFetch, Set.of());
            this.assertPrimaryKeys("rning", shouldDeferFetch, Set.of());
        }
    }

    @Test
    void testQueryWithStopWords() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            TestRecordsTextProto.SimpleDocument document1 = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(1L).setGroup(1L).setText("Good morning Mr Tian").build();
            this.recordStore.saveRecord((Message)document1);
            TestRecordsTextProto.SimpleDocument document2 = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(2L).setGroup(1L).setText("Good morning the Mr Tian").build();
            this.recordStore.saveRecord((Message)document2);
            TestRecordsTextProto.SimpleDocument document3 = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(3L).setGroup(1L).setText("Good morning these Mr Tian").build();
            this.recordStore.saveRecord((Message)document3);
            this.assertPrimaryKeys("text:(+morn* +the*)", false, Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L)));
            this.assertPrimaryKeys("text:(+morn* the*)", false, Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L)));
            this.assertPrimaryKeys("text:(+morn* +the)", false, Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L)));
            this.assertPrimaryKeys("text:(+morn* the)", false, Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L)));
        }
    }

    @Test
    void testQueryWithUnicode() {
        ArrayList<StringBuilder> allBuilders = new ArrayList<StringBuilder>();
        String beginningWord = "banana";
        String endWord = "catamaran";
        BiConsumer<StringBuilder, String> addWord = (stringBuilder, word) -> stringBuilder.append(" ").append((String)word).append(" ");
        StringBuilder sb = new StringBuilder();
        addWord.accept(sb, "banana");
        allBuilders.add(sb);
        int skipped = 0;
        for (int i = 0; i < 0x10FFFF; ++i) {
            if (Character.isSupplementaryCodePoint(i)) {
                sb.append(Character.highSurrogate(i));
                sb.append(Character.lowSurrogate(i));
            } else if (Character.isDefined(i) && Character.getType(i) != 18 && !Character.isSurrogate((char)i)) {
                sb.append((char)i);
            } else {
                ++skipped;
            }
            if (sb.length() <= 50000) continue;
            addWord.accept(sb, "catamaran");
            sb = new StringBuilder();
            addWord.accept(sb, "banana");
            allBuilders.add(sb);
        }
        addWord.accept((StringBuilder)allBuilders.get(allBuilders.size() - 1), "catamaran");
        List allTexts = allBuilders.stream().map(StringBuilder::toString).collect(Collectors.toList());
        LOGGER.debug("Skipped: " + skipped + "/1114111");
        LOGGER.debug("AllTexts (" + allTexts.size() + "): " + allTexts.stream().map(text -> String.valueOf(text.length())).collect(Collectors.joining(", ")));
        long id = 1L;
        for (String text2 : allTexts) {
            FDBRecordContext context = this.openContext();
            try {
                this.openRecordStore(context);
                TestRecordsTextProto.SimpleDocument document1 = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(id++).setGroup(1L).setText(text2).build();
                this.recordStore.saveRecord((Message)document1);
                context.commit();
            }
            finally {
                if (context == null) continue;
                context.close();
            }
        }
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            this.assertPrimaryKeys("text:(banana)", false, LongStream.range(1L, id).boxed().collect(Collectors.toSet()));
            this.assertPrimaryKeys("text:(catamaran)", false, LongStream.range(1L, id).boxed().collect(Collectors.toSet()));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void simpleLuceneScans(boolean shouldDeferFetch) throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent(LuceneQueryType.QUERY, "civil blood makes civil hands unclean", false, (List)Lists.newArrayList(), true, null, null);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter1).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScan((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI civil blood makes civil hands unclean")))));
            RecordQueryPlan plan = this.planQuery(query);
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor cursor = this.recordStore.executeQuery(plan);){
                List queriedRecordList = (List)cursor.asList().get();
                Set primaryKeys = queriedRecordList.stream().map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).collect(Collectors.toSet());
                Assertions.assertEquals(Set.of(Long.valueOf(2L), Long.valueOf(4L)), Set.copyOf(primaryKeys));
                Set<String> texts = queriedRecordList.stream().map(FDBQueriedRecord::getStoredRecord).filter(Objects::nonNull).map(FDBStoredRecord::getRecord).map(m -> (String)m.getField(m.getDescriptorForType().findFieldByName("text"))).collect(Collectors.toSet());
                texts.forEach(t -> Assertions.assertTrue((boolean)t.contains("civil blood makes civil hands unclean")));
            }
        }
    }

    @ParameterizedTest(name="testThenExpressionBeforeFieldExpression[shouldDeferFetch={0}]")
    @BooleanSource
    void testThenExpressionBeforeFieldExpression(boolean shouldDeferFetch) throws Exception {
        this.initializeNestedWithField();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("*:*", (List)Lists.newArrayList((Object[])new String[]{"doc_id"}));
            RecordQuery query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter((QueryComponent)filter1).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            try (RecordCursor fdbQueriedRecordRecordCursor = this.recordStore.executeQuery(plan);){
                RecordCursor map = fdbQueriedRecordRecordCursor.map(FDBRecord::getPrimaryKey);
                List primaryKeys = (List)map.map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(2L)), Set.copyOf(primaryKeys));
            }
        }
    }

    @ParameterizedTest(name="simpleLuceneScansDocId[shouldDeferFetch={0}]")
    @BooleanSource
    void simpleLuceneScansDocId(boolean shouldDeferFetch) throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(com.apple.foundationdb.record.query.expressions.Query.field((String)"doc_id").equalsValue((Object)1L)).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            Matcher matcher = PlanMatchers.typeFilter((Matcher)Matchers.equalTo(Collections.singleton("SimpleDocument")), (Matcher)PlanMatchers.scan((Matcher)PlanMatchers.bounds((Matcher)PlanMatchers.hasTupleString((String)"[[1],[1]]"))));
            RecordQueryPlan plan = this.planQuery(query);
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor cursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)cursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(1L)), Set.copyOf(primaryKeys));
            }
        }
    }

    @ParameterizedTest(name="delayFetchOnOrOfLuceneScanWithFieldFilter[shouldDeferFetch={0}]")
    @BooleanSource
    void delayFetchOnOrOfLuceneScanWithFieldFilter(boolean shouldDeferFetch) throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("civil blood makes civil hands unclean", (List)Lists.newArrayList((Object[])new String[]{"text"}));
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(com.apple.foundationdb.record.query.expressions.Query.or((QueryComponent)filter1, (QueryComponent)com.apple.foundationdb.record.query.expressions.Query.field((String)"doc_id").lessThan((Object)10000L), (QueryComponent[])new QueryComponent[0])).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.primaryKeyDistinct((Matcher)PlanMatchers.unorderedUnion((Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScan((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"civil blood makes civil hands unclean"))))), (Matcher)PlanMatchers.typeFilter((Matcher)Matchers.equalTo(Collections.singleton("SimpleDocument")), (Matcher)PlanMatchers.scan((Matcher)PlanMatchers.bounds((Matcher)PlanMatchers.hasTupleString((String)"([null],[10000])"))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor cursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)cursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(2L), Long.valueOf(4L), Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(3L), Long.valueOf(5L)), Set.copyOf(primaryKeys));
                if (shouldDeferFetch) {
                    TestHelpers.assertLoadRecord((int)5, (FDBRecordContext)context);
                } else {
                    TestHelpers.assertLoadRecord((int)6, (FDBRecordContext)context);
                }
            }
        }
    }

    @ParameterizedTest(name="delayFetchOnFilterWithSort[shouldDeferFetch={0}]")
    @BooleanSource
    void delayFetchOnLuceneFilterWithSort(boolean shouldDeferFetch) throws Exception {
        this.initializeWithGroup();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStoreWithGroup(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("parents", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter1).setSort((KeyExpression)Key.Expressions.field((String)"group"), true).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(List.of(Long.valueOf(5L), Long.valueOf(2L), Long.valueOf(4L)), (Object)primaryKeys);
                if (shouldDeferFetch) {
                    TestHelpers.assertLoadRecord((int)5, (FDBRecordContext)context);
                } else {
                    TestHelpers.assertLoadRecord((int)6, (FDBRecordContext)context);
                }
            }
        }
    }

    @ParameterizedTest(name="delayFetchOnAndOfLuceneAndFieldFilter[shouldDeferFetch={0}]")
    @ValueSource(booleans={true, false})
    void delayFetchOnAndOfLuceneAndFieldFilter(boolean shouldDeferFetch) throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("civil blood makes civil hands unclean", (List)Lists.newArrayList());
            QueryComponent filter2 = com.apple.foundationdb.record.query.expressions.Query.field((String)"doc_id").equalsValue((Object)2L);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)filter2, (QueryComponent)filter1, (QueryComponent[])new QueryComponent[0])).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planner.plan(query);
            Matcher scanMatcher = PlanMatchers.fetch((Matcher)PlanMatchers.filter((QueryComponent)filter2, (Matcher)PlanMatchers.coveringIndexScan((Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexScan((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI civil blood makes civil hands unclean"))))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)scanMatcher);
            try (RecordCursor primaryKeys = this.recordStore.executeQuery(plan);){
                List keys = (List)primaryKeys.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(2L)), Set.copyOf(keys));
                if (shouldDeferFetch) {
                    TestHelpers.assertLoadRecord((int)3, (FDBRecordContext)context);
                } else {
                    TestHelpers.assertLoadRecord((int)4, (FDBRecordContext)context);
                }
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void delayFetchOnOrOfLuceneFiltersGivesUnion(boolean shouldDeferFetch) throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent(LuceneQueryType.QUERY, "(\"civil blood makes civil hands unclean\")", false, (List)Lists.newArrayList((Object[])new String[]{"text"}), true, null, null);
            LuceneQueryComponent filter2 = new LuceneQueryComponent(LuceneQueryType.QUERY, "(\"was king from 966 to 1016\")", false, (List)Lists.newArrayList(), true, null, null);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(com.apple.foundationdb.record.query.expressions.Query.or((QueryComponent)filter1, (QueryComponent)filter2, (QueryComponent[])new QueryComponent[0])).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            Matcher scan1 = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScan((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI (\"civil blood makes civil hands unclean\")")))));
            Matcher scan2 = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScan((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI (\"was king from 966 to 1016\")")))));
            Matcher matcher = shouldDeferFetch ? PlanMatchers.fetch((Matcher)PlanMatchers.primaryKeyDistinct((Matcher)PlanMatchers.unorderedUnion((Matcher)PlanMatchers.coveringIndexScan((Matcher)scan1), (Matcher)PlanMatchers.coveringIndexScan((Matcher)scan2)))) : PlanMatchers.primaryKeyDistinct((Matcher)PlanMatchers.unorderedUnion((Matcher)scan1, (Matcher)scan2));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor cursor = this.recordStore.executeQuery(plan);){
                List queriedRecordList = (List)cursor.asList().get();
                Set primaryKeys = queriedRecordList.stream().map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).collect(Collectors.toSet());
                Assertions.assertEquals(Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(4L)), primaryKeys);
                if (shouldDeferFetch) {
                    TestHelpers.assertLoadRecord((int)5, (FDBRecordContext)context);
                } else {
                    TestHelpers.assertLoadRecord((int)6, (FDBRecordContext)context);
                }
                Set texts = queriedRecordList.stream().map(FDBQueriedRecord::getStoredRecord).filter(Objects::nonNull).map(FDBStoredRecord::getRecord).map(m -> (String)m.getField(m.getDescriptorForType().findFieldByName("text"))).collect(Collectors.toSet());
                for (String text : texts) {
                    boolean match1 = text.contains("was king from 966 to 1016");
                    boolean match2 = text.contains("civil blood makes civil hands unclean");
                    Assertions.assertTrue((match1 || match2 ? 1 : 0) != 0);
                }
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void delayFetchOnAndOfLuceneFilters(boolean shouldDeferFetch) throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent(LuceneQueryType.QUERY, "\"the continuance\"", false, (List)Lists.newArrayList(), true, null, null);
            LuceneQueryComponent filter2 = new LuceneQueryComponent(LuceneQueryType.QUERY, "grudge", false, (List)Lists.newArrayList(), true, null, null);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)filter1, (QueryComponent)filter2, (QueryComponent[])new QueryComponent[0])).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexName((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI \"the continuance\" AND MULTI grudge")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor cursor = this.recordStore.executeQuery(plan);){
                List queriedRecordList = (List)cursor.asList().get();
                Set primaryKeys = queriedRecordList.stream().map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).collect(Collectors.toSet());
                Assertions.assertEquals(Set.of(Long.valueOf(4L)), primaryKeys);
                if (shouldDeferFetch) {
                    TestHelpers.assertLoadRecord((int)3, (FDBRecordContext)context);
                } else {
                    TestHelpers.assertLoadRecord((int)4, (FDBRecordContext)context);
                }
                Set texts = queriedRecordList.stream().map(FDBQueriedRecord::getStoredRecord).filter(Objects::nonNull).map(FDBStoredRecord::getRecord).map(m -> (String)m.getField(m.getDescriptorForType().findFieldByName("text"))).collect(Collectors.toSet());
                for (String text : texts) {
                    boolean match1 = text.contains("the continuance");
                    boolean match2 = text.contains("grudge");
                    Assertions.assertTrue((match1 || match2 ? 1 : 0) != 0);
                }
            }
        }
    }

    @ParameterizedTest(name="delayFetchOnLuceneComplexStringAnd[shouldDeferFetch={0}]")
    @BooleanSource
    void delayFetchOnLuceneComplexStringAnd(boolean shouldDeferFetch) throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("(the continuance AND grudge)", (List)Lists.newArrayList());
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter1).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexName((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI (the continuance AND grudge)")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(4L)), Set.copyOf(primaryKeys));
                if (shouldDeferFetch) {
                    TestHelpers.assertLoadRecord((int)3, (FDBRecordContext)context);
                } else {
                    TestHelpers.assertLoadRecord((int)4, (FDBRecordContext)context);
                }
            }
        }
    }

    @ParameterizedTest(name="delayFetchOnLuceneComplexStringOr[shouldDeferFetch={0}]")
    @BooleanSource
    void delayFetchOnLuceneComplexStringOr(boolean shouldDeferFetch) throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("\"the continuance\" OR grudge", (List)Lists.newArrayList());
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter1).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexName((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI \"the continuance\" OR grudge")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(4L), Long.valueOf(5L), Long.valueOf(2L)), Set.copyOf(primaryKeys));
                if (shouldDeferFetch) {
                    TestHelpers.assertLoadRecord((int)3, (FDBRecordContext)context);
                } else {
                    TestHelpers.assertLoadRecord((int)4, (FDBRecordContext)context);
                }
            }
        }
    }

    @ParameterizedTest(name="misMatchQueryShouldReturnNoResult[shouldDeferFetch={0}]")
    @ValueSource(booleans={true, false})
    void misMatchQueryShouldReturnNoResult(boolean shouldDeferFetch) throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("doesNotExist", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter1).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScan((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI doesNotExist")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(), Set.copyOf(primaryKeys));
                if (shouldDeferFetch) {
                    TestHelpers.assertLoadRecord((int)3, (FDBRecordContext)context);
                } else {
                    TestHelpers.assertLoadRecord((int)4, (FDBRecordContext)context);
                }
            }
        }
    }

    private static Stream<Arguments> threadCount() {
        return Stream.concat(Stream.of(1, 10).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0})), RandomizedTestUtils.randomArguments(random -> Arguments.of((Object[])new Object[]{random.nextInt(10) + 1})));
    }

    @ParameterizedTest(name="threadedLuceneScanDoesntBreakPlannerAndSearch-PoolThreadCount={0}")
    @MethodSource(value={"threadCount"})
    @SuperSlow
    void threadedLuceneScanDoesntBreakPlannerAndSearch(@Nonnull Integer value) throws Exception {
        FDBDatabaseFactory factory = this.dbExtension.getDatabaseFactory();
        factory.setExecutor((Executor)new ForkJoinPool(8, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, false));
        CountingThreadFactory threadFactory = new CountingThreadFactory();
        this.executorService = Executors.newFixedThreadPool(value, threadFactory);
        this.initializeFlat();
        for (int i = 0; i < 200; ++i) {
            try (FDBRecordContext context = this.openContext();){
                this.openRecordStore(context);
                String[] randomWords = LuceneIndexTestUtils.generateRandomWords(500);
                TestRecordsTextProto.SimpleDocument dylan = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId((long)i).setText(randomWords[1]).setGroup(2L).build();
                this.recordStore.saveRecord((Message)dylan);
                this.commit(context);
                continue;
            }
        }
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("*:*", (List)Lists.newArrayList((Object[])new String[]{"text"}), false);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter1).build();
            this.setDeferFetchAfterUnionAndIntersection(false);
            RecordQueryPlan plan = this.planQuery(query);
            try (RecordCursor cursor = this.recordStore.executeQuery(plan);){
                List ignored = (List)cursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                MatcherAssert.assertThat(threadFactory.threadCounts, (Matcher)Matchers.aMapWithSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
            }
        }
    }

    @ParameterizedTest(name="nestedLuceneAndQuery[shouldDeferFetch={0}]")
    @BooleanSource
    void nestedLuceneAndQuery(boolean shouldDeferFetch) throws Exception {
        this.initializeNested();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            RecordQuery query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter(com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)new LuceneQueryComponent("entry_value:king", (List)Lists.newArrayList((Object[])new String[]{"entry"}), false), (QueryComponent)com.apple.foundationdb.record.query.expressions.Query.field((String)"entry").oneOfThem().matches(com.apple.foundationdb.record.query.expressions.Query.field((String)"key").equalsValue((Object)"a")), (QueryComponent[])new QueryComponent[0])).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexScan((String)"Map$entry-value"), LucenePlanMatchers.scanParams((Matcher<IndexScanParameters>)Matchers.allOf(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"entry_value:king")), LucenePlanMatchers.group((Matcher<ScanComparisons>)PlanMatchers.hasTupleString((String)"[[a],[a]]"))))));
                MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
                Assertions.assertEquals(Set.of(Long.valueOf(2L)), Set.copyOf(primaryKeys));
            }
        }
    }

    @ParameterizedTest(name="nestedLuceneFieldQuery[shouldDeferFetch={0}]")
    @BooleanSource
    void nestedLuceneFieldQuery(boolean shouldDeferFetch) throws Exception {
        this.initializeNested();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            RecordQuery query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter((QueryComponent)new LuceneQueryComponent("entry_value:king", (List)Lists.newArrayList((Object[])new String[]{"entry"}))).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexScan((String)"MapField$values"), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"entry_value:king")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(0L), Long.valueOf(2L)), Set.copyOf(primaryKeys));
            }
        }
    }

    @ParameterizedTest(name="nestedOneOfThemQuery[shouldDeferFetch={0}]")
    @BooleanSource
    void nestedOneOfThemQuery(boolean shouldDeferFetch) throws Exception {
        this.initializeNested();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            RecordQuery query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter(com.apple.foundationdb.record.query.expressions.Query.field((String)"entry").oneOfThem().matches(com.apple.foundationdb.record.query.expressions.Query.field((String)"key").equalsValue((Object)"king"))).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexScan((String)"MapField$values"), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"entry_key:STRING EQUALS king")))));
            matcher = shouldDeferFetch ? PlanMatchers.fetch((Matcher)PlanMatchers.primaryKeyDistinct((Matcher)PlanMatchers.coveringIndexScan((Matcher)matcher))) : PlanMatchers.primaryKeyDistinct((Matcher)matcher);
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(), Set.copyOf(primaryKeys));
            }
        }
    }

    @ParameterizedTest(name="nestedOneOfThemWithAndQuery[shouldDeferFetch={0}]")
    @BooleanSource
    void nestedOneOfThemWithAndQuery(boolean shouldDeferFetch) {
        this.initializeNested();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            QueryComponent filter = com.apple.foundationdb.record.query.expressions.Query.field((String)"entry").oneOfThem().matches(com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)com.apple.foundationdb.record.query.expressions.Query.field((String)"key").equalsValue((Object)"b"), (QueryComponent)com.apple.foundationdb.record.query.expressions.Query.field((String)"value").text().containsPhrase("civil blood makes civil hands unclean"), (QueryComponent[])new QueryComponent[0]));
            RecordQuery query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter(filter).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)MAP_AND_FIELD_ON_LUCENE_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"entry_key:STRING EQUALS b AND entry_value:TEXT TEXT_CONTAINS_PHRASE civil blood makes civil hands unclean")))));
            matcher = shouldDeferFetch ? PlanMatchers.fetch((Matcher)PlanMatchers.primaryKeyDistinct((Matcher)PlanMatchers.coveringIndexScan((Matcher)matcher))) : PlanMatchers.primaryKeyDistinct((Matcher)matcher);
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }

    @ParameterizedTest(name="nestedOneOfThemWithOrQuery[shouldDeferFetch={0}]")
    @BooleanSource
    void nestedOneOfThemWithOrQuery(boolean shouldDeferFetch) throws Exception {
        this.initializeNested();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            QueryComponent filter = com.apple.foundationdb.record.query.expressions.Query.field((String)"entry").oneOfThem().matches(com.apple.foundationdb.record.query.expressions.Query.or((QueryComponent)com.apple.foundationdb.record.query.expressions.Query.field((String)"key").equalsValue((Object)"b"), (QueryComponent)com.apple.foundationdb.record.query.expressions.Query.field((String)"value").text().containsPhrase("civil blood makes civil hands unclean"), (QueryComponent[])new QueryComponent[0]));
            RecordQuery query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter(filter).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)MAP_AND_FIELD_ON_LUCENE_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"entry_key:STRING EQUALS b OR entry_value:TEXT TEXT_CONTAINS_PHRASE civil blood makes civil hands unclean")))));
            matcher = shouldDeferFetch ? PlanMatchers.fetch((Matcher)PlanMatchers.primaryKeyDistinct((Matcher)PlanMatchers.coveringIndexScan((Matcher)matcher))) : PlanMatchers.primaryKeyDistinct((Matcher)matcher);
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(2L)), Set.copyOf(primaryKeys));
            }
        }
    }

    @ParameterizedTest(name="longFieldQuery[shouldDeferFetch={0}]")
    @BooleanSource
    void longFieldQuery(boolean shouldDeferFetch) throws Exception {
        this.initializeNested();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            RecordQuery query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter(com.apple.foundationdb.record.query.expressions.Query.field((String)"doc_id").greaterThan((Object)1L)).build();
            this.setDeferFetchAfterUnionAndIntersection(shouldDeferFetch);
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexName((String)MAP_AND_FIELD_ON_LUCENE_INDEX.getName()), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"doc_id:LONG GREATER_THAN 1")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(2L)), Set.copyOf(primaryKeys));
            }
        }
    }

    @Test
    void covering() throws Exception {
        this.initializeWithGroup();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStoreWithGroup(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("parents", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter1).setRequiredResults(List.of(Key.Expressions.field((String)"group"))).build();
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.coveringIndexScan((Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexName((String)TEXT_AND_GROUP.getName()), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI parents"))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List results = (List)recordCursor.map(qr -> {
                    long pk = qr.getPrimaryKey().getLong(0);
                    TestRecordsTextProto.SimpleDocument.Builder builder = TestRecordsTextProto.SimpleDocument.newBuilder();
                    builder.mergeFrom(qr.getRecord());
                    long gr = builder.getGroup();
                    return Pair.of((Object)pk, (Object)gr);
                }).asList().get();
                Assertions.assertEquals(Set.of(Pair.of((Object)2L, (Object)0L), Pair.of((Object)4L, (Object)0L), Pair.of((Object)5L, (Object)1L)), Set.copyOf(results));
                TestHelpers.assertLoadRecord((int)0, (FDBRecordContext)context);
            }
        }
    }

    @Test
    void fullGroupScan() {
        Matcher matcher;
        RecordQueryPlan plan;
        RecordQuery query;
        QueryComponent groupFilter;
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, md -> md.removeIndex(MAP_AND_FIELD_ON_LUCENE_INDEX.getName()), LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES);
            groupFilter = com.apple.foundationdb.record.query.expressions.Query.field((String)"entry").oneOfThem().matches(com.apple.foundationdb.record.query.expressions.Query.field((String)"key").equalsValue((Object)"a"));
            query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter(groupFilter).build();
            plan = this.planQuery(query);
            matcher = PlanMatchers.filter((QueryComponent)groupFilter, (Matcher)PlanMatchers.typeFilter((Matcher)Matchers.equalTo(Collections.singleton(MAP_DOC)), (Matcher)PlanMatchers.scan((Matcher)PlanMatchers.unbounded())));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
        context = this.openContext();
        try {
            this.openRecordStore(context, md -> {
                md.removeIndex(MAP_AND_FIELD_ON_LUCENE_INDEX.getName());
                md.removeIndex(MAP_ON_LUCENE_INDEX.getName());
                md.addIndex(MAP_DOC, new Index("GroupedMap", (KeyExpression)new GroupingKeyExpression((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)mainExpression, (KeyExpression[])new KeyExpression[0]), 1), "lucene"));
            }, LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES);
            groupFilter = com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)com.apple.foundationdb.record.query.expressions.Query.field((String)"group").equalsValue((Object)1L), (QueryComponent)com.apple.foundationdb.record.query.expressions.Query.field((String)"entry").oneOfThem().matches(com.apple.foundationdb.record.query.expressions.Query.field((String)"key").equalsValue((Object)"a")), (QueryComponent[])new QueryComponent[0]);
            query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter(groupFilter).build();
            plan = this.planQuery(query);
            matcher = PlanMatchers.filter((QueryComponent)groupFilter, (Matcher)PlanMatchers.typeFilter((Matcher)Matchers.equalTo(Collections.singleton(MAP_DOC)), (Matcher)PlanMatchers.scan((Matcher)PlanMatchers.unbounded())));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    void andNot() throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("Verona", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            LuceneQueryComponent filter2 = new LuceneQueryComponent("traffic", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)filter1, (QueryComponent)com.apple.foundationdb.record.query.expressions.Query.not((QueryComponent)filter2), (QueryComponent[])new QueryComponent[0])).build();
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScan((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI Verona AND NOT MULTI traffic")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            MatcherAssert.assertThat((Object)this.getLuceneQuery(plan), (Matcher)Matchers.hasToString((String)"+(text:verona) -(text:traffic)"));
            try (RecordCursor fdbQueriedRecordRecordCursor = this.recordStore.executeQuery(plan);){
                RecordCursor map = fdbQueriedRecordRecordCursor.map(FDBRecord::getPrimaryKey);
                List primaryKeys = (List)map.map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(2L)), Set.copyOf(primaryKeys));
            }
        }
    }

    @Test
    void justNot() throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter = new LuceneQueryComponent("Verona", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(com.apple.foundationdb.record.query.expressions.Query.not((QueryComponent)filter)).build();
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScan((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"NOT MULTI Verona")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            MatcherAssert.assertThat((Object)this.getLuceneQuery(plan), (Matcher)Matchers.hasToString((String)"+*:* -(text:verona)"));
            try (RecordCursor fdbQueriedRecordRecordCursor = this.recordStore.executeQuery(plan);){
                RecordCursor map = fdbQueriedRecordRecordCursor.map(FDBRecord::getPrimaryKey);
                List primaryKeys = (List)map.map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(3L), Long.valueOf(5L)), Set.copyOf(primaryKeys));
            }
        }
    }

    @Test
    void notOr() throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("Verona", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            LuceneQueryComponent filter2 = new LuceneQueryComponent("traffic", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(com.apple.foundationdb.record.query.expressions.Query.not((QueryComponent)com.apple.foundationdb.record.query.expressions.Query.or((QueryComponent)filter1, (QueryComponent)filter2, (QueryComponent[])new QueryComponent[0]))).build();
            RecordQueryPlan plan = this.planQuery(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScan((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"NOT MULTI Verona AND NOT MULTI traffic")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            MatcherAssert.assertThat((Object)this.getLuceneQuery(plan), (Matcher)Matchers.hasToString((String)"+*:* -(text:verona) -(text:traffic)"));
            try (RecordCursor fdbQueriedRecordRecordCursor = this.recordStore.executeQuery(plan);){
                RecordCursor map = fdbQueriedRecordRecordCursor.map(FDBRecord::getPrimaryKey);
                List primaryKeys = (List)map.map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(Set.of(Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(3L)), Set.copyOf(primaryKeys));
            }
        }
    }

    private Query getLuceneQuery(RecordQueryPlan plan) {
        LuceneIndexQueryPlan indexPlan = (LuceneIndexQueryPlan)plan;
        LuceneScanQuery scan = (LuceneScanQuery)indexPlan.getScanParameters().bind((FDBRecordStoreBase)this.recordStore, this.recordStore.getRecordMetaData().getIndex(indexPlan.getIndexName()), EvaluationContext.EMPTY);
        return scan.getQuery();
    }

    @Test
    void sortByPrimaryKey() throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("parents", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter1).setSort((KeyExpression)Key.Expressions.field((String)"doc_id"), true).build();
            RecordQueryPlan plan = this.planQuery(query);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Assertions.assertEquals(List.of(Long.valueOf(5L), Long.valueOf(4L), Long.valueOf(2L)), (Object)primaryKeys);
            }
        }
    }

    @Test
    void sortByGroupedPrimaryKey() throws Exception {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStoreWithComplex(context);
            this.complexDocuments.forEach(arg_0 -> ((FDBRecordStore)this.recordStore).saveRecord(arg_0));
            this.commit(context);
        }
        context = this.openContext();
        try {
            this.openRecordStoreWithComplex(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("parents", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter(com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)com.apple.foundationdb.record.query.expressions.Query.field((String)"group").equalsValue((Object)0L), (QueryComponent)filter1, (QueryComponent[])new QueryComponent[0])).setSort((KeyExpression)Key.Expressions.field((String)"doc_id"), true).build();
            RecordQueryPlan plan = this.planQuery(query);
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(1)).asList().get();
                Assertions.assertEquals(List.of(Long.valueOf(2L), Long.valueOf(0L)), (Object)primaryKeys);
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest(name="unionSearches[sorted={0}]")
    @BooleanSource
    void unionSearches(boolean sorted) throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("parents", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            LuceneQueryComponent filter2 = new LuceneQueryComponent("king", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            RecordQuery.Builder query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter(com.apple.foundationdb.record.query.expressions.Query.or((QueryComponent)filter1, (QueryComponent)filter2, (QueryComponent[])new QueryComponent[0]));
            if (sorted) {
                query.setSort((KeyExpression)Key.Expressions.field((String)"doc_id"));
            }
            RecordQueryPlan plan = this.planQuery(query.build());
            Matcher matcher1 = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexName((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI parents")))));
            Matcher matcher2 = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexName((String)LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES.getName()), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"MULTI king")))));
            if (sorted) {
                MatcherAssert.assertThat((Object)plan, (Matcher)PlanMatchers.union((Matcher)matcher1, (Matcher)matcher2));
            } else {
                MatcherAssert.assertThat((Object)plan, (Matcher)PlanMatchers.primaryKeyDistinct((Matcher)PlanMatchers.unorderedUnion((Matcher)matcher1, (Matcher)matcher2)));
            }
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                if (sorted) {
                    Assertions.assertEquals(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(4L), Long.valueOf(5L)), (Object)primaryKeys);
                } else {
                    Assertions.assertEquals(Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(4L), Long.valueOf(5L)), new HashSet(primaryKeys));
                }
            }
        }
    }

    @ParameterizedTest(name="continuations[sorted={0}]")
    @BooleanSource
    void continuations(boolean sorted) throws Exception {
        this.initializeFlat();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            LuceneQueryComponent filter1 = new LuceneQueryComponent("parents", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            RecordQuery.Builder query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter1);
            if (sorted) {
                query.setSort((KeyExpression)Key.Expressions.field((String)"doc_id"));
            }
            RecordQueryPlan plan = this.planQuery(query.build());
            ExecuteProperties executeProperties = ExecuteProperties.newBuilder().setReturnedRowLimit(2).build();
            ArrayList primaryKeys = new ArrayList();
            byte[] continuation = null;
            AtomicReference holder = new AtomicReference();
            do {
                try (RecordCursor recordCursor = this.recordStore.executeQuery(plan, continuation, executeProperties);){
                    primaryKeys.addAll((Collection)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList(holder).get());
                    continuation = ((RecordCursorResult)holder.get()).getContinuation().toBytes();
                }
            } while (continuation != null);
            if (sorted) {
                Assertions.assertEquals(List.of(Long.valueOf(2L), Long.valueOf(4L), Long.valueOf(5L)), primaryKeys);
            } else {
                Assertions.assertEquals(Set.of(Long.valueOf(2L), Long.valueOf(4L), Long.valueOf(5L)), new HashSet(primaryKeys));
            }
        }
    }

    @Test
    void testQueryWithManyDocuments() {
        FDBDatabaseFactory factory = this.dbExtension.getDatabaseFactory();
        factory.setExecutor((Executor)new ForkJoinPool(8, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, false));
        factory.getDatabase().setAsyncToSyncTimeout(event -> Duration.ofSeconds(1L));
        for (long i = 0L; i < 20L; ++i) {
            try (FDBRecordContext context = this.openContext();){
                this.openRecordStore(context);
                for (int j = 0; j < 10; ++j) {
                    TestRecordsTextProto.SimpleDocument document1 = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(i * 1000L + (long)j).setGroup(1L).setText(LuceneIndexTestUtils.generateRandomWords(1000)[1]).build();
                    this.recordStore.saveRecord((Message)document1);
                }
                this.commit(context);
                continue;
            }
        }
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            this.assertPrimaryKeys("text:morningstart", false, Set.of());
        }
    }

    @ParameterizedTest
    @RandomSeedSource
    void encrypted(long seed) throws Exception {
        RollingTestKeyManager rollingTestKeyManager = new RollingTestKeyManager(seed);
        this.keyManager = rollingTestKeyManager;
        for (TestRecordsTextProto.SimpleDocument doc : DOCUMENTS) {
            FDBRecordContext context = this.openContext();
            try {
                this.openRecordStore(context);
                this.recordStore.saveRecord((Message)doc);
                this.commit(context);
            }
            finally {
                if (context == null) continue;
                context.close();
            }
        }
        MatcherAssert.assertThat((Object)rollingTestKeyManager.numberOfKeys(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
        try (FDBRecordContext context = this.openContext();){
            List primaryKeys;
            this.openRecordStore(context);
            LuceneQueryComponent filter = new LuceneQueryComponent("parents", (List)Lists.newArrayList((Object[])new String[]{"text"}), true);
            RecordQuery.Builder query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter);
            RecordQueryPlan plan = this.planQuery(query.build());
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
            }
            Assertions.assertEquals(Set.of(Long.valueOf(2L), Long.valueOf(4L), Long.valueOf(5L)), new HashSet(primaryKeys));
        }
    }

    static class CountingThreadFactory
    implements ThreadFactory {
        final Map<String, Integer> threadCounts = new ConcurrentHashMap<String, Integer>();
        final ThreadFactory delegate = Executors.defaultThreadFactory();

        CountingThreadFactory() {
        }

        @Override
        public Thread newThread(@Nonnull Runnable r) {
            return this.delegate.newThread(() -> {
                this.threadCounts.merge(Thread.currentThread().getName(), 1, Integer::sum);
                r.run();
            });
        }
    }
}

