/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.query;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;

public class BitSetQuery
extends Query {
    private final String field;
    private final long bitMask;

    public BitSetQuery(String field, long bitMask) {
        this.field = field;
        this.bitMask = bitMask;
    }

    public String toString(String field) {
        return "BITSET-MASK(" + Long.toBinaryString(this.bitMask) + ")";
    }

    public String getField() {
        return this.field;
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object obj) {
        return this.sameClassAs(obj) && this.equalsTo((BitSetQuery)((Object)((Object)((Object)this)).getClass().cast(obj)));
    }

    private boolean equalsTo(BitSetQuery query) {
        return Objects.equals(this.bitMask, query.bitMask) && Objects.equals(this.field, query.field);
    }

    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        return 31 * hash + Long.hashCode(this.bitMask);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            private boolean matches(byte[] bitSet) {
                return (NumericUtils.sortableBytesToLong((byte[])bitSet, (int)0) & BitSetQuery.this.bitMask) == BitSetQuery.this.bitMask;
            }

            private PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    public void visit(int docID, byte[] packedValue) {
                        if (this.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                        if (this.matches(packedValue)) {
                            int docID;
                            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                                this.visit(docID);
                            }
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                };
            }

            private PointValues.IntersectVisitor getInverseIntersectVisitor(final FixedBitSet result, final int[] cost) {
                return new PointValues.IntersectVisitor(){

                    public void visit(int docID) {
                        result.clear(docID);
                        cost[0] = cost[0] - 1;
                    }

                    public void visit(int docID, byte[] packedValue) {
                        if (!this.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                        if (!this.matches(packedValue)) {
                            int docID;
                            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                                this.visit(docID);
                            }
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                };
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(BitSetQuery.this.field);
                if (values == null) {
                    return null;
                }
                1 weight = this;
                return new ScorerSupplier((Weight)weight){
                    final DocIdSetBuilder result;
                    final PointValues.IntersectVisitor visitor;
                    long cost;
                    final /* synthetic */ Weight val$weight;
                    {
                        this.val$weight = weight;
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values, BitSetQuery.this.field);
                        this.visitor = this.getIntersectVisitor(this.result);
                        this.cost = -1L;
                    }

                    public Scorer get(long leadCost) throws IOException {
                        values.intersect(this.visitor);
                        DocIdSetIterator iterator = this.result.build().iterator();
                        return new ConstantScoreScorer(this.val$weight, this.score(), scoreMode, iterator);
                    }

                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimateDocCount(this.visitor);
                            assert (this.cost >= 0L);
                        }
                        return this.cost;
                    }
                };
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }
}

