/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.highlight;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCoreArgumentException;

@API(value=API.Status.EXPERIMENTAL)
@SpotBugsSuppressWarnings(value={"EI2"}, justification="functionally immutable, and done for performance reasons")
public class HighlightedTerm {
    private final String fieldName;
    private final String summarizedText;
    private final int[] highlightStarts;
    private final int[] highlightEnds;

    public HighlightedTerm(String fieldName, String summarizedText, int[] highlightStarts, int[] highlightEnds) {
        this.fieldName = fieldName;
        this.summarizedText = summarizedText;
        this.highlightStarts = highlightStarts;
        this.highlightEnds = highlightEnds;
        if (highlightStarts.length != highlightEnds.length) {
            throw new RecordCoreArgumentException("There must be a start and end for each highlight", new Object[0]);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getSummarizedText() {
        return this.summarizedText;
    }

    public int getNumHighlights() {
        return this.highlightStarts.length;
    }

    public int getHighlightStart(int pos) {
        return this.highlightStarts[pos];
    }

    public int getHighlightEnd(int pos) {
        return this.highlightEnds[pos];
    }
}

