/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.lucene.codec.PrefetchableBufferedChecksumIndexInput;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import javax.annotation.Nonnull;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public final class FDBIndexOutput
extends IndexOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBIndexOutput.class);
    private int currentSize = 0;
    private ByteBuffer buffer;
    private final String resourceDescription;
    private final FDBDirectory fdbDirectory;
    private final int blockSize;
    private final CRC32 crc;
    private final long id;
    private long actualSize;

    public FDBIndexOutput(@Nonnull String name, @Nonnull FDBDirectory fdbDirectory) throws IOException {
        this(name, name, fdbDirectory);
    }

    public FDBIndexOutput(@Nonnull String resourceDescription, @Nonnull String name, @Nonnull FDBDirectory fdbDirectory) throws IOException {
        super(resourceDescription, name);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(KeyValueLogMessage.of((String)"init", (Object[])new Object[]{LuceneLogMessageKeys.RESOURCE, resourceDescription, LuceneLogMessageKeys.FILE_NAME, name}));
        }
        this.resourceDescription = resourceDescription;
        this.fdbDirectory = fdbDirectory;
        this.actualSize = 0L;
        this.blockSize = fdbDirectory.getBlockSize();
        this.buffer = ByteBuffer.allocate(this.blockSize);
        this.crc = new CRC32();
        this.id = fdbDirectory.getIncrement();
    }

    @SpotBugsSuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="it is fine if it is not accepted")
    public void close() throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("close()", new Object[]{LuceneLogMessageKeys.RESOURCE, this.resourceDescription}));
        }
        try {
            if (this.buffer != null) {
                this.flush();
                this.buffer = null;
                this.fdbDirectory.writeFDBLuceneFileReference(this.resourceDescription, new FDBLuceneFileReference(this.id, this.currentSize, this.actualSize, this.blockSize));
            }
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    public long getFilePointer() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("getFilePointer()", new Object[]{LuceneLogMessageKeys.RESOURCE, this.resourceDescription, LuceneLogMessageKeys.POINTER, this.currentSize}));
        }
        return this.currentSize;
    }

    public long getChecksum() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("getChecksum()", new Object[]{LuceneLogMessageKeys.CHECKSUM, this.crc.getValue()}));
        }
        return this.crc.getValue();
    }

    public void writeByte(byte b) throws IOException {
        try {
            this.buffer.put(b);
            this.crc.update(b);
            ++this.currentSize;
            this.flushIfFullBuffer();
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    void setExpectedBytes(@Nonnull PrefetchableBufferedChecksumIndexInput input, long numBytes) {
        input.setExpectedBytes(numBytes);
    }

    public void copyBytes(@Nonnull DataInput input, long numBytes) throws IOException {
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(this.getLogMessage("copy bytes", new Object[]{LuceneLogMessageKeys.INPUT, input, LuceneLogMessageKeys.BYTE_NUMBER, numBytes}));
            }
            if (input instanceof PrefetchableBufferedChecksumIndexInput) {
                this.setExpectedBytes((PrefetchableBufferedChecksumIndexInput)input, numBytes);
            }
            super.copyBytes(input, numBytes);
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    public void writeBytes(@Nonnull byte[] bytes, int offset, int length) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("writeBytes()", new Object[]{LuceneLogMessageKeys.OFFSET, offset, LuceneLogMessageKeys.LENGTH, length}));
        }
        try {
            this.crc.update(bytes, offset, length);
            int bytesWritten = 0;
            while (bytesWritten < length) {
                int toWrite = Math.min(length - bytesWritten, this.blockSize - this.buffer.position());
                this.buffer.put(bytes, bytesWritten + offset, toWrite);
                bytesWritten += toWrite;
                this.currentSize += toWrite;
                this.flushIfFullBuffer();
            }
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    private void flush() throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("flush()", new Object[]{LuceneLogMessageKeys.FILE_ID, this.id}));
        }
        if (this.buffer.position() > 0) {
            this.buffer.flip();
            byte[] arr = new byte[this.buffer.remaining()];
            this.buffer.get(arr);
            this.actualSize += (long)this.fdbDirectory.writeData(this.id, (this.currentSize - 1) / this.blockSize, arr);
        }
        this.buffer.clear();
    }

    private void flushIfFullBuffer() throws IOException {
        if (this.buffer.position() >= this.blockSize) {
            this.flush();
        }
    }

    @Nonnull
    private String getLogMessage(@Nonnull String staticMsg, Object ... keysAndValues) {
        return KeyValueLogMessage.build((String)staticMsg, (Object[])keysAndValues).addKeyAndValue((Object)LogMessageKeys.SUBSPACE, (Object)this.fdbDirectory.getSubspace()).addKeyAndValue((Object)LuceneLogMessageKeys.RESOURCE, (Object)this.resourceDescription).toString();
    }
}

