/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedCompoundReader;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import javax.annotation.Nonnull;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;

public class FDBDirectoryUtils {
    private FDBDirectoryUtils() {
    }

    @Nonnull
    public static FDBDirectory getFDBDirectory(@Nonnull Directory directory) {
        Directory unwrapped = FilterDirectory.unwrap((Directory)directory);
        if (unwrapped instanceof FDBDirectory) {
            return (FDBDirectory)unwrapped;
        }
        if (unwrapped instanceof LuceneOptimizedCompoundReader) {
            return (FDBDirectory)FilterDirectory.unwrap((Directory)((LuceneOptimizedCompoundReader)unwrapped).getDirectory());
        }
        throw new RecordCoreException("Unexpected type of directory " + unwrapped.getClass().getSimpleName(), new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.NAME, unwrapped.getClass().getSimpleName()});
    }

    @Nonnull
    public static FDBDirectory getFDBDirectoryNotCompound(@Nonnull Directory directory) {
        Directory unwrapped = FilterDirectory.unwrap((Directory)directory);
        if (unwrapped instanceof FDBDirectory) {
            return (FDBDirectory)unwrapped;
        }
        if (unwrapped instanceof LuceneOptimizedCompoundReader) {
            throw new RecordCoreException("CompoundReader given as directory", new Object[0]);
        }
        throw new RecordCoreException("Unexpected type of directory", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.NAME, unwrapped.getClass().getSimpleName()});
    }
}

