/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@API(value=API.Status.EXPERIMENTAL)
@ThreadSafe
public class FDBDirectorySharedCache {
    @Nonnull
    private final Tuple key;
    private final long sequenceNumber;
    @Nonnull
    private final AtomicReference<Map<String, FDBLuceneFileReference>> fileReferences;
    @Nonnull
    private final AtomicReference<ConcurrentMap<Long, AtomicInteger>> fieldInfosReferenceCount = new AtomicReference();
    @Nonnull
    private final Cache<Pair<Long, Integer>, byte[]> blocks;

    public FDBDirectorySharedCache(@Nonnull Tuple key, long sequenceNumber, int maximumSize, int concurrencyLevel, int initialCapacity) {
        this.key = key;
        this.sequenceNumber = sequenceNumber;
        this.fileReferences = new AtomicReference();
        this.blocks = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumSize((long)maximumSize).recordStats().build();
    }

    @Nonnull
    public Tuple getKey() {
        return this.key;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Nullable
    public Map<String, FDBLuceneFileReference> getFileReferencesIfPresent() {
        return this.fileReferences.get();
    }

    public void setFileReferencesIfAbsent(@Nonnull Map<String, FDBLuceneFileReference> fileReferences) {
        this.fileReferences.compareAndSet(null, fileReferences);
    }

    @Nullable
    public byte[] getBlockIfPresent(long id, int blockNumber) {
        return (byte[])this.blocks.getIfPresent((Object)Pair.of((Object)id, (Object)blockNumber));
    }

    public void putBlockIfAbsent(long id, int blockNumber, @Nonnull byte[] block) {
        this.blocks.asMap().putIfAbsent(Pair.of((Object)id, (Object)blockNumber), block);
    }

    public void setFieldInfosReferenceCount(ConcurrentMap<Long, AtomicInteger> fieldInfosReferenceCount) {
        this.fieldInfosReferenceCount.compareAndSet(null, fieldInfosReferenceCount);
    }

    public ConcurrentMap<Long, AtomicInteger> getFieldInfosReferenceCount() {
        return this.fieldInfosReferenceCount.get();
    }
}

