/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import java.io.IOException;
import org.apache.lucene.store.IndexOutput;

public class EmptyIndexOutput
extends IndexOutput {
    private final FDBDirectory fdbDirectory;
    private final String resourceDescription;
    private final long id;

    protected EmptyIndexOutput(String resourceDescription, String name, FDBDirectory fdbDirectory) throws IOException {
        super(resourceDescription, name);
        this.resourceDescription = resourceDescription;
        this.fdbDirectory = fdbDirectory;
        this.id = fdbDirectory.getIncrement();
    }

    public void close() throws IOException {
        try {
            this.fdbDirectory.writeFDBLuceneFileReference(this.resourceDescription, new FDBLuceneFileReference(this.id, 0L, 0L, 0L));
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    public long getFilePointer() {
        return 0L;
    }

    public long getChecksum() {
        return 0L;
    }

    public void writeByte(byte b) throws IOException {
        throw new IOException("Tried to write to FieldInfos");
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        throw new IOException("Tried to write to FieldInfos");
    }
}

