/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.codec.LazyCloseable;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedPostingsFormat;
import java.io.IOException;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public class LuceneOptimizedPointsFormat
extends PointsFormat {
    PointsFormat pointsFormat;

    public LuceneOptimizedPointsFormat(PointsFormat pointsFormat) {
        this.pointsFormat = pointsFormat;
    }

    public PointsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return this.pointsFormat.fieldsWriter(state);
    }

    public PointsReader fieldsReader(SegmentReadState state) throws IOException {
        return new LazyPointsReader(state);
    }

    private class LazyPointsReader
    extends PointsReader {
        private LazyCloseable<PointsReader> pointsReader = LazyCloseable.supply(() -> LuceneOptimizedPointsFormat.this.pointsFormat.fieldsReader(state));

        private LazyPointsReader(SegmentReadState state) {
        }

        public void checkIntegrity() throws IOException {
            if (LuceneOptimizedPostingsFormat.allowCheckDataIntegrity) {
                this.pointsReader.get().checkIntegrity();
            }
        }

        public PointValues getValues(String field) throws IOException {
            return this.pointsReader.get().getValues(field);
        }

        public void close() throws IOException {
            this.pointsReader.close();
        }

        public long ramBytesUsed() {
            return this.pointsReader.getUnchecked().ramBytesUsed();
        }
    }
}

