/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneScanBounds;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.tuple.Tuple;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

@API(value=API.Status.UNSTABLE)
public class LuceneScanQuery
extends LuceneScanBounds {
    @Nonnull
    private final Query query;
    @Nullable
    private final Sort sort;
    @Nullable
    private final List<String> storedFields;
    @Nullable
    private final List<LuceneIndexExpressions.DocumentFieldType> storedFieldTypes;
    @Nullable
    private final LuceneScanQueryParameters.LuceneQueryHighlightParameters luceneQueryHighlightParameters;
    @Nullable
    private final Map<String, Set<String>> termMap;

    public LuceneScanQuery(@Nonnull IndexScanType scanType, @Nonnull Tuple groupKey, @Nonnull Query query, @Nullable Sort sort, @Nullable List<String> storedFields, @Nullable List<LuceneIndexExpressions.DocumentFieldType> storedFieldTypes, @Nullable LuceneScanQueryParameters.LuceneQueryHighlightParameters luceneQueryHighlightParameters, @Nullable Map<String, Set<String>> termMap) {
        super(scanType, groupKey);
        this.query = query;
        this.sort = sort;
        this.storedFields = storedFields;
        this.storedFieldTypes = storedFieldTypes;
        this.luceneQueryHighlightParameters = luceneQueryHighlightParameters;
        this.termMap = termMap;
    }

    @Nonnull
    public Query getQuery() {
        return this.query;
    }

    @Nullable
    public Sort getSort() {
        return this.sort;
    }

    @Nullable
    public List<String> getStoredFields() {
        return this.storedFields;
    }

    @Nullable
    public List<LuceneIndexExpressions.DocumentFieldType> getStoredFieldTypes() {
        return this.storedFieldTypes;
    }

    @Nullable
    public LuceneScanQueryParameters.LuceneQueryHighlightParameters getLuceneQueryHighlightParameters() {
        return this.luceneQueryHighlightParameters;
    }

    @Nullable
    public Map<String, Set<String>> getTermMap() {
        return this.termMap;
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.valueOf(this.query);
    }
}

