/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.query.expressions.Comparisons;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class LuceneComparisonQuery
extends Query {
    private final Query query;
    private final String fieldName;
    private final Comparisons.Type comparisonType;
    private final Object comparand;

    public LuceneComparisonQuery(@Nonnull Query query, @Nonnull String fieldName, @Nonnull Comparisons.Type comparisonType, @Nullable Object comparand) {
        this.query = query;
        this.fieldName = fieldName;
        this.comparisonType = comparisonType;
        this.comparand = comparand;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return this.query.createWeight(searcher, scoreMode, boost);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this.query.rewrite(reader);
    }

    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Comparisons.Type getComparisonType() {
        return this.comparisonType;
    }

    public Object getComparand() {
        return this.comparand;
    }

    public String toString(String field) {
        return this.query.toString(field);
    }

    public boolean equals(Object obj) {
        return obj instanceof LuceneComparisonQuery && Objects.equals(this.fieldName, ((LuceneComparisonQuery)((Object)obj)).fieldName) && Objects.equals(this.comparisonType, ((LuceneComparisonQuery)((Object)obj)).comparisonType) && Objects.equals(this.comparand, ((LuceneComparisonQuery)((Object)obj)).comparand) && Objects.equals(this.query, ((LuceneComparisonQuery)((Object)obj)).query);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.comparisonType, this.comparand, this.query);
    }
}

