/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.standard.UAX29URLEmailAnalyzer;

public class LuceneAnalyzerWrapper {
    public static final String STANDARD_ANALYZER_NAME = "STANDARD";
    private final String uniqueIdentifier;
    private final Analyzer analyzer;

    public LuceneAnalyzerWrapper(@Nonnull String uniqueIdentifier, @Nonnull Analyzer analyzer) {
        this.uniqueIdentifier = uniqueIdentifier;
        this.analyzer = analyzer;
    }

    @Nonnull
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @Nonnull
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Nonnull
    public static LuceneAnalyzerWrapper getStandardAnalyzerWrapper() {
        UAX29URLEmailAnalyzer backingAnalyzer = new UAX29URLEmailAnalyzer(EnglishAnalyzer.ENGLISH_STOP_WORDS_SET);
        backingAnalyzer.setMaxTokenLength(30);
        return new LuceneAnalyzerWrapper(STANDARD_ANALYZER_NAME, (Analyzer)backingAnalyzer);
    }
}

