/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.filter.AlphanumericLengthFilter;
import com.apple.foundationdb.record.lucene.filter.CjkUnigramFilter;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapRegistryImpl;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.synonym.SynonymGraphFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;

public class AlphanumericCjkAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MIN_TOKEN_LENGTH = 3;
    public static final String UNIQUE_IDENTIFIER = "cjk";
    private int minTokenLength;
    private int maxTokenLength;
    @Nullable
    private final String synonymName;
    private final boolean breakLongTokens;

    public AlphanumericCjkAnalyzer(@Nonnull CharArraySet stopWords) {
        this(stopWords, null);
    }

    public AlphanumericCjkAnalyzer(@Nonnull CharArraySet stopWords, boolean breakLongTokens) {
        this(stopWords, 3, 255, breakLongTokens, null);
    }

    public AlphanumericCjkAnalyzer(@Nonnull CharArraySet stopWords, @Nullable String synonymName) {
        this(stopWords, 3, 255, true, synonymName);
    }

    public AlphanumericCjkAnalyzer(@Nonnull CharArraySet stopWords, int minTokenLength, int maxTokenLength, @Nullable String synonymName) {
        this(stopWords, minTokenLength, maxTokenLength, true, synonymName);
    }

    public AlphanumericCjkAnalyzer(@Nonnull CharArraySet stopWords, int minTokenLength, int maxTokenLength, boolean breakLongTokens, @Nullable String synonymName) {
        super(stopWords);
        this.breakLongTokens = breakLongTokens;
        this.minTokenLength = minTokenLength;
        this.maxTokenLength = maxTokenLength;
        this.synonymName = synonymName;
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public void setMinTokenLength(int length) {
        this.minTokenLength = length;
    }

    public int getMinTokenLength() {
        return this.minTokenLength;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        UAX29URLEmailTokenizer src = new UAX29URLEmailTokenizer();
        if (this.breakLongTokens) {
            src.setMaxTokenLength(this.maxTokenLength);
        }
        Object result = new CJKWidthFilter((TokenStream)src);
        result = new LowerCaseFilter((TokenStream)result);
        result = new ASCIIFoldingFilter((TokenStream)result);
        result = new CjkUnigramFilter((TokenStream)result);
        result = new AlphanumericLengthFilter((TokenStream)result, this.minTokenLength, this.getMaxTokenLength());
        result = new StopFilter((TokenStream)result, this.stopwords);
        SynonymMap synonymMap = this.getSynonymMap();
        if (synonymMap != null) {
            result = new SynonymGraphFilter((TokenStream)result, synonymMap, true);
        }
        if (this.breakLongTokens) {
            return new Analyzer.TokenStreamComponents(r -> {
                src.setMaxTokenLength(this.maxTokenLength);
                src.setReader(r);
            }, (TokenStream)result);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)result);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter((TokenStream)new CJKWidthFilter(in));
    }

    @Nullable
    private SynonymMap getSynonymMap() {
        if (this.synonymName == null) {
            return null;
        }
        return SynonymMapRegistryImpl.instance().getSynonymMap(this.synonymName);
    }
}

