/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.RecordCoreException;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public class InjectedFailureRepository {
    private EnumMap<Methods, FailureDescription> failureDescriptions = new EnumMap(Methods.class);
    private EnumMap<Methods, AtomicLong> invocationCounts = new EnumMap(Methods.class);
    private EnumMap<Flags, Boolean> flagsMap = new EnumMap(Flags.class);

    public void addFailure(@Nonnull Methods method, @Nonnull Exception exception, long count) {
        this.failureDescriptions.put(method, new FailureDescription(method, exception, count));
    }

    public void removeFailure(@Nonnull Methods method) {
        this.failureDescriptions.remove((Object)method);
        this.invocationCounts.remove((Object)method);
    }

    public void clear() {
        this.failureDescriptions.clear();
        this.invocationCounts.clear();
    }

    public void setFlag(@Nonnull Flags flag) {
        this.setFlag(flag, true);
    }

    public void setFlag(@Nonnull Flags flag, Boolean value) {
        this.flagsMap.put(flag, value);
    }

    public boolean hasFlag(@Nonnull Flags flag) {
        return Optional.ofNullable(this.flagsMap.get((Object)flag)).orElse(false);
    }

    public void checkFailureForIoException(@Nonnull Methods method) throws IOException {
        try {
            this.checkFailure(method);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Expected IOException, got " + ex.getClass().getSimpleName(), ex);
        }
    }

    public void checkFailureForCoreException(@Nonnull Methods method) throws RecordCoreException {
        try {
            this.checkFailure(method);
        }
        catch (RecordCoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Expected RecordCoreException, got " + ex.getClass().getSimpleName(), ex);
        }
    }

    private void checkFailure(@Nonnull Methods method) throws Exception {
        AtomicLong count;
        long invocations;
        FailureDescription failureDescription = this.failureDescriptions.get((Object)method);
        if (failureDescription != null && (invocations = (count = this.invocationCounts.computeIfAbsent(method, m -> new AtomicLong(0L))).incrementAndGet()) > failureDescription.getCount()) {
            throw failureDescription.getException();
        }
    }

    public static enum Methods {
        LUCENE_GET_INCREMENT,
        LUCENE_GET_FDB_LUCENE_FILE_REFERENCE_ASYNC,
        LUCENE_READ_BLOCK,
        LUCENE_LIST_ALL,
        LUCENE_GET_FILE_REFERENCE_CACHE_ASYNC,
        LUCENE_DELETE_FILE_INTERNAL,
        LUCENE_GET_PRIMARY_KEY_SEGMENT_INDEX,
        LUCENE_GET_ALL_FIELDS_INFO_STREAM;

    }

    public static enum Flags {
        LUCENE_MAINTAINER_SKIP_INDEX_UPDATE;

    }

    public static class FailureDescription {
        @Nonnull
        private final Methods method;
        @Nonnull
        private final Exception exception;
        private final long count;

        public FailureDescription(@Nonnull Methods method, @Nonnull Exception exception, long count) {
            this.method = method;
            this.exception = exception;
            this.count = count;
        }

        @Nonnull
        public Methods getMethod() {
            return this.method;
        }

        @Nonnull
        public Exception getException() {
            return this.exception;
        }

        public long getCount() {
            return this.count;
        }
    }
}

