/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.record.lucene.LuceneConcurrency;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.directory.EmptyIndexInput;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryBaseTest;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import com.apple.foundationdb.record.lucene.directory.InjectedFailureRepository;
import com.apple.foundationdb.record.lucene.directory.LuceneSerializer;
import com.apple.foundationdb.record.lucene.directory.MockedFDBDirectory;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.subspace.Subspace;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.lucene.store.IndexInput;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RequiresFDB")
public class FDBDirectoryFailuresTest
extends FDBDirectoryBaseTest {
    private InjectedFailureRepository injectedFailures;

    @Test
    public void testGetIncrement() throws IOException {
        this.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_INCREMENT, new IOException("Blah"), 2);
        Assertions.assertEquals((long)1L, (long)this.directory.getIncrement());
        Assertions.assertEquals((long)2L, (long)this.directory.getIncrement());
        Assertions.assertThrows(IOException.class, () -> this.directory.getIncrement());
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_GET_INCREMENT_CALLS, 2);
        this.directory.getCallerContext().commit();
        try (FDBRecordContext context = this.fdb.openContext();){
            this.directory = new FDBDirectory(this.subspace, context, null);
            Assertions.assertEquals((long)3L, (long)this.directory.getIncrement());
        }
    }

    @Test
    public void testWriteLuceneFileReference() {
        this.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_FDB_LUCENE_FILE_REFERENCE_ASYNC, (Exception)new LuceneConcurrency.AsyncToSyncTimeoutException("Blah", (Throwable)new TimeoutException("Blah")), 0);
        FDBLuceneFileReference reference1 = new FDBLuceneFileReference(2L, 1L, 1L, 1L);
        this.directory.writeFDBLuceneFileReference("test1", reference1);
        FDBLuceneFileReference reference2 = new FDBLuceneFileReference(3L, 1L, 1L, 1L);
        this.directory.writeFDBLuceneFileReference("test1", reference2);
        Exception ex = (Exception)Assertions.assertThrows(LuceneConcurrency.AsyncToSyncTimeoutException.class, () -> this.directory.getFDBLuceneFileReference("test1"));
        Assertions.assertTrue((boolean)(ex.getCause() instanceof TimeoutException));
    }

    @Test
    public void testWriteSeekData() throws Exception {
        this.addFailure(InjectedFailureRepository.Methods.LUCENE_READ_BLOCK, (Exception)new LuceneConcurrency.AsyncToSyncTimeoutException("Blah", (Throwable)new TimeoutException("Blah")), 0);
        this.directory.writeFDBLuceneFileReference("testReference1", new FDBLuceneFileReference(1L, 1L, 1L, 1L));
        EmptyIndexInput emptyInput = new EmptyIndexInput("Empty Input");
        Exception ex = (Exception)Assertions.assertThrows(ExecutionException.class, () -> this.directory.readBlock((IndexInput)emptyInput, "testReference1", this.directory.getFDBLuceneFileReferenceAsync("testReference1"), 1).get());
        Assertions.assertTrue((boolean)(ex.getCause() instanceof LuceneConcurrency.AsyncToSyncTimeoutException));
        this.directory.writeFDBLuceneFileReference("testReference2", new FDBLuceneFileReference(2L, 1L, 1L, 200L));
        byte[] data = "test string for write".getBytes();
        this.directory.writeData(2L, 1, data);
        ex = (Exception)Assertions.assertThrows(LuceneConcurrency.AsyncToSyncTimeoutException.class, () -> LuceneConcurrency.asyncToSync((StoreTimer.Wait)LuceneEvents.Waits.WAIT_LUCENE_GET_DATA_BLOCK, (CompletableFuture)this.directory.readBlock((IndexInput)emptyInput, "testReference2", this.directory.getFDBLuceneFileReferenceAsync("testReference2"), 1), (FDBRecordContext)this.context));
        Assertions.assertTrue((boolean)(ex.getCause() instanceof TimeoutException));
        this.directory.getCallerContext().commit();
        this.assertCorrectMetricSize((StoreTimer.SizeEvent)LuceneEvents.SizeEvents.LUCENE_WRITE, 1, LuceneSerializer.encode((byte[])data, (boolean)true, (boolean)false).length);
    }

    @Test
    public void testLitAllGetFileReference() throws IOException {
        this.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_FILE_REFERENCE_CACHE_ASYNC, (Exception)new LuceneConcurrency.AsyncToSyncTimeoutException("Blah", (Throwable)new TimeoutException("Blah")), 0);
        Exception ex = (Exception)Assertions.assertThrows(IOException.class, () -> this.directory.listAll());
        Assertions.assertTrue((boolean)(ex.getCause() instanceof LuceneConcurrency.AsyncToSyncTimeoutException));
    }

    @Test
    public void testListAll() throws IOException {
        this.addFailure(InjectedFailureRepository.Methods.LUCENE_LIST_ALL, new IOException("Blah"), 0);
        Assertions.assertThrows(IOException.class, () -> this.directory.listAll());
        this.directory.writeFDBLuceneFileReference("test1", new FDBLuceneFileReference(1L, 1L, 1L, 1L));
        this.directory.writeFDBLuceneFileReference("test2", new FDBLuceneFileReference(2L, 1L, 1L, 1L));
        this.directory.writeFDBLuceneFileReference("test3", new FDBLuceneFileReference(3L, 1L, 1L, 1L));
        this.removeFailure(InjectedFailureRepository.Methods.LUCENE_LIST_ALL);
        Assertions.assertArrayEquals((Object[])new String[]{"test1", "test2", "test3"}, (Object[])this.directory.listAll());
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LIST_ALL, 1);
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LOAD_FILE_CACHE, 1);
        this.directory.getCallerContext().ensureActive().cancel();
        FDBStoreTimer timer = new FDBStoreTimer();
        try (FDBRecordContext context = this.fdb.openContext(null, timer);){
            this.directory = new FDBDirectory(this.subspace, context, null);
            Assertions.assertArrayEquals((Object[])new String[0], (Object[])this.directory.listAll());
            Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LIST_ALL));
            Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LOAD_FILE_CACHE));
        }
    }

    @Test
    public void testDeleteData() throws Exception {
        this.addFailure(InjectedFailureRepository.Methods.LUCENE_DELETE_FILE_INTERNAL, (Exception)new LuceneConcurrency.AsyncToSyncTimeoutException("Blah", (Throwable)new TimeoutException()), 1);
        Assertions.assertThrows(NoSuchFileException.class, () -> this.directory.deleteFile("NonExist"));
        FDBLuceneFileReference reference1 = new FDBLuceneFileReference(1L, 1L, 1L, 1L);
        this.directory.writeFDBLuceneFileReference("test1", reference1);
        Exception ex = (Exception)Assertions.assertThrows(IOException.class, () -> this.directory.deleteFile("test1"));
        Assertions.assertTrue((boolean)(ex.getCause() instanceof LuceneConcurrency.AsyncToSyncTimeoutException));
        Assertions.assertEquals((int)this.directory.listAll().length, (int)1);
        this.assertMetricCountAtMost((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_DELETE_FILE, 1);
    }

    @Test
    public void testFileLength() throws Exception {
        this.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_FDB_LUCENE_FILE_REFERENCE_ASYNC, (Exception)new FDBExceptions.FDBStoreTransactionIsTooOldException("Blah", new FDBException("Blah", 7)), 0);
        long expectedSize = 20L;
        FDBLuceneFileReference reference1 = new FDBLuceneFileReference(1L, expectedSize, expectedSize, 1024L);
        this.directory.writeFDBLuceneFileReference("test1", reference1);
        Assertions.assertThrows(LuceneExceptions.LuceneTransactionTooOldException.class, () -> this.directory.fileLength("test1"));
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_GET_FILE_LENGTH, 1);
        this.directory.getCallerContext().commit();
        FDBStoreTimer timer = new FDBStoreTimer();
        try (FDBRecordContext context = this.fdb.openContext(null, timer);){
            this.directory = new FDBDirectory(this.subspace, context, null);
            long fileSize2 = this.directory.fileLength("test1");
            Assertions.assertEquals((long)expectedSize, (long)fileSize2);
            Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_GET_FILE_LENGTH));
            Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_FILE_LENGTH));
        }
    }

    @Test
    public void testRename() {
        this.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_FILE_REFERENCE_CACHE_ASYNC, (Exception)new LuceneConcurrency.AsyncToSyncTimeoutException("Blah", (Throwable)new TimeoutException("Blah")), 0);
        IOException ioException = (IOException)Assertions.assertThrows(IOException.class, () -> this.directory.rename("NoExist", "newName"));
        Assertions.assertTrue((boolean)(ioException.getCause() instanceof LuceneConcurrency.AsyncToSyncTimeoutException));
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_RENAME_FILE, 1);
    }

    private void assertCorrectMetricCount(StoreTimer.Event metric, int expectedValue) {
        Assertions.assertEquals((int)expectedValue, (int)this.timer.getCount(metric), () -> "Incorrect call count for metric " + String.valueOf(metric));
    }

    private void assertCorrectMetricSize(StoreTimer.SizeEvent metric, int expectedNumber, long expectedCumulativeBytes) {
        Assertions.assertEquals((int)expectedNumber, (int)this.timer.getCount((StoreTimer.Event)metric), () -> "Incorrect call count for metric " + String.valueOf(metric));
        Assertions.assertEquals((long)expectedCumulativeBytes, (long)this.timer.getSize(metric), () -> "Incorrect size for metric " + String.valueOf(metric));
    }

    private void assertMetricCountAtMost(StoreTimer.Event metric, int maximumValue) {
        MatcherAssert.assertThat((String)("Metric " + String.valueOf(metric) + " should be called at most " + maximumValue + " times"), (Object)this.timer.getCount(metric), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(maximumValue)));
    }

    @Override
    @Nonnull
    protected FDBDirectory createDirectory(Subspace subspace, FDBRecordContext context, Map<String, String> indexOptions) {
        this.injectedFailures = new InjectedFailureRepository();
        MockedFDBDirectory directory = new MockedFDBDirectory(subspace, context, indexOptions);
        directory.setInjectedFailures(this.injectedFailures);
        return directory;
    }

    private void addFailure(InjectedFailureRepository.Methods method, Exception exception, int count) {
        this.injectedFailures.addFailure(method, exception, count);
    }

    private void removeFailure(InjectedFailureRepository.Methods method) {
        this.injectedFailures.removeFailure(method);
    }
}

