/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContextConfig;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBTransactionPriority;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.test.FDBDatabaseExtension;
import com.apple.foundationdb.record.test.TestKeySpacePathManagerExtension;
import com.apple.foundationdb.subspace.Subspace;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;

public abstract class FDBDirectoryBaseTest {
    @RegisterExtension
    final FDBDatabaseExtension dbExtension = new FDBDatabaseExtension();
    @RegisterExtension
    final TestKeySpacePathManagerExtension pathManager = new TestKeySpacePathManagerExtension(this.dbExtension);
    protected FDBDatabase fdb;
    protected KeySpacePath path;
    protected Subspace subspace;
    protected FDBDirectory directory;
    protected Random random = new Random();
    protected FDBRecordContext context;
    protected FDBStoreTimer timer = new FDBStoreTimer();

    @BeforeEach
    public void setUp() {
        this.fdb = this.dbExtension.getDatabase();
        this.path = this.pathManager.createPath(new String[]{"rawData"});
        this.context = this.fdb.openContext(this.getContextConfig());
        this.subspace = (Subspace)this.fdb.run(arg_0 -> ((KeySpacePath)this.path).toSubspace(arg_0));
        this.directory = this.createDirectory(this.subspace, this.context, null);
    }

    @Nonnull
    protected FDBDirectory createDirectory(Subspace subspace, FDBRecordContext context, Map<String, String> indexOptions) {
        return new FDBDirectory(subspace, context, indexOptions);
    }

    @AfterEach
    public void tearDown() {
        this.context.close();
    }

    private FDBRecordContextConfig getContextConfig() {
        return FDBRecordContextConfig.newBuilder().setTimer(this.timer).setPriority(FDBTransactionPriority.DEFAULT).setRecordContextProperties(RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_INDEX_COMPRESSION_ENABLED, (Object)true).build()).build();
    }

    protected int randomInt(int minimum) {
        return Math.abs(this.random.nextInt(10240)) + minimum;
    }
}

