/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.codec.FDBThreadFilter;
import com.apple.foundationdb.record.lucene.codec.TestFDBDirectory;
import com.carrotsearch.randomizedtesting.annotations.Seed;
import com.carrotsearch.randomizedtesting.annotations.Seeds;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakFilters;
import java.io.IOException;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.BaseIndexFileFormatTestCaseUtils;
import org.apache.lucene.index.BasePointsFormatTestCase;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleLimitSysouts;
import org.junit.Ignore;

@ThreadLeakFilters(defaultFilters=true, filters={FDBThreadFilter.class})
@TestRuleLimitSysouts.Limit(bytes=50000L)
public class LuceneOptimizedPointsFormatTest
extends BasePointsFormatTestCase {
    protected Codec getCodec() {
        return BaseIndexFileFormatTestCaseUtils.getCodec();
    }

    public void setUp() throws Exception {
        super.setUp();
        BaseIndexFileFormatTestCaseUtils.resetStaticConfigs();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        BaseIndexFileFormatTestCaseUtils.resetStaticConfigs();
    }

    public void testMultiClose() throws IOException {
        BaseIndexFileFormatTestCaseUtils.testMultiClose((BaseIndexFileFormatTestCase)this);
    }

    @Ignore(value="Always makes an FSDirectory, and copying the implementation would require copying a lot of private methods")
    public void testWithExceptions() throws Exception {
        super.testWithExceptions();
    }

    public void testAddIndexes() throws IOException {
        TestFDBDirectory.allowAddIndexes();
        super.testAddIndexes();
    }

    public void testAllEqual() throws Exception {
        TestFDBDirectory.allowAddIndexes();
        super.testAllEqual();
    }

    public void testOneDimTwoValues() throws Exception {
        TestFDBDirectory.allowAddIndexes();
        super.testOneDimTwoValues();
    }

    public void testOneDimEqual() throws Exception {
        TestFDBDirectory.allowAddIndexes();
        super.testOneDimEqual();
    }

    @Seeds(value={@Seed, @Seed(value="FA63D2AE2DE7C6B0")})
    public void testMultiValued() throws Exception {
        TestFDBDirectory.allowAddIndexes();
        super.testMultiValued();
    }

    public void testRandomBinaryTiny() throws Exception {
        TestFDBDirectory.allowAddIndexes();
        super.testRandomBinaryTiny();
    }

    public void testRandomBinaryMedium() throws Exception {
        TestFDBDirectory.allowAddIndexes();
        super.testRandomBinaryMedium();
    }

    @Ignore
    @LuceneTestCase.Nightly
    public void testRandomBinaryBig() throws Exception {
        TestFDBDirectory.allowAddIndexes();
        super.testRandomBinaryBig();
    }

    @Ignore
    @LuceneTestCase.Nightly
    public void testRamBytesUsed() throws IOException {
        super.testRamBytesUsed();
    }
}

