/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.lucene.codec.LazyCloseableTest;
import com.apple.foundationdb.record.lucene.codec.LazyOpener;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
class LazyOpenerTest {
    LazyOpenerTest() {
    }

    @Test
    void testOpensLazilyExactlyOnce() throws IOException {
        AtomicInteger supplier = new AtomicInteger(0);
        LazyOpener opener = LazyOpener.supply(supplier::incrementAndGet);
        Assertions.assertEquals((int)0, (int)supplier.get());
        Assertions.assertEquals((int)1, (Integer)((Integer)opener.get()));
        Assertions.assertEquals((int)1, (Integer)((Integer)opener.get()));
        Assertions.assertEquals((int)1, (Integer)((Integer)opener.getUnchecked()));
        Assertions.assertEquals((int)1, (int)supplier.get());
    }

    @Test
    void testOpensLazilyExactlyOnceThreaded() throws InterruptedException {
        AtomicInteger starts = new AtomicInteger(0);
        AtomicInteger ends = new AtomicInteger(0);
        int concurrency = 100;
        LazyOpener opener = LazyOpener.supply(() -> {
            starts.incrementAndGet();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)"Timed out waiting for latch");
            }
            return ends.incrementAndGet();
        });
        ConcurrentHashMap threads = new ConcurrentHashMap();
        Deque<Integer> allValues = LazyCloseableTest.collectFromMultipleThreads(100, () -> {
            int value = (Integer)opener.getUnchecked();
            threads.compute(Thread.currentThread(), (k, v) -> v == null ? 1 : v + 1);
            return value;
        });
        MatcherAssert.assertThat(allValues, (Matcher)Matchers.everyItem((Matcher)Matchers.is((Object)1)));
        Assertions.assertEquals((int)1, (int)starts.get());
        Assertions.assertEquals((int)1, (int)ends.get());
        MatcherAssert.assertThat((Object)threads.keySet(), (Matcher)Matchers.hasSize((int)100));
        MatcherAssert.assertThat(threads.values(), (Matcher)Matchers.everyItem((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    void testForkJoinPoolDeadlock() throws ExecutionException, InterruptedException, TimeoutException {
        ForkJoinPool forkJoinPool = new ForkJoinPool(2);
        AtomicInteger openCounter = new AtomicInteger(0);
        LazyOpener initial = LazyOpener.supply(() -> {
            int openCount = openCounter.incrementAndGet();
            try {
                return (String)((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> {}, forkJoinPool).thenCompose(ignored -> MoreAsyncUtil.delayedFuture((long)2L, (TimeUnit)TimeUnit.SECONDS))).thenApplyAsync(v -> "Opened " + openCount, (Executor)forkJoinPool)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        List result = IntStream.range(0, 50).parallel().mapToObj(i -> CompletableFuture.supplyAsync(() -> (String)initial.getUnchecked() + " " + i, forkJoinPool)).collect(Collectors.toList());
        List strings = (List)AsyncUtil.getAll(result).get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)strings, (Matcher)Matchers.containsInAnyOrder((Collection)IntStream.range(0, 50).mapToObj(i -> Matchers.is((Object)("Opened 1 " + i))).collect(Collectors.toList())));
    }

    @Test
    void testThrowsIoException() {
        IOException thrownException = new IOException("test foo");
        LazyOpener opener = LazyOpener.supply(() -> {
            throw thrownException;
        });
        IOException resultingException = (IOException)Assertions.assertThrows(IOException.class, () -> ((LazyOpener)opener).get());
        Assertions.assertSame((Object)thrownException, (Object)resultingException);
    }

    @Test
    void testThrowsUncheckedIoException() {
        IOException thrownException = new IOException("test foo");
        LazyOpener opener = LazyOpener.supply(() -> {
            throw thrownException;
        });
        UncheckedIOException resultingException = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> ((LazyOpener)opener).getUnchecked());
        Assertions.assertSame((Object)thrownException, (Object)resultingException.getCause());
    }
}

