/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

class RandomTextGenerator {
    private final Random random;
    private final List<String> words;

    private RandomTextGenerator(Random random, List<String> words) {
        this.random = random;
        this.words = words;
    }

    public RandomTextGenerator(Random random) {
        this.random = random;
        this.words = RandomTextGenerator.generateRandomWords(random, 10000);
    }

    public RandomTextGenerator withNewRandom(Random random) {
        return new RandomTextGenerator(random, this.words);
    }

    public String generateRandomText(String universalWord) {
        int length;
        while ((length = (int)(this.random.nextGaussian() * 500.0 + 1000.0)) <= 0 || length > 10000) {
        }
        StringBuilder builder = new StringBuilder(this.words.get(this.random.nextInt(this.words.size())));
        int universalWordIndex = this.random.nextInt(length);
        for (int i = 0; i < length; ++i) {
            String baseWord;
            String string = baseWord = i == universalWordIndex ? universalWord : this.words.get(this.random.nextInt(this.words.size()));
            if (this.random.nextInt(100) == 0) {
                builder.append(". ").append(Character.toUpperCase(baseWord.charAt(0))).append(baseWord, 1, baseWord.length());
                continue;
            }
            if (this.random.nextInt(30) == 0) {
                builder.append(", ").append(baseWord);
                continue;
            }
            builder.append(" ").append(baseWord);
        }
        return builder.toString();
    }

    private static List<String> generateRandomWords(Random random, int numberOfWords) {
        assert (numberOfWords > 0) : "Number of words have to be greater than 0";
        ArrayList<String> words = new ArrayList<String>(numberOfWords);
        for (int i = 0; i < numberOfWords; ++i) {
            int wordLength;
            while ((wordLength = (int)(random.nextGaussian() * 2.0 + 5.0)) <= 0) {
            }
            char[] word = new char[wordLength];
            for (int j = 0; j < word.length; ++j) {
                word[j] = (char)(97 + random.nextInt(26));
            }
            words.add(new String(word));
        }
        return words;
    }
}

