/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.lucene.LuceneIndexTest;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextIndexTestUtils;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.test.BooleanSource;
import com.google.protobuf.Message;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import org.apache.lucene.store.LockObtainFailedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;

class LuceneLockFailureTest
extends FDBRecordStoreTestBase {
    private static final Index SIMPLE_INDEX = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES;
    protected static final Index COMPLEX_PARTITIONED = LuceneIndexTest.complexPartitionedIndex(Map.of("textTokenizerName", "all_suffixes", "partitionFieldName", "timestamp", "partitionHighWatermark", "10"));

    LuceneLockFailureTest() {
    }

    @ParameterizedTest
    @BooleanSource
    void testAddDocument(boolean partitioned) throws IOException {
        try (FDBRecordContext context = this.openContext();){
            this.openStore(partitioned, context);
            this.grabLockExternally(partitioned, context, 2, 0);
            context.commit();
        }
        context = this.openContext();
        try {
            this.openStore(partitioned, context);
            Assertions.assertThrows(FDBExceptions.FDBStoreLockTakenException.class, () -> this.recordStore.saveRecord(this.createDocument(partitioned, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2)));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @BooleanSource
    void testDeleteDocument(boolean partitioned) throws IOException {
        Tuple primaryKey;
        Message doc = this.createDocument(partitioned, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2);
        try (FDBRecordContext context = this.openContext();){
            this.openStore(partitioned, context);
            FDBStoredRecord record = this.recordStore.saveRecord(doc);
            primaryKey = record.getPrimaryKey();
            context.commit();
        }
        context = this.openContext();
        try {
            this.openStore(partitioned, context);
            this.grabLockExternally(partitioned, context, 2, 0);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openStore(partitioned, context);
            Assertions.assertThrows(FDBExceptions.FDBStoreLockTakenException.class, () -> {
                this.recordStore.deleteRecord(primaryKey);
                context.commit();
            });
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @BooleanSource
    void testUpdateDocument(boolean partitioned) throws IOException {
        Message doc = this.createDocument(partitioned, 6666L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 0);
        try (FDBRecordContext context = this.openContext();){
            this.openStore(partitioned, context);
            this.recordStore.saveRecord(doc);
            context.commit();
        }
        context = this.openContext();
        try {
            this.openStore(partitioned, context);
            this.grabLockExternally(partitioned, context, 0, 0);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openStore(partitioned, context);
            Assertions.assertThrows(FDBExceptions.FDBStoreLockTakenException.class, () -> this.recordStore.updateRecord(this.updateDocument(partitioned, doc)));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @BooleanSource
    void testDeleteAll(boolean partitioned) throws IOException {
        try (FDBRecordContext context = this.openContext();){
            this.openStore(partitioned, context);
            Message doc = this.createDocument(partitioned, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2);
            this.recordStore.saveRecord(doc);
            context.commit();
        }
        context = this.openContext();
        try {
            this.openStore(partitioned, context);
            this.grabLockExternally(partitioned, context, 2, 0);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openStore(partitioned, context);
            this.recordStore.deleteAllRecords();
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openStore(partitioned, context);
            this.grabLockExternally(partitioned, context, 2, 0);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    void testDeleteWhere() throws IOException {
        try (FDBRecordContext context = this.openContext();){
            this.openStore(true, context);
            this.recordStore.saveRecord(this.createDocument(true, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1));
            context.commit();
        }
        context = this.openContext();
        try {
            this.openStore(true, context);
            this.grabLockExternally(true, context, 1, 0);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openStore(true, context);
            this.recordStore.deleteRecordsWhere("ComplexDocument", Query.field((String)"group").equalsValue((Object)1));
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openStore(true, context);
            this.grabLockExternally(true, context, 1, 0);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @BooleanSource
    void testMerge(boolean partitioned) throws IOException {
        try (FDBRecordContext context = this.openContext();){
            this.openStore(partitioned, context);
            this.recordStore.saveRecord(this.createDocument(partitioned, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
            context.commit();
        }
        context = this.openContext();
        try {
            this.openStore(partitioned, context);
            this.grabLockExternally(partitioned, context, 2, 0);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openStore(partitioned, context);
            Assertions.assertThrows(FDBExceptions.FDBStoreLockTakenException.class, () -> this.mergeSegments(partitioned));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    void testRebalance() throws IOException {
        try (FDBRecordContext context = this.openContext();){
            this.openStore(true, context);
            for (int i = 0; i < 50; ++i) {
                this.recordStore.saveRecord(this.createDocument(true, 6666L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 0));
            }
            context.commit();
        }
        context = this.openContext();
        try {
            this.openStore(true, context);
            this.grabLockExternally(true, context, 0, 1);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openStore(true, context);
            Exception ex = (Exception)Assertions.assertThrows(RecordCoreException.class, () -> LuceneIndexTestUtils.rebalancePartitions(this.recordStore, COMPLEX_PARTITIONED));
            Assertions.assertTrue((boolean)(ex.getCause() instanceof LockObtainFailedException));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    void testLockTwice() throws IOException {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", SIMPLE_INDEX);
            this.grabLockExternally(SIMPLE_INDEX, context);
            context.commit();
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", SIMPLE_INDEX);
            Assertions.assertThrows(LockObtainFailedException.class, () -> this.grabLockExternally(SIMPLE_INDEX, context));
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    private void openStore(boolean partitioned, FDBRecordContext context) {
        if (partitioned) {
            this.openStoreWithPrefixes(context, "ComplexDocument", COMPLEX_PARTITIONED);
        } else {
            this.rebuildIndexMetaData(context, "SimpleDocument", SIMPLE_INDEX);
        }
    }

    private Message createDocument(boolean partitioned, long docId, String text, int group) {
        if (partitioned) {
            return LuceneIndexTestUtils.createComplexDocument(docId, text, group, Instant.now().toEpochMilli());
        }
        return LuceneIndexTestUtils.createSimpleDocument(docId, text, group);
    }

    private Message updateDocument(boolean partitioned, Message doc) {
        if (partitioned) {
            return ((TestRecordsTextProto.ComplexDocument)doc).toBuilder().setText("Blah").build();
        }
        return ((TestRecordsTextProto.SimpleDocument)doc).toBuilder().setText("Blah").build();
    }

    private void grabLockExternally(boolean partitioned, FDBRecordContext context, int group, int partition) throws IOException {
        if (partitioned) {
            this.grabLockExternallyForPartition(COMPLEX_PARTITIONED, context, group, partition);
        } else {
            this.grabLockExternally(SIMPLE_INDEX, context);
        }
    }

    private void grabLockExternally(Index index, FDBRecordContext context) throws IOException {
        FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index), context, index.getOptions());
        directory.obtainLock("write.lock");
    }

    private void grabLockExternallyForPartition(Index index, FDBRecordContext context, int group, int partition) throws IOException {
        Subspace partitionSubspace = this.recordStore.indexSubspace(index).subspace(Tuple.from((Object[])new Object[]{group, 1}).add((long)partition));
        FDBDirectory directory = new FDBDirectory(partitionSubspace, context, index.getOptions());
        directory.obtainLock("write.lock");
    }

    private void mergeSegments(boolean partitioned) {
        if (partitioned) {
            LuceneIndexTestUtils.mergeSegments(this.recordStore, COMPLEX_PARTITIONED);
        } else {
            LuceneIndexTestUtils.mergeSegments(this.recordStore, SIMPLE_INDEX);
        }
    }

    private void rebuildIndexMetaData(FDBRecordContext context, String document, Index index) {
        Pair<FDBRecordStore, QueryPlanner> pair = LuceneIndexTestUtils.rebuildIndexMetaData(context, this.path, document, index, this.useCascadesPlanner);
        this.recordStore = (FDBRecordStore)pair.getLeft();
        this.planner = (QueryPlanner)pair.getRight();
    }

    private void openStoreWithPrefixes(FDBRecordContext context, String document, Index index) {
        this.recordStore = LuceneIndexTestUtils.openRecordStore(context, this.path, metaDataBuilder -> {
            TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
            metaDataBuilder.removeIndex("SimpleDocument$text");
            metaDataBuilder.addIndex(document, index);
        });
    }
}

