/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.LoggableTimeoutException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerCombinationProvider;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerRegistryImpl;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.lucene.LuceneConcurrency;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneIndexTestDataModel;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LuceneIndexTestValidator;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.RandomTextGenerator;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryLockFactory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryWrapper;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreConcurrentTestBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintenanceFilter;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.util.LoggableKeysAndValues;
import com.apple.test.RandomizedTestUtils;
import com.apple.test.SuperSlow;
import com.apple.test.TestConfigurationUtils;
import com.google.protobuf.Message;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.store.Lock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="RequiresFDB")
public class LuceneIndexMaintenanceTest
extends FDBRecordStoreConcurrentTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneIndexMaintenanceTest.class);

    @BeforeEach
    void setUp() {
        this.fdb.setAsyncToSyncTimeout(waitEvent -> {
            if (waitEvent == FDBStoreTimer.Waits.WAIT_ONLINE_MERGE_INDEX) {
                return Duration.ofSeconds(60L);
            }
            return Duration.ofSeconds(7L);
        });
    }

    static Stream<Arguments> configurationArguments() {
        return Stream.concat(Stream.of(Arguments.of((Object[])new Object[]{true, false, false, 13, 3, 20, 9237590782644L}), Arguments.of((Object[])new Object[]{true, true, true, 10, 2, 23, -644766138635622644L}), Arguments.of((Object[])new Object[]{false, true, true, 11, 4, 20, -1089113174774589435L}), Arguments.of((Object[])new Object[]{false, false, false, 5, 1, 18, 6223372946177329440L}), Arguments.of((Object[])new Object[]{true, false, false, 14, 6, 0, 2451719304283565963L})), RandomizedTestUtils.randomArguments(random -> Arguments.of((Object[])new Object[]{random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextInt(20) + 2, random.nextInt(10) + 1, 0, random.nextLong()})));
    }

    @ParameterizedTest(name="randomizedRepartitionTest({argumentsWithNames})")
    @MethodSource(value={"configurationArguments"})
    void randomizedRepartitionTest(boolean isGrouped, boolean isSynthetic, boolean primaryKeySegmentIndexEnabled, int partitionHighWatermark, int repartitionCount, int minDocumentCount, long seed) throws IOException {
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(seed, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setIsGrouped(isGrouped).setIsSynthetic(isSynthetic).setPrimaryKeySegmentIndexEnabled(primaryKeySegmentIndexEnabled).setPartitionHighWatermark(partitionHighWatermark).build();
        LOGGER.info(KeyValueLogMessage.of((String)"Running randomizedRepartitionTest", (Object[])new Object[]{"dataModel", dataModel, "repartitionCount", repartitionCount, "seed", seed}));
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)repartitionCount).addProp(LuceneRecordContextProperties.LUCENE_MAX_DOCUMENTS_TO_MOVE_DURING_REPARTITIONING, (Object)(dataModel.nextInt(1000) + repartitionCount)).addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)((double)dataModel.nextInt(10).intValue() + 2.0)).build();
        dataModel.saveManyRecords(minDocumentCount, () -> this.openContext(contextProps), dataModel.nextInt(15) + 1);
        this.explicitMergeIndex(dataModel.index, contextProps, dataModel.schemaSetup);
        dataModel.validate(() -> this.openContext(contextProps));
        if (isGrouped) {
            this.validateDeleteWhere(isSynthetic, dataModel.groupingKeyToPrimaryKeyToPartitionKey, contextProps, dataModel.schemaSetup, dataModel.index);
        }
    }

    public static Stream<Arguments> savingInReverseDoesNotRequireRepartitioning() {
        return Stream.concat(Stream.of(true, false).flatMap(isGrouped -> Stream.of(true, false).map(isSynthetic -> Arguments.of((Object[])new Object[]{isGrouped, isSynthetic, 8, 1234098}))), RandomizedTestUtils.randomArguments(random -> Arguments.of((Object[])new Object[]{random.nextBoolean(), random.nextBoolean(), random.nextInt(30) + 2, random.nextLong()})));
    }

    @ParameterizedTest
    @MethodSource
    void savingInReverseDoesNotRequireRepartitioning(boolean isGrouped, boolean isSynthetic, int partitionHighWatermark, long seed) throws IOException {
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(seed, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setIsGrouped(isGrouped).setIsSynthetic(isSynthetic).setPrimaryKeySegmentIndexEnabled(true).setPartitionHighWatermark(partitionHighWatermark).build();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)((double)dataModel.nextInt(10).intValue() + 2.0)).build();
        try (FDBRecordContext context = this.openContext(contextProps);){
            dataModel.saveRecordsToAllGroups(partitionHighWatermark, context);
            context.commit();
        }
        dataModel.validate(() -> this.openContext(contextProps));
        dataModel.getPartitionCounts(() -> this.openContext(contextProps)).forEach((groupingKey, partitionCounts) -> MatcherAssert.assertThat((Object)partitionCounts, (Matcher)Matchers.contains((Object[])new Integer[]{partitionHighWatermark})));
        dataModel.setReverseSaveOrder(true);
        context = this.openContext(contextProps);
        try {
            dataModel.saveRecordsToAllGroups(partitionHighWatermark - 1, context);
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        dataModel.validate(() -> this.openContext(contextProps));
        dataModel.getPartitionCounts(() -> this.openContext(contextProps)).forEach((groupingKey, partitionCounts) -> MatcherAssert.assertThat((Object)partitionCounts, (Matcher)Matchers.contains((Object[])new Integer[]{partitionHighWatermark - 1, partitionHighWatermark})));
        if (isGrouped) {
            this.validateDeleteWhere(isSynthetic, dataModel.groupingKeyToPrimaryKeyToPartitionKey, contextProps, dataModel.schemaSetup, dataModel.index);
        }
    }

    static Stream<Arguments> manyDocumentsArgumentsSlow() {
        return Stream.concat(Stream.of(Arguments.of((Object[])new Object[]{true, true, true, 80, 2, 200, 234809}), Arguments.of((Object[])new Object[]{false, true, false, 50, 8, 212, 3125111852333110588L})), RandomizedTestUtils.randomArguments(random -> Arguments.of((Object[])new Object[]{random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextInt(300) + 50, random.nextInt(10) + 1, random.nextInt(200) + 100, random.nextLong()})));
    }

    @ParameterizedTest
    @MethodSource(value={"manyDocumentsArgumentsSlow"})
    @SuperSlow
    void manyDocumentSlow(boolean isGrouped, boolean isSynthetic, boolean primaryKeySegmentIndexEnabled, int partitionHighWatermark, int repartitionCount, int loopCount, long seed) throws IOException {
        this.manyDocument(isGrouped, isSynthetic, primaryKeySegmentIndexEnabled, partitionHighWatermark, repartitionCount, loopCount, 10, seed);
    }

    static Stream<Arguments> manyDocumentsArguments() {
        return Stream.concat(Stream.concat(Stream.of(Arguments.of((Object[])new Object[]{true, true, true, 20, 4, 50, 3, -644766138635622644L})), TestConfigurationUtils.onlyNightly(Stream.of(Arguments.of((Object[])new Object[]{true, false, false, 21, 3, 55, 3, 9237590782644L}), Arguments.of((Object[])new Object[]{false, true, true, 18, 3, 46, 3, -1089113174774589435L}), Arguments.of((Object[])new Object[]{false, false, false, 24, 6, 59, 3, 6223372946177329440L}), Arguments.of((Object[])new Object[]{true, false, false, 27, 9, 48, 3, 2451719304283565963L})))), RandomizedTestUtils.randomArguments(random -> Arguments.of((Object[])new Object[]{random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextInt(150) + 2, random.nextInt(10) + 1, random.nextInt(100) + 50, 3, random.nextLong()})));
    }

    @ParameterizedTest
    @MethodSource(value={"manyDocumentsArguments"})
    void manyDocument(boolean isGrouped, boolean isSynthetic, boolean primaryKeySegmentIndexEnabled, int partitionHighWatermark, int repartitionCount, int loopCount, int maxTransactionsPerLoop, long seed) throws IOException {
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(seed, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setIsGrouped(isGrouped).setIsSynthetic(isSynthetic).setPrimaryKeySegmentIndexEnabled(primaryKeySegmentIndexEnabled).setPartitionHighWatermark(partitionHighWatermark).build();
        LOGGER.info(KeyValueLogMessage.of((String)"Running manyDocument", (Object[])new Object[]{"dataModel", dataModel, "repartitionCount", repartitionCount, "seed", seed, "loopCount", loopCount}));
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)repartitionCount).addProp(LuceneRecordContextProperties.LUCENE_MAX_DOCUMENTS_TO_MOVE_DURING_REPARTITIONING, (Object)(dataModel.nextInt(1000) + repartitionCount)).addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)((double)dataModel.nextInt(10).intValue() + 2.0)).build();
        for (int i = 0; i < loopCount; ++i) {
            LOGGER.info(KeyValueLogMessage.of((String)"ManyDocument loop", (Object[])new Object[]{"iteration", i, "groupCount", dataModel.groupingKeyToPrimaryKeyToPartitionKey.size(), "docCount", dataModel.groupingKeyToPrimaryKeyToPartitionKey.values().stream().mapToInt(Map::size).sum(), "docMinPerGroup", dataModel.groupingKeyToPrimaryKeyToPartitionKey.values().stream().mapToInt(Map::size).min(), "docMaxPerGroup", dataModel.groupingKeyToPrimaryKeyToPartitionKey.values().stream().mapToInt(Map::size).max()}));
            dataModel.saveManyRecords(1, () -> this.openContext(contextProps), dataModel.nextInt(maxTransactionsPerLoop - 1) + 1);
            this.explicitMergeIndex(dataModel.index, contextProps, dataModel.schemaSetup);
        }
        dataModel.validate(() -> this.openContext(contextProps));
        if (isGrouped) {
            this.validateDeleteWhere(isSynthetic, dataModel.groupingKeyToPrimaryKeyToPartitionKey, contextProps, dataModel.schemaSetup, dataModel.index);
        }
    }

    static Stream<Arguments> flakyMergeArguments() {
        return Stream.concat(TestConfigurationUtils.onlyNightly(Stream.of(Arguments.of((Object[])new Object[]{true, false, false, 50, 9237590782644L, true}), Arguments.of((Object[])new Object[]{false, true, true, 33, -1089113174774589435L, true}), Arguments.of((Object[])new Object[]{false, false, false, 35, 6223372946177329440L, true}))), RandomizedTestUtils.randomArguments(random -> Arguments.of((Object[])new Object[]{random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextInt(40) + 2, random.nextLong(), false})));
    }

    @Test
    @Tag(value="Slow")
    void flakyMergeQuick() throws IOException {
        this.flakyMerge(true, true, true, 31, -644766138635622644L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="flakyMerge({argumentsWithNames})")
    @MethodSource(value={"flakyMergeArguments"})
    @SuperSlow
    void flakyMerge(boolean isGrouped, boolean isSynthetic, boolean primaryKeySegmentIndexEnabled, int minDocumentCount, long seed, boolean requireFailure) throws IOException {
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(seed, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setIsGrouped(isGrouped).setIsSynthetic(isSynthetic).setPrimaryKeySegmentIndexEnabled(primaryKeySegmentIndexEnabled).setPartitionHighWatermark(Integer.MAX_VALUE).build();
        LOGGER.info(KeyValueLogMessage.of((String)"Running flakyMerge test", (Object[])new Object[]{"dataModel", dataModel, "seed", seed}));
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)2.0).addProp(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_TIME_QUOTA, (Object)1).addProp(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_SIZE_QUOTA, (Object)1).addProp(LuceneRecordContextProperties.LUCENE_FILE_LOCK_TIME_WINDOW_MILLISECONDS, (Object)((int)TimeUnit.SECONDS.toMillis(10L) + 1)).build();
        int transactionCount = dataModel.nextInt(15) + 10;
        dataModel.saveManyRecords(minDocumentCount, () -> this.openContext(contextProps), transactionCount);
        Function oldAsyncToSyncTimeout = this.fdb.getAsyncToSyncTimeout();
        AtomicInteger waitCounts = new AtomicInteger();
        try {
            Function<StoreTimer.Wait, Duration> asyncToSyncTimeout = wait -> {
                if (wait.getClass().equals(LuceneEvents.Waits.class) && wait != LuceneEvents.Waits.WAIT_LUCENE_FILE_LOCK_CLEAR && wait != LuceneEvents.Waits.WAIT_LUCENE_FILE_LOCK_SET && waitCounts.getAndDecrement() == 0) {
                    return Duration.ofNanos(1L);
                }
                return oldAsyncToSyncTimeout == null ? Duration.ofDays(1L) : (Duration)oldAsyncToSyncTimeout.apply(wait);
            };
            for (int i = 0; i < 100; ++i) {
                this.fdb.setAsyncToSyncTimeout(asyncToSyncTimeout);
                waitCounts.set(i);
                boolean success = false;
                try {
                    LOGGER.info(KeyValueLogMessage.of((String)"Merge started", (Object[])new Object[]{"iteration", i}));
                    this.explicitMergeIndex(dataModel.index, contextProps, dataModel.schemaSetup);
                    LOGGER.info(KeyValueLogMessage.of((String)"Merge completed", (Object[])new Object[]{"iteration", i}));
                    Assertions.assertFalse((requireFailure && i < 15 ? 1 : 0) != 0, (String)(i + " merge should have failed"));
                    success = true;
                }
                catch (RecordCoreException e) {
                    LoggableKeysAndValues<? extends Exception> timeoutException = LuceneIndexMaintenanceTest.findTimeoutException(e);
                    LOGGER.info(KeyValueLogMessage.of((String)"Merge failed", (Object[])new Object[]{"iteration", i, "cause", ((Object)((Object)e)).getClass(), "message", e.getMessage(), "timeout", timeoutException != null}));
                    if (timeoutException == null) {
                        throw e;
                    }
                    Assertions.assertEquals((Object)1L, timeoutException.getLogInfo().get(LogMessageKeys.TIME_LIMIT.toString()), (String)(i + " " + e.getMessage()));
                    Assertions.assertEquals((Object)((Object)TimeUnit.NANOSECONDS), timeoutException.getLogInfo().get(LogMessageKeys.TIME_UNIT.toString()), (String)(i + " " + e.getMessage()));
                }
                this.fdb.setAsyncToSyncTimeout(oldAsyncToSyncTimeout);
                this.dbExtension.checkForOpenContexts();
                LOGGER.debug(KeyValueLogMessage.of((String)"Validating", (Object[])new Object[]{"iteration", i}));
                new LuceneIndexTestValidator(() -> this.openContext(contextProps), context -> Objects.requireNonNull(dataModel.schemaSetup.apply((FDBRecordContext)context))).validate(dataModel.index, dataModel.groupingKeyToPrimaryKeyToPartitionKey, isSynthetic ? "child_str_value:forth" : "text_value:about", !success);
                LOGGER.debug(KeyValueLogMessage.of((String)"Done Validating", (Object[])new Object[]{"iteration", i}));
                this.dbExtension.checkForOpenContexts();
            }
        }
        finally {
            this.fdb.setAsyncToSyncTimeout(oldAsyncToSyncTimeout);
            if (LOGGER.isDebugEnabled()) {
                dataModel.groupingKeyToPrimaryKeyToPartitionKey.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> LOGGER.debug(String.valueOf(entry.getKey()) + ": " + String.valueOf(((ConcurrentMap)entry.getValue()).keySet())));
            }
        }
    }

    @Test
    void lockCommitThenValidateTest() throws IOException {
        FDBRecordStore recordStore;
        Map<String, String> options = Map.of("partitionFieldName", "timestamp", "partitionHighWatermark", String.valueOf(8));
        Index index = LuceneIndexMaintenanceTest.complexPartitionedIndex(options);
        KeySpacePath path = this.pathManager.createPath(new String[]{"recordStore"});
        Function<FDBRecordContext, FDBRecordStore> schemaSetup = context -> (FDBRecordStore)LuceneIndexTestUtils.rebuildIndexMetaData(context, path, TestRecordsTextProto.ComplexDocument.getDescriptor().getName(), index, this.useCascadesPlanner).getLeft();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)8).build();
        long timestamp = System.currentTimeMillis();
        HashMap<Tuple, Map<Tuple, Tuple>> insertedDocs = new HashMap<Tuple, Map<Tuple, Tuple>>();
        this.createComplexRecords(1, insertedDocs, contextProps, schemaSetup);
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            recordStore = Objects.requireNonNull(schemaSetup.apply(context2));
            Subspace subspace = recordStore.indexSubspace(index).subspace(Tuple.from((Object[])new Object[]{1, 1, 0, 7}));
            byte[] fileLockKey = subspace.pack(Tuple.from((Object[])new Object[]{"write.lock"}));
            FDBDirectoryLockFactory lockFactory = new FDBDirectoryLockFactory(null, 10000);
            Lock testLock = lockFactory.obtainLock((AgilityContext)new AgilityContext.NonAgile(context2), fileLockKey, "write.lock");
            testLock.ensureValid();
            this.commit(context2);
        }
        context2 = this.openContext(contextProps);
        try {
            recordStore = Objects.requireNonNull(schemaSetup.apply(context2));
            try (RecordCursor cursor = recordStore.scanIndex(index, (IndexScanBounds)LuceneIndexTestValidator.groupedSortedTextSearch(recordStore, index, "text:word", null, (Object)1), null, ScanProperties.FORWARD_SCAN);){
                List primaryKeys = ((List)LuceneConcurrency.asyncToSync((StoreTimer.Wait)FDBStoreTimer.Waits.WAIT_ADVANCE_CURSOR, (CompletableFuture)cursor.asList(), (FDBRecordContext)context2)).stream().map(IndexEntry::getPrimaryKey).collect(Collectors.toList());
                Assertions.assertEquals((int)1, (int)primaryKeys.size());
                Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{1, 1000L}), primaryKeys.get(0));
            }
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
        context2 = this.openContext(contextProps);
        try {
            recordStore = Objects.requireNonNull(schemaSetup.apply(context2));
            TestRecordsTextProto.ComplexDocument cd = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup(1L).setDocId(2000L).setIsSeen(true).setText("A word about what I want to say").setTimestamp(timestamp + 2000L).setHeader(TestRecordsTextProto.ComplexDocument.Header.newBuilder().setHeaderId(1999L)).build();
            Assertions.assertThrows(RecordCoreException.class, () -> recordStore.saveRecord((Message)cd), (String)"Lock failed: already locked by another entity");
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
        new LuceneIndexTestValidator(() -> this.openContext(contextProps), context -> Objects.requireNonNull((FDBRecordStore)schemaSetup.apply((FDBRecordContext)context))).validate(index, insertedDocs, "text:about", false);
    }

    @Test
    void chaosMergeAndUpdateTest() throws InterruptedException, IOException {
        Map<String, String> options = Map.of("partitionFieldName", "timestamp", "partitionHighWatermark", String.valueOf(100));
        Index index = LuceneIndexMaintenanceTest.complexPartitionedIndex(options);
        KeySpacePath path = this.pathManager.createPath(new String[]{"recordStore"});
        Function<FDBRecordContext, FDBRecordStore> schemaSetup = context -> (FDBRecordStore)LuceneIndexTestUtils.rebuildIndexMetaData(context, path, TestRecordsTextProto.ComplexDocument.getDescriptor().getName(), index, this.useCascadesPlanner).getLeft();
        Assertions.assertNotNull((Object)index);
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)8).build();
        long timestamp = System.currentTimeMillis();
        HashMap insertedDocs = new HashMap();
        ArrayBlockingQueue mergeQueue = new ArrayBlockingQueue(1);
        AtomicInteger successfulMerges = new AtomicInteger();
        AtomicInteger merges = new AtomicInteger();
        AtomicInteger docCount = new AtomicInteger();
        AtomicInteger conflicts = new AtomicInteger();
        AtomicInteger fileLockFailures = new AtomicInteger();
        AtomicReference failedInsert = new AtomicReference();
        AtomicReference failedMerge = new AtomicReference();
        Thread inserter = new Thread(() -> {
            try {
                int i = 0;
                while (docCount.get() < 200) {
                    FDBRecordContext context = this.openContext(contextProps);
                    FDBRecordStore recordStore = Objects.requireNonNull((FDBRecordStore)schemaSetup.apply(context));
                    recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
                    TestRecordsTextProto.ComplexDocument cd = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup(1L).setDocId((long)i + 1000L).setIsSeen(true).setText("A word about what I want to say").setTimestamp(timestamp + (long)i).setHeader(TestRecordsTextProto.ComplexDocument.Header.newBuilder().setHeaderId(1000L - (long)i)).build();
                    try {
                        Tuple primaryKey = recordStore.saveRecord((Message)cd).getPrimaryKey();
                        try (RecordCursor cursor = recordStore.scanIndex(index, (IndexScanBounds)LuceneIndexTestValidator.groupedSortedTextSearch(recordStore, index, "text:word", null, (Object)1), null, ScanProperties.FORWARD_SCAN);){
                            List matches = (List)LuceneConcurrency.asyncToSync((StoreTimer.Wait)FDBStoreTimer.Waits.WAIT_ADVANCE_CURSOR, (CompletableFuture)cursor.asList(), (FDBRecordContext)context);
                            Assertions.assertFalse((boolean)matches.isEmpty());
                        }
                        this.commit(context);
                        insertedDocs.computeIfAbsent(Tuple.from((Object[])new Object[]{1}), k -> new HashMap()).put(primaryKey, Tuple.from((Object[])new Object[]{timestamp + (long)(++i)}));
                        docCount.incrementAndGet();
                        mergeQueue.offer(true);
                    }
                    catch (Exception e) {
                        block34: {
                            block35: {
                                if (Thread.currentThread().isInterrupted()) {
                                    if (context != null) {
                                        context.close();
                                    }
                                    try {
                                        mergeQueue.put(false);
                                        return;
                                    }
                                    catch (InterruptedException e2) {
                                        Thread.currentThread().interrupt();
                                    }
                                    return;
                                }
                                if (e instanceof FDBExceptions.FDBStoreTransactionConflictException) {
                                    conflicts.incrementAndGet();
                                    break block34;
                                }
                                if (e instanceof FDBExceptions.FDBStoreLockTakenException) {
                                    fileLockFailures.incrementAndGet();
                                    break block34;
                                }
                                LOGGER.debug("Failing: couldn't commit for key {}", (Object)(1000L + (long)i), (Object)e);
                                failedInsert.set(e);
                                if (context == null) break block35;
                                context.close();
                            }
                            try {
                                mergeQueue.put(false);
                                return;
                            }
                            catch (InterruptedException e3) {
                                Thread.currentThread().interrupt();
                            }
                            return;
                        }
                        try {
                            LOGGER.debug("Ignoring: couldn't commit for key {} due to {}", (Object)(1000L + (long)i), (Object)e.getClass().getSimpleName());
                            continue;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            finally {
                                if (context == null) continue;
                                context.close();
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                try {
                    mergeQueue.put(false);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        Thread merger = new Thread(() -> {
            int i = 0;
            try {
                while (((Boolean)mergeQueue.take()).booleanValue()) {
                    ++i;
                    try {
                        merges.incrementAndGet();
                        this.explicitMergeIndex(index, contextProps, schemaSetup);
                        successfulMerges.incrementAndGet();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Merging: failed {}", (Object)i);
                        failedMerge.compareAndSet(null, e);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        inserter.start();
        merger.start();
        inserter.join();
        Assertions.assertNull(failedInsert.get());
        if (insertedDocs.isEmpty()) {
            merger.interrupt();
        }
        MatcherAssert.assertThat(insertedDocs, (Matcher)Matchers.not((Matcher)Matchers.anEmptyMap()));
        merger.join();
        Assertions.assertNull(failedMerge.get());
        MatcherAssert.assertThat((Object)successfulMerges.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
        MatcherAssert.assertThat((Object)conflicts.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
        MatcherAssert.assertThat((Object)fileLockFailures.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
        MatcherAssert.assertThat((Object)docCount.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(200)));
        new LuceneIndexTestValidator(() -> this.openContext(contextProps), context -> Objects.requireNonNull((FDBRecordStore)schemaSetup.apply((FDBRecordContext)context))).validate(index, insertedDocs, "text:about", false);
    }

    @Test
    void multipleConcurrentMergesTest() throws IOException, InterruptedException {
        Map<String, String> options = Map.of("partitionFieldName", "timestamp", "partitionHighWatermark", String.valueOf(100));
        Index index = LuceneIndexMaintenanceTest.complexPartitionedIndex(options);
        KeySpacePath path = this.pathManager.createPath(new String[]{"recordStore"});
        Function<FDBRecordContext, FDBRecordStore> schemaSetup = context -> (FDBRecordStore)LuceneIndexTestUtils.rebuildIndexMetaData(context, path, TestRecordsTextProto.ComplexDocument.getDescriptor().getName(), index, this.useCascadesPlanner).getLeft();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)8).build();
        int countReps = 20;
        int threadCount = 10;
        HashMap<Tuple, Map<Tuple, Tuple>> insertedDocs = new HashMap<Tuple, Map<Tuple, Tuple>>();
        this.createComplexRecords(20, insertedDocs, contextProps, schemaSetup);
        CountDownLatch readyToMerge = new CountDownLatch(1);
        CountDownLatch doneMerging = new CountDownLatch(10);
        for (int i = 0; i < 10; ++i) {
            new Thread(() -> {
                try {
                    readyToMerge.await();
                    this.explicitMergeIndex(index, contextProps, schemaSetup);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    doneMerging.countDown();
                }
            }).start();
        }
        readyToMerge.countDown();
        doneMerging.await();
        new LuceneIndexTestValidator(() -> this.openContext(contextProps), context -> Objects.requireNonNull((FDBRecordStore)schemaSetup.apply((FDBRecordContext)context))).validate(index, insertedDocs, "text:about", false);
    }

    static Stream<Arguments> mergeLosesLockTest() {
        return Stream.concat(Stream.of(Integer.valueOf(65)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0})), RandomizedTestUtils.randomArguments(random -> Arguments.of((Object[])new Object[]{random.nextInt(100) + 1})));
    }

    @ParameterizedTest
    @MethodSource
    void mergeLosesLockTest(int failurePercentage) throws IOException {
        Map<String, String> options = Map.of("partitionFieldName", "timestamp", "partitionHighWatermark", String.valueOf(200));
        Index index = LuceneIndexMaintenanceTest.complexPartitionedIndex(options);
        KeySpacePath path = this.pathManager.createPath(new String[]{"recordStore"});
        Function<FDBRecordContext, FDBRecordStore> schemaSetup = context -> (FDBRecordStore)LuceneIndexTestUtils.rebuildIndexMetaData(context, path, TestRecordsTextProto.ComplexDocument.getDescriptor().getName(), index, this.useCascadesPlanner).getLeft();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)8).addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)2.0).addProp(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_TIME_QUOTA, (Object)1).build();
        int docCount = 100;
        HashMap<Tuple, Map<Tuple, Tuple>> insertedDocs = new HashMap<Tuple, Map<Tuple, Tuple>>();
        this.createComplexRecords(100, insertedDocs, contextProps, schemaSetup);
        for (int l = 0; l < 2; ++l) {
            try (FDBRecordContext context2 = this.openContext(contextProps);){
                FDBRecordStore recordStore = Objects.requireNonNull(schemaSetup.apply(context2));
                Tuple directoryKey = Tuple.from((Object[])new Object[]{1, 1, 0});
                IndexMaintainerState state = new IndexMaintainerState(recordStore, index, IndexMaintenanceFilter.NORMAL);
                Map fieldInfos = LuceneIndexExpressions.getDocumentFieldDerivations((Index)state.index, (RecordMetaData)state.store.getRecordMetaData());
                LuceneAnalyzerCombinationProvider indexAnalyzerSelector = LuceneAnalyzerRegistryImpl.instance().getLuceneAnalyzerCombinationProvider(state.index, LuceneAnalyzerType.FULL_TEXT, fieldInfos);
                InvalidLockTestFDBDirectory fdbDirectory = new InvalidLockTestFDBDirectory(recordStore.indexSubspace(index).subspace(directoryKey), context2, options, failurePercentage);
                FDBDirectoryWrapper fdbDirectoryWrapper = new FDBDirectoryWrapper(state, (FDBDirectory)fdbDirectory, directoryKey, 1, AgilityContext.agile((FDBRecordContext)context2, (long)1L, (long)1L), indexAnalyzerSelector.provideIndexAnalyzer(), new Exception());
                Assertions.assertThrows(IOException.class, () -> fdbDirectoryWrapper.mergeIndex(), (String)"invalid lock");
                this.commit(context2);
                continue;
            }
        }
        new LuceneIndexTestValidator(() -> this.openContext(contextProps), context -> Objects.requireNonNull((FDBRecordStore)schemaSetup.apply((FDBRecordContext)context))).validate(index, insertedDocs, "text:about", false);
    }

    static Stream<Arguments> sampledDelete() {
        return Stream.concat(Stream.of(Arguments.of((Object[])new Object[]{true, true, 230498}), Arguments.of((Object[])new Object[]{false, false, 43790})), RandomizedTestUtils.randomArguments(random -> Arguments.of((Object[])new Object[]{random.nextBoolean(), random.nextBoolean(), random.nextLong()})));
    }

    @ParameterizedTest
    @MethodSource
    void sampledDelete(boolean isSynthetic, boolean isGrouped, long seed) throws IOException {
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(seed, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setIsGrouped(isGrouped).setIsSynthetic(isSynthetic).setPrimaryKeySegmentIndexEnabled(true).setPartitionHighWatermark(10).build();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)2).addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)((double)dataModel.nextInt(10).intValue() + 2.0)).build();
        try (FDBRecordContext context = this.openContext(contextProps);){
            dataModel.saveRecordsToAllGroups(25, context);
            this.commit(context);
        }
        this.explicitMergeIndex(dataModel.index, contextProps, dataModel.schemaSetup);
        dataModel.getPartitionCounts(() -> this.openContext(contextProps)).forEach((groupingKey, partitionCounts) -> MatcherAssert.assertThat((Object)partitionCounts, (Matcher)Matchers.contains((Object[])new Integer[]{10, 6, 9})));
        dataModel.validate(() -> this.openContext(contextProps));
        context = this.openContext(contextProps);
        try {
            FDBRecordStore recordStore = dataModel.createOrOpenRecordStore(context);
            dataModel.sampleRecordsUnderTest().forEach(record -> record.deleteRecord(recordStore).join());
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        dataModel.validate(() -> this.openContext(contextProps));
        dataModel.getPartitionCounts(() -> this.openContext(contextProps)).forEach((groupingKey, partitionCounts) -> MatcherAssert.assertThat((Object)partitionCounts, (Matcher)Matchers.contains((Object[])new Integer[]{5, 3, 4})));
    }

    private static Stream<Arguments> concurrentParameters() {
        return Stream.concat(Stream.of(Boolean.valueOf(false)), TestConfigurationUtils.onlyNightly(IntStream.range(0, 3).boxed().flatMap(i -> Stream.of(true, false)))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"concurrentParameters"})
    void concurrentUpdate(boolean isSynthetic) throws IOException {
        this.concurrentTestWithinTransaction(isSynthetic, (dataModel, recordStore) -> RecordCursor.fromList(dataModel.recordsUnderTest()).mapPipelined(record -> record.updateOtherValue((FDBRecordStore)recordStore), 10).asList().join(), Assertions::assertEquals);
    }

    @ParameterizedTest
    @MethodSource(value={"concurrentParameters"})
    void concurrentDelete(boolean isSynthetic) throws IOException {
        this.concurrentTestWithinTransaction(isSynthetic, (dataModel, recordStore) -> RecordCursor.fromList(dataModel.recordsUnderTest()).mapPipelined(record -> record.deleteRecord((FDBRecordStore)recordStore), 10).asList().join(), (inserted, actual) -> Assertions.assertEquals((int)0, (Integer)actual));
    }

    @ParameterizedTest
    @MethodSource(value={"concurrentParameters"})
    void concurrentInsert(boolean isSynthetic) throws IOException {
        this.concurrentTestWithinTransaction(isSynthetic, (dataModel, recordStore) -> RecordCursor.fromList(dataModel.recordsUnderTest()).mapPipelined(record -> dataModel.saveRecordAsync(true, (FDBRecordStore)recordStore, 1), 10).asList().join(), (inserted, actual) -> Assertions.assertEquals((int)(inserted * 2), (Integer)actual));
    }

    private static Stream<Arguments> concurrentMixParameters() {
        return Stream.of(true, false).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"concurrentMixParameters"})
    void concurrentMix(boolean isSynthetic) throws IOException {
        AtomicInteger step = new AtomicInteger(0);
        this.concurrentTestWithinTransaction(isSynthetic, (dataModel, recordStore) -> RecordCursor.fromList(dataModel.recordsUnderTest()).mapPipelined(record -> {
            switch (step.incrementAndGet() % 3) {
                case 0: {
                    return record.updateOtherValue((FDBRecordStore)recordStore);
                }
                case 1: {
                    return record.deleteRecord((FDBRecordStore)recordStore);
                }
            }
            return dataModel.saveRecordAsync(true, (FDBRecordStore)recordStore, 1).thenAccept(vignore -> {});
        }, 10).asList().join(), Assertions::assertEquals);
    }

    private void concurrentTestWithinTransaction(boolean isSynthetic, BiConsumer<LuceneIndexTestDataModel, FDBRecordStore> applyChangeConcurrently, BiConsumer<Integer, Integer> assertDataModelCount) throws IOException {
        FDBRecordContext context;
        AtomicInteger threadCounter = new AtomicInteger();
        this.dbExtension.getDatabaseFactory().setExecutor((Executor)new ForkJoinPool(3, pool -> {
            ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            thread.setName("ConcurrentUpdatePool-" + threadCounter.getAndIncrement());
            return thread;
        }, null, false));
        long seed = 320947L;
        boolean isGrouped = true;
        boolean primaryKeySegmentIndexEnabled = true;
        int partitionHighWatermark = -1;
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(320947L, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setIsGrouped(true).setIsSynthetic(isSynthetic).setPrimaryKeySegmentIndexEnabled(true).setPartitionHighWatermark(-1).build();
        int repartitionCount = 10;
        int loopCount = 50;
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)10).addProp(LuceneRecordContextProperties.LUCENE_MAX_DOCUMENTS_TO_MOVE_DURING_REPARTITIONING, (Object)(dataModel.nextInt(1000) + 10)).addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)((double)dataModel.nextInt(10).intValue() + 2.0)).build();
        for (int i = 0; i < 50; ++i) {
            LOGGER.info(KeyValueLogMessage.of((String)"concurrentUpdate loop", (Object[])new Object[]{"iteration", i, "groupCount", dataModel.groupingKeyToPrimaryKeyToPartitionKey.size(), "docCount", dataModel.groupingKeyToPrimaryKeyToPartitionKey.values().stream().mapToInt(Map::size).sum(), "docMinPerGroup", dataModel.groupingKeyToPrimaryKeyToPartitionKey.values().stream().mapToInt(Map::size).min(), "docMaxPerGroup", dataModel.groupingKeyToPrimaryKeyToPartitionKey.values().stream().mapToInt(Map::size).max()}));
            context = this.openContext(contextProps);
            try {
                dataModel.saveRecords(10, context, 1);
                this.commit(context);
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
            this.explicitMergeIndex(dataModel.index, contextProps, dataModel.schemaSetup);
        }
        Map<Tuple, Map> initial = dataModel.groupingKeyToPrimaryKeyToPartitionKey.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Map.copyOf((Map)entry.getValue())));
        dataModel.validate(() -> this.openContext(contextProps));
        context = this.openContext(contextProps);
        try {
            FDBRecordStore recordStore = Objects.requireNonNull(dataModel.schemaSetup.apply(context));
            recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
            MatcherAssert.assertThat(dataModel.recordsUnderTest(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(30))));
            LOGGER.info("concurrentUpdate: Starting updates");
            applyChangeConcurrently.accept(dataModel, recordStore);
            this.commit(context);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        System.out.println("=== initial ===");
        System.out.println(initial);
        System.out.println("=== updated ===");
        System.out.println(dataModel.groupingKeyToPrimaryKeyToPartitionKey);
        assertDataModelCount.accept(500, dataModel.groupingKeyToPrimaryKeyToPartitionKey.values().stream().mapToInt(Map::size).sum());
        dataModel.validate(() -> this.openContext(contextProps));
        this.validateDeleteWhere(isSynthetic, dataModel.groupingKeyToPrimaryKeyToPartitionKey, contextProps, dataModel.schemaSetup, dataModel.index);
    }

    static Stream<Arguments> concurrentStoreTest() {
        return Stream.concat(Stream.of(Arguments.of((Object[])new Object[]{true, true, true, 10, 9237590782644L})), RandomizedTestUtils.randomArguments(random -> Arguments.of((Object[])new Object[]{random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextInt(30) + 3, random.nextLong()})));
    }

    @ParameterizedTest
    @MethodSource
    @SuperSlow
    void concurrentStoreTest(boolean isGrouped, boolean isSynthetic, boolean primaryKeySegmentIndexEnabled, int storeCount, long seed) {
        long end = System.nanoTime() + TimeUnit.MINUTES.toNanos(5L);
        Random random = new Random(seed);
        int repartitionCount = 2;
        RandomTextGenerator outerTextGenerator = new RandomTextGenerator(random);
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)2).addProp(LuceneRecordContextProperties.LUCENE_MAX_DOCUMENTS_TO_MOVE_DURING_REPARTITIONING, (Object)(random.nextInt(1000) + 2)).addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)((double)random.nextInt(10) + 2.0)).build();
        LuceneIndexTestDataModel.Builder dataModelBuilder = new LuceneIndexTestDataModel.Builder(random.nextLong(), (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setIsGrouped(isGrouped).setIsSynthetic(isSynthetic).setPrimaryKeySegmentIndexEnabled(primaryKeySegmentIndexEnabled).setPartitionHighWatermark(1000).setTextGeneratorWithNewRandom(outerTextGenerator);
        List runners = IntStream.range(0, storeCount).mapToObj(i -> new ConcurrentStoreTestRunner(contextProps, end, dataModelBuilder)).collect(Collectors.toList());
        List allIds = (List)AsyncUtil.getAll((Collection)runners.stream().map(CompletableFuture::supplyAsync).collect(Collectors.toList())).join();
        LOGGER.info(KeyValueLogMessage.of((String)"Completed concurrentStoreTest successfully", (Object[])new Object[]{"ids", allIds.stream().map(storeIds -> storeIds.values().stream().mapToInt(Map::size).sum()).collect(Collectors.toList())}));
        for (ConcurrentMap storeIds2 : allIds) {
            MatcherAssert.assertThat((String)"All of the stores should have generated a fair amount of documents", (Object)storeIds2.values().stream().mapToInt(Map::size).sum(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(200)));
        }
    }

    private void createComplexRecords(int count, Map<Tuple, Map<Tuple, Tuple>> insertedKeys, RecordLayerPropertyStorage contextProps, Function<FDBRecordContext, FDBRecordStore> schemaSetup) {
        long timestamp = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            try (FDBRecordContext context = this.openContext(contextProps);){
                FDBRecordStore recordStore = Objects.requireNonNull(schemaSetup.apply(context));
                recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
                TestRecordsTextProto.ComplexDocument cd = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup(1L).setDocId((long)i + 1000L).setIsSeen(true).setText("A word about what I want to say").setTimestamp(timestamp + (long)i).setHeader(TestRecordsTextProto.ComplexDocument.Header.newBuilder().setHeaderId(1000L - (long)i)).build();
                Tuple primaryKey = recordStore.saveRecord((Message)cd).getPrimaryKey();
                insertedKeys.computeIfAbsent(Tuple.from((Object[])new Object[]{1}), k -> new HashMap()).put(primaryKey, Tuple.from((Object[])new Object[]{timestamp}));
                this.commit(context);
                continue;
            }
        }
    }

    private static LoggableKeysAndValues<? extends Exception> findTimeoutException(RecordCoreException e) {
        IdentityHashMap<Throwable, String> visited = new IdentityHashMap<Throwable, String>();
        ArrayDeque<Throwable> toVisit = new ArrayDeque<Throwable>();
        toVisit.push(e);
        while (!toVisit.isEmpty()) {
            Throwable cause = (Throwable)toVisit.removeFirst();
            if (visited.containsKey(cause)) continue;
            if (cause instanceof LoggableTimeoutException) {
                return (LoggableTimeoutException)cause;
            }
            if (cause instanceof LuceneConcurrency.AsyncToSyncTimeoutException) {
                return (LuceneConcurrency.AsyncToSyncTimeoutException)cause;
            }
            if (cause.getCause() != null) {
                toVisit.addLast(cause.getCause());
            }
            for (Throwable suppressed : cause.getSuppressed()) {
                toVisit.addLast(suppressed);
            }
            visited.put(cause, "");
        }
        return null;
    }

    @Nonnull
    public static Index complexPartitionedIndex(Map<String, String> options) {
        return new Index("Complex$partitioned", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")), (KeyExpression[])new KeyExpression[0]).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene", options);
    }

    private void validateDeleteWhere(boolean isSynthetic, Map<Tuple, ? extends Map<Tuple, Tuple>> ids, RecordLayerPropertyStorage contextProps, Function<FDBRecordContext, FDBRecordStore> schemaSetup, Index index) throws IOException {
        List<Tuple> groups = List.copyOf(ids.keySet());
        for (Tuple group : groups) {
            try (FDBRecordContext context2 = this.openContext(contextProps);){
                FDBRecordStore recordStore = Objects.requireNonNull(schemaSetup.apply(context2));
                recordStore.deleteRecordsWhere(Query.field((String)"group").equalsValue((Object)group.getLong(0)));
                context2.commit();
            }
            ids.remove(group);
            new LuceneIndexTestValidator(() -> this.openContext(contextProps), context -> Objects.requireNonNull((FDBRecordStore)schemaSetup.apply((FDBRecordContext)context))).validate(index, ids, isSynthetic ? "child_str_value:forth" : "text_value:about");
        }
    }

    private void explicitMergeIndex(Index index, RecordLayerPropertyStorage contextProps, Function<FDBRecordContext, FDBRecordStore> schemaSetup) {
        try (FDBRecordContext context = this.openContext(contextProps);){
            FDBRecordStore recordStore = Objects.requireNonNull(schemaSetup.apply(context));
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(recordStore)).setIndex(index).setTimer(new FDBStoreTimer())).build();){
                indexBuilder.mergeIndex();
            }
        }
    }

    protected RecordLayerPropertyStorage.Builder addDefaultProps(RecordLayerPropertyStorage.Builder props) {
        return super.addDefaultProps(props).addProp(LuceneRecordContextProperties.LUCENE_INDEX_COMPRESSION_ENABLED, (Object)true);
    }

    static class InvalidLockTestFDBDirectory
    extends FDBDirectory {
        private final int percentFailure;

        public InvalidLockTestFDBDirectory(@Nonnull Subspace subspace, @Nonnull FDBRecordContext context, @Nullable Map<String, String> indexOptions, int percentFailure) {
            super(subspace, context, indexOptions);
            this.percentFailure = percentFailure;
        }

        @Nonnull
        public Lock obtainLock(@Nonnull String lockName) throws IOException {
            final Lock lock = super.obtainLock(lockName);
            return new Lock(){

                public void close() throws IOException {
                    lock.close();
                }

                public void ensureValid() throws IOException {
                    if (ThreadLocalRandom.current().nextInt(100) < percentFailure) {
                        throw new IOException("invalid lock");
                    }
                    lock.ensureValid();
                }
            };
        }
    }

    private class ConcurrentStoreTestRunner
    implements Supplier<ConcurrentMap<Tuple, ConcurrentMap<Tuple, Tuple>>> {
        private final RecordLayerPropertyStorage contextProps;
        private final LuceneIndexTestDataModel dataModel;
        private final long endTime;

        public ConcurrentStoreTestRunner(RecordLayerPropertyStorage contextProps, long endTime, LuceneIndexTestDataModel.Builder dataModelBuilder) {
            this.contextProps = contextProps;
            this.endTime = endTime;
            this.dataModel = dataModelBuilder.build();
        }

        @Override
        public ConcurrentMap<Tuple, ConcurrentMap<Tuple, Tuple>> get() {
            int maxTransactionsPerLoop = 5;
            LuceneIndexTestValidator luceneIndexTestValidator = new LuceneIndexTestValidator(() -> LuceneIndexMaintenanceTest.this.openContext(this.contextProps), this.dataModel::createOrOpenRecordStore);
            int currentLoop = 0;
            while (System.nanoTime() < this.endTime) {
                ++currentLoop;
                try {
                    this.dataModel.saveManyRecords(1, () -> LuceneIndexMaintenanceTest.this.openContext(this.contextProps), this.dataModel.nextInt(maxTransactionsPerLoop - 1) + 1);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Failed to generate documents at iteration " + currentLoop, e);
                }
                boolean mergeFailed = this.mergeIndex(currentLoop);
                try {
                    luceneIndexTestValidator.validate(this.dataModel.index, this.dataModel.groupingKeyToPrimaryKeyToPartitionKey, this.dataModel.isSynthetic ? "child_str_value:forth" : "text_value:about", mergeFailed);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.dataModel.groupingKeyToPrimaryKeyToPartitionKey;
        }

        private boolean mergeIndex(int currentLoop) {
            try {
                LuceneIndexMaintenanceTest.this.explicitMergeIndex(this.dataModel.index, this.contextProps, this.dataModel.schemaSetup);
            }
            catch (FDBExceptions.FDBStoreRetriableException e) {
                FDBException fe;
                if (e.getCause() instanceof FDBException && (fe = (FDBException)e.getCause()).getCode() == 1051) {
                    LOGGER.info("Batch GRV exceeded at iteration " + currentLoop, (Throwable)e);
                    try {
                        Thread.sleep(50L);
                        return true;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(ex);
                    }
                }
                throw new RuntimeException("Failed merge at iteration " + currentLoop, e);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Failed merge at iteration " + currentLoop, e);
            }
            return false;
        }
    }
}

