/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.lucene.LuceneGetMetadataInfo;
import com.apple.foundationdb.record.lucene.LuceneIndexTestDataModel;
import com.apple.foundationdb.record.lucene.LuceneMetadataInfo;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperation;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperationResult;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class LuceneIndexGetMetadataInfoTest
extends FDBRecordStoreTestBase {
    static Stream<Arguments> arguments() {
        return Stream.of(true, false).flatMap(justPartitionInfo -> Stream.of(true, false).map(isGrouped -> Arguments.of((Object[])new Object[]{justPartitionInfo, isGrouped})));
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    void getMetadata(boolean justPartitionInfo, boolean isGrouped) {
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(234097L, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setPartitionHighWatermark(-1).setIsGrouped(isGrouped).build();
        for (int i = 0; i < 5; ++i) {
            try (FDBRecordContext context = this.openContext();){
                dataModel.saveRecords(10, context, i);
                this.commit(context);
                continue;
            }
        }
        Set<Tuple> groupingKeys = isGrouped ? dataModel.groupingKeys() : Set.of(Tuple.from((Object[])new Object[0]));
        for (Tuple groupingKey : groupingKeys) {
            LuceneMetadataInfo result = this.getLuceneMetadataInfo(justPartitionInfo, groupingKey, dataModel, null);
            Assertions.assertEquals(List.of(), (Object)result.getPartitionInfo());
            if (justPartitionInfo) {
                Assertions.assertEquals(Map.of(), (Object)result.getLuceneInfo());
                continue;
            }
            Assertions.assertEquals(Set.of(Integer.valueOf(0)), result.getLuceneInfo().keySet());
            LuceneMetadataInfo.LuceneInfo luceneInfo = (LuceneMetadataInfo.LuceneInfo)result.getLuceneInfo().get(0);
            Assertions.assertEquals((int)dataModel.primaryKeys(groupingKey).size(), (int)luceneInfo.getDocumentCount());
            MatcherAssert.assertThat((Object)luceneInfo.getFiles(), (Matcher)Matchers.hasSize((int)LuceneIndexGetMetadataInfoTest.segmentCountToFileCount(isGrouped ? 1 : 5)));
            MatcherAssert.assertThat((Object)luceneInfo.getDetailedFileInfos(), (Matcher)Matchers.hasSize((int)LuceneIndexGetMetadataInfoTest.segmentCountToFileCount(isGrouped ? 1 : 5)));
            Assertions.assertEquals((int)1, (int)luceneInfo.getFieldInfoCount());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    void getMetadataPartitioned(boolean justPartitionInfo, boolean isGrouped) {
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(234097L, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setPartitionHighWatermark(10).setIsGrouped(isGrouped).build();
        for (int i2 = 0; i2 < 6; ++i2) {
            try (FDBRecordContext context = this.openContext();){
                dataModel.saveRecords(10, context, i2 / 3);
                this.commit(context);
            }
            context = this.openContext();
            try {
                dataModel.explicitMergeIndex(context, this.timer);
                continue;
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
        }
        Set<Tuple> groupingKeys = isGrouped ? dataModel.groupingKeys() : Set.of(Tuple.from((Object[])new Object[0]));
        for (Tuple groupingKey : groupingKeys) {
            LuceneMetadataInfo result = this.getLuceneMetadataInfo(justPartitionInfo, groupingKey, dataModel, null);
            List partitionInfo = result.getPartitionInfo();
            List<Integer> partitionIds = isGrouped ? List.of(Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(1)) : List.of(Integer.valueOf(0), Integer.valueOf(5), Integer.valueOf(4), Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1));
            Assertions.assertEquals(partitionIds, partitionInfo.stream().map(info -> info.getId()).collect(Collectors.toList()));
            Assertions.assertEquals(partitionIds.stream().map(i -> 10).collect(Collectors.toList()), partitionInfo.stream().map(info -> info.getCount()).collect(Collectors.toList()));
            LuceneIndexGetMetadataInfoTest.assertPartitionInfosHaveCorrectFromTo(partitionInfo);
            if (justPartitionInfo) {
                Assertions.assertEquals(Map.of(), (Object)result.getLuceneInfo());
                continue;
            }
            Assertions.assertEquals(Set.copyOf(partitionIds), result.getLuceneInfo().keySet());
            for (Integer partitionId : partitionIds) {
                LuceneMetadataInfo.LuceneInfo luceneInfo = (LuceneMetadataInfo.LuceneInfo)result.getLuceneInfo().get(partitionId);
                Assertions.assertEquals((int)10, (int)luceneInfo.getDocumentCount());
                MatcherAssert.assertThat((Object)luceneInfo.getFiles(), (Matcher)Matchers.hasSize((int)LuceneIndexGetMetadataInfoTest.segmentCountToFileCount(1)));
                MatcherAssert.assertThat((Object)luceneInfo.getDetailedFileInfos(), (Matcher)Matchers.hasSize((int)LuceneIndexGetMetadataInfoTest.segmentCountToFileCount(1)));
                Assertions.assertEquals((int)1, (int)luceneInfo.getFieldInfoCount());
                LuceneMetadataInfo resultForPartition = this.getLuceneMetadataInfo(justPartitionInfo, groupingKey, dataModel, partitionId);
                Assertions.assertEquals(Set.of(partitionId), resultForPartition.getLuceneInfo().keySet());
                Assertions.assertEquals((Object)luceneInfo, resultForPartition.getLuceneInfo().get(partitionId));
            }
        }
    }

    @Test
    void getMetadataAfterDelete() {
        FDBRecordContext context;
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(234097L, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setPartitionHighWatermark(10).setIsGrouped(false).build();
        for (int i = 0; i < 6; ++i) {
            context = this.openContext();
            try {
                dataModel.saveRecords(10, context, i / 3);
                this.commit(context);
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
            context = this.openContext();
            try {
                dataModel.explicitMergeIndex(context, this.timer);
                continue;
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
        }
        Tuple groupingKey = Tuple.from((Object[])new Object[0]);
        context = this.openContext();
        try {
            Tuple toDelete = (Tuple)dataModel.primaryKeys(groupingKey).stream().findFirst().orElseThrow();
            dataModel.deleteRecord(context, toDelete);
            this.commit(context);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        LuceneMetadataInfo result = this.getLuceneMetadataInfo(false, groupingKey, dataModel, null);
        List partitionInfo = result.getPartitionInfo();
        List<Integer> partitionIds = List.of(Integer.valueOf(0), Integer.valueOf(5), Integer.valueOf(4), Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1));
        Assertions.assertEquals(partitionIds, partitionInfo.stream().map(LucenePartitionInfoProto.LucenePartitionInfo::getId).collect(Collectors.toList()));
        List partitionCounts = partitionInfo.stream().map(LucenePartitionInfoProto.LucenePartitionInfo::getCount).collect(Collectors.toList());
        MatcherAssert.assertThat(partitionCounts, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{9, 10, 10, 10, 10, 10}));
        LuceneIndexGetMetadataInfoTest.assertPartitionInfosHaveCorrectFromTo(partitionInfo);
        Assertions.assertEquals(Set.copyOf(partitionIds), result.getLuceneInfo().keySet());
        int smallerPartition = partitionInfo.stream().filter(partition -> partition.getCount() == 9).map(LucenePartitionInfoProto.LucenePartitionInfo::getId).findFirst().orElseThrow();
        for (Integer partitionId : partitionIds) {
            LuceneMetadataInfo.LuceneInfo luceneInfo = (LuceneMetadataInfo.LuceneInfo)result.getLuceneInfo().get(partitionId);
            if (partitionId == smallerPartition) {
                Assertions.assertEquals((int)9, (int)luceneInfo.getDocumentCount());
                MatcherAssert.assertThat((Object)luceneInfo.getFiles(), (Matcher)Matchers.hasSize((int)(LuceneIndexGetMetadataInfoTest.segmentCountToFileCount(1) + 1)));
                MatcherAssert.assertThat((Object)luceneInfo.getDetailedFileInfos(), (Matcher)Matchers.hasSize((int)(LuceneIndexGetMetadataInfoTest.segmentCountToFileCount(1) + 1)));
            } else {
                Assertions.assertEquals((int)10, (int)luceneInfo.getDocumentCount());
                MatcherAssert.assertThat((Object)luceneInfo.getFiles(), (Matcher)Matchers.hasSize((int)LuceneIndexGetMetadataInfoTest.segmentCountToFileCount(1)));
                MatcherAssert.assertThat((Object)luceneInfo.getDetailedFileInfos(), (Matcher)Matchers.hasSize((int)LuceneIndexGetMetadataInfoTest.segmentCountToFileCount(1)));
            }
            Assertions.assertEquals((int)1, (int)luceneInfo.getFieldInfoCount());
        }
    }

    @Test
    void testLuceneInfoConstructor() {
        List<LuceneMetadataInfo.LuceneFileInfo> detailedFiles = List.of(new LuceneMetadataInfo.LuceneFileInfo("file1.txt", 1L, 100L), new LuceneMetadataInfo.LuceneFileInfo("file2.txt", 2L, 200L), new LuceneMetadataInfo.LuceneFileInfo("file3.txt", 3L, 300L));
        List<String> fileNames = List.of("file1.txt", "file2.txt", "file3.txt");
        LuceneMetadataInfo.LuceneInfo luceneInfo = new LuceneMetadataInfo.LuceneInfo(15, 5, detailedFiles);
        Assertions.assertEquals((int)15, (int)luceneInfo.getDocumentCount());
        Assertions.assertEquals((int)5, (int)luceneInfo.getFieldInfoCount());
        Assertions.assertEquals(detailedFiles, (Object)luceneInfo.getDetailedFileInfos());
        Assertions.assertEquals(fileNames, (Object)luceneInfo.getFiles());
        luceneInfo = new LuceneMetadataInfo.LuceneInfo(15, fileNames, 5);
        Assertions.assertEquals((int)15, (int)luceneInfo.getDocumentCount());
        Assertions.assertEquals((int)5, (int)luceneInfo.getFieldInfoCount());
        Assertions.assertEquals(null, (Object)luceneInfo.getDetailedFileInfos());
        Assertions.assertEquals(fileNames, (Object)luceneInfo.getFiles());
    }

    @Test
    void testLuceneInfoEqualsAndHashCode() {
        List<LuceneMetadataInfo.LuceneFileInfo> detailedFiles1 = List.of(new LuceneMetadataInfo.LuceneFileInfo("file1.txt", 1L, 100L), new LuceneMetadataInfo.LuceneFileInfo("file2.txt", 2L, 200L));
        List<LuceneMetadataInfo.LuceneFileInfo> detailedFiles2 = List.of(new LuceneMetadataInfo.LuceneFileInfo("file3.txt", 3L, 300L), new LuceneMetadataInfo.LuceneFileInfo("file4.txt", 4L, 400L));
        List<LuceneMetadataInfo.LuceneFileInfo> detailedFiles1Copy = List.of(new LuceneMetadataInfo.LuceneFileInfo("file1.txt", 1L, 100L), new LuceneMetadataInfo.LuceneFileInfo("file2.txt", 2L, 200L));
        LuceneMetadataInfo.LuceneInfo info1 = new LuceneMetadataInfo.LuceneInfo(10, 5, detailedFiles1);
        LuceneMetadataInfo.LuceneInfo info2 = new LuceneMetadataInfo.LuceneInfo(10, 5, detailedFiles1Copy);
        LuceneMetadataInfo.LuceneInfo info3 = new LuceneMetadataInfo.LuceneInfo(15, 5, detailedFiles1);
        LuceneMetadataInfo.LuceneInfo info4 = new LuceneMetadataInfo.LuceneInfo(10, 3, detailedFiles1);
        LuceneMetadataInfo.LuceneInfo info5 = new LuceneMetadataInfo.LuceneInfo(10, 5, detailedFiles2);
        Assertions.assertEquals((Object)info1, (Object)info2);
        Assertions.assertNotEquals((Object)info1, (Object)info3);
        Assertions.assertNotEquals((Object)info1, (Object)info4);
        Assertions.assertNotEquals((Object)info1, (Object)info5);
        Assertions.assertEquals((int)info1.hashCode(), (int)info2.hashCode());
        Assertions.assertNotEquals((int)info1.hashCode(), (int)info3.hashCode());
        Assertions.assertNotEquals((int)info1.hashCode(), (int)info4.hashCode());
        Assertions.assertNotEquals((int)info1.hashCode(), (int)info5.hashCode());
        Assertions.assertEquals((Object)info1, (Object)info1);
        Assertions.assertEquals((int)info1.hashCode(), (int)info1.hashCode());
    }

    private static void assertPartitionInfosHaveCorrectFromTo(List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfo) {
        for (int i = 0; i < partitionInfo.size(); ++i) {
            LucenePartitionInfoProto.LucenePartitionInfo info = partitionInfo.get(i);
            LuceneIndexGetMetadataInfoTest.assertLessThan(info.getFrom(), info.getTo());
            if (i <= 0) continue;
            LuceneIndexGetMetadataInfoTest.assertLessThan(info.getTo(), partitionInfo.get(i - 1).getFrom());
        }
    }

    private LuceneMetadataInfo getLuceneMetadataInfo(boolean justPartitionInfo, @Nonnull Tuple groupingKey, @Nonnull LuceneIndexTestDataModel dataModel, @Nullable Integer partitionId) {
        try (FDBRecordContext context = this.openContext();){
            FDBRecordStore store = dataModel.schemaSetup.apply(context);
            IndexOperationResult indexOperationResult = store.performIndexOperation(dataModel.index.getName(), (IndexOperation)new LuceneGetMetadataInfo(groupingKey, partitionId, justPartitionInfo));
            MatcherAssert.assertThat((Object)indexOperationResult, (Matcher)Matchers.instanceOf(LuceneMetadataInfo.class));
            LuceneMetadataInfo luceneMetadataInfo = (LuceneMetadataInfo)indexOperationResult;
            return luceneMetadataInfo;
        }
    }

    private static void assertLessThan(ByteString lesserOne, ByteString greaterOne) {
        MatcherAssert.assertThat((Object)Tuple.fromBytes((byte[])lesserOne.toByteArray()), (Matcher)Matchers.lessThan((Comparable)Tuple.fromBytes((byte[])greaterOne.toByteArray())));
    }

    private static int segmentCountToFileCount(int segmentCount) {
        return segmentCount * 4 + 1;
    }
}

