/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.UnstoredRecord;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerCombinationProvider;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerWrapper;
import com.apple.foundationdb.record.lucene.LuceneDocumentFromRecord;
import com.apple.foundationdb.record.lucene.LuceneFunctionNames;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneIndexKeyValueToPartialRecordUtils;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.lucene.highlight.HighlightedTerm;
import com.apple.foundationdb.record.lucene.highlight.LuceneHighlighting;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LuceneDocumentFromRecordTest {
    private final LuceneAnalyzerCombinationProvider analyzerProvider = new LuceneAnalyzerCombinationProvider(LuceneAnalyzerWrapper::getStandardAnalyzerWrapper, LuceneAnalyzerWrapper::getStandardAnalyzerWrapper, null, null);

    LuceneDocumentFromRecordTest() {
    }

    @Test
    void simple() {
        TestRecordsTextProto.SimpleDocument.Builder builder = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(1L).setText("some text");
        TestRecordsTextProto.SimpleDocument message = builder.build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        FunctionKeyExpression index = Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"));
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[0]), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("text", "some text"))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
        List terms = LuceneHighlighting.highlightedTermsForMessage(record, (Message)message, null, (KeyExpression)index, Map.of("text", Set.of("some")), (LuceneAnalyzerCombinationProvider)this.analyzerProvider, (LuceneScanQueryParameters.LuceneQueryHighlightParameters)new LuceneScanQueryParameters.LuceneQueryHighlightParameters(-1, 10, (Query)new TermQuery(new Term("text", "some"))));
        Assertions.assertEquals((int)1, (int)terms.size(), (String)"Should only match once");
        Assertions.assertEquals((int)1, (int)((HighlightedTerm)terms.get(0)).getNumHighlights(), (String)"Incorrect number of highlights");
        Assertions.assertEquals((int)0, (int)((HighlightedTerm)terms.get(0)).getHighlightStart(0));
        Assertions.assertEquals((int)4, (int)((HighlightedTerm)terms.get(0)).getHighlightEnd(0));
        FieldKeyExpression primaryKey = Key.Expressions.field((String)"doc_id");
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        TestRecordsTextProto.SimpleDocument.Builder newBuilder = TestRecordsTextProto.SimpleDocument.newBuilder();
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord((KeyExpression)index, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (String)"text", (String)"suggestion");
        LuceneIndexKeyValueToPartialRecordUtils.populatePrimaryKey((KeyExpression)primaryKey, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (Tuple)Tuple.from((Object[])new Object[]{1}));
        TestRecordsTextProto.SimpleDocument partialMsg = newBuilder.build();
        Assertions.assertEquals((Object)"suggestion", (Object)partialMsg.getText());
        Assertions.assertEquals((long)1L, (long)partialMsg.getDocId());
    }

    @Test
    void group() {
        TestRecordsTextProto.SimpleDocument.Builder builder = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(2L).setText("more text").setGroup(2L);
        TestRecordsTextProto.SimpleDocument message = builder.build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        GroupingKeyExpression index = Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]);
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[]{2}), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("text", "more text"))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
        List terms = LuceneHighlighting.highlightedTermsForMessage(record, (Message)message, null, (KeyExpression)index, Map.of("text", Set.of("text")), (LuceneAnalyzerCombinationProvider)this.analyzerProvider, (LuceneScanQueryParameters.LuceneQueryHighlightParameters)new LuceneScanQueryParameters.LuceneQueryHighlightParameters(-1, 10, (Query)new TermQuery(new Term("text", "text"))));
        Assertions.assertEquals((int)1, (int)terms.size(), (String)"Should only match once");
        Assertions.assertEquals((int)1, (int)((HighlightedTerm)terms.get(0)).getNumHighlights(), (String)"Incorrect number of highlights");
        Assertions.assertEquals((int)5, (int)((HighlightedTerm)terms.get(0)).getHighlightStart(0));
        Assertions.assertEquals((int)9, (int)((HighlightedTerm)terms.get(0)).getHighlightEnd(0));
        ThenKeyExpression primaryKey = Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]);
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        TestRecordsTextProto.SimpleDocument.Builder newBuilder = TestRecordsTextProto.SimpleDocument.newBuilder();
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord((KeyExpression)index, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (String)"text", (String)"suggestion", (Tuple)Tuple.from((Object[])new Object[]{2}));
        LuceneIndexKeyValueToPartialRecordUtils.populatePrimaryKey((KeyExpression)primaryKey, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (Tuple)Tuple.from((Object[])new Object[]{2, 2}));
        TestRecordsTextProto.SimpleDocument partialMsg = newBuilder.build();
        Assertions.assertEquals((Object)"suggestion", (Object)partialMsg.getText());
        Assertions.assertEquals((long)2L, (long)partialMsg.getGroup());
        Assertions.assertEquals((long)2L, (long)partialMsg.getGroup());
        Assertions.assertEquals((long)2L, (long)partialMsg.getDocId());
    }

    @Test
    void multi() {
        TestRecordsTextProto.MultiDocument.Builder builder = TestRecordsTextProto.MultiDocument.newBuilder().setDocId(3L).addText("some text").addText("other text");
        TestRecordsTextProto.MultiDocument message = builder.build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        FunctionKeyExpression index = Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text", (KeyExpression.FanType)KeyExpression.FanType.FanOut));
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[0]), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("text", "some text"), (Object)LuceneDocumentFromRecordTest.textField("text", "other text"))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
        List terms = LuceneHighlighting.highlightedTermsForMessage(record, (Message)message, null, (KeyExpression)index, Map.of("text", Set.of("text")), (LuceneAnalyzerCombinationProvider)this.analyzerProvider, (LuceneScanQueryParameters.LuceneQueryHighlightParameters)new LuceneScanQueryParameters.LuceneQueryHighlightParameters(-1, 10, (Query)new TermQuery(new Term("text", "text"))));
        Assertions.assertEquals((int)2, (int)terms.size(), (String)"Should only match once");
        Assertions.assertEquals((int)1, (int)((HighlightedTerm)terms.get(0)).getNumHighlights(), (String)"Incorrect number of highlights");
        Assertions.assertEquals((int)5, (int)((HighlightedTerm)terms.get(0)).getHighlightStart(0));
        Assertions.assertEquals((int)9, (int)((HighlightedTerm)terms.get(0)).getHighlightEnd(0));
        Assertions.assertEquals((int)1, (int)((HighlightedTerm)terms.get(1)).getNumHighlights(), (String)"Incorrect number of highlights");
        Assertions.assertEquals((int)6, (int)((HighlightedTerm)terms.get(1)).getHighlightStart(0));
        Assertions.assertEquals((int)10, (int)((HighlightedTerm)terms.get(1)).getHighlightEnd(0));
        Assertions.assertEquals((Object)"some text", (Object)builder.build().getText(0));
        Assertions.assertEquals((Object)"other text", (Object)builder.build().getText(1));
        FieldKeyExpression primaryKey = Key.Expressions.field((String)"doc_id");
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        TestRecordsTextProto.MultiDocument.Builder newBuilder = TestRecordsTextProto.MultiDocument.newBuilder();
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord((KeyExpression)index, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (String)"text", (String)"suggestion", (Tuple)Tuple.from((Object[])new Object[]{2}));
        LuceneIndexKeyValueToPartialRecordUtils.populatePrimaryKey((KeyExpression)primaryKey, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (Tuple)Tuple.from((Object[])new Object[]{3}));
        TestRecordsTextProto.MultiDocument partialMsg = newBuilder.build();
        Assertions.assertEquals((int)1, (int)partialMsg.getTextCount());
        Assertions.assertEquals((Object)"suggestion", (Object)partialMsg.getText(0));
        Assertions.assertEquals((long)3L, (long)partialMsg.getDocId());
    }

    @Test
    void biGroup() {
        TestRecordsTextProto.ComplexDocument.Builder builder = TestRecordsTextProto.ComplexDocument.newBuilder().setHeader(TestRecordsTextProto.ComplexDocument.Header.newBuilder().setHeaderId(4L)).setGroup(10L).setDocId(4L).setText("first text").addTag("tag1").addTag("tag2").setText2("second text").setScore(100);
        TestRecordsTextProto.ComplexDocument message = builder.build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        GroupingKeyExpression index = Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"score")}).groupBy((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"tag", (KeyExpression.FanType)KeyExpression.FanType.FanOut), (KeyExpression[])new KeyExpression[0]), new KeyExpression[0]);
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[]{10, "tag1"}), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("text", "first text"), (Object)LuceneDocumentFromRecordTest.textField("text2", "second text"), (Object)LuceneDocumentFromRecordTest.intField("score", 100)), (Object)Tuple.from((Object[])new Object[]{10, "tag2"}), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("text", "first text"), (Object)LuceneDocumentFromRecordTest.textField("text2", "second text"), (Object)LuceneDocumentFromRecordTest.intField("score", 100))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
        List terms = LuceneHighlighting.highlightedTermsForMessage(record, (Message)message, null, (KeyExpression)index, Map.of("text2", Set.of("text")), (LuceneAnalyzerCombinationProvider)this.analyzerProvider, (LuceneScanQueryParameters.LuceneQueryHighlightParameters)new LuceneScanQueryParameters.LuceneQueryHighlightParameters(-1, 10, (Query)new TermQuery(new Term("text2", "text"))));
        Assertions.assertEquals((int)1, (int)terms.size(), (String)"Should only match once");
        Assertions.assertEquals((int)1, (int)((HighlightedTerm)terms.get(0)).getNumHighlights(), (String)"Incorrect number of highlights");
        Assertions.assertEquals((int)7, (int)((HighlightedTerm)terms.get(0)).getHighlightStart(0));
        Assertions.assertEquals((int)11, (int)((HighlightedTerm)terms.get(0)).getHighlightEnd(0));
        Assertions.assertEquals((Object)"first text", (Object)builder.build().getText());
        Assertions.assertEquals((Object)"second text", (Object)builder.build().getText2());
        ThenKeyExpression primaryKey = Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"header").nest("header_id"), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"doc_id")});
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        TestRecordsTextProto.ComplexDocument.Builder newBuilder = TestRecordsTextProto.ComplexDocument.newBuilder();
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord((KeyExpression)index, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (String)"text", (String)"suggestion", (Tuple)Tuple.from((Object[])new Object[]{10, "tag1"}));
        LuceneIndexKeyValueToPartialRecordUtils.populatePrimaryKey((KeyExpression)primaryKey, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (Tuple)Tuple.from((Object[])new Object[]{10, 4, 4}));
        TestRecordsTextProto.ComplexDocument partialMsg = newBuilder.build();
        Assertions.assertEquals((Object)"suggestion", (Object)partialMsg.getText());
        Assertions.assertEquals((long)10L, (long)partialMsg.getGroup());
        Assertions.assertEquals((int)1, (int)partialMsg.getTagCount());
        Assertions.assertEquals((Object)"tag1", (Object)partialMsg.getTag(0));
        Assertions.assertEquals((long)10L, (long)partialMsg.getGroup());
        Assertions.assertEquals((long)4L, (long)partialMsg.getHeader().getHeaderId());
        Assertions.assertEquals((long)4L, (long)partialMsg.getDocId());
    }

    @Test
    void uncorrelatedMap() {
        TestRecordsTextProto.MapDocument.Builder builder = TestRecordsTextProto.MapDocument.newBuilder().setGroup(10L).setDocId(5L).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("k1").setValue("v1")).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("k2").setValue("v2"));
        TestRecordsTextProto.MapDocument message = builder.build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        NestingKeyExpression index = Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"key"), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"value")), (KeyExpression[])new KeyExpression[0]));
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[0]), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.stringField("entry_key", "k1"), (Object)LuceneDocumentFromRecordTest.textField("entry_value", "v1"), (Object)LuceneDocumentFromRecordTest.stringField("entry_key", "k2"), (Object)LuceneDocumentFromRecordTest.textField("entry_value", "v2"))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
        List terms = LuceneHighlighting.highlightedTermsForMessage(record, (Message)message, null, (KeyExpression)index, Map.of("entry_value", Set.of("v2")), (LuceneAnalyzerCombinationProvider)this.analyzerProvider, (LuceneScanQueryParameters.LuceneQueryHighlightParameters)new LuceneScanQueryParameters.LuceneQueryHighlightParameters(-1, 10, (Query)new TermQuery(new Term("entry_value", "v2"))));
        Assertions.assertEquals((int)1, (int)terms.size(), (String)"Should only match once");
        Assertions.assertEquals((int)1, (int)((HighlightedTerm)terms.get(0)).getNumHighlights(), (String)"Incorrect number of highlights");
        Assertions.assertEquals((int)0, (int)((HighlightedTerm)terms.get(0)).getHighlightStart(0));
        Assertions.assertEquals((int)2, (int)((HighlightedTerm)terms.get(0)).getHighlightEnd(0));
        Assertions.assertEquals((Object)"v1", (Object)builder.build().getEntry(0).getValue());
        Assertions.assertEquals((Object)"v2", (Object)builder.build().getEntry(1).getValue());
        ThenKeyExpression primaryKey = Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]);
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        TestRecordsTextProto.MapDocument.Builder newBuilder = TestRecordsTextProto.MapDocument.newBuilder();
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord((KeyExpression)index, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (String)"entry_value", (String)"suggestion");
        LuceneIndexKeyValueToPartialRecordUtils.populatePrimaryKey((KeyExpression)primaryKey, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (Tuple)Tuple.from((Object[])new Object[]{10, 5}));
        TestRecordsTextProto.MapDocument partialMsg = newBuilder.build();
        Assertions.assertEquals((int)1, (int)partialMsg.getEntryCount());
        TestRecordsTextProto.MapDocument.Entry entry = partialMsg.getEntry(0);
        Assertions.assertEquals((Object)"suggestion", (Object)entry.getValue());
        Assertions.assertEquals((long)10L, (long)partialMsg.getGroup());
        Assertions.assertEquals((long)5L, (long)partialMsg.getDocId());
    }

    @Test
    void map() {
        TestRecordsTextProto.MapDocument.Builder builder = TestRecordsTextProto.MapDocument.newBuilder().setGroup(10L).setDocId(5L).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("k1").setValue("v1")).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("k2").setValue("v2"));
        TestRecordsTextProto.MapDocument message = builder.build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        FunctionKeyExpression index = Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"value")), (KeyExpression)Key.Expressions.field((String)"key"), (KeyExpression[])new KeyExpression[0]))), (KeyExpression)Key.Expressions.value(null), (KeyExpression[])new KeyExpression[0]));
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[0]), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("k1", "v1"), (Object)LuceneDocumentFromRecordTest.textField("k2", "v2"))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
        List terms = LuceneHighlighting.highlightedTermsForMessage(record, (Message)message, null, (KeyExpression)index, Map.of("k2", Set.of("v2")), (LuceneAnalyzerCombinationProvider)this.analyzerProvider, (LuceneScanQueryParameters.LuceneQueryHighlightParameters)new LuceneScanQueryParameters.LuceneQueryHighlightParameters(-1, 10, (Query)new TermQuery(new Term("k2", "v2"))));
        Assertions.assertEquals((int)1, (int)terms.size(), (String)"Should only match once");
        Assertions.assertEquals((int)1, (int)((HighlightedTerm)terms.get(0)).getNumHighlights(), (String)"Incorrect number of highlights");
        Assertions.assertEquals((int)0, (int)((HighlightedTerm)terms.get(0)).getHighlightStart(0));
        Assertions.assertEquals((int)2, (int)((HighlightedTerm)terms.get(0)).getHighlightEnd(0));
        Assertions.assertEquals((Object)"v1", (Object)builder.build().getEntry(0).getValue());
        Assertions.assertEquals((Object)"v2", (Object)builder.build().getEntry(1).getValue());
        ThenKeyExpression primaryKey = Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]);
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        TestRecordsTextProto.MapDocument.Builder newBuilder = TestRecordsTextProto.MapDocument.newBuilder();
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord((KeyExpression)index, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (String)"k1", (String)"suggestion");
        LuceneIndexKeyValueToPartialRecordUtils.populatePrimaryKey((KeyExpression)primaryKey, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (Tuple)Tuple.from((Object[])new Object[]{10, 5}));
        TestRecordsTextProto.MapDocument partialMsg = newBuilder.build();
        Assertions.assertEquals((int)1, (int)partialMsg.getEntryCount());
        TestRecordsTextProto.MapDocument.Entry entry = partialMsg.getEntry(0);
        Assertions.assertEquals((Object)"k1", (Object)entry.getKey());
        Assertions.assertEquals((Object)"suggestion", (Object)entry.getValue());
        Assertions.assertEquals((long)10L, (long)partialMsg.getGroup());
        Assertions.assertEquals((long)5L, (long)partialMsg.getDocId());
    }

    @Test
    void groupedMap() {
        TestRecordsTextProto.MapDocument.Builder builder = TestRecordsTextProto.MapDocument.newBuilder().setDocId(6L).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("k1").setValue("v10")).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("k2").setValue("v20")).setGroup(20L);
        TestRecordsTextProto.MapDocument message = builder.build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        GroupingKeyExpression index = Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"value")), (KeyExpression)Key.Expressions.field((String)"key"), (KeyExpression[])new KeyExpression[0]))), (KeyExpression)Key.Expressions.value(null), (KeyExpression[])new KeyExpression[0])).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]);
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[]{20}), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("k1", "v10"), (Object)LuceneDocumentFromRecordTest.textField("k2", "v20"))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
        List terms = LuceneHighlighting.highlightedTermsForMessage(record, (Message)message, null, (KeyExpression)index, Map.of("k2", Set.of("v20")), (LuceneAnalyzerCombinationProvider)this.analyzerProvider, (LuceneScanQueryParameters.LuceneQueryHighlightParameters)new LuceneScanQueryParameters.LuceneQueryHighlightParameters(-1, 10, (Query)new TermQuery(new Term("k2", "v20"))));
        Assertions.assertEquals((int)1, (int)terms.size(), (String)"Should only match once");
        Assertions.assertEquals((int)1, (int)((HighlightedTerm)terms.get(0)).getNumHighlights(), (String)"Incorrect number of highlights");
        Assertions.assertEquals((int)0, (int)((HighlightedTerm)terms.get(0)).getHighlightStart(0));
        Assertions.assertEquals((int)3, (int)((HighlightedTerm)terms.get(0)).getHighlightEnd(0));
        Assertions.assertEquals((Object)"v10", (Object)builder.build().getEntry(0).getValue());
        Assertions.assertEquals((Object)"v20", (Object)builder.build().getEntry(1).getValue());
        ThenKeyExpression primaryKey = Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]);
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        TestRecordsTextProto.MapDocument.Builder newBuilder = TestRecordsTextProto.MapDocument.newBuilder();
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord((KeyExpression)index, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (String)"k1", (String)"suggestion", (Tuple)Tuple.from((Object[])new Object[]{20}));
        LuceneIndexKeyValueToPartialRecordUtils.populatePrimaryKey((KeyExpression)primaryKey, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (Tuple)Tuple.from((Object[])new Object[]{20, 6}));
        TestRecordsTextProto.MapDocument partialMsg = newBuilder.build();
        Assertions.assertEquals((int)1, (int)partialMsg.getEntryCount());
        TestRecordsTextProto.MapDocument.Entry entry = partialMsg.getEntry(0);
        Assertions.assertEquals((Object)"k1", (Object)entry.getKey());
        Assertions.assertEquals((Object)"suggestion", (Object)entry.getValue());
        Assertions.assertEquals((long)20L, (long)partialMsg.getGroup());
        Assertions.assertEquals((long)6L, (long)partialMsg.getDocId());
    }

    @Test
    void groupingMap() {
        TestRecordsTextProto.MapDocument.Builder builder = TestRecordsTextProto.MapDocument.newBuilder().setDocId(7L).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("r1").setValue("val").setSecondValue("2val").setThirdValue("3val")).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("r2").setValue("nval").setSecondValue("2nval").setThirdValue("3nval")).setGroup(30L);
        TestRecordsTextProto.MapDocument message = builder.build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        GroupingKeyExpression index = new GroupingKeyExpression((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"key"), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"value")), (KeyExpression[])new KeyExpression[]{Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"second_value")), Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"third_value"))})), (KeyExpression[])new KeyExpression[0]), 3);
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[]{30, "r1"}), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("entry_value", "val"), (Object)LuceneDocumentFromRecordTest.textField("entry_second_value", "2val"), (Object)LuceneDocumentFromRecordTest.textField("entry_third_value", "3val")), (Object)Tuple.from((Object[])new Object[]{30, "r2"}), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("entry_value", "nval"), (Object)LuceneDocumentFromRecordTest.textField("entry_second_value", "2nval"), (Object)LuceneDocumentFromRecordTest.textField("entry_third_value", "3nval"))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
        List terms = LuceneHighlighting.highlightedTermsForMessage(record, (Message)message, null, (KeyExpression)index, Map.of("entry_second_value", Set.of("2val")), (LuceneAnalyzerCombinationProvider)this.analyzerProvider, (LuceneScanQueryParameters.LuceneQueryHighlightParameters)new LuceneScanQueryParameters.LuceneQueryHighlightParameters(-1, 10, (Query)new TermQuery(new Term("entry_second_value", "2val"))));
        Assertions.assertEquals((int)1, (int)terms.size(), (String)"Should only match once");
        Assertions.assertEquals((int)1, (int)((HighlightedTerm)terms.get(0)).getNumHighlights(), (String)"Incorrect number of highlights");
        Assertions.assertEquals((int)0, (int)((HighlightedTerm)terms.get(0)).getHighlightStart(0));
        Assertions.assertEquals((int)4, (int)((HighlightedTerm)terms.get(0)).getHighlightEnd(0));
        Assertions.assertEquals((Object)"val", (Object)builder.build().getEntry(0).getValue());
        Assertions.assertEquals((Object)"2val", (Object)builder.build().getEntry(0).getSecondValue());
        Assertions.assertEquals((Object)"nval", (Object)builder.build().getEntry(1).getValue());
        Assertions.assertEquals((Object)"2nval", (Object)builder.build().getEntry(1).getSecondValue());
        ThenKeyExpression primaryKey = Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]);
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        TestRecordsTextProto.MapDocument.Builder newBuilder = TestRecordsTextProto.MapDocument.newBuilder();
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord((KeyExpression)index, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (String)"entry_value", (String)"suggestion", (Tuple)Tuple.from((Object[])new Object[]{30, "r1"}));
        LuceneIndexKeyValueToPartialRecordUtils.populatePrimaryKey((KeyExpression)primaryKey, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (Tuple)Tuple.from((Object[])new Object[]{30, 7}));
        TestRecordsTextProto.MapDocument partialMsg = newBuilder.build();
        Assertions.assertEquals((int)1, (int)partialMsg.getEntryCount());
        TestRecordsTextProto.MapDocument.Entry entry = partialMsg.getEntry(0);
        Assertions.assertEquals((Object)"suggestion", (Object)entry.getValue());
        Assertions.assertFalse((boolean)entry.hasSecondValue());
        Assertions.assertEquals((Object)"r1", (Object)entry.getKey());
        Assertions.assertEquals((long)30L, (long)partialMsg.getGroup());
        Assertions.assertEquals((long)7L, (long)partialMsg.getDocId());
    }

    @Test
    void groupingMapWithExtra() {
        TestRecordsTextProto.MapDocument.Builder builder = TestRecordsTextProto.MapDocument.newBuilder().setDocId(8L).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("en").setValue("first").setSecondValue("second")).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("de").setValue("erste").setSecondValue("zweite")).setGroup(40L).setText2("extra");
        TestRecordsTextProto.MapDocument message = builder.build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        GroupingKeyExpression index = new GroupingKeyExpression((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"key"), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"value")), (KeyExpression[])new KeyExpression[]{Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"second_value"))})), (KeyExpression[])new KeyExpression[]{Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"))}), 3);
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[]{40, "en"}), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("entry_value", "first"), (Object)LuceneDocumentFromRecordTest.textField("entry_second_value", "second"), (Object)LuceneDocumentFromRecordTest.textField("text2", "extra")), (Object)Tuple.from((Object[])new Object[]{40, "de"}), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("entry_value", "erste"), (Object)LuceneDocumentFromRecordTest.textField("entry_second_value", "zweite"), (Object)LuceneDocumentFromRecordTest.textField("text2", "extra"))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
        List terms = LuceneHighlighting.highlightedTermsForMessage(record, (Message)message, null, (KeyExpression)index, Map.of("entry_second_value", Set.of("second")), (LuceneAnalyzerCombinationProvider)this.analyzerProvider, (LuceneScanQueryParameters.LuceneQueryHighlightParameters)new LuceneScanQueryParameters.LuceneQueryHighlightParameters(-1, 10, (Query)new TermQuery(new Term("entry_second_value", "second"))));
        Assertions.assertEquals((int)1, (int)terms.size(), (String)"Should only match once");
        Assertions.assertEquals((int)1, (int)((HighlightedTerm)terms.get(0)).getNumHighlights(), (String)"Incorrect number of highlights");
        Assertions.assertEquals((int)0, (int)((HighlightedTerm)terms.get(0)).getHighlightStart(0));
        Assertions.assertEquals((int)6, (int)((HighlightedTerm)terms.get(0)).getHighlightEnd(0));
        Assertions.assertEquals((Object)"first", (Object)builder.build().getEntry(0).getValue());
        Assertions.assertEquals((Object)"second", (Object)builder.build().getEntry(0).getSecondValue());
        Assertions.assertEquals((Object)"erste", (Object)builder.build().getEntry(1).getValue());
        Assertions.assertEquals((Object)"zweite", (Object)builder.build().getEntry(1).getSecondValue());
        ThenKeyExpression primaryKey = Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]);
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        TestRecordsTextProto.MapDocument.Builder newBuilder = TestRecordsTextProto.MapDocument.newBuilder();
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord((KeyExpression)index, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (String)"entry_second_value", (String)"suggestion", (Tuple)Tuple.from((Object[])new Object[]{40, "en"}));
        LuceneIndexKeyValueToPartialRecordUtils.populatePrimaryKey((KeyExpression)primaryKey, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (Tuple)Tuple.from((Object[])new Object[]{40, 8}));
        TestRecordsTextProto.MapDocument partialMsg = newBuilder.build();
        Assertions.assertEquals((int)1, (int)partialMsg.getEntryCount());
        TestRecordsTextProto.MapDocument.Entry entry = partialMsg.getEntry(0);
        Assertions.assertEquals((Object)"suggestion", (Object)entry.getSecondValue());
        Assertions.assertFalse((boolean)entry.hasValue());
        Assertions.assertEquals((Object)"en", (Object)entry.getKey());
        Assertions.assertEquals((long)40L, (long)partialMsg.getGroup());
        Assertions.assertEquals((long)8L, (long)partialMsg.getDocId());
    }

    @Test
    void mapWithSubMessage() {
        TestRecordsTextProto.NestedMapDocument.Builder builder = TestRecordsTextProto.NestedMapDocument.newBuilder().setDocId(5L).setGroup(50L).addEntry(TestRecordsTextProto.NestedMapDocument.Entry.newBuilder().setKey("k1").setSubEntry(TestRecordsTextProto.NestedMapDocument.SubEntry.newBuilder().setValue("testValue").build()).build());
        TestRecordsTextProto.NestedMapDocument message = builder.build();
        NestingKeyExpression index = Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"sub_entry").nest((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"value")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"second_value")), (KeyExpression[])new KeyExpression[0])), (KeyExpression)Key.Expressions.field((String)"key"), (KeyExpression[])new KeyExpression[0])));
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[0]), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("entry_k1_value", "testValue"))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
        List terms = LuceneHighlighting.highlightedTermsForMessage(record, (Message)message, null, (KeyExpression)index, Map.of("entry_k1_value", Set.of("testvalue")), (LuceneAnalyzerCombinationProvider)this.analyzerProvider, (LuceneScanQueryParameters.LuceneQueryHighlightParameters)new LuceneScanQueryParameters.LuceneQueryHighlightParameters(-1, 10, (Query)new TermQuery(new Term("entry_k1_value", "testvalue"))));
        Assertions.assertEquals((int)1, (int)terms.size(), (String)"Should only match once");
        Assertions.assertEquals((int)1, (int)((HighlightedTerm)terms.get(0)).getNumHighlights(), (String)"Incorrect number of highlights");
        Assertions.assertEquals((int)0, (int)((HighlightedTerm)terms.get(0)).getHighlightStart(0));
        Assertions.assertEquals((int)9, (int)((HighlightedTerm)terms.get(0)).getHighlightEnd(0));
        Assertions.assertEquals((Object)"testValue", (Object)builder.build().getEntry(0).getSubEntry().getValue());
        ThenKeyExpression primaryKey = Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]);
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        TestRecordsTextProto.NestedMapDocument.Builder newBuilder = TestRecordsTextProto.NestedMapDocument.newBuilder();
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord((KeyExpression)index, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (String)"entry_k1_value", (String)"suggestion");
        LuceneIndexKeyValueToPartialRecordUtils.populatePrimaryKey((KeyExpression)primaryKey, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)newBuilder, (Tuple)Tuple.from((Object[])new Object[]{50, 5}));
        TestRecordsTextProto.NestedMapDocument partialMsg = newBuilder.build();
        Assertions.assertEquals((int)1, (int)partialMsg.getEntryCount());
        TestRecordsTextProto.NestedMapDocument.Entry entry = partialMsg.getEntry(0);
        Assertions.assertEquals((Object)"k1", (Object)entry.getKey());
        TestRecordsTextProto.NestedMapDocument.SubEntry subEntry = entry.getSubEntry();
        Assertions.assertEquals((Object)"suggestion", (Object)subEntry.getValue());
        Assertions.assertFalse((boolean)subEntry.hasSecondValue());
        Assertions.assertEquals((long)50L, (long)partialMsg.getGroup());
        Assertions.assertEquals((long)5L, (long)partialMsg.getDocId());
    }

    @Test
    void mapWithSubMessageWithAmbiguity() {
        TestRecordsTextProto.NestedMapDocument message = TestRecordsTextProto.NestedMapDocument.newBuilder().setDocId(5L).setGroup(60L).addEntry(TestRecordsTextProto.NestedMapDocument.Entry.newBuilder().setKey("k1").setSubEntry(TestRecordsTextProto.NestedMapDocument.SubEntry.newBuilder().setSecondValue("testValue").build()).build()).build();
        NestingKeyExpression index = Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"sub_entry").nest((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"value")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"second_value")), (KeyExpression[])new KeyExpression[0])), (KeyExpression)Key.Expressions.field((String)"key"), (KeyExpression[])new KeyExpression[0])));
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[0]), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("entry_k1_second_value", "testValue"))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
        ThenKeyExpression primaryKey = Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"group"), (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]);
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        TestRecordsTextProto.NestedMapDocument.Builder builder = TestRecordsTextProto.NestedMapDocument.newBuilder();
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord((KeyExpression)index, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)builder, (String)"entry_k1_second_value", (String)"suggestion");
        LuceneIndexKeyValueToPartialRecordUtils.populatePrimaryKey((KeyExpression)primaryKey, (Descriptors.Descriptor)recordDescriptor, (Message.Builder)builder, (Tuple)Tuple.from((Object[])new Object[]{60, 5}));
        TestRecordsTextProto.NestedMapDocument partialMsg = builder.build();
        Assertions.assertEquals((int)1, (int)partialMsg.getEntryCount());
        TestRecordsTextProto.NestedMapDocument.Entry entry = partialMsg.getEntry(0);
        Assertions.assertEquals((Object)"k1_second", (Object)entry.getKey());
        TestRecordsTextProto.NestedMapDocument.SubEntry subEntry = entry.getSubEntry();
        Assertions.assertEquals((Object)"suggestion", (Object)subEntry.getValue());
        Assertions.assertFalse((boolean)subEntry.hasSecondValue());
        Assertions.assertEquals((long)60L, (long)partialMsg.getGroup());
        Assertions.assertEquals((long)5L, (long)partialMsg.getDocId());
    }

    @Test
    void simpleWithFieldConfigs() {
        TestRecordsTextProto.SimpleDocument message = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(1L).setGroup(70L).setText("some text").build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        FunctionKeyExpression index = Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"text"), (KeyExpression)Key.Expressions.function((String)"lucene_full_text_field_index_options", (KeyExpression)Key.Expressions.value((Object)LuceneFunctionNames.LuceneFieldIndexOptions.DOCS.name())), (KeyExpression[])new KeyExpression[0]));
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[0]), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("text", "some text", (Map<String, Object>)ImmutableMap.of((Object)"lucene_full_text_field_index_options", (Object)LuceneFunctionNames.LuceneFieldIndexOptions.DOCS.name())))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
    }

    @Test
    void groupWithFieldConfigs() {
        TestRecordsTextProto.SimpleDocument message = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(2L).setText("more text").setGroup(2L).build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        GroupingKeyExpression index = Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]);
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[]{2}), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("text", "more text"))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
    }

    @Test
    void mapWithFieldConfigs() {
        TestRecordsTextProto.MapDocument message = TestRecordsTextProto.MapDocument.newBuilder().setDocId(5L).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("k1").setValue("v1")).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("k2").setValue("v2")).build();
        FDBRecord<Message> record = LuceneDocumentFromRecordTest.unstoredRecord((Message)message);
        FunctionKeyExpression index = Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"value"), (KeyExpression)Key.Expressions.function((String)"lucene_full_text_field_with_term_vectors", (KeyExpression)Key.Expressions.value((Object)true)), (KeyExpression[])new KeyExpression[]{Key.Expressions.function((String)"lucene_full_text_field_with_term_vector_positions", (KeyExpression)Key.Expressions.value((Object)true))})), (KeyExpression)Key.Expressions.field((String)"key"), (KeyExpression[])new KeyExpression[0]))), (KeyExpression)Key.Expressions.value(null), (KeyExpression[])new KeyExpression[0]));
        ImmutableMap expectedConfigs = ImmutableMap.of((Object)"lucene_full_text_field_with_term_vectors", (Object)true, (Object)"lucene_full_text_field_with_term_vector_positions", (Object)true);
        Assertions.assertEquals((Object)ImmutableMap.of((Object)Tuple.from((Object[])new Object[0]), (Object)ImmutableList.of((Object)LuceneDocumentFromRecordTest.textField("k1", "v1", (Map<String, Object>)expectedConfigs), (Object)LuceneDocumentFromRecordTest.textField("k2", "v2", (Map<String, Object>)expectedConfigs))), (Object)LuceneDocumentFromRecord.getRecordFields((KeyExpression)index, record));
    }

    private static FDBRecord<Message> unstoredRecord(Message message) {
        return new UnstoredRecord(message);
    }

    private static LuceneDocumentFromRecord.DocumentField documentField(String name, @Nullable Object value, LuceneIndexExpressions.DocumentFieldType type, boolean stored, boolean sorted, @Nonnull Map<String, Object> fieldConfigs) {
        return new LuceneDocumentFromRecord.DocumentField(name, value, type, stored, sorted, fieldConfigs);
    }

    private static LuceneDocumentFromRecord.DocumentField stringField(String name, String value) {
        return LuceneDocumentFromRecordTest.documentField(name, value, LuceneIndexExpressions.DocumentFieldType.STRING, false, false, Collections.emptyMap());
    }

    private static LuceneDocumentFromRecord.DocumentField textField(String name, String value) {
        return LuceneDocumentFromRecordTest.textField(name, value, Collections.emptyMap());
    }

    private static LuceneDocumentFromRecord.DocumentField textField(String name, String value, Map<String, Object> fieldConfigs) {
        return LuceneDocumentFromRecordTest.documentField(name, value, LuceneIndexExpressions.DocumentFieldType.TEXT, false, false, fieldConfigs);
    }

    private static LuceneDocumentFromRecord.DocumentField intField(String name, int value) {
        return LuceneDocumentFromRecordTest.documentField(name, value, LuceneIndexExpressions.DocumentFieldType.INT, false, false, Collections.emptyMap());
    }
}

