/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.ArrayUtil;

public final class CjkUnigramFilter
extends TokenFilter {
    public static final String SINGLE_TYPE = "<SINGLE>";
    private static final String HAN_TYPE = StandardTokenizer.TOKEN_TYPES[3];
    private static final String HIRAGANA_TYPE = StandardTokenizer.TOKEN_TYPES[4];
    private static final String KATAKANA_TYPE = StandardTokenizer.TOKEN_TYPES[5];
    private static final String HANGUL_TYPE = StandardTokenizer.TOKEN_TYPES[6];
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    int[] buffer = new int[8];
    int[] startOffset = new int[8];
    int[] endOffset = new int[8];
    int bufferLen;
    int index;
    int lastEndOffset;
    private boolean exhausted;

    public CjkUnigramFilter(TokenStream in) {
        super(in);
    }

    public boolean incrementToken() throws IOException {
        while (true) {
            if (this.hasBufferedUnigram()) {
                this.flushUnigram();
                return true;
            }
            if (!this.doNext()) {
                return false;
            }
            if (!this.isCjkType(this.typeAtt.type())) {
                return true;
            }
            this.refill();
        }
    }

    private boolean isCjkType(String type) {
        return HAN_TYPE.equals(type) || HIRAGANA_TYPE.equals(type) || KATAKANA_TYPE.equals(type) || HANGUL_TYPE.equals(type);
    }

    private boolean doNext() throws IOException {
        if (this.exhausted) {
            return false;
        }
        if (this.input.incrementToken()) {
            return true;
        }
        this.exhausted = true;
        return false;
    }

    private void refill() {
        int end;
        if (this.bufferLen > 64) {
            int last = this.bufferLen - 1;
            this.buffer[0] = this.buffer[last];
            this.startOffset[0] = this.startOffset[last];
            this.endOffset[0] = this.endOffset[last];
            this.bufferLen = 1;
            this.index -= last;
        }
        char[] termBuffer = this.termAtt.buffer();
        int len = this.termAtt.length();
        int newSize = this.bufferLen + len;
        this.buffer = ArrayUtil.grow((int[])this.buffer, (int)newSize);
        this.startOffset = ArrayUtil.grow((int[])this.startOffset, (int)newSize);
        this.endOffset = ArrayUtil.grow((int[])this.endOffset, (int)newSize);
        int start = this.offsetAtt.startOffset();
        this.lastEndOffset = end = this.offsetAtt.endOffset();
        if (end - start != len) {
            int cp;
            for (int i = 0; i < len; i += Character.charCount(cp)) {
                cp = this.buffer[this.bufferLen] = Character.codePointAt(termBuffer, i, len);
                this.startOffset[this.bufferLen] = start;
                this.endOffset[this.bufferLen] = end;
                ++this.bufferLen;
            }
        } else {
            int cpLen;
            for (int i = 0; i < len; i += cpLen) {
                int cp = this.buffer[this.bufferLen] = Character.codePointAt(termBuffer, i, len);
                cpLen = Character.charCount(cp);
                this.startOffset[this.bufferLen] = start;
                start = this.endOffset[this.bufferLen] = start + cpLen;
                ++this.bufferLen;
            }
        }
    }

    private void flushUnigram() {
        this.clearAttributes();
        char[] termBuffer = this.termAtt.resizeBuffer(2);
        int len = Character.toChars(this.buffer[this.index], termBuffer, 0);
        this.termAtt.setLength(len);
        this.offsetAtt.setOffset(this.startOffset[this.index], this.endOffset[this.index]);
        this.typeAtt.setType(SINGLE_TYPE);
        ++this.index;
    }

    private boolean hasBufferedUnigram() {
        return this.bufferLen - this.index > 0;
    }

    public void reset() throws IOException {
        super.reset();
        this.bufferLen = 0;
        this.index = 0;
        this.lastEndOffset = 0;
        this.exhausted = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CjkUnigramFilter that = (CjkUnigramFilter)((Object)o);
        return this.bufferLen == that.bufferLen && this.index == that.index && this.lastEndOffset == that.lastEndOffset && this.exhausted == that.exhausted && this.termAtt.equals(that.termAtt) && this.typeAtt.equals(that.typeAtt) && this.offsetAtt.equals(that.offsetAtt) && Arrays.equals(this.buffer, that.buffer) && Arrays.equals(this.startOffset, that.startOffset) && Arrays.equals(this.endOffset, that.endOffset);
    }

    static boolean isUnigramTokenType(String type) {
        return SINGLE_TYPE.equals(type);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.buffer), Arrays.hashCode(this.startOffset), Arrays.hashCode(this.endOffset), this.termAtt, this.typeAtt, this.offsetAtt, this.bufferLen, this.index, this.lastEndOffset, this.exhausted);
    }
}

