/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneSerializer.class);
    private static final int ENCODING_ENCRYPTED = 1;
    private static final int ENCODING_COMPRESSED = 2;
    private static final byte COMPRESSION_VERSION_FOR_HIGH_COMPRESSION = 0;

    @Nullable
    public static byte[] encode(@Nullable byte[] data, boolean compress, boolean encrypt) {
        if (data == null) {
            return null;
        }
        EncodingState state = new EncodingState();
        ByteBuffersDataOutput decodedDataOutput = new ByteBuffersDataOutput();
        decodedDataOutput.writeByte((byte)0);
        byte[] encoded = LuceneSerializer.compressIfNeeded(compress, data, decodedDataOutput, state, 1);
        int code = 0;
        if (state.isCompressed()) {
            code |= 2;
        }
        if (state.isEncrypted()) {
            code |= 1;
        }
        encoded[0] = (byte)code;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(KeyValueLogMessage.of((String)"Encoded lucene data", (Object[])new Object[]{LuceneLogMessageKeys.COMPRESSION_SUPPOSED, compress, LuceneLogMessageKeys.ENCRYPTION_SUPPOSED, encrypt, LuceneLogMessageKeys.COMPRESSED_EVENTUALLY, state.isCompressed(), LuceneLogMessageKeys.ENCRYPTED_EVENTUALLY, state.isEncrypted(), LuceneLogMessageKeys.ORIGINAL_DATA_SIZE, data.length, LuceneLogMessageKeys.ENCODED_DATA_SIZE, encoded.length}));
        }
        return encoded;
    }

    @Nullable
    public static byte[] decode(@Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length < 2) {
            throw new RecordCoreException("Invalid data", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.DATA_VALUE, data});
        }
        byte encoding = data[0];
        boolean encrypted = (encoding & 1) == 1;
        boolean compressed = (encoding & 2) == 2;
        byte[] decoded = LuceneSerializer.decompressIfNeeded(compressed, data, 1);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(KeyValueLogMessage.of((String)"Decoded lucene data", (Object[])new Object[]{LuceneLogMessageKeys.COMPRESSED_EVENTUALLY, compressed, LuceneLogMessageKeys.ENCRYPTED_EVENTUALLY, encrypted, LuceneLogMessageKeys.ENCODED_DATA_SIZE, data.length, LuceneLogMessageKeys.ORIGINAL_DATA_SIZE, decoded.length}));
        }
        return decoded;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private static byte[] compressIfNeeded(boolean compressionNeeded, @Nonnull byte[] data, @Nonnull ByteBuffersDataOutput encodedDataOutput, @Nonnull EncodingState state, int offset) {
        if (!compressionNeeded) {
            return LuceneSerializer.fallBackToUncompressed(encodedDataOutput.toArrayCopy(), data, state, offset);
        }
        try (Compressor compressor = CompressionMode.HIGH_COMPRESSION.newCompressor();){
            encodedDataOutput.writeByte((byte)0);
            encodedDataOutput.writeVInt(data.length);
            compressor.compress(data, 0, data.length, (DataOutput)encodedDataOutput);
            byte[] compressedData = encodedDataOutput.toArrayCopy();
            if (compressedData.length < data.length) {
                state.setCompressed(true);
                byte[] byArray2 = compressedData;
                return byArray2;
            }
            byte[] byArray = LuceneSerializer.fallBackToUncompressed(compressedData, data, state, offset);
            return byArray;
        }
        catch (Exception e) {
            throw new RecordCoreException("Lucene data compression failure", (Throwable)e);
        }
    }

    private static byte[] fallBackToUncompressed(@Nonnull byte[] compressedData, @Nonnull byte[] originalData, @Nonnull EncodingState state, int offset) {
        state.setCompressed(false);
        byte[] encoded = new byte[originalData.length + offset];
        System.arraycopy(compressedData, 0, encoded, 0, offset);
        System.arraycopy(originalData, 0, encoded, offset, originalData.length);
        return encoded;
    }

    @Nonnull
    private static byte[] decompressIfNeeded(boolean decompressionNeeded, @Nonnull byte[] data, int offset) {
        if (!decompressionNeeded) {
            return Arrays.copyOfRange(data, offset, data.length);
        }
        if (data.length < 2 + offset) {
            throw new RecordCoreException("Invalid data for decompression", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.DIR_VALUE, data});
        }
        byte version = data[offset];
        if (version != 0) {
            throw new RecordCoreException("Un-supported compression version", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.COMPRESSION_VERSION, version});
        }
        try {
            BytesRef ref = new BytesRef();
            ByteArrayDataInput input = new ByteArrayDataInput(data, offset + 1, data.length - offset - 1);
            int originalLength = input.readVInt();
            Decompressor decompressor = CompressionMode.HIGH_COMPRESSION.newDecompressor();
            decompressor.decompress((DataInput)input, originalLength, 0, originalLength, ref);
            return Arrays.copyOfRange(ref.bytes, ref.offset, ref.length);
        }
        catch (Exception e) {
            throw new RecordCoreException("Lucene data decompression failure", (Throwable)e);
        }
    }

    private static class EncodingState {
        private boolean compressed = false;
        private boolean encrypted = false;

        private EncodingState() {
        }

        void setCompressed(boolean compressed) {
            this.compressed = compressed;
        }

        void setEncrypted(boolean encrypted) {
            this.encrypted = encrypted;
        }

        boolean isCompressed() {
            return this.compressed;
        }

        boolean isEncrypted() {
            return this.encrypted;
        }
    }
}

