/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.lucene.LuceneAnalyzerWrapper;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneLoggerInfoStream;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.codec.LazyCloseable;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedCodec;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectorySharedCacheManager;
import com.apple.foundationdb.record.lucene.directory.FDBTieredMergePolicy;
import com.apple.foundationdb.record.lucene.directory.MergeUtils;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexDeferredMaintenanceControl;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.StandardDirectoryReaderOptimization;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FDBDirectoryWrapper
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBDirectoryWrapper.class);
    private static final Codec CODEC = LuceneOptimizedCodec.CODEC;
    public static final boolean USE_COMPOUND_FILE = true;
    private final IndexMaintainerState state;
    private final FDBDirectory directory;
    private final int mergeDirectoryCount;
    private final AgilityContext agilityContext;
    private final Tuple key;
    @Nonnull
    private final LuceneAnalyzerWrapper analyzerWrapper;
    private volatile boolean useWriter = false;
    private final LazyCloseable<IndexWriter> writer;
    private final LazyCloseable<DirectoryReader> writerReader;

    FDBDirectoryWrapper(@Nonnull IndexMaintainerState state, @Nonnull Tuple key, int mergeDirectoryCount, @Nonnull AgilityContext agilityContext, int blockCacheMaximumSize, @Nonnull LuceneAnalyzerWrapper analyzerWrapper, @Nullable Exception exceptionAtCreation) {
        this.state = state;
        this.key = key;
        this.directory = this.createFDBDirectory(state, key, agilityContext, blockCacheMaximumSize);
        this.agilityContext = agilityContext;
        this.mergeDirectoryCount = mergeDirectoryCount;
        this.analyzerWrapper = analyzerWrapper;
        this.writer = LazyCloseable.supply(() -> this.createIndexWriter(exceptionAtCreation));
        this.writerReader = LazyCloseable.supply(() -> DirectoryReader.open((IndexWriter)this.writer.get()));
    }

    @VisibleForTesting
    public FDBDirectoryWrapper(@Nonnull IndexMaintainerState state, @Nonnull FDBDirectory directory, @Nonnull Tuple key, int mergeDirectoryCount, @Nonnull AgilityContext agilityContext, @Nonnull LuceneAnalyzerWrapper analyzerWrapper, @Nullable Exception exceptionAtCreation) {
        this.state = state;
        this.key = key;
        this.directory = directory;
        this.agilityContext = agilityContext;
        this.mergeDirectoryCount = mergeDirectoryCount;
        this.analyzerWrapper = analyzerWrapper;
        this.writer = LazyCloseable.supply(() -> this.createIndexWriter(exceptionAtCreation));
        this.writerReader = LazyCloseable.supply(() -> DirectoryReader.open((IndexWriter)this.writer.get()));
    }

    @Nonnull
    private IndexWriter createIndexWriter(Exception exceptionAtCreation) throws IOException {
        this.useWriter = true;
        IndexDeferredMaintenanceControl mergeControl = this.state.store.getIndexDeferredMaintenanceControl();
        TieredMergePolicy tieredMergePolicy = new FDBTieredMergePolicy(mergeControl, this.agilityContext, this.state.indexSubspace, this.key, exceptionAtCreation).setMaxMergedSegmentMB((Double)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_MERGE_MAX_SIZE)).setSegmentsPerTier(((Double)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER)).doubleValue());
        tieredMergePolicy.setNoCFSRatio(1.0);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzerWrapper.getAnalyzer()).setUseCompoundFile(true).setMergePolicy((MergePolicy)tieredMergePolicy).setMergeScheduler(this.getMergeScheduler(this.state, this.mergeDirectoryCount, this.agilityContext, this.key)).setCodec(CODEC).setInfoStream((InfoStream)new LuceneLoggerInfoStream(LOGGER));
        mergeControl.setMergeRequiredIndexes(this.state.index);
        return new IndexWriter((Directory)this.directory, indexWriterConfig);
    }

    @Nonnull
    protected FDBDirectory createFDBDirectory(IndexMaintainerState state, Tuple key, AgilityContext agilityContext, int blockCacheMaximumSize) {
        Subspace subspace = state.indexSubspace.subspace(key);
        FDBDirectorySharedCacheManager sharedCacheManager = FDBDirectorySharedCacheManager.forContext(state.context);
        Tuple sharedCacheKey = sharedCacheManager == null ? null : (sharedCacheManager.getSubspace() == null ? state.store.getSubspace().unpack(subspace.pack()) : sharedCacheManager.getSubspace().unpack(subspace.pack()));
        return this.createFDBDirectory(subspace, state.index.getOptions(), sharedCacheManager, sharedCacheKey, true, agilityContext, blockCacheMaximumSize);
    }

    @Nonnull
    protected FDBDirectory createFDBDirectory(Subspace subspace, Map<String, String> options, FDBDirectorySharedCacheManager sharedCacheManager, Tuple sharedCacheKey, boolean useCompoundFile, AgilityContext agilityContext, int blockCacheMaximumSize) {
        return new FDBDirectory(subspace, options, sharedCacheManager, sharedCacheKey, useCompoundFile, agilityContext, blockCacheMaximumSize);
    }

    public FDBDirectory getDirectory() {
        return this.directory;
    }

    public IndexReader getReader() throws IOException {
        if (this.useWriter) {
            return DirectoryReader.open((IndexWriter)this.writer.get());
        }
        return StandardDirectoryReaderOptimization.open(this.directory, null, null, this.state.context.getExecutor(), (Integer)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_OPEN_PARALLELISM));
    }

    public DirectoryReader getWriterReader() throws IOException {
        return this.writerReader.get();
    }

    private MergeScheduler getMergeScheduler(@Nonnull IndexMaintainerState state, int mergeDirectoryCount, @Nonnull AgilityContext agilityContext, @Nonnull Tuple key) {
        Boolean useConcurrent = (Boolean)state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_USE_CONCURRENT_MERGE_SCHEDULER);
        return Boolean.TRUE.equals(useConcurrent) ? new FDBDirectoryMergeScheduler(state, mergeDirectoryCount, agilityContext, key) : new FDBDirectorySerialMergeScheduler(state, mergeDirectoryCount, agilityContext, key);
    }

    @Nonnull
    public IndexWriter getWriter() throws IOException {
        return this.writer.get();
    }

    @Override
    public synchronized void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.writer, this.writerReader, this.directory});
    }

    public void mergeIndex() throws IOException {
        this.getWriter().maybeMerge();
    }

    private static class FDBDirectoryMergeScheduler
    extends ConcurrentMergeScheduler {
        @Nonnull
        private final IndexMaintainerState state;
        private final int mergeDirectoryCount;
        @Nonnull
        private final AgilityContext agilityContext;
        @Nonnull
        private final Tuple key;

        private FDBDirectoryMergeScheduler(@Nonnull IndexMaintainerState state, int mergeDirectoryCount, @Nonnull AgilityContext agilityContext, @Nonnull Tuple key) {
            this.state = state;
            this.mergeDirectoryCount = mergeDirectoryCount;
            this.agilityContext = agilityContext;
            this.key = key;
        }

        public synchronized void merge(MergeScheduler.MergeSource mergeSource, MergeTrigger trigger) throws IOException {
            long startTime = System.nanoTime();
            if (((Boolean)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_MULTIPLE_MERGE_OPTIMIZATION_ENABLED)).booleanValue() && trigger == MergeTrigger.FULL_FLUSH) {
                if (ThreadLocalRandom.current().nextInt(this.mergeDirectoryCount) == 0) {
                    if (mergeSource.hasPendingMerges()) {
                        MergeUtils.logExecutingMerge(LOGGER, "Executing Merge Concurrently based on probability", this.agilityContext, this.state.indexSubspace, this.key, trigger);
                    }
                    super.merge(mergeSource, trigger);
                } else {
                    this.skipMerge(mergeSource);
                }
            } else {
                if (mergeSource.hasPendingMerges()) {
                    MergeUtils.logExecutingMerge(LOGGER, "Executing Merge Concurrently", this.agilityContext, this.state.indexSubspace, this.key, trigger);
                }
                super.merge(mergeSource, trigger);
            }
            this.state.context.record((StoreTimer.Event)LuceneEvents.Events.LUCENE_MERGE, System.nanoTime() - startTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void skipMerge(MergeScheduler.MergeSource mergeSource) {
            FDBDirectoryMergeScheduler fDBDirectoryMergeScheduler = this;
            synchronized (fDBDirectoryMergeScheduler) {
                MergePolicy.OneMerge nextMerge = mergeSource.getNextMerge();
                while (nextMerge != null) {
                    nextMerge.setAborted();
                    mergeSource.onMergeFinished(nextMerge);
                    nextMerge = mergeSource.getNextMerge();
                }
            }
        }
    }

    private static class FDBDirectorySerialMergeScheduler
    extends MergeScheduler {
        @Nonnull
        private final IndexMaintainerState state;
        private final int mergeDirectoryCount;
        @Nonnull
        private final AgilityContext agilityContext;
        @Nonnull
        private final Tuple key;

        private FDBDirectorySerialMergeScheduler(@Nonnull IndexMaintainerState state, int mergeDirectoryCount, @Nonnull AgilityContext agilityContext, @Nonnull Tuple key) {
            this.state = state;
            this.mergeDirectoryCount = mergeDirectoryCount;
            this.agilityContext = agilityContext;
            this.key = key;
        }

        public synchronized void merge(MergeScheduler.MergeSource mergeSource, MergeTrigger trigger) throws IOException {
            long startTime = System.nanoTime();
            if (((Boolean)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_MULTIPLE_MERGE_OPTIMIZATION_ENABLED)).booleanValue() && trigger == MergeTrigger.FULL_FLUSH) {
                if (ThreadLocalRandom.current().nextInt(this.mergeDirectoryCount) == 0) {
                    if (mergeSource.hasPendingMerges()) {
                        MergeUtils.logExecutingMerge(LOGGER, "Executing Merge based on probability", this.agilityContext, this.state.indexSubspace, this.key, trigger);
                    }
                    this.serialMerge(mergeSource, trigger);
                } else {
                    this.skipMerge(mergeSource);
                }
            } else {
                if (mergeSource.hasPendingMerges()) {
                    MergeUtils.logExecutingMerge(LOGGER, "Executing Merge", this.agilityContext, this.state.indexSubspace, this.key, trigger);
                }
                this.serialMerge(mergeSource, trigger);
            }
            this.state.context.record((StoreTimer.Event)LuceneEvents.Events.LUCENE_MERGE, System.nanoTime() - startTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void skipMerge(MergeScheduler.MergeSource mergeSource) {
            FDBDirectorySerialMergeScheduler fDBDirectorySerialMergeScheduler = this;
            synchronized (fDBDirectorySerialMergeScheduler) {
                MergePolicy.OneMerge nextMerge = mergeSource.getNextMerge();
                while (nextMerge != null) {
                    nextMerge.setAborted();
                    mergeSource.onMergeFinished(nextMerge);
                    nextMerge = mergeSource.getNextMerge();
                }
            }
        }

        void serialMerge(MergeScheduler.MergeSource mergeSource, MergeTrigger trigger) throws IOException {
            MergePolicy.OneMerge merge;
            while ((merge = mergeSource.getNextMerge()) != null) {
                mergeSource.merge(merge);
            }
        }

        public void close() {
        }
    }
}

