/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.KeyRange;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.cursors.ChainedCursor;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerCombinationProvider;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerRegistryImpl;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerWrapper;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.LucenePartitioner;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryWrapper;
import com.apple.foundationdb.record.lucene.directory.FDBTieredMergePolicy;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContextConfig;
import com.apple.foundationdb.record.provider.foundationdb.FDBTransactionPriority;
import com.apple.foundationdb.record.provider.foundationdb.IndexDeferredMaintenanceControl;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class FDBDirectoryManager
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBDirectoryManager.class);
    @Nonnull
    private final IndexMaintainerState state;
    @Nonnull
    private final Map<Tuple, FDBDirectoryWrapper> createdDirectories;
    private final int mergeDirectoryCount;
    @Nonnull
    protected final LuceneAnalyzerWrapper writerAnalyzer;
    @Nonnull
    private final LuceneAnalyzerCombinationProvider analyzerSelector;
    @Nullable
    protected final Exception exceptionAtCreation;

    protected FDBDirectoryManager(@Nonnull IndexMaintainerState state) {
        this.state = state;
        this.createdDirectories = new ConcurrentHashMap<Tuple, FDBDirectoryWrapper>();
        this.mergeDirectoryCount = this.getMergeDirectoryCount(state);
        this.exceptionAtCreation = FDBTieredMergePolicy.usesCreationStack() ? new Exception() : null;
        Map<String, LuceneIndexExpressions.DocumentFieldDerivation> fieldInfos = LuceneIndexExpressions.getDocumentFieldDerivations(state.index, state.store.getRecordMetaData());
        this.analyzerSelector = LuceneAnalyzerRegistryImpl.instance().getLuceneAnalyzerCombinationProvider(state.index, LuceneAnalyzerType.FULL_TEXT, fieldInfos);
        this.writerAnalyzer = this.analyzerSelector.provideIndexAnalyzer();
    }

    @Override
    public synchronized void close() throws IOException {
        for (FDBDirectoryWrapper directory : this.createdDirectories.values()) {
            directory.close();
        }
        this.createdDirectories.clear();
    }

    @Nonnull
    public LuceneAnalyzerCombinationProvider getAnalyzerSelector() {
        return this.analyzerSelector;
    }

    public CompletableFuture<Void> mergeIndex(@Nonnull LucenePartitioner partitioner) {
        ScanProperties scanProperties = ScanProperties.FORWARD_SCAN.with(props -> props.clearState().setReturnedRowLimit(1));
        Range range = this.state.indexSubspace.range();
        KeyRange keyRange = new KeyRange(range.begin, range.end);
        Subspace subspace = this.state.indexSubspace;
        KeyExpression rootExpression = this.state.index.getRootExpression();
        AgilityContext agilityContext = this.getAgilityContext(true, false);
        if (!(rootExpression instanceof GroupingKeyExpression)) {
            return this.mergeIndex(TupleHelpers.EMPTY, partitioner, agilityContext).whenComplete((ignore, ex) -> FDBDirectoryManager.closeOrAbortAgilityContext(agilityContext, ex));
        }
        GroupingKeyExpression expression = (GroupingKeyExpression)rootExpression;
        int groupingCount = expression.getGroupingCount();
        ChainedCursor cursor = new ChainedCursor(this.state.context, lastKey -> agilityContext.apply(context -> FDBDirectoryManager.nextTuple(context, subspace, keyRange, lastKey, scanProperties, groupingCount)), Tuple::pack, Tuple::fromBytes, null, ScanProperties.FORWARD_SCAN);
        return cursor.map(tuple -> Tuple.fromItems(tuple.getItems().subList(0, groupingCount))).forEachAsync(groupingKey -> this.mergeIndex((Tuple)groupingKey, partitioner, agilityContext), 1).whenComplete((ignore, ex) -> FDBDirectoryManager.closeOrAbortAgilityContext(agilityContext, ex));
    }

    private CompletableFuture<Void> mergeIndex(Tuple groupingKey, @Nonnull LucenePartitioner partitioner, AgilityContext agileContext) {
        if (!partitioner.isPartitioningEnabled()) {
            agileContext.flush();
            this.mergeIndexNow(groupingKey, null);
            return AsyncUtil.DONE;
        }
        AtomicReference lastPartitionInfo = new AtomicReference();
        return AsyncUtil.whileTrue(() -> this.getNextOlderPartitionInfo(groupingKey, agileContext, lastPartitionInfo).thenApply(partitionId -> {
            if (partitionId == null) {
                return false;
            }
            agileContext.flush();
            this.mergeIndexNow(groupingKey, (Integer)partitionId);
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeIndexNow(Tuple groupingKey, @Nullable Integer partitionId) {
        AgilityContext agilityContext = this.getAgilityContext(true, true);
        try {
            this.mergeIndexWithContext(groupingKey, partitionId, agilityContext);
        }
        finally {
            agilityContext.flushAndClose();
        }
    }

    public void mergeIndexWithContext(@Nonnull Tuple groupingKey, @Nullable Integer partitionId, @Nonnull AgilityContext agilityContext) {
        try (FDBDirectoryWrapper directoryWrapper = this.createDirectoryWrapper(groupingKey, partitionId, agilityContext);){
            try {
                directoryWrapper.mergeIndex();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(KeyValueLogMessage.of((String)"Lucene merge success", (Object[])new Object[]{LuceneLogMessageKeys.GROUP, groupingKey, LuceneLogMessageKeys.INDEX_PARTITION, partitionId}));
                }
            }
            catch (IOException e) {
                throw LuceneExceptions.toRecordCoreException("Lucene mergeIndex failed", e, new Object[]{LuceneLogMessageKeys.GROUP, groupingKey, LuceneLogMessageKeys.INDEX_PARTITION, partitionId});
            }
        }
        catch (IOException e) {
            throw LuceneExceptions.toRecordCoreException("Lucene mergeIndex close failed", e, new Object[]{LuceneLogMessageKeys.GROUP, groupingKey, LuceneLogMessageKeys.INDEX_PARTITION, partitionId});
        }
    }

    private static void closeOrAbortAgilityContext(AgilityContext agilityContext, Throwable ex) {
        if (ex == null) {
            agilityContext.flushAndClose();
        } else {
            agilityContext.abortAndClose();
        }
    }

    private CompletableFuture<Integer> getNextOlderPartitionInfo(Tuple groupingKey, AgilityContext agileContext, AtomicReference<LucenePartitionInfoProto.LucenePartitionInfo> lastPartitionInfo) {
        return agileContext.apply(context -> LucenePartitioner.getNextOlderPartitionInfo(context, groupingKey, lastPartitionInfo.get() == null ? null : LucenePartitioner.getPartitionKey((LucenePartitionInfoProto.LucenePartitionInfo)lastPartitionInfo.get()), this.state.indexSubspace).thenApply(partitionInfo -> {
            lastPartitionInfo.set((LucenePartitionInfoProto.LucenePartitionInfo)partitionInfo);
            return partitionInfo == null ? null : Integer.valueOf(partitionInfo.getId());
        }));
    }

    public static CompletableFuture<Optional<Tuple>> nextTuple(@Nonnull FDBRecordContext context, @Nonnull Subspace subspace, @Nonnull KeyRange range, @Nonnull Optional<Tuple> lastTuple, @Nonnull ScanProperties scanProperties, int groupingCount) {
        KeyValueCursor.Builder cursorBuilder = (KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace((Subspace)subspace).setContext(context)).setContinuation(null)).setScanProperties(scanProperties);
        if (lastTuple.isPresent()) {
            byte[] lowKey = subspace.pack(Tuple.fromItems(lastTuple.get().getItems().subList(0, groupingCount)));
            ((KeyValueCursor.Builder)cursorBuilder.setLow(lowKey, EndpointType.RANGE_EXCLUSIVE)).setHigh(range.getHighKey(), range.getHighEndpoint());
        } else {
            ((KeyValueCursor.Builder)cursorBuilder.setContext(context)).setRange(range);
        }
        return cursorBuilder.build().onNext().thenApply(next -> {
            KeyValue kv;
            if (next.hasNext() && (kv = (KeyValue)next.get()) != null) {
                return Optional.of(subspace.unpack(kv.getKey()));
            }
            return Optional.empty();
        });
    }

    public void invalidatePrefix(@Nonnull Tuple prefix) {
        Iterator<Map.Entry<Tuple, FDBDirectoryWrapper>> iterator = this.createdDirectories.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Tuple, FDBDirectoryWrapper> item = iterator.next();
            if (!TupleHelpers.isPrefix((Tuple)prefix, (Tuple)item.getKey())) continue;
            try {
                item.getValue().close();
            }
            catch (IOException e) {
                throw LuceneExceptions.toRecordCoreException("unable to close index writer", e, new Object[0]);
            }
            iterator.remove();
        }
    }

    private FDBDirectoryWrapper getDirectoryWrapper(@Nullable Tuple groupingKey, @Nullable Integer partitionId) {
        return this.getDirectoryWrapper(groupingKey, partitionId, this.getAgilityContext(false, false));
    }

    private FDBDirectoryWrapper getDirectoryWrapper(@Nullable Tuple groupingKey, @Nullable Integer partitionId, AgilityContext agilityContext) {
        Tuple mapKey = FDBDirectoryManager.getDirectoryKey(groupingKey, partitionId);
        return this.createdDirectories.computeIfAbsent(mapKey, key -> this.createNewDirectoryWrapper(this.state, (Tuple)key, this.mergeDirectoryCount, agilityContext, this.getBlockCacheMaximumSize()));
    }

    private FDBDirectoryWrapper createDirectoryWrapper(@Nullable Tuple groupingKey, @Nullable Integer partitionId, AgilityContext agilityContext) {
        return this.createNewDirectoryWrapper(this.state, FDBDirectoryManager.getDirectoryKey(groupingKey, partitionId), this.mergeDirectoryCount, agilityContext, this.getBlockCacheMaximumSize());
    }

    @Nonnull
    protected FDBDirectoryWrapper createNewDirectoryWrapper(IndexMaintainerState state, Tuple key, int mergeDirectoryCount, AgilityContext agilityContext, int blockCacheMaximumSize) {
        return new FDBDirectoryWrapper(state, key, mergeDirectoryCount, agilityContext, blockCacheMaximumSize, this.writerAnalyzer, this.exceptionAtCreation);
    }

    private int getBlockCacheMaximumSize() {
        return (Integer)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_BLOCK_CACHE_MAXIMUM_SIZE);
    }

    private static Tuple getDirectoryKey(@Nullable Tuple groupingKey, @Nullable Integer partitionId) {
        Tuple mapKey;
        Tuple tuple = mapKey = groupingKey == null ? TupleHelpers.EMPTY : groupingKey;
        if (partitionId != null) {
            mapKey = mapKey.add(1L).add((long)partitionId.intValue());
        }
        return mapKey;
    }

    private AgilityContext getAgilityContext(boolean useAgilityContext, boolean allowDefaultPriority) {
        boolean useDefaultPriorityDuringMerge;
        long sizeQuotaBytes;
        IndexDeferredMaintenanceControl deferredControl = this.state.store.getIndexDeferredMaintenanceControl();
        if (!useAgilityContext || Boolean.TRUE.equals(this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_AGILE_DISABLE_AGILITY_CONTEXT))) {
            deferredControl.setTimeQuotaMillis(0L);
            deferredControl.setSizeQuotaBytes(0L);
            return AgilityContext.nonAgile(this.state.context);
        }
        long timeQuotaMillis = deferredControl.getTimeQuotaMillis();
        if (timeQuotaMillis <= 0L) {
            timeQuotaMillis = Objects.requireNonNullElse((Integer)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_TIME_QUOTA), 4000).intValue();
            deferredControl.setTimeQuotaMillis(timeQuotaMillis);
        }
        if ((sizeQuotaBytes = deferredControl.getSizeQuotaBytes()) <= 0L) {
            sizeQuotaBytes = Objects.requireNonNullElse((Integer)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_SIZE_QUOTA), 900000).intValue();
            deferredControl.setSizeQuotaBytes(sizeQuotaBytes);
        }
        boolean bl = useDefaultPriorityDuringMerge = allowDefaultPriority && Objects.requireNonNullElse((Boolean)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_USE_DEFAULT_PRIORITY_DURING_MERGE), true) != false;
        if (useDefaultPriorityDuringMerge) {
            FDBRecordContextConfig.Builder contextBuilder = this.state.context.getConfig().toBuilder();
            contextBuilder.setPriority(FDBTransactionPriority.DEFAULT);
            return AgilityContext.agile(this.state.context, contextBuilder, timeQuotaMillis, sizeQuotaBytes);
        }
        return AgilityContext.agile(this.state.context, timeQuotaMillis, sizeQuotaBytes);
    }

    @Nonnull
    public FDBDirectory getDirectory(@Nullable Tuple groupingKey, @Nullable Integer partitionId) {
        return this.getDirectoryWrapper(groupingKey, partitionId).getDirectory();
    }

    public IndexReader getIndexReader(@Nullable Tuple groupingKey, @Nullable Integer partitionId) throws IOException {
        return this.getDirectoryWrapper(groupingKey, partitionId).getReader();
    }

    @Nonnull
    public IndexWriter getIndexWriter(@Nullable Tuple groupingKey, @Nullable Integer partitionId) throws IOException {
        return this.getDirectoryWrapper(groupingKey, partitionId).getWriter();
    }

    public DirectoryReader getWriterReader(@Nullable Tuple groupingKey, @Nullable Integer partititonId) throws IOException {
        return this.getDirectoryWrapper(groupingKey, partititonId).getWriterReader();
    }

    @Nonnull
    public static FDBDirectoryManager getManager(@Nonnull IndexMaintainerState state) {
        return FDBDirectoryManager.getOrCreateManager(state, () -> new FDBDirectoryManager(state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected static FDBDirectoryManager getOrCreateManager(@Nonnull IndexMaintainerState state, Supplier<FDBDirectoryManager> managerSupplier) {
        FDBRecordContext fDBRecordContext = state.context;
        synchronized (fDBRecordContext) {
            FDBRecordContext context = state.context;
            FDBDirectoryManager existing = (FDBDirectoryManager)context.getInSession((Object)state.indexSubspace, FDBDirectoryManager.class);
            if (existing != null) {
                return existing;
            }
            FDBDirectoryManager newManager = managerSupplier.get();
            context.putInSessionIfAbsent((Object)state.indexSubspace, (Object)newManager);
            context.addCommitCheck(() -> {
                try {
                    newManager.close();
                }
                catch (IOException e) {
                    throw LuceneExceptions.toRecordCoreException("unable to close directories", e, new Object[0]);
                }
                return AsyncUtil.DONE;
            });
            return newManager;
        }
    }

    private int getMergeDirectoryCount(@Nonnull IndexMaintainerState state) {
        return Math.toIntExact(state.store.getRecordMetaData().getAllIndexes().stream().filter(i -> "lucene".equals(i.getType())).count());
    }
}

