/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneFieldInfosProto;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedCompoundReader;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryUtils;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import com.apple.foundationdb.record.lucene.directory.FieldInfosStorage;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;

public class LuceneOptimizedFieldInfosFormat
extends FieldInfosFormat {
    public static final String EXTENSION = "fip";

    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext iocontext) throws IOException {
        try {
            String fileName = LuceneOptimizedFieldInfosFormat.getFileName(directory, segmentInfo, segmentSuffix);
            return this.read(directory, fileName);
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    @Nonnull
    @VisibleForTesting
    public FieldInfos read(Directory directory, String fileName) throws IOException {
        FieldInfosStorage fieldInfosStorage = FDBDirectoryUtils.getFDBDirectory(directory).getFieldInfosStorage();
        FDBLuceneFileReference fileReference = fieldInfosStorage.getFDBLuceneFileReference(fileName);
        long id = fileReference.getFieldInfosId();
        ByteString bitSetBytes = fileReference.getFieldInfosBitSet();
        if (bitSetBytes.isEmpty()) {
            return new FieldInfos(new FieldInfo[0]);
        }
        BitSet bitSet = BitSet.valueOf(bitSetBytes.toByteArray());
        LuceneFieldInfosProto.FieldInfos protobuf = fieldInfosStorage.readFieldInfos(id);
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        for (LuceneFieldInfosProto.FieldInfo fieldInfo : protobuf.getFieldInfoList()) {
            if (!bitSet.get(fieldInfo.getNumber())) continue;
            fieldInfos.add(new FieldInfo(fieldInfo.getName(), fieldInfo.getNumber(), fieldInfo.getStoreTermVectors(), fieldInfo.getOmitsNorms(), fieldInfo.getStorePayloads(), this.protoToLucene(fieldInfo.getIndexOptions()), this.protoToLucene(fieldInfo.getDocValues()), fieldInfo.getDocValuesGen(), this.protoToLucene(fieldInfo.getAttributesList()), fieldInfo.getPointDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), fieldInfo.getSoftDeletesField()));
        }
        return new FieldInfos(fieldInfos.toArray(new FieldInfo[0]));
    }

    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        try {
            String fileName = IndexFileNames.segmentFileName((String)segmentInfo.name, (String)segmentSuffix, (String)EXTENSION);
            directory.createOutput(fileName, context).close();
            this.write(directory, infos, fileName);
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    @VisibleForTesting
    public void write(Directory directory, FieldInfos infos, String fileName) throws IOException {
        long id;
        BitSet bitSet = new BitSet();
        LuceneFieldInfosProto.FieldInfos.Builder protobuf = this.luceneToProto(infos, bitSet);
        FieldInfosStorage fieldInfosStorage = FDBDirectoryUtils.getFDBDirectory(directory).getFieldInfosStorage();
        LuceneFieldInfosProto.FieldInfos globalFieldInfos = fieldInfosStorage.readGlobalFieldInfos();
        boolean globalNeedsUpdating = false;
        boolean canReuseGlobal = true;
        if (globalFieldInfos == null) {
            globalNeedsUpdating = true;
            globalFieldInfos = protobuf.build();
        } else {
            LuceneFieldInfosProto.FieldInfos.Builder globalFieldInfosBuilder = globalFieldInfos.toBuilder();
            Map globalFieldInfo = globalFieldInfosBuilder.getFieldInfoList().stream().collect(Collectors.toMap(LuceneFieldInfosProto.FieldInfo::getNumber, Function.identity()));
            for (LuceneFieldInfosProto.FieldInfo fieldInfo : protobuf.getFieldInfoList()) {
                LuceneFieldInfosProto.FieldInfo globalVersion = (LuceneFieldInfosProto.FieldInfo)globalFieldInfo.get(fieldInfo.getNumber());
                if (globalVersion == null) {
                    globalFieldInfosBuilder.addFieldInfo(fieldInfo);
                    globalNeedsUpdating = true;
                    continue;
                }
                if (globalVersion.equals(fieldInfo)) continue;
                if (this.sameExceptAttributesOrdering(globalVersion, fieldInfo)) {
                    globalFieldInfosBuilder.setFieldInfo(fieldInfo.getNumber(), fieldInfo);
                    globalNeedsUpdating = true;
                    continue;
                }
                canReuseGlobal = false;
                break;
            }
            if (canReuseGlobal && globalNeedsUpdating) {
                globalFieldInfos = globalFieldInfosBuilder.build();
            }
        }
        if (!canReuseGlobal) {
            id = fieldInfosStorage.writeFieldInfos(protobuf.build());
        } else {
            id = -2L;
            if (globalNeedsUpdating) {
                fieldInfosStorage.updateGlobalFieldInfos(globalFieldInfos);
            }
        }
        fieldInfosStorage.setFieldInfoId(directory, fileName, id, bitSet);
    }

    private boolean sameExceptAttributesOrdering(@Nonnull LuceneFieldInfosProto.FieldInfo globalVersion, @Nonnull LuceneFieldInfosProto.FieldInfo newVersion) {
        if (this.protoToLucene(globalVersion.getAttributesList()).equals(this.protoToLucene(newVersion.getAttributesList()))) {
            return globalVersion.toBuilder().clearAttributes().build().equals(newVersion.toBuilder().clearAttributes().build());
        }
        return false;
    }

    private Map<String, String> protoToLucene(List<LuceneFieldInfosProto.Attribute> attributesList) {
        return attributesList.stream().collect(Collectors.toUnmodifiableMap(LuceneFieldInfosProto.Attribute::getKey, LuceneFieldInfosProto.Attribute::getValue));
    }

    private DocValuesType protoToLucene(LuceneFieldInfosProto.DocValues docValues) {
        switch (docValues) {
            case NO_DOC_VALUES: {
                return DocValuesType.NONE;
            }
            case NUMERIC: {
                return DocValuesType.NUMERIC;
            }
            case BINARY: {
                return DocValuesType.BINARY;
            }
            case SORTED: {
                return DocValuesType.SORTED;
            }
            case SORTED_SET: {
                return DocValuesType.SORTED_SET;
            }
            case SORTED_NUMERIC: {
                return DocValuesType.SORTED_NUMERIC;
            }
        }
        throw LuceneOptimizedFieldInfosFormat.unexpectedEnumValue(docValues);
    }

    private IndexOptions protoToLucene(LuceneFieldInfosProto.IndexOptions indexOptions) {
        switch (indexOptions) {
            case NO_INDEX_OPTIONS: {
                return IndexOptions.NONE;
            }
            case DOCS: {
                return IndexOptions.DOCS;
            }
            case DOCS_AND_FREQS: {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        throw LuceneOptimizedFieldInfosFormat.unexpectedEnumValue(indexOptions);
    }

    private LuceneFieldInfosProto.FieldInfos.Builder luceneToProto(FieldInfos infos, BitSet bitSet) {
        LuceneFieldInfosProto.FieldInfos.Builder protobuf = LuceneFieldInfosProto.FieldInfos.newBuilder();
        for (FieldInfo fieldInfo : infos) {
            LuceneFieldInfosProto.FieldInfo.Builder builder = protobuf.addFieldInfoBuilder().setName(fieldInfo.name).setNumber(fieldInfo.number).setStoreTermVectors(fieldInfo.hasVectors()).setOmitsNorms(fieldInfo.omitsNorms()).setStorePayloads(fieldInfo.hasPayloads()).setIndexOptions(this.luceneToProto(fieldInfo.getIndexOptions())).setDocValues(this.luceneToProto(fieldInfo.getDocValuesType())).setDocValuesGen(fieldInfo.getDocValuesGen()).setPointDimensionCount(fieldInfo.getPointDimensionCount()).setPointIndexDimensionCount(fieldInfo.getPointIndexDimensionCount()).setPointNumBytes(fieldInfo.getPointNumBytes()).setSoftDeletesField(fieldInfo.isSoftDeletesField());
            fieldInfo.attributes().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(attribute -> builder.addAttributesBuilder().setKey(Objects.requireNonNull((String)attribute.getKey(), "FieldInfo attribute key")).setValue(Objects.requireNonNull((String)attribute.getValue(), "FieldInfo attribute value")));
            bitSet.set(fieldInfo.number);
        }
        return protobuf;
    }

    private LuceneFieldInfosProto.DocValues luceneToProto(DocValuesType docValuesType) {
        switch (docValuesType) {
            case NONE: {
                return LuceneFieldInfosProto.DocValues.NO_DOC_VALUES;
            }
            case NUMERIC: {
                return LuceneFieldInfosProto.DocValues.NUMERIC;
            }
            case BINARY: {
                return LuceneFieldInfosProto.DocValues.BINARY;
            }
            case SORTED: {
                return LuceneFieldInfosProto.DocValues.SORTED;
            }
            case SORTED_NUMERIC: {
                return LuceneFieldInfosProto.DocValues.SORTED_NUMERIC;
            }
            case SORTED_SET: {
                return LuceneFieldInfosProto.DocValues.SORTED_SET;
            }
        }
        throw LuceneOptimizedFieldInfosFormat.unexpectedEnumValue(docValuesType);
    }

    private LuceneFieldInfosProto.IndexOptions luceneToProto(IndexOptions indexOptions) {
        switch (indexOptions) {
            case NONE: {
                return LuceneFieldInfosProto.IndexOptions.NO_INDEX_OPTIONS;
            }
            case DOCS: {
                return LuceneFieldInfosProto.IndexOptions.DOCS;
            }
            case DOCS_AND_FREQS: {
                return LuceneFieldInfosProto.IndexOptions.DOCS_AND_FREQS;
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return LuceneFieldInfosProto.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return LuceneFieldInfosProto.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        throw LuceneOptimizedFieldInfosFormat.unexpectedEnumValue(indexOptions);
    }

    @Nonnull
    private static <T extends Enum<T>> RecordCoreException unexpectedEnumValue(T enumValue) {
        return new RecordCoreException("Unexpected enum value", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.NAME, enumValue});
    }

    @Nullable
    private static String getFileName(Directory directory, SegmentInfo segmentInfo, String segmentSuffix) {
        String fileName;
        Directory unwrapped = FilterDirectory.unwrap((Directory)directory);
        if (unwrapped instanceof FDBDirectory) {
            fileName = IndexFileNames.segmentFileName((String)segmentInfo.name, (String)segmentSuffix, (String)EXTENSION);
        } else if (unwrapped instanceof LuceneOptimizedCompoundReader) {
            LuceneOptimizedCompoundReader compoundReader = (LuceneOptimizedCompoundReader)unwrapped;
            fileName = compoundReader.getEntriesFileName();
        } else {
            throw new RecordCoreException("Unexpected type of directory", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.NAME, unwrapped.getClass().getSimpleName()});
        }
        return fileName;
    }
}

