/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.codec.LazyCloseable;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedPostingsFormat;
import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene80.Lucene80DocValuesFormat;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;

public class LuceneOptimizedDocValuesFormat
extends DocValuesFormat {
    private DocValuesFormat docValuesFormat;

    public LuceneOptimizedDocValuesFormat() {
        this((DocValuesFormat)new Lucene80DocValuesFormat());
    }

    public LuceneOptimizedDocValuesFormat(DocValuesFormat docValuesFormat) {
        super("RL80");
        this.docValuesFormat = docValuesFormat;
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return this.docValuesFormat.fieldsConsumer(state);
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new LazyDocValuesProducer(state);
    }

    private class LazyDocValuesProducer
    extends DocValuesProducer {
        private final LazyCloseable<DocValuesProducer> docValuesProducer = LazyCloseable.supply(() -> LuceneOptimizedDocValuesFormat.this.docValuesFormat.fieldsProducer(state));

        public LazyDocValuesProducer(SegmentReadState state) {
        }

        public NumericDocValues getNumeric(FieldInfo field) throws IOException {
            return this.docValuesProducer.get().getNumeric(field);
        }

        public BinaryDocValues getBinary(FieldInfo field) throws IOException {
            return this.docValuesProducer.get().getBinary(field);
        }

        public SortedDocValues getSorted(FieldInfo field) throws IOException {
            return this.docValuesProducer.get().getSorted(field);
        }

        public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
            return this.docValuesProducer.get().getSortedNumeric(field);
        }

        public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
            return this.docValuesProducer.get().getSortedSet(field);
        }

        public void checkIntegrity() throws IOException {
            if (LuceneOptimizedPostingsFormat.allowCheckDataIntegrity) {
                this.docValuesProducer.get().checkIntegrity();
            }
        }

        public void close() throws IOException {
            this.docValuesProducer.close();
        }

        public long ramBytesUsed() {
            return this.docValuesProducer.getUnchecked().ramBytesUsed();
        }
    }
}

