/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedCompoundReader;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FieldInfosStorage;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.codecs.CompoundDirectory;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

public class LuceneOptimizedCompoundFormat
extends CompoundFormat {
    public static final String DATA_EXTENSION = "cfs";
    public static final String ENTRIES_EXTENSION = "cfe";
    public static final String ENTRY_CODEC = "Lucene50CompoundEntries";
    public static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    protected final CompoundFormat underlying;

    public LuceneOptimizedCompoundFormat(CompoundFormat underlying) {
        this.underlying = underlying;
    }

    public CompoundDirectory getCompoundReader(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        return new LuceneOptimizedCompoundReader(dir, si, context);
    }

    public void write(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        try {
            for (String s : si.files()) {
                dir.openInput(s, IOContext.READONCE).close();
            }
            Set<String> filesForAfter = Set.copyOf(si.files());
            Set<String> filteredFiles = this.filterMarkerFiles(si.files());
            si.setFiles(filteredFiles);
            this.underlying.write(dir, si, context);
            si.setFiles(filesForAfter);
            String entriesFile = IndexFileNames.segmentFileName((String)si.name, (String)"", (String)ENTRIES_EXTENSION);
            this.copyFieldInfosId(dir, filesForAfter, entriesFile);
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    protected void copyFieldInfosId(Directory dir, Set<String> filesForAfter, String entriesFile) throws IOException {
        String fieldInfosFileName = filesForAfter.stream().filter(FDBDirectory::isFieldInfoFile).findFirst().orElseThrow();
        FieldInfosStorage.copyFieldInfosId(dir, fieldInfosFileName, entriesFile);
    }

    private Set<String> filterMarkerFiles(Set<String> files) {
        int fieldInfos = 0;
        int storedFields = 0;
        HashSet<String> filteredFiles = new HashSet<String>(files.size());
        for (String file : files) {
            if (FDBDirectory.isFieldInfoFile(file)) {
                ++fieldInfos;
                continue;
            }
            if (FDBDirectory.isStoredFieldsFile(file)) {
                ++storedFields;
                continue;
            }
            filteredFiles.add(file);
        }
        this.validateFileCounts(files, fieldInfos, storedFields);
        return filteredFiles;
    }

    protected void validateFileCounts(Set<String> files, int fieldInfos, int storedFields) {
        if (fieldInfos != 1) {
            throw new RecordCoreException("Segment has wrong number of FieldInfos", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.FILE_LIST, files});
        }
        if (storedFields > 1) {
            throw new RecordCoreException("Segment has wrong number of StoredFields", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.FILE_LIST, files});
        }
    }
}

