/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public class LazyOpener<T> {
    private final CompletableFuture<Void> starter = new CompletableFuture();
    private final CompletableFuture<T> future = this.starter.thenApplyAsync(ignored -> {
        try {
            return opener.open();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }, executor);
    private static final Executor executor = Runnable::run;

    private LazyOpener(Opener<T> opener) {
    }

    public static <U> LazyOpener<U> supply(Opener<U> opener) {
        return new LazyOpener<U>(opener);
    }

    public T get() throws IOException {
        try {
            return this.getInternal();
        }
        catch (ExecutionException e) {
            Throwable outerCause = e.getCause();
            if (outerCause instanceof UncheckedIOException) {
                IOException innerCause = ((UncheckedIOException)outerCause).getCause();
                innerCause.addSuppressed(e);
                throw innerCause;
            }
            throw LuceneExceptions.toIoException(outerCause, e);
        }
    }

    public T getUnchecked() {
        try {
            return this.getInternal();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                cause.addSuppressed(e);
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw LuceneExceptions.toRecordCoreException(cause.getMessage(), (IOException)cause, new Object[0]);
            }
            throw new RecordCoreException(cause);
        }
    }

    private T getInternal() throws ExecutionException {
        this.starter.complete(null);
        try {
            return this.future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RecordCoreException((Throwable)e);
        }
    }

    @FunctionalInterface
    public static interface Opener<T> {
        @Nonnull
        public T open() throws IOException;
    }
}

