/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneScanBounds;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.planprotos.PIndexScanType;
import com.apple.foundationdb.record.planprotos.PLuceneScanParameters;
import com.apple.foundationdb.record.planprotos.PScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public abstract class LuceneScanParameters
implements IndexScanParameters {
    @Nonnull
    protected final IndexScanType scanType;
    @Nonnull
    protected final ScanComparisons groupComparisons;

    protected LuceneScanParameters(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneScanParameters luceneScanParametersProto) {
        this(IndexScanType.fromProto((PlanSerializationContext)serializationContext, (PIndexScanType)Objects.requireNonNull(luceneScanParametersProto.getScanType())), ScanComparisons.fromProto((PlanSerializationContext)serializationContext, (PScanComparisons)Objects.requireNonNull(luceneScanParametersProto.getGroupComparisons())));
    }

    protected LuceneScanParameters(@Nonnull IndexScanType scanType, @Nonnull ScanComparisons groupComparisons) {
        this.scanType = scanType;
        this.groupComparisons = groupComparisons;
    }

    @Nonnull
    public IndexScanType getScanType() {
        return this.scanType;
    }

    @Nonnull
    public abstract LuceneScanBounds bind(@Nonnull FDBRecordStoreBase<?> var1, @Nonnull Index var2, @Nonnull EvaluationContext var3);

    @Nonnull
    public ScanComparisons getGroupComparisons() {
        return this.groupComparisons;
    }

    @Nonnull
    protected static List<String> indexTextFields(@Nonnull Index index, @Nonnull RecordMetaData metaData) {
        ArrayList<String> textFields = new ArrayList<String>();
        for (RecordType recordType : metaData.recordTypesForIndex(index)) {
            for (LuceneIndexExpressions.DocumentFieldDerivation documentField : LuceneIndexExpressions.getDocumentFieldDerivations(index.getRootExpression(), recordType.getDescriptor()).values()) {
                if (documentField.getType() != LuceneIndexExpressions.DocumentFieldType.TEXT) continue;
                textFields.add(documentField.getDocumentField());
            }
        }
        return textFields;
    }

    public boolean isUnique(@Nonnull Index index) {
        return false;
    }

    protected String getGroupScanDetails() {
        if (this.groupComparisons.isEmpty()) {
            return "";
        }
        return String.valueOf(this.groupComparisons) + " ";
    }

    @Nonnull
    protected Tuple getGroupKey(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
        TupleRange tupleRange = this.groupComparisons.toTupleRange(store, context);
        if (TupleRange.ALL.equals((Object)tupleRange)) {
            return TupleHelpers.EMPTY;
        }
        if (!tupleRange.isEquals()) {
            throw new RecordCoreException("group comparisons did not result in equality", new Object[0]);
        }
        return tupleRange.getLow();
    }

    @Nullable
    public Tuple getGroupKeyWithoutContext() {
        try {
            return this.getGroupKey(null, null);
        }
        catch (Comparisons.EvaluationContextRequiredException ex) {
            return null;
        }
    }

    public void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> detailsBuilder, @Nonnull ImmutableMap.Builder<String, Attribute> attributeMapBuilder) {
        detailsBuilder.add((Object)"scan type: {{scanType}}");
        attributeMapBuilder.put((Object)"scanType", (Object)Attribute.gml((Object)this.scanType.toString()));
        if (!this.groupComparisons.isEmpty()) {
            Tuple groupKey = this.getGroupKeyWithoutContext();
            if (groupKey != null) {
                detailsBuilder.add((Object)"group: {{range}}");
                attributeMapBuilder.put((Object)"range", (Object)Attribute.gml((Object)groupKey.toString()));
            } else {
                detailsBuilder.add((Object)"group: {{comparisons}}");
                attributeMapBuilder.put((Object)"comparisons", (Object)Attribute.gml((Object)this.groupComparisons.toString()));
            }
        }
    }

    public String toString() {
        return String.valueOf(this.scanType) + ":" + String.valueOf(this.groupComparisons);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LuceneScanParameters that = (LuceneScanParameters)o;
        if (!this.scanType.equals((Object)that.scanType)) {
            return false;
        }
        return this.groupComparisons.equals((Object)that.groupComparisons);
    }

    public int hashCode() {
        int result = this.scanType.hashCode();
        result = 31 * result + this.groupComparisons.hashCode();
        return result;
    }

    @Nonnull
    public PLuceneScanParameters toLuceneScanParametersProto(@Nonnull PlanSerializationContext serializationContext) {
        return PLuceneScanParameters.newBuilder().setScanType(this.scanType.toProto(serializationContext)).setGroupComparisons(this.groupComparisons.toProto(serializationContext)).build();
    }
}

