/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.LucenePartitioner;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class LuceneRepartitionPlanner {
    private final int indexPartitionLowWatermark;
    private final int indexPartitionHighWatermark;

    public LuceneRepartitionPlanner(int indexPartitionLowWatermark, int indexPartitionHighWatermark) {
        this.indexPartitionLowWatermark = indexPartitionLowWatermark;
        this.indexPartitionHighWatermark = indexPartitionHighWatermark;
    }

    @Nonnull
    RepartitioningContext determineRepartitioningAction(@Nonnull Tuple groupingKey, @Nonnull List<LucenePartitionInfoProto.LucenePartitionInfo> allPartitions, int currentPartitionPosition, int repartitionDocumentCount) {
        int maxPartitionId = allPartitions.stream().mapToInt(LucenePartitionInfoProto.LucenePartitionInfo::getId).max().orElse(0);
        LucenePartitionInfoProto.LucenePartitionInfo candidatePartition = allPartitions.get(currentPartitionPosition);
        Pair<LucenePartitionInfoProto.LucenePartitionInfo, LucenePartitionInfoProto.LucenePartitionInfo> neighborPartitions = LucenePartitioner.getPartitionNeighbors(allPartitions, currentPartitionPosition);
        LucenePartitionInfoProto.LucenePartitionInfo olderPartition = (LucenePartitionInfoProto.LucenePartitionInfo)neighborPartitions.getRight();
        LucenePartitionInfoProto.LucenePartitionInfo newerPartition = (LucenePartitionInfoProto.LucenePartitionInfo)neighborPartitions.getLeft();
        RepartitioningContext repartitioningContext = new RepartitioningContext(groupingKey, maxPartitionId, candidatePartition, olderPartition, newerPartition);
        int currentPartitionCount = candidatePartition.getCount();
        if (currentPartitionCount >= this.indexPartitionLowWatermark && currentPartitionCount <= this.indexPartitionHighWatermark) {
            return repartitioningContext;
        }
        if (currentPartitionCount < this.indexPartitionLowWatermark) {
            if (currentPartitionCount > repartitionDocumentCount) {
                repartitioningContext.countToMove = repartitionDocumentCount + 1;
                repartitioningContext.newBoundaryRecordPresent = true;
            } else {
                repartitioningContext.countToMove = currentPartitionCount;
                repartitioningContext.emptyingPartition = true;
            }
            if (olderPartition != null && olderPartition.getCount() + currentPartitionCount <= this.indexPartitionHighWatermark) {
                repartitioningContext.action = RepartitioningAction.MERGE_INTO_OLDER;
            } else if (newerPartition != null && newerPartition.getCount() + currentPartitionCount <= this.indexPartitionHighWatermark) {
                repartitioningContext.action = RepartitioningAction.MERGE_INTO_NEWER;
            } else if (olderPartition != null && newerPartition != null && 2 * this.indexPartitionHighWatermark - olderPartition.getCount() - newerPartition.getCount() >= currentPartitionCount) {
                repartitioningContext.action = RepartitioningAction.MERGE_INTO_BOTH;
                int olderPartitionCapacity = this.indexPartitionHighWatermark - olderPartition.getCount();
                repartitioningContext.countToMove = Math.min(olderPartitionCapacity, repartitionDocumentCount);
                if (currentPartitionCount > repartitioningContext.countToMove) {
                    ++repartitioningContext.countToMove;
                    repartitioningContext.newBoundaryRecordPresent = true;
                }
                repartitioningContext.emptyingPartition = false;
            } else {
                repartitioningContext.action = RepartitioningAction.NO_CAPACITY_FOR_MERGE;
            }
        } else {
            repartitioningContext.countToMove = 1 + Math.min(repartitionDocumentCount, this.indexPartitionHighWatermark);
            if (currentPartitionCount - repartitioningContext.countToMove < this.indexPartitionLowWatermark) {
                repartitioningContext.countToMove = Math.max(1, (this.indexPartitionHighWatermark - this.indexPartitionLowWatermark) / 2);
            }
            repartitioningContext.newBoundaryRecordPresent = true;
            repartitioningContext.action = RepartitioningAction.OVERFLOW;
        }
        return repartitioningContext;
    }

    @VisibleForTesting
    public static class RepartitioningContext {
        @Nonnull
        Tuple groupingKey;
        @Nonnull
        final LucenePartitionInfoProto.LucenePartitionInfo sourcePartition;
        @Nullable
        final LucenePartitionInfoProto.LucenePartitionInfo olderPartition;
        @Nullable
        final LucenePartitionInfoProto.LucenePartitionInfo newerPartition;
        boolean emptyingPartition;
        int countToMove;
        int maxPartitionId;
        boolean newBoundaryRecordPresent;
        RepartitioningAction action;

        RepartitioningContext(@Nonnull Tuple groupingKey, int maxPartitionId, @Nonnull LucenePartitionInfoProto.LucenePartitionInfo sourcePartition, @Nullable LucenePartitionInfoProto.LucenePartitionInfo olderPartition, @Nullable LucenePartitionInfoProto.LucenePartitionInfo newerPartition) {
            this.groupingKey = groupingKey;
            this.maxPartitionId = maxPartitionId;
            this.sourcePartition = sourcePartition;
            this.olderPartition = olderPartition;
            this.newerPartition = newerPartition;
            this.action = RepartitioningAction.NOT_REQUIRED;
        }

        public String toString() {
            return "RepartitioningContext{groupingKey=" + String.valueOf(this.groupingKey) + ", sourcePartition=" + String.valueOf(this.sourcePartition) + ", olderPartition=" + String.valueOf(this.olderPartition) + ", newerPartition=" + String.valueOf(this.newerPartition) + ", emptyingPartition=" + this.emptyingPartition + ", countToMove=" + this.countToMove + ", maxPartitionId=" + this.maxPartitionId + ", newBoundaryRecordPresent=" + this.newBoundaryRecordPresent + ", action=" + String.valueOf((Object)this.action) + "}";
        }
    }

    static enum RepartitioningAction {
        NOT_REQUIRED,
        OVERFLOW,
        MERGE_INTO_NEWER,
        MERGE_INTO_OLDER,
        MERGE_INTO_BOTH,
        NO_CAPACITY_FOR_MERGE;

    }
}

