/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.lucene.LuceneBooleanQuery;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;

@API(value=API.Status.UNSTABLE)
public class LuceneNotQuery
extends LuceneBooleanQuery {
    @Nonnull
    private final List<LuceneQueryClause> negatedChildren;

    public LuceneNotQuery(@Nonnull LuceneQueryType queryType, @Nonnull List<LuceneQueryClause> children, @Nonnull List<LuceneQueryClause> negatedChildren) {
        super(queryType, children, BooleanClause.Occur.MUST);
        this.negatedChildren = negatedChildren;
    }

    public LuceneNotQuery(@Nonnull LuceneQueryType queryType, @Nonnull LuceneQueryClause negatedChild) {
        this(queryType, Collections.emptyList(), Collections.singletonList(negatedChild));
    }

    @Nonnull
    protected List<LuceneQueryClause> getNegatedChildren() {
        return this.negatedChildren;
    }

    @Override
    public LuceneQueryClause.BoundQuery bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
        Map<String, Set<String>> childHighlightingTermsMap;
        LuceneQueryClause.BoundQuery childBoundQuery;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        HashMap highlightingTermsMap = null;
        if (this.getChildren().isEmpty()) {
            MatchAllDocsQuery matchAllDocsQuery = new MatchAllDocsQuery();
            builder.add((Query)matchAllDocsQuery, BooleanClause.Occur.MUST);
            if (this.getQueryType() == LuceneQueryType.QUERY_HIGHLIGHT) {
                highlightingTermsMap = this.toBoundQuery((Query)matchAllDocsQuery).getHighlightingTermsMap();
            }
        } else {
            for (LuceneQueryClause child : this.getChildren()) {
                childBoundQuery = child.bind(store, index, context);
                builder.add(childBoundQuery.getLuceneQuery(), BooleanClause.Occur.MUST);
                childHighlightingTermsMap = childBoundQuery.getHighlightingTermsMap();
                if (childHighlightingTermsMap == null) continue;
                if (highlightingTermsMap == null) {
                    highlightingTermsMap = Maps.newHashMap();
                }
                LuceneNotQuery.combineHighlightingTermsMaps(highlightingTermsMap, childHighlightingTermsMap);
            }
        }
        for (LuceneQueryClause child : this.negatedChildren) {
            childBoundQuery = child.bind(store, index, context);
            builder.add(childBoundQuery.getLuceneQuery(), BooleanClause.Occur.MUST_NOT);
            childHighlightingTermsMap = childBoundQuery.getHighlightingTermsMap();
            if (childHighlightingTermsMap == null) continue;
            if (highlightingTermsMap == null) {
                highlightingTermsMap = Maps.newHashMap();
            }
            LuceneNotQuery.combineHighlightingTermsMaps(highlightingTermsMap, childHighlightingTermsMap);
        }
        return new LuceneQueryClause.BoundQuery((Query)builder.build(), highlightingTermsMap);
    }

    @Override
    public void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> detailsBuilder, @Nonnull ImmutableMap.Builder<String, Attribute> attributeMapBuilder) {
        super.getPlannerGraphDetails(detailsBuilder, attributeMapBuilder);
        for (LuceneQueryClause child : this.negatedChildren) {
            child.getPlannerGraphDetails(detailsBuilder, attributeMapBuilder);
        }
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return super.planHash(mode) - PlanHashable.iterablePlanHash((PlanHashable.PlanHashMode)mode, this.negatedChildren);
    }

    @Override
    public String toString() {
        return Stream.concat(this.getChildren().stream().map(Objects::toString), this.negatedChildren.stream().map(c -> "NOT " + String.valueOf(c))).collect(Collectors.joining(" AND "));
    }
}

