/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperationResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class LuceneMetadataInfo
extends IndexOperationResult {
    private List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfo;
    private Map<Integer, LuceneInfo> luceneInfo;

    public LuceneMetadataInfo(@Nonnull List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfo, @Nonnull Map<Integer, LuceneInfo> luceneInfo) {
        this.partitionInfo = partitionInfo;
        this.luceneInfo = luceneInfo;
    }

    public List<LucenePartitionInfoProto.LucenePartitionInfo> getPartitionInfo() {
        return this.partitionInfo;
    }

    public Map<Integer, LuceneInfo> getLuceneInfo() {
        return this.luceneInfo;
    }

    public static class LuceneFileInfo {
        private final String name;
        private final long id;
        private final long size;

        public LuceneFileInfo(String name, long id, long size) {
            this.name = name;
            this.id = id;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public long getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LuceneFileInfo)) {
                return false;
            }
            LuceneFileInfo that = (LuceneFileInfo)o;
            return this.id == that.id && this.size == that.size && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.id, this.size);
        }
    }

    public static class LuceneInfo {
        private final int documentCount;
        @API(value=API.Status.DEPRECATED)
        private final Collection<String> files;
        private final int fieldInfoCount;
        @Nullable
        private final List<LuceneFileInfo> detailedFileInfos;

        @API(value=API.Status.DEPRECATED)
        public LuceneInfo(int documentCount, Collection<String> files, int fieldInfoCount) {
            this.documentCount = documentCount;
            this.files = files;
            this.fieldInfoCount = fieldInfoCount;
            this.detailedFileInfos = null;
        }

        public LuceneInfo(int documentCount, int fieldInfoCount, @Nonnull List<LuceneFileInfo> detailedFileInfos) {
            this.documentCount = documentCount;
            this.files = detailedFileInfos.stream().map(LuceneFileInfo::getName).collect(Collectors.toList());
            this.fieldInfoCount = fieldInfoCount;
            this.detailedFileInfos = Collections.unmodifiableList(detailedFileInfos);
        }

        public int getDocumentCount() {
            return this.documentCount;
        }

        @API(value=API.Status.DEPRECATED)
        public Collection<String> getFiles() {
            return this.files;
        }

        public int getFieldInfoCount() {
            return this.fieldInfoCount;
        }

        @Nullable
        public List<LuceneFileInfo> getDetailedFileInfos() {
            return this.detailedFileInfos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LuceneInfo that = (LuceneInfo)o;
            return this.documentCount == that.documentCount && this.fieldInfoCount == that.fieldInfoCount && Objects.equals(this.files, that.files) && Objects.equals(this.detailedFileInfos, that.detailedFileInfos);
        }

        public int hashCode() {
            return Objects.hash(this.documentCount, this.files, this.fieldInfoCount, this.detailedFileInfos);
        }
    }
}

