/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneIndexOptions;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.MetaDataValidator;
import com.apple.foundationdb.record.metadata.RecordType;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LuceneIndexValidator
extends IndexValidator {
    public LuceneIndexValidator(@Nonnull Index index) {
        super(index);
    }

    public void validate(@Nonnull MetaDataValidator metaDataValidator) {
        super.validate(metaDataValidator);
        this.validateNotVersion();
        RecordMetaData recordMetadata = metaDataValidator.getRecordMetaData();
        for (RecordType recordType : recordMetadata.recordTypesForIndex(this.index)) {
            LuceneIndexExpressions.validate(this.index.getRootExpression(), recordType.getDescriptor());
        }
        LuceneIndexValidator.validateIndexOptions(this.index, recordMetadata);
    }

    @VisibleForTesting
    public static void validateIndexOptions(@Nonnull Index index, @Nonnull RecordMetaData recordMetaData) {
        LuceneIndexValidator.validateAnalyzerNamePerFieldOption("luceneAnalyzerNamePerField", index);
        LuceneIndexValidator.validateAnalyzerNamePerFieldOption("autoCompleteAnalyzerNamePerField", index);
        LuceneIndexValidator.validatePartitionOptions(index);
        LuceneIndexValidator.validatePrimaryKeyOptions(index.getOptions());
        if (index.getBooleanOption("unique", false)) {
            throw new MetaDataException("Lucene does not support unique indexes", new Object[0]);
        }
    }

    private static void validatePartitionOptions(@Nonnull Index index) {
        String lowWatermarkOption = index.getOption("partitionLowWatermark");
        String highWatermarkOption = index.getOption("partitionHighWatermark");
        Integer highWatermark = null;
        if (highWatermarkOption != null && (highWatermark = Integer.valueOf(Integer.parseInt(highWatermarkOption))) < 1) {
            throw new MetaDataException("Invalid value for partitionHighWatermark: must be > 1", new Object[0]);
        }
        if (lowWatermarkOption != null) {
            int actualHighWatermark;
            int lowWatermark = Integer.parseInt(lowWatermarkOption);
            if (lowWatermark < 0) {
                throw new MetaDataException("Invalid value for partitionLowWatermark: must be > 0", new Object[0]);
            }
            int n = actualHighWatermark = highWatermark == null ? 400000 : highWatermark;
            if (lowWatermark >= actualHighWatermark) {
                throw new MetaDataException("Invalid value for partitionLowWatermark: less than partitionHighWatermark: " + actualHighWatermark, new Object[0]);
            }
        }
    }

    private static void validatePrimaryKeyOptions(Map<String, String> options) {
        if (Boolean.parseBoolean(options.get("primaryKeySegmentIndexV2Enabled"))) {
            if (Boolean.parseBoolean(options.get("primaryKeySegmentIndexEnabled"))) {
                throw new MetaDataException("Index cannot enable both primaryKeySegmentIndexV2Enabled and primaryKeySegmentIndexEnabled", new Object[0]);
            }
            if (options.get("optimizedStoredFieldsFormatEnabled") != null) {
                throw new MetaDataException("The index option optimizedStoredFieldsFormatEnabled is implied by primaryKeySegmentIndexV2Enabled and cannot be controlled independently", new Object[0]);
            }
        }
    }

    private static void validateAnalyzerNamePerFieldOption(@Nonnull String optionKey, @Nonnull Index index) {
        String analyzerNamePerFieldOption = index.getOption(optionKey);
        if (analyzerNamePerFieldOption != null) {
            LuceneIndexOptions.validateKeyValuePairOptionValue(analyzerNamePerFieldOption, new MetaDataException("Index has invalid option value", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.INDEX_NAME, index.getName()}).addLogInfo(new Object[]{LogMessageKeys.INDEX_OPTION, optionKey}).addLogInfo(new Object[]{LogMessageKeys.VALUE, analyzerNamePerFieldOption}));
        }
    }
}

