/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.planprotos.LuceneRecordQueryPlanProto;
import com.apple.foundationdb.record.planprotos.PIndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.planprotos.PLuceneSpellCheckCopier;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.ImmutableIntArray;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LuceneIndexKeyValueToPartialRecordUtils {
    private LuceneIndexKeyValueToPartialRecordUtils() {
    }

    public static void buildPartialRecord(@Nonnull KeyExpression root, @Nonnull Descriptors.Descriptor descriptor, @Nonnull Message.Builder builder, @Nonnull String luceneField, @Nonnull String suggestion) {
        LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord(root, descriptor, builder, luceneField, suggestion, TupleHelpers.EMPTY);
    }

    public static void buildPartialRecord(@Nonnull KeyExpression root, @Nonnull Descriptors.Descriptor descriptor, @Nonnull Message.Builder builder, @Nonnull String luceneField, @Nonnull String suggestion, @Nonnull Tuple groupingKey) {
        KeyExpression expression = root instanceof GroupingKeyExpression ? ((GroupingKeyExpression)root).getWholeKey() : root;
        LuceneIndexExpressions.getFieldsRecursively(expression, new PartialRecordBuildSource(null, descriptor, builder), (source, fieldName, value, type, fieldNameOverride, namedFieldPath, namedFieldSuffix, stored, sorted, overriddenKeyRanges, groupingKeyIndex, keyIndex, fieldConfigsIgnored) -> {
            if (groupingKeyIndex > -1) {
                if (groupingKeyIndex > groupingKey.size() - 1) {
                    throw new RecordCoreException("Invalid grouping value tuple given a grouping key", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, groupingKey.toString()});
                }
                source.buildMessage(groupingKey.get(groupingKeyIndex), (String)value, null, null, false);
            } else if (type.equals((Object)LuceneIndexExpressions.DocumentFieldType.TEXT)) {
                LuceneIndexKeyValueToPartialRecordUtils.buildIfFieldNameMatch(source, fieldName, luceneField, overriddenKeyRanges, suggestion, (String)value);
            }
        }, null, 0, root instanceof GroupingKeyExpression ? ((GroupingKeyExpression)root).getGroupingCount() : 0, new ArrayList<Integer>());
    }

    public static void populatePrimaryKey(@Nonnull KeyExpression primaryKey, @Nonnull Descriptors.Descriptor descriptor, @Nonnull Message.Builder builder, @Nonnull Tuple tuple) {
        LuceneIndexExpressions.getFields(primaryKey, new PartialRecordBuildSource(null, descriptor, builder), (source, fieldName, value, type, fieldNameOverride, namedFieldPath, namedFieldSuffix, stored, sorted, overriddenKeyRanges, groupingKeyIndex, keyIndex, fieldConfigsIgnored) -> source.buildMessage(tuple.get(keyIndex), (String)value, null, null, false), null);
    }

    private static void buildIfFieldNameMatch(@Nonnull PartialRecordBuildSource source, @Nonnull String concatenatedFieldPath, @Nonnull String givenFieldName, @Nonnull List<Integer> overriddenKeyRanges, @Nonnull String suggestion, @Nonnull String protoFieldName) {
        String customizedKeyForLuceneField;
        if (overriddenKeyRanges.isEmpty()) {
            if (concatenatedFieldPath.equals(givenFieldName)) {
                source.buildMessage((Object)suggestion, protoFieldName, null, null, true);
            }
            return;
        }
        if (concatenatedFieldPath.equals(givenFieldName)) {
            source.buildMessage((Object)suggestion, protoFieldName, null, null, true);
            return;
        }
        NonnullPair<List<String>, List<String>> pair = LuceneIndexKeyValueToPartialRecordUtils.getOriginalAndMappedFieldElements(concatenatedFieldPath, overriddenKeyRanges);
        List fixedFieldNames = (List)pair.getLeft();
        List dynamicFieldNames = (List)pair.getRight();
        String fieldName = givenFieldName;
        for (String fixedField : fixedFieldNames) {
            int index = fieldName.indexOf(fixedField);
            if (index < 0) {
                return;
            }
            if (index + fixedField.length() < fieldName.length() && fieldName.charAt(index + fixedField.length()) != '_') {
                return;
            }
            fieldName = fieldName.substring(index + fixedField.length());
        }
        String mappedKeyField = (String)dynamicFieldNames.get(dynamicFieldNames.size() - 1);
        if (fixedFieldNames.isEmpty()) {
            customizedKeyForLuceneField = givenFieldName;
        } else if (fixedFieldNames.size() == 1) {
            String lastOriginalField = (String)fixedFieldNames.get(fixedFieldNames.size() - 1);
            if (givenFieldName.endsWith(lastOriginalField)) {
                if (dynamicFieldNames.size() == 1) {
                    customizedKeyForLuceneField = givenFieldName.substring(0, givenFieldName.lastIndexOf(lastOriginalField) - 1);
                } else {
                    int index;
                    for (index = 0; index <= givenFieldName.lastIndexOf(lastOriginalField) - 1 && givenFieldName.charAt(index) == concatenatedFieldPath.charAt(index); ++index) {
                    }
                    customizedKeyForLuceneField = givenFieldName.substring(index, givenFieldName.lastIndexOf(lastOriginalField) - 1);
                }
            } else {
                customizedKeyForLuceneField = givenFieldName.substring(givenFieldName.lastIndexOf(lastOriginalField) + lastOriginalField.length() + 1);
            }
        } else {
            String penultimateOriginalField = (String)fixedFieldNames.get(fixedFieldNames.size() - 2);
            String lastOriginalField = (String)fixedFieldNames.get(fixedFieldNames.size() - 1);
            if (givenFieldName.endsWith(lastOriginalField)) {
                if (penultimateOriginalField.equals(lastOriginalField)) {
                    int endIndex = givenFieldName.lastIndexOf(lastOriginalField) - 1;
                    int startIndex = givenFieldName.substring(0, endIndex).lastIndexOf(penultimateOriginalField) + penultimateOriginalField.length() + 1;
                    customizedKeyForLuceneField = givenFieldName.substring(startIndex, endIndex);
                } else {
                    int startIndex = givenFieldName.lastIndexOf(penultimateOriginalField) + penultimateOriginalField.length() + 1;
                    int endIndex = givenFieldName.lastIndexOf(lastOriginalField) - 1;
                    customizedKeyForLuceneField = givenFieldName.substring(startIndex, endIndex);
                }
            } else {
                customizedKeyForLuceneField = givenFieldName.substring(givenFieldName.lastIndexOf(lastOriginalField) + lastOriginalField.length() + 1);
            }
        }
        source.buildMessage((Object)suggestion, protoFieldName, customizedKeyForLuceneField, mappedKeyField, true);
    }

    private static NonnullPair<List<String>, List<String>> getOriginalAndMappedFieldElements(@Nonnull String entireFieldName, @Nonnull List<Integer> overriddenKeyRanges) {
        int startIndex;
        int size = overriddenKeyRanges.size();
        ArrayList<String> fixedFieldNames = new ArrayList<String>();
        ArrayList<String> dynamicFieldNames = new ArrayList<String>();
        if (overriddenKeyRanges.get(0) > 0) {
            int endIndex;
            startIndex = 0;
            int n = endIndex = overriddenKeyRanges.get(0) > entireFieldName.length() - 1 ? entireFieldName.length() : overriddenKeyRanges.get(0) - 1;
            if (endIndex >= startIndex) {
                fixedFieldNames.add(entireFieldName.substring(startIndex, endIndex));
            }
        }
        for (int i = 0; i < size - 1; i += 2) {
            int endIndex;
            boolean keyIsNull;
            boolean bl = keyIsNull = overriddenKeyRanges.get(i) == overriddenKeyRanges.get(i + 1);
            if (keyIsNull) {
                dynamicFieldNames.add("");
            } else {
                dynamicFieldNames.add(entireFieldName.substring(overriddenKeyRanges.get(i), overriddenKeyRanges.get(i + 1)));
            }
            if (i >= size - 3) continue;
            int startIndex2 = overriddenKeyRanges.get(i + 1) == 0 ? overriddenKeyRanges.get(i + 1) : overriddenKeyRanges.get(i + 1) + 1;
            int n = endIndex = overriddenKeyRanges.get(i + 2).intValue() == entireFieldName.length() ? overriddenKeyRanges.get(i + 2) : overriddenKeyRanges.get(i + 2) - 1;
            if (endIndex < startIndex2) continue;
            fixedFieldNames.add(entireFieldName.substring(startIndex2, endIndex));
        }
        if (overriddenKeyRanges.get(size - 1) < entireFieldName.length()) {
            int n = startIndex = overriddenKeyRanges.get(size - 1) == 0 ? overriddenKeyRanges.get(size - 1) : overriddenKeyRanges.get(size - 1) + 1;
            if (entireFieldName.length() >= startIndex) {
                fixedFieldNames.add(entireFieldName.substring(startIndex));
            }
        }
        return NonnullPair.of(fixedFieldNames, dynamicFieldNames);
    }

    @Nonnull
    @VisibleForTesting
    public static IndexKeyValueToPartialRecord getToPartialRecord(@Nonnull Index index, @Nonnull RecordType recordType, @Nonnull IndexScanType scanType) {
        int groupingColumnSize;
        IndexKeyValueToPartialRecord.Builder builder = IndexKeyValueToPartialRecord.newBuilder((RecordType)recordType);
        KeyExpression root = index.getRootExpression();
        if (root instanceof GroupingKeyExpression) {
            KeyExpression groupingKey = ((GroupingKeyExpression)root).getGroupingSubKey();
            groupingColumnSize = groupingKey.getColumnSize();
            for (int i = 0; i < groupingKey.getColumnSize(); ++i) {
                AvailableFields.addCoveringField((KeyExpression)groupingKey, (AvailableFields.FieldData)AvailableFields.FieldData.ofUnconditional((IndexKeyValueToPartialRecord.TupleSource)IndexKeyValueToPartialRecord.TupleSource.KEY, (ImmutableIntArray)ImmutableIntArray.of((int)i)), (IndexKeyValueToPartialRecord.Builder)builder);
            }
        } else {
            groupingColumnSize = 0;
        }
        builder.addRequiredMessageFields();
        if (!builder.isValid(true)) {
            throw new RecordCoreException("Missing required field for result record", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.INDEX_NAME, index.getName()}).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, recordType.getName()}).addLogInfo(new Object[]{LogMessageKeys.SCAN_TYPE, scanType});
        }
        builder.addRegularCopier((IndexKeyValueToPartialRecord.Copier)new LuceneSpellCheckCopier(groupingColumnSize));
        return builder.build();
    }

    static class PartialRecordBuildSource
    implements LuceneIndexExpressions.RecordSource<PartialRecordBuildSource> {
        @Nullable
        private final PartialRecordBuildSource parent;
        @Nonnull
        private final Descriptors.Descriptor descriptor;
        @Nullable
        private final Descriptors.FieldDescriptor fieldDescriptor;
        @Nonnull
        private final Message.Builder builder;
        private boolean hasBeenBuilt = false;

        PartialRecordBuildSource(@Nullable PartialRecordBuildSource parent, @Nonnull Descriptors.Descriptor descriptor, @Nonnull Message.Builder builder) {
            this.parent = parent;
            this.descriptor = descriptor;
            this.fieldDescriptor = null;
            this.builder = builder;
        }

        PartialRecordBuildSource(@Nullable PartialRecordBuildSource parent, @Nonnull Descriptors.FieldDescriptor fieldDescriptor, @Nonnull Message.Builder builder) {
            this.parent = parent;
            this.descriptor = fieldDescriptor.getMessageType();
            this.fieldDescriptor = fieldDescriptor;
            this.builder = builder;
        }

        @Override
        public Descriptors.Descriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public Iterable<PartialRecordBuildSource> getChildren(@Nonnull FieldKeyExpression parentExpression) {
            String parentField = parentExpression.getFieldName();
            Descriptors.FieldDescriptor parentFieldDescriptor = this.descriptor.findFieldByName(parentField);
            return Collections.singletonList(new PartialRecordBuildSource(this, parentFieldDescriptor, this.builder.newBuilderForField(parentFieldDescriptor)));
        }

        @Override
        public Iterable<Object> getValues(@Nonnull KeyExpression keyExpression) {
            ArrayList<Object> result = new ArrayList<Object>();
            KeyExpression current = keyExpression;
            while (current != null) {
                if (current instanceof NestingKeyExpression) {
                    NestingKeyExpression expression = (NestingKeyExpression)current;
                    result.add(expression.getParent().getFieldName());
                    current = expression.getChild();
                    continue;
                }
                if (current instanceof FieldKeyExpression) {
                    result.add(((FieldKeyExpression)current).getFieldName());
                    current = null;
                    continue;
                }
                throw new RecordCoreArgumentException("Nested key type not supported for values", new Object[0]).addLogInfo("keyType", (Object)current.getClass().getName());
            }
            return result;
        }

        public void buildMessage(@Nullable Object value, @Nonnull String field, @Nullable String customizedKey, @Nullable String mappedKeyField, boolean forLuceneField) {
            if (this.hasBeenBuilt()) {
                return;
            }
            this.buildMessage(value, this.descriptor.findFieldByName(field), customizedKey, mappedKeyField, forLuceneField);
        }

        private void buildMessage(@Nullable Object value, Descriptors.FieldDescriptor subFieldDescriptor, @Nullable String customizedKey, @Nullable String mappedKeyField, boolean forLuceneField) {
            Descriptors.FieldDescriptor mappedKeyFieldDescriptor;
            Descriptors.FieldDescriptor fieldDescriptor = mappedKeyFieldDescriptor = mappedKeyField == null ? null : this.descriptor.findFieldByName(mappedKeyField);
            if (mappedKeyFieldDescriptor != null) {
                if (customizedKey == null) {
                    return;
                }
                this.builder.setField(mappedKeyFieldDescriptor, (Object)customizedKey);
            }
            if (value == null) {
                return;
            }
            if (subFieldDescriptor.isRepeated()) {
                if (this.builder.getRepeatedFieldCount(subFieldDescriptor) > 0) {
                    Message.Builder subBuilder = this.builder.newBuilderForField(subFieldDescriptor);
                    subBuilder.mergeFrom((Message)this.builder.getRepeatedField(subFieldDescriptor, 0)).mergeFrom((Message)value);
                    this.builder.setRepeatedField(subFieldDescriptor, 0, (Object)subBuilder.build());
                } else {
                    this.builder.addRepeatedField(subFieldDescriptor, value);
                }
            } else {
                this.builder.setField(subFieldDescriptor, value);
            }
            if (this.parent != null) {
                PartialRecordBuildSource.addRequiredFieldsToBuilder(this.builder);
                this.parent.buildMessage((Object)this.builder.build(), this.fieldDescriptor, mappedKeyFieldDescriptor == null ? customizedKey : null, mappedKeyFieldDescriptor == null ? mappedKeyField : null, forLuceneField);
            }
            if (forLuceneField) {
                this.hasBeenBuilt = true;
            }
        }

        private static MessageLite.Builder addRequiredFieldsToBuilder(@Nonnull Message.Builder builder) {
            Descriptors.Descriptor recordDescriptor = builder.getDescriptorForType();
            for (Descriptors.FieldDescriptor fieldDescriptor : recordDescriptor.getFields()) {
                if (!fieldDescriptor.isRequired() || fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE || builder.hasField(fieldDescriptor)) continue;
                Message.Builder fieldBuilder = builder.newBuilderForField(fieldDescriptor);
                builder.setField(fieldDescriptor, (Object)PartialRecordBuildSource.addRequiredFieldsToBuilder(fieldBuilder).build());
            }
            return builder;
        }

        private boolean hasBeenBuilt() {
            if (this.hasBeenBuilt) {
                return true;
            }
            if (this.parent != null) {
                return this.parent.hasBeenBuilt;
            }
            return false;
        }
    }

    public static class LuceneSpellCheckCopier
    implements IndexKeyValueToPartialRecord.Copier {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash((Object)"Lucene-Spell-Check-Copier");
        private final int groupingColumnSize;

        public LuceneSpellCheckCopier(int groupingColumnSize) {
            this.groupingColumnSize = groupingColumnSize;
        }

        public boolean copy(@Nonnull Descriptors.Descriptor recordDescriptor, @Nonnull Message.Builder recordBuilder, @Nonnull IndexEntry kv) {
            Tuple keyTuple = kv.getKey();
            if (keyTuple.size() < 2) {
                throw new RecordCoreException("Invalid key tuple for auto-complete suggestion's index entry", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.KEY_SIZE, keyTuple.size()}).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, recordDescriptor.getName()});
            }
            Tuple groupingKey = Tuple.fromList(keyTuple.getItems().subList(0, this.groupingColumnSize));
            String fieldName = (String)keyTuple.get(this.groupingColumnSize);
            String value = (String)keyTuple.get(this.groupingColumnSize + 1);
            LuceneIndexKeyValueToPartialRecordUtils.buildPartialRecord(kv.getIndex().getRootExpression(), recordDescriptor, recordBuilder, fieldName, value, groupingKey);
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LuceneSpellCheckCopier)) {
                return false;
            }
            LuceneSpellCheckCopier that = (LuceneSpellCheckCopier)o;
            return this.groupingColumnSize == that.groupingColumnSize;
        }

        public int hashCode() {
            return Objects.hash(BASE_HASH, this.groupingColumnSize);
        }

        public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
            return PlanHashable.objectsPlanHash((PlanHashable.PlanHashMode)hashMode, (Object[])new Object[]{BASE_HASH, this.groupingColumnSize});
        }

        @Nonnull
        public PLuceneSpellCheckCopier toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PLuceneSpellCheckCopier.newBuilder().setGroupingColumnSize(this.groupingColumnSize).build();
        }

        @Nonnull
        public PIndexKeyValueToPartialRecord.PCopier toCopierProto(@Nonnull PlanSerializationContext serializationContext) {
            return PIndexKeyValueToPartialRecord.PCopier.newBuilder().setExtension(LuceneRecordQueryPlanProto.luceneSpellCheckCopier, (Object)this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static LuceneSpellCheckCopier fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneSpellCheckCopier luceneSpellCheckCopierProto) {
            return new LuceneSpellCheckCopier((Integer)PlanSerialization.getFieldOrThrow((Message)luceneSpellCheckCopierProto, PLuceneSpellCheckCopier::hasGroupingColumnSize, PLuceneSpellCheckCopier::getGroupingColumnSize));
        }

        public static class Deserializer
        implements PlanDeserializer<PLuceneSpellCheckCopier, LuceneSpellCheckCopier> {
            @Nonnull
            public Class<PLuceneSpellCheckCopier> getProtoMessageClass() {
                return PLuceneSpellCheckCopier.class;
            }

            @Nonnull
            public LuceneSpellCheckCopier fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneSpellCheckCopier luceneSpellCheckCopierProto) {
                return LuceneSpellCheckCopier.fromProto(serializationContext, luceneSpellCheckCopierProto);
            }
        }
    }
}

