/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.lucene.LuceneRecordCursor;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChildren;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.search.ScoreDoc;

@API(value=API.Status.EXPERIMENTAL)
public abstract class LuceneFunctionKeyExpression
extends FunctionKeyExpression {
    protected LuceneFunctionKeyExpression(@Nonnull String name, @Nonnull KeyExpression arguments) {
        super(name, arguments);
    }

    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateFunction(@Nullable FDBRecord<M> rec, @Nullable Message message, @Nonnull Key.Evaluated argvals) {
        return this.arguments.evaluateMessage(rec, message);
    }

    public boolean createsDuplicates() {
        return this.arguments.createsDuplicates();
    }

    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        throw new IllegalStateException("Should not be used in a plan");
    }

    public static class LuceneSortBy
    extends LuceneFunctionKeyExpression {
        public LuceneSortBy(@Nonnull String name, @Nonnull KeyExpression arguments) {
            super(name, arguments);
        }

        public int getMinArguments() {
            return 0;
        }

        public int getMaxArguments() {
            return 0;
        }

        public int getColumnSize() {
            return 1;
        }

        @Override
        @Nonnull
        public <M extends Message> List<Key.Evaluated> evaluateFunction(@Nullable FDBRecord<M> rec, @Nullable Message message, @Nonnull Key.Evaluated argvals) {
            Key.Evaluated result;
            if (rec instanceof FDBQueriedRecord && ((FDBQueriedRecord)rec).getIndexEntry() instanceof LuceneRecordCursor.ScoreDocIndexEntry) {
                ScoreDoc scoreDoc = ((LuceneRecordCursor.ScoreDocIndexEntry)((FDBQueriedRecord)rec).getIndexEntry()).getScoreDoc();
                Number value = this.isRelevance() ? (Number)Float.valueOf(scoreDoc.score) : (Number)scoreDoc.doc;
                result = Key.Evaluated.scalar((Object)value);
            } else {
                result = Key.Evaluated.NULL;
            }
            return Collections.singletonList(result);
        }

        public boolean isRelevance() {
            return "lucene_sort_by_relevance".equals(this.getName());
        }

        @Nonnull
        public Value toValue(@Nonnull List<? extends Value> argumentValues) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static class LuceneFieldConfig
    extends LuceneFunctionKeyExpression {
        public LuceneFieldConfig(@Nonnull String name, @Nonnull KeyExpression arguments) {
            super(name, arguments);
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return Integer.MAX_VALUE;
        }

        public int getColumnSize() {
            return 1;
        }

        @Nonnull
        public Value toValue(@Nonnull List<? extends Value> argumentValues) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static class LuceneText
    extends LuceneFunctionKeyExpression {
        public LuceneText(@Nonnull String name, @Nonnull KeyExpression arguments) {
            super(name, arguments);
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return Integer.MAX_VALUE;
        }

        public int getColumnSize() {
            return this.getFieldExpression().getColumnSize();
        }

        @Nonnull
        public KeyExpression getFieldExpression() {
            if (this.arguments.getColumnSize() > 1) {
                return (KeyExpression)((KeyExpressionWithChildren)this.arguments).getChildren().get(0);
            }
            return this.arguments;
        }

        @Nonnull
        public Map<String, Object> getFieldConfigs() {
            HashMap<String, Object> configs = new HashMap<String, Object>();
            if (this.arguments instanceof ThenKeyExpression) {
                for (KeyExpression child : ((ThenKeyExpression)this.arguments).getChildren()) {
                    if (!(child instanceof LuceneFieldConfig)) continue;
                    LuceneFieldConfig fieldConfig = (LuceneFieldConfig)child;
                    if (!(((LuceneFunctionKeyExpression)fieldConfig).arguments instanceof LiteralKeyExpression)) {
                        throw new KeyExpression.InvalidExpressionException("Lucene field config should have value arguments");
                    }
                    configs.put(fieldConfig.getName(), ((LiteralKeyExpression)((LuceneFunctionKeyExpression)fieldConfig).arguments).getValue());
                }
            }
            return configs;
        }

        @Nonnull
        public Value toValue(@Nonnull List<? extends Value> argumentValues) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static class LuceneSorted
    extends LuceneFunctionKeyExpression {
        public LuceneSorted(@Nonnull String name, @Nonnull KeyExpression arguments) {
            super(name, arguments);
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return 1;
        }

        public int getColumnSize() {
            return this.getSortedExpression().getColumnSize();
        }

        @Nonnull
        public KeyExpression getSortedExpression() {
            return this.arguments;
        }

        @Nonnull
        public Value toValue(@Nonnull List<? extends Value> argumentValues) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static class LuceneStored
    extends LuceneFunctionKeyExpression {
        public LuceneStored(@Nonnull String name, @Nonnull KeyExpression arguments) {
            super(name, arguments);
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return 1;
        }

        public int getColumnSize() {
            return this.getStoredExpression().getColumnSize();
        }

        @Nonnull
        public KeyExpression getStoredExpression() {
            return this.arguments;
        }

        @Nonnull
        public Value toValue(@Nonnull List<? extends Value> argumentValues) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static class LuceneFieldName
    extends LuceneFunctionKeyExpression {
        public LuceneFieldName(@Nonnull String name, @Nonnull KeyExpression arguments) {
            super(name, arguments);
        }

        public int getMinArguments() {
            return 2;
        }

        public int getMaxArguments() {
            return Integer.MAX_VALUE;
        }

        public int getColumnSize() {
            return this.getNamedExpression().getColumnSize();
        }

        public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor descriptor) {
            List result = super.validate(descriptor);
            if (!(this.arguments instanceof ThenKeyExpression) || ((ThenKeyExpression)this.arguments).getChildren().size() != 2 || ((KeyExpression)((ThenKeyExpression)this.arguments).getChildren().get(1)).getColumnSize() != 1) {
                throw new KeyExpression.InvalidExpressionException("Lucene field name subexpression should be single column");
            }
            return result;
        }

        @Nonnull
        public KeyExpression getNamedExpression() {
            return (KeyExpression)((KeyExpressionWithChildren)this.arguments).getChildren().get(0);
        }

        @Nonnull
        public KeyExpression getNameExpression() {
            return (KeyExpression)((KeyExpressionWithChildren)this.arguments).getChildren().get(1);
        }

        @Nonnull
        public Value toValue(@Nonnull List<? extends Value> argumentValues) {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

