/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LuceneDocumentFromRecord {
    private LuceneDocumentFromRecord() {
    }

    @Nonnull
    protected static <M extends Message> Map<Tuple, List<DocumentField>> getRecordFields(@Nonnull KeyExpression root, @Nullable FDBRecord<M> rec) {
        HashMap<Tuple, List<DocumentField>> result = new HashMap<Tuple, List<DocumentField>>();
        if (rec != null) {
            if (root instanceof GroupingKeyExpression) {
                GroupingKeyExpression group = (GroupingKeyExpression)root;
                LuceneDocumentFromRecord.getGroupedFields(Collections.singletonList(group.getWholeKey()), 0, 0, group.getGroupingCount(), TupleHelpers.EMPTY, rec, rec.getRecord(), result, null);
            } else {
                result.put(TupleHelpers.EMPTY, LuceneDocumentFromRecord.getFields(root, rec, rec.getRecord(), null));
            }
        }
        return result;
    }

    protected static <M extends Message> void getGroupedFields(@Nonnull List<KeyExpression> keys, int keyIndex, int keyPosition, int groupingCount, @Nonnull Tuple groupPrefix, @Nonnull FDBRecord<M> rec, @Nonnull Message message, @Nonnull Map<Tuple, List<DocumentField>> result, @Nullable String fieldNamePrefix) {
        if (keyIndex >= keys.size()) {
            return;
        }
        KeyExpression key = keys.get(keyIndex);
        int keySize = key.getColumnSize();
        if (keyPosition + keySize <= groupingCount) {
            List groups = key.evaluateMessage(rec, message);
            for (Key.Evaluated group : groups) {
                Tuple wholeGroup = groupPrefix.addAll(group.toTupleAppropriateList());
                if (groupingCount == wholeGroup.size()) {
                    result.putIfAbsent(wholeGroup, new ArrayList());
                }
                LuceneDocumentFromRecord.getGroupedFields(keys, keyIndex + 1, keyPosition + key.getColumnSize(), groupingCount, wholeGroup, rec, message, result, fieldNamePrefix);
            }
            return;
        }
        if (groupingCount <= keyPosition) {
            List<DocumentField> fields = LuceneDocumentFromRecord.getFields(key, rec, message, fieldNamePrefix);
            for (Map.Entry<Tuple, List<DocumentField>> entry : result.entrySet()) {
                if (!TupleHelpers.isPrefix((Tuple)groupPrefix, (Tuple)entry.getKey())) continue;
                entry.getValue().addAll(fields);
            }
        } else if (key instanceof NestingKeyExpression) {
            NestingKeyExpression nesting = (NestingKeyExpression)key;
            String parentFieldName = nesting.getParent().getFieldName();
            for (Key.Evaluated value : nesting.getParent().evaluateMessage(rec, message)) {
                Message submessage = (Message)value.toList().get(0);
                LuceneDocumentFromRecord.getGroupedFields(Collections.singletonList(nesting.getChild()), 0, keyPosition, groupingCount, groupPrefix, rec, submessage, result, (String)(fieldNamePrefix == null ? parentFieldName : fieldNamePrefix + "_" + parentFieldName));
            }
        } else if (key instanceof ThenKeyExpression) {
            ThenKeyExpression then = (ThenKeyExpression)key;
            LuceneDocumentFromRecord.getGroupedFields(then.getChildren(), 0, keyPosition, groupingCount, groupPrefix, rec, message, result, fieldNamePrefix);
        } else {
            throw new RecordCoreException("Cannot split key for document grouping: " + String.valueOf(key), new Object[0]);
        }
        LuceneDocumentFromRecord.getGroupedFields(keys, keyIndex + 1, keyPosition + key.getColumnSize(), groupingCount, groupPrefix, rec, message, result, fieldNamePrefix);
    }

    @Nonnull
    public static <M extends Message> List<DocumentField> getFields(@Nonnull KeyExpression expression, @Nonnull FDBRecord<M> rec, @Nonnull Message message, @Nullable String fieldNamePrefix) {
        DocumentFieldList fields = new DocumentFieldList();
        LuceneIndexExpressions.getFields(expression, new FDBRecordSource<M>(rec, message), fields, fieldNamePrefix);
        return fields.getFields();
    }

    protected static class DocumentFieldList<T extends LuceneIndexExpressions.RecordSource<T>>
    implements LuceneIndexExpressions.DocumentDestination<T> {
        private final List<DocumentField> fields = new ArrayList<DocumentField>();

        protected DocumentFieldList() {
        }

        public List<DocumentField> getFields() {
            return this.fields;
        }

        @Override
        public void addField(@Nonnull T source, @Nonnull String fieldName, @Nullable Object value, @Nonnull LuceneIndexExpressions.DocumentFieldType type, boolean fieldNameOverride, @Nullable List<String> namedFieldPath, @Nullable String namedFieldSuffix, boolean stored, boolean sorted, @Nonnull List<Integer> overriddenKeyRanges, int groupingKeyIndex, int keyIndex, @Nonnull Map<String, Object> fieldConfigs) {
            this.fields.add(new DocumentField(fieldName, value, type, stored, sorted, fieldConfigs));
        }
    }

    public static class FDBRecordSource<M extends Message>
    implements LuceneIndexExpressions.RecordSource<FDBRecordSource<M>> {
        @Nonnull
        private final FDBRecord<M> rec;
        @Nonnull
        private final Message message;

        public FDBRecordSource(@Nonnull FDBRecord<M> rec, @Nonnull Message message) {
            this.rec = rec;
            this.message = message;
        }

        @Nonnull
        public Message getMessage() {
            return this.message;
        }

        @Override
        public Descriptors.Descriptor getDescriptor() {
            return this.message.getDescriptorForType();
        }

        @Override
        public Iterable<FDBRecordSource<M>> getChildren(FieldKeyExpression parentExpression) {
            ArrayList<FDBRecordSource<M>> children = new ArrayList<FDBRecordSource<M>>();
            for (Key.Evaluated evaluated : parentExpression.evaluateMessage(this.rec, this.message)) {
                Message submessage = (Message)evaluated.toList().get(0);
                if (submessage == null) continue;
                children.add(new FDBRecordSource<M>(this.rec, submessage));
            }
            return children;
        }

        @Override
        public Iterable<Object> getValues(KeyExpression keyExpression) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Key.Evaluated evaluated : keyExpression.evaluateMessage(this.rec, this.message)) {
                Object value = evaluated.getObject(0);
                if (value == null) continue;
                values.add(value);
            }
            return values;
        }
    }

    protected static class DocumentField {
        @Nonnull
        private final String fieldName;
        @Nullable
        private final Object value;
        private final LuceneIndexExpressions.DocumentFieldType type;
        private final boolean stored;
        private final boolean sorted;
        @Nonnull
        private final Map<String, Object> fieldConfigs;

        public DocumentField(@Nonnull String fieldName, @Nullable Object value, LuceneIndexExpressions.DocumentFieldType type, boolean stored, boolean sorted, @Nonnull Map<String, Object> fieldConfigs) {
            this.fieldName = fieldName;
            this.value = value;
            this.type = type;
            this.stored = stored;
            this.sorted = sorted;
            this.fieldConfigs = fieldConfigs;
        }

        @Nonnull
        public String getFieldName() {
            return this.fieldName;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public LuceneIndexExpressions.DocumentFieldType getType() {
            return this.type;
        }

        public boolean isStored() {
            return this.stored;
        }

        public boolean isSorted() {
            return this.sorted;
        }

        @Nullable
        public Object getConfig(@Nonnull String key) {
            return this.fieldConfigs.get(key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DocumentField that = (DocumentField)o;
            if (this.stored != that.stored) {
                return false;
            }
            if (this.sorted != that.sorted) {
                return false;
            }
            if (!this.fieldName.equals(that.fieldName)) {
                return false;
            }
            if (!Objects.equals(this.value, that.value)) {
                return false;
            }
            if (this.type != that.type) {
                return false;
            }
            return Objects.equals(this.fieldConfigs, that.fieldConfigs);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + this.type.hashCode();
            result = 31 * result + (this.stored ? 1 : 0);
            result = 31 * result + (this.sorted ? 1 : 0);
            return result;
        }

        public String toString() {
            return this.fieldName + "=" + String.valueOf(this.value);
        }
    }
}

