/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.filter.CjkUnigramFilter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;

public class AutoCompleteAnalyzer
extends StopwordAnalyzerBase {
    public static final String UNIQUE_IDENTIFIER = "AUTO_COMPLETE";

    public AutoCompleteAnalyzer() {
        super(null);
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        UAX29URLEmailTokenizer src = new UAX29URLEmailTokenizer();
        Object result = new CJKWidthFilter((TokenStream)src);
        result = new CjkUnigramFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        result = new ASCIIFoldingFilter((TokenStream)result);
        return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)result);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter((TokenStream)new CJKWidthFilter(in));
    }
}

