/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.test.FDBDatabaseExtension;
import com.apple.foundationdb.record.test.TestKeySpacePathManagerExtension;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.test.BooleanSource;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

@Tag(value="RequiresFDB")
class FDBDirectoryLockTest {
    @RegisterExtension
    final FDBDatabaseExtension dbExtension = new FDBDatabaseExtension();
    @RegisterExtension
    final TestKeySpacePathManagerExtension pathManager = new TestKeySpacePathManagerExtension(this.dbExtension);
    private FDBDatabase fdb;
    private Subspace subspace;

    FDBDirectoryLockTest() {
    }

    @BeforeEach
    void setUp() {
        this.fdb = this.dbExtension.getDatabase();
        KeySpacePath path = this.pathManager.createPath(new String[]{"rawData"});
        this.subspace = (Subspace)this.fdb.run(arg_0 -> ((KeySpacePath)path).toSubspace(arg_0));
    }

    @ParameterizedTest
    @BooleanSource
    void testFileLock(boolean useAgile) throws IOException {
        try (FDBRecordContext context = this.fdb.openContext();){
            AgilityContext agilityContext = useAgile ? AgilityContext.agile((FDBRecordContext)context, (long)1000L, (long)1000000L) : AgilityContext.nonAgile((FDBRecordContext)context);
            FDBDirectory directory = this.createDirectory(agilityContext);
            String lockName = "file.lock";
            String alreadyLockedMessage = "FileLock: Lock failed: already locked by another entity";
            Lock lock1 = directory.obtainLock(lockName);
            lock1.ensureValid();
            LockObtainFailedException e = (LockObtainFailedException)Assertions.assertThrows(LockObtainFailedException.class, () -> directory.obtainLock(lockName));
            Assertions.assertTrue((boolean)e.getMessage().contains(alreadyLockedMessage));
            lock1.ensureValid();
            lock1.close();
            Assertions.assertThrows(AlreadyClosedException.class, () -> ((Lock)lock1).ensureValid());
            Lock lock2 = directory.obtainLock(lockName);
            lock2.ensureValid();
            e = (LockObtainFailedException)Assertions.assertThrows(LockObtainFailedException.class, () -> directory.obtainLock(lockName));
            Assertions.assertTrue((boolean)e.getMessage().contains(alreadyLockedMessage));
            lock2.ensureValid();
            lock2.close();
        }
    }

    @Test
    void testFileLockCallback() throws IOException {
        try (FDBRecordContext context = this.fdb.openContext();){
            AgilityContext agilityContext = AgilityContext.agile((FDBRecordContext)context, (long)1000L, (long)1000000L);
            FDBDirectory directory = this.createDirectory(agilityContext);
            String lockName = "file.lock";
            Lock lock1 = directory.obtainLock("file.lock");
            String string1 = lock1.toString();
            byte[] firstKey = new byte[]{1, 2, 3};
            byte[] firstValue = new byte[]{3, 2, 1};
            agilityContext.accept(aContext -> aContext.ensureActive().set(firstKey, firstValue));
            agilityContext.accept(aContext -> aContext.ensureActive().set(new byte[]{4, 5, 6}, new byte[]{6, 5, 4}));
            agilityContext.flush();
            String string2 = lock1.toString();
            byte[] bytes = (byte[])agilityContext.asyncToSync((StoreTimer.Wait)LuceneEvents.Waits.WAIT_LUCENE_GET_DATA_BLOCK, agilityContext.apply(aContext -> aContext.ensureActive().get(firstKey)));
            Assertions.assertArrayEquals((byte[])firstValue, (byte[])bytes);
            agilityContext.accept(aContext -> aContext.ensureActive().set(new byte[]{7, 8, 9}, new byte[]{9, 8, 7}));
            agilityContext.accept(aContext -> aContext.ensureActive().set(new byte[]{10, 11, 12}, new byte[]{12, 11, 10}));
            String string22 = lock1.toString();
            Assertions.assertEquals((Object)string2, (Object)string22);
            agilityContext.flush();
            String string3 = lock1.toString();
            Assertions.assertNotEquals((Object)string1, (Object)string2);
            Assertions.assertNotEquals((Object)string2, (Object)string3);
            Assertions.assertNotEquals((Object)string3, (Object)string1);
            lock1.ensureValid();
            lock1.close();
        }
    }

    @Test
    void testFileLockCallbackFrequently() throws IOException {
        String lockName = "file.lock";
        try (FDBRecordContext context = this.fdb.openContext();){
            AgilityContext agilityContext = AgilityContext.agile((FDBRecordContext)context, (long)0L, (long)0L);
            try (FDBDirectory directory = this.createDirectory(agilityContext);){
                Lock lock1 = directory.obtainLock("file.lock");
                lock1.close();
            }
            agilityContext.flushAndClose();
        }
        this.assertCanObtainLock("file.lock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @BooleanSource
    void testFileLockCallbackFrequentlyLost(boolean clearLock) throws IOException {
        String lockName = "file.lock";
        try (FDBRecordContext context = this.fdb.openContext();){
            AgilityContext agilityContext = AgilityContext.agile((FDBRecordContext)context, (long)-5L, (long)0L);
            FDBDirectory directory = this.createDirectory(agilityContext);
            try {
                Lock lock1 = directory.obtainLock("file.lock");
                if (clearLock) {
                    this.forceClearLock("file.lock");
                } else {
                    this.forceStealLock("file.lock");
                }
                Assertions.assertThrows(AlreadyClosedException.class, () -> ((Lock)lock1).close());
            }
            finally {
                Assertions.assertThrows(AlreadyClosedException.class, () -> ((FDBDirectory)directory).close());
            }
            agilityContext.abortAndClose();
        }
        this.assertCanObtainLock("file.lock");
    }

    @ParameterizedTest
    @CsvSource(value={"true,true", "true,false", "false,true", "false,false"})
    void testFileLockClose(boolean useAgile, boolean abortAgilityContext) throws IOException {
        for (int i = 0; i < 3; ++i) {
            try (FDBRecordContext context = this.fdb.openContext();){
                AgilityContext agilityContext = useAgile ? AgilityContext.agile((FDBRecordContext)context, (long)1000L, (long)1000000L) : AgilityContext.nonAgile((FDBRecordContext)context);
                FDBDirectory directory = this.createDirectory(agilityContext);
                String lockName = "file.lock";
                Lock lock1 = directory.obtainLock(lockName);
                lock1.ensureValid();
                if (abortAgilityContext) {
                    agilityContext.abortAndClose();
                    Assertions.assertTrue((boolean)agilityContext.isClosed());
                } else {
                    Assertions.assertFalse((boolean)agilityContext.isClosed());
                }
                lock1.close();
                directory.close();
                agilityContext.flushAndClose();
                context.commit();
                continue;
            }
        }
    }

    private void assertCanObtainLock(String lockName) throws IOException {
        try (FDBRecordContext context = this.fdb.openContext();){
            AgilityContext agilityContext = AgilityContext.nonAgile((FDBRecordContext)context);
            try (FDBDirectory directory = this.createDirectory(agilityContext);){
                directory.obtainLock(lockName).close();
            }
            agilityContext.abortAndClose();
        }
    }

    private void forceClearLock(String lockName) throws IOException {
        try (FDBRecordContext context = this.fdb.openContext();){
            AgilityContext agilityContext = AgilityContext.nonAgile((FDBRecordContext)context);
            try (FDBDirectory directory2 = this.createDirectory(agilityContext);){
                agilityContext.accept(context2 -> context2.ensureActive().clear(directory2.fileLockKey(lockName)));
            }
            context.commit();
        }
    }

    private void forceStealLock(String lockName) throws IOException {
        try (FDBRecordContext context = this.fdb.openContext();){
            AgilityContext agilityContext = AgilityContext.nonAgile((FDBRecordContext)context);
            try (FDBDirectory directory = this.createDirectory(agilityContext);){
                agilityContext.accept(context2 -> context2.ensureActive().clear(directory.fileLockKey(lockName)));
                directory.obtainLock(lockName);
            }
            context.commit();
        }
    }

    @Nonnull
    private FDBDirectory createDirectory(AgilityContext agilityContext) {
        return new FDBDirectory(this.subspace, null, null, null, true, agilityContext);
    }
}

