/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.lucene.codec.LazyCloseable;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
class LazyCloseableTest {
    LazyCloseableTest() {
    }

    @Nonnull
    static <T> Deque<T> collectFromMultipleThreads(int concurrency, @Nonnull Supplier<T> supplier) throws InterruptedException {
        ArrayList<Thread> threads = new ArrayList<Thread>(concurrency);
        CountDownLatch latch = new CountDownLatch(concurrency);
        ConcurrentLinkedDeque results = new ConcurrentLinkedDeque();
        for (int i = 0; i < concurrency; ++i) {
            Thread t = new Thread(() -> {
                try {
                    latch.countDown();
                    latch.await();
                    Object value = supplier.get();
                    results.add(value);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            t.setName("collectFromMultipleThreads-" + i);
            t.start();
            threads.add(t);
        }
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        for (Thread t : threads) {
            t.join(TimeUnit.SECONDS.toMillis(30L));
        }
        MatcherAssert.assertThat(results, (Matcher)Matchers.hasSize((int)concurrency));
        return results;
    }

    @Test
    void testOpensLazilyExactlyOnce() throws IOException {
        AtomicInteger openCounter = new AtomicInteger(0);
        AtomicInteger closeCounter = new AtomicInteger(0);
        try (LazyCloseable opener = LazyCloseable.supply(() -> new CountingCloseable(openCounter, closeCounter));){
            Assertions.assertEquals((int)0, (int)openCounter.get());
            Assertions.assertEquals((int)1, (int)((CountingCloseable)opener.get()).openCounts);
            Assertions.assertEquals((int)1, (int)((CountingCloseable)opener.get()).openCounts);
            Assertions.assertEquals((int)1, (int)((CountingCloseable)opener.getUnchecked()).openCounts);
            Assertions.assertSame((Object)opener.get(), (Object)opener.get());
            Assertions.assertEquals((int)1, (int)openCounter.get());
        }
        Assertions.assertEquals((int)1, (int)closeCounter.get());
    }

    @Test
    void testOpensLazilyExactlyOnceThreaded() throws IOException, InterruptedException {
        AtomicInteger starts = new AtomicInteger(0);
        AtomicInteger ends = new AtomicInteger(0);
        AtomicInteger opens = new AtomicInteger(0);
        AtomicInteger closes = new AtomicInteger(0);
        int concurrency = 100;
        LazyCloseable opener = LazyCloseable.supply(() -> {
            starts.incrementAndGet();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)"Timed out waiting for latch");
            }
            ends.incrementAndGet();
            return new CountingCloseable(opens, closes);
        });
        ConcurrentHashMap threads = new ConcurrentHashMap();
        Deque<CountingCloseable> allValues = LazyCloseableTest.collectFromMultipleThreads(100, () -> {
            CountingCloseable value = (CountingCloseable)opener.getUnchecked();
            threads.compute(Thread.currentThread(), (k, v) -> v == null ? 1 : v + 1);
            return value;
        });
        CountingCloseable closeable = allValues.getFirst();
        Assertions.assertNotNull((Object)closeable);
        MatcherAssert.assertThat(allValues, (Matcher)Matchers.everyItem((Matcher)Matchers.sameInstance((Object)closeable)));
        Assertions.assertEquals((int)1, (int)starts.get());
        Assertions.assertEquals((int)1, (int)ends.get());
        Assertions.assertEquals((int)1, (int)opens.get());
        Assertions.assertEquals((int)0, (int)closes.get());
        for (CountingCloseable allValue : allValues) {
            allValue.close();
        }
        Assertions.assertEquals((int)100, (int)closes.get());
        MatcherAssert.assertThat((Object)threads.keySet(), (Matcher)Matchers.hasSize((int)100));
        MatcherAssert.assertThat(threads.values(), (Matcher)Matchers.everyItem((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    void testForkJoinPoolDeadlock() throws ExecutionException, InterruptedException, TimeoutException {
        ForkJoinPool forkJoinPool = new ForkJoinPool(2);
        AtomicInteger openCounter = new AtomicInteger(0);
        LazyCloseable initial = LazyCloseable.supply(() -> {
            final int openCount = openCounter.incrementAndGet();
            try {
                return (Closeable)((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> {}, forkJoinPool).thenCompose(ignored -> MoreAsyncUtil.delayedFuture((long)2L, (TimeUnit)TimeUnit.SECONDS))).thenApplyAsync(v -> new Closeable(){

                    @Override
                    public void close() throws IOException {
                    }

                    public String toString() {
                        return "Opened " + openCount;
                    }
                }, (Executor)forkJoinPool)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        List result = IntStream.range(0, 50).parallel().mapToObj(i -> CompletableFuture.supplyAsync(() -> initial.getUnchecked().toString() + " " + i, forkJoinPool)).collect(Collectors.toList());
        List strings = (List)AsyncUtil.getAll(result).get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)strings, (Matcher)Matchers.containsInAnyOrder((Collection)IntStream.range(0, 50).mapToObj(i -> Matchers.is((Object)("Opened 1 " + i))).collect(Collectors.toList())));
    }

    @Test
    void testCloseDoesNotOpen() throws IOException {
        AtomicInteger openCounter = new AtomicInteger(0);
        AtomicInteger closeCounter = new AtomicInteger(0);
        LazyCloseable.supply(() -> new CountingCloseable(openCounter, closeCounter)).close();
        Assertions.assertEquals((int)0, (int)openCounter.get());
    }

    @Test
    void testCloseCloses() throws IOException {
        AtomicInteger openCounter = new AtomicInteger(0);
        AtomicInteger closeCounter = new AtomicInteger(0);
        try (LazyCloseable opener = LazyCloseable.supply(() -> new CountingCloseable(openCounter, closeCounter));){
            opener.get();
        }
        Assertions.assertEquals((int)1, (int)openCounter.get());
        Assertions.assertEquals((int)1, (int)closeCounter.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCloseMultipleTimes() throws IOException {
        AtomicInteger openCounter = new AtomicInteger(0);
        AtomicInteger closeCounter = new AtomicInteger(0);
        LazyCloseable opener = LazyCloseable.supply(() -> new CountingCloseable(openCounter, closeCounter));
        try {
            opener.get();
        }
        finally {
            for (int i = 0; i < 5; ++i) {
                opener.close();
            }
        }
        Assertions.assertEquals((int)1, (int)openCounter.get());
        Assertions.assertEquals((int)5, (int)closeCounter.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCloseFails() throws IOException {
        AtomicInteger openCounter = new AtomicInteger(0);
        AtomicInteger closeCounter = new AtomicInteger(0);
        LazyCloseable opener = LazyCloseable.supply(() -> new CountingCloseable(openCounter, closeCounter, true));
        try {
            opener.get();
        }
        finally {
            Assertions.assertThrows(IOException.class, () -> ((LazyCloseable)opener).close(), (String)"an error");
            Assertions.assertThrows(IOException.class, () -> ((LazyCloseable)opener).close(), (String)"an error");
        }
        Assertions.assertEquals((int)1, (int)openCounter.get());
        Assertions.assertEquals((int)0, (int)closeCounter.get());
    }

    @Test
    void testThrowsIoException() throws IOException {
        IOException thrownException = new IOException("test foo");
        try (LazyCloseable<Closeable> opener = LazyCloseableTest.failingOpener(thrownException);){
            IOException resultingException = (IOException)Assertions.assertThrows(IOException.class, () -> opener.get());
            Assertions.assertSame((Object)thrownException, (Object)resultingException);
        }
    }

    @Test
    void testThrowsUncheckedIoException() throws IOException {
        IOException thrownException = new IOException("test foo");
        try (LazyCloseable<Closeable> opener = LazyCloseableTest.failingOpener(thrownException);){
            UncheckedIOException resultingException = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> opener.getUnchecked());
            Assertions.assertSame((Object)thrownException, (Object)resultingException.getCause());
        }
    }

    @Test
    void testUnusedDoesNotThrowOnClose() {
        IOException thrownException = new IOException("test foo");
        LazyCloseable<Closeable> opener = LazyCloseableTest.failingOpener(thrownException);
        Assertions.assertDoesNotThrow(() -> opener.close());
    }

    @Nonnull
    private static LazyCloseable<Closeable> failingOpener(IOException thrownException) {
        return LazyCloseable.supply(() -> {
            throw thrownException;
        });
    }

    private static class CountingCloseable
    implements Closeable {
        final int openCounts;
        final AtomicInteger closeCounter;
        final boolean failOnClose;

        private CountingCloseable(AtomicInteger openCounter, AtomicInteger closeCounter) {
            this.openCounts = openCounter.incrementAndGet();
            this.closeCounter = closeCounter;
            this.failOnClose = false;
        }

        private CountingCloseable(AtomicInteger openCounter, AtomicInteger closeCounter, boolean failOnClose) {
            this.openCounts = openCounter.incrementAndGet();
            this.closeCounter = closeCounter;
            this.failOnClose = failOnClose;
        }

        @Override
        public void close() throws IOException {
            if (this.failOnClose) {
                throw new IOException("an error");
            }
            this.closeCounter.incrementAndGet();
        }
    }
}

