/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.cursors.AutoContinuingCursor;
import com.apple.foundationdb.record.lucene.LuceneIndexTestDataModel;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LuceneIndexTestValidator;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQuerySearchClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.LuceneScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreConcurrentTestBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.test.BooleanSource;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Tag(value="RequiresFDB")
public class LuceneScanAllEntriesTest
extends FDBRecordStoreConcurrentTestBase {
    public static Stream<Arguments> scanArguments() {
        return Stream.of(false, true).flatMap(isSynthetic -> Stream.of(false, true).flatMap(matchAllDocs -> Stream.of(false, true).flatMap(isGrouped -> Stream.of(false, true).map(includeEmptyDoc -> Arguments.of((Object[])new Object[]{isSynthetic, matchAllDocs, isGrouped, includeEmptyDoc})))));
    }

    @ParameterizedTest(name="indexScanTest({argumentsWithNames})")
    @MethodSource(value={"scanArguments"})
    public void indexScanTest(boolean isSynthetic, boolean matchAllDocs, boolean isGrouped, boolean includeEmptyDoc) throws Exception {
        Tuple group2ContentDoc;
        Tuple group1ContentDoc;
        long seed = 5363275763521L;
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(5363275763521L, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setIsGrouped(isGrouped).setIsSynthetic(isSynthetic).setPrimaryKeySegmentIndexEnabled(true).setPartitionHighWatermark(10).build();
        Tuple group2EmptyDoc = null;
        try (FDBRecordContext context = this.openContext();){
            FDBRecordStore store = dataModel.createOrOpenRecordStore(context);
            group1ContentDoc = dataModel.saveRecord(store, 1);
            group2ContentDoc = dataModel.saveRecord(store, 2);
            if (includeEmptyDoc) {
                group2EmptyDoc = dataModel.saveEmptyRecord(store, 2);
            }
            this.commit(context);
        }
        LuceneQueryClause search = matchAllDocs ? LuceneQuerySearchClause.MATCH_ALL_DOCS_QUERY : (isSynthetic ? new LuceneQuerySearchClause(LuceneQueryType.QUERY, "child_str_value:forth", false) : new LuceneQuerySearchClause(LuceneQueryType.QUERY, "text_value:about", false));
        Set<Tuple> expectedResult = this.expectedResults(matchAllDocs, isGrouped, includeEmptyDoc, group1ContentDoc, group2ContentDoc, group2EmptyDoc);
        try (FDBRecordContext context = this.openContext();){
            FDBRecordStore store = dataModel.createOrOpenRecordStore(context);
            LuceneScanBounds scanBounds = isGrouped ? LuceneIndexTestValidator.groupedSortedTextSearch(store, dataModel.index, search, null, (Object)2) : LuceneIndexTestUtils.fullTextSearch(store, dataModel.index, search, false);
            this.assertIndexEntryPrimaryKeyTuples(expectedResult, (RecordCursor<IndexEntry>)store.scanIndex(dataModel.index, (IndexScanBounds)scanBounds, null, ScanProperties.FORWARD_SCAN));
        }
    }

    private Set<Tuple> expectedResults(boolean matchAllDocs, boolean isGrouped, boolean includeEmptyDoc, Tuple group1ContentDoc, Tuple group2ContentDoc, Tuple group2EmptyDoc) {
        HashSet<Tuple> result = new HashSet<Tuple>();
        if (!isGrouped) {
            result.add(group1ContentDoc);
        }
        result.add(group2ContentDoc);
        if (matchAllDocs && includeEmptyDoc) {
            result.add(group2EmptyDoc);
        }
        return result;
    }

    @ParameterizedTest
    @BooleanSource
    public void scanLargeIndexTest(boolean isGrouped) throws Exception {
        long seed = 6437286L;
        boolean isSynthetic = false;
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(6437286L, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setIsGrouped(isGrouped).setIsSynthetic(false).setPrimaryKeySegmentIndexEnabled(true).setPartitionHighWatermark(10).build();
        try (FDBRecordContext context = this.openContext();){
            dataModel.saveRecords(500, context, 2);
            this.commit(context);
        }
        LuceneQueryClause search = LuceneQuerySearchClause.MATCH_ALL_DOCS_QUERY;
        try (FDBRecordContext context = this.openContext();){
            FDBRecordStore store = dataModel.createOrOpenRecordStore(context);
            LuceneScanBounds scanBounds = isGrouped ? LuceneIndexTestValidator.groupedSortedTextSearch(store, dataModel.index, search, null, (Object)2) : LuceneIndexTestUtils.fullTextSearch(store, dataModel.index, search, false);
            Tuple groupTuple = LuceneIndexTestDataModel.calculateGroupTuple(isGrouped, 2);
            Set<Tuple> expectedKeys = ((ConcurrentMap)dataModel.groupingKeyToPrimaryKeyToPartitionKey.get(groupTuple)).keySet();
            Assertions.assertEquals((int)500, (int)expectedKeys.size());
            this.assertIndexEntryPrimaryKeyTuples(expectedKeys, (RecordCursor<IndexEntry>)store.scanIndex(dataModel.index, (IndexScanBounds)scanBounds, null, ScanProperties.FORWARD_SCAN));
        }
    }

    @ParameterizedTest
    @BooleanSource
    public void scanWithContinuationsTest(boolean isGrouped) throws Exception {
        long seed = 85373450L;
        boolean isSynthetic = false;
        LuceneIndexTestDataModel dataModel = new LuceneIndexTestDataModel.Builder(85373450L, (x$0, x$1, x$2) -> this.getStoreBuilder(x$0, (RecordMetaDataProvider)x$1, x$2), this.pathManager).setIsGrouped(isGrouped).setIsSynthetic(false).setPrimaryKeySegmentIndexEnabled(true).setPartitionHighWatermark(210).build();
        try (FDBRecordContext context2 = this.openContext();){
            dataModel.saveRecords(500, context2, 2);
            this.commit(context2);
        }
        ScanProperties scanProperties = new ScanProperties(ExecuteProperties.newBuilder().setReturnedRowLimit(36).setIsolationLevel(IsolationLevel.SERIALIZABLE).build());
        LuceneQueryClause search = LuceneQuerySearchClause.MATCH_ALL_DOCS_QUERY;
        try (FDBDatabaseRunner runner = this.fdb.newRunner();){
            AutoContinuingCursor cursor = new AutoContinuingCursor(runner, (context, continuation) -> {
                FDBRecordStore store = dataModel.createOrOpenRecordStore((FDBRecordContext)context);
                LuceneScanBounds scanBounds = isGrouped ? LuceneIndexTestValidator.groupedSortedTextSearch(store, dataModel.index, search, null, (Object)2) : LuceneIndexTestUtils.fullTextSearch(store, dataModel.index, search, false);
                return store.scanIndex(dataModel.index, (IndexScanBounds)scanBounds, continuation, scanProperties);
            });
            Tuple groupTuple = LuceneIndexTestDataModel.calculateGroupTuple(isGrouped, 2);
            Set<Tuple> expectedKeys = ((ConcurrentMap)dataModel.groupingKeyToPrimaryKeyToPartitionKey.get(groupTuple)).keySet();
            Assertions.assertEquals((int)500, (int)expectedKeys.size());
            this.assertIndexEntryPrimaryKeyTuples(expectedKeys, (RecordCursor<IndexEntry>)cursor);
        }
    }

    private void assertIndexEntryPrimaryKeyTuples(Set<Tuple> primaryKeys, RecordCursor<IndexEntry> cursor) {
        List indexEntries = (List)cursor.asList().join();
        Assertions.assertEquals(primaryKeys, indexEntries.stream().map(IndexEntry::getPrimaryKey).collect(Collectors.toSet()));
    }
}

